// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllACLBackendOKCode is the HTTP code returned for type GetAllACLBackendOK
const GetAllACLBackendOKCode int = 200

/*
GetAllACLBackendOK Successful operation

swagger:response getAllAclBackendOK
*/
type GetAllACLBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Acls `json:"body,omitempty"`
}

// NewGetAllACLBackendOK creates GetAllACLBackendOK with default headers values
func NewGetAllACLBackendOK() *GetAllACLBackendOK {

	return &GetAllACLBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Acl backend o k response
func (o *GetAllACLBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllACLBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Acl backend o k response
func (o *GetAllACLBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Acl backend o k response
func (o *GetAllACLBackendOK) WithPayload(payload models.Acls) *GetAllACLBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Acl backend o k response
func (o *GetAllACLBackendOK) SetPayload(payload models.Acls) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllACLBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Acls{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllACLBackendDefault General Error

swagger:response getAllAclBackendDefault
*/
type GetAllACLBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllACLBackendDefault creates GetAllACLBackendDefault with default headers values
func NewGetAllACLBackendDefault(code int) *GetAllACLBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllACLBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all Acl backend default response
func (o *GetAllACLBackendDefault) WithStatusCode(code int) *GetAllACLBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all Acl backend default response
func (o *GetAllACLBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all Acl backend default response
func (o *GetAllACLBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllACLBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Acl backend default response
func (o *GetAllACLBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Acl backend default response
func (o *GetAllACLBackendDefault) WithPayload(payload *models.Error) *GetAllACLBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Acl backend default response
func (o *GetAllACLBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllACLBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
