// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Parameters on this idempotent request are inconsistent with parameters used in previous request(s).</p>
/// <p>For a list of error codes and more information on Amazon S3 errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">Error codes</a>.</p><note>
/// <p>Idempotency ensures that an API request completes no more than one time. With an idempotent request, if the original request completes successfully, any subsequent retries complete successfully without performing any further actions.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct IdempotencyParameterMismatch {
    #[allow(missing_docs)] // documentation missing in model
    pub message: ::std::option::Option<::std::string::String>,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl IdempotencyParameterMismatch {
    /// Returns the error message.
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl ::std::fmt::Display for IdempotencyParameterMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "IdempotencyParameterMismatch")?;
        if let ::std::option::Option::Some(inner_1) = &self.message {
            {
                ::std::write!(f, ": {inner_1}")?;
            }
        }
        Ok(())
    }
}
impl ::std::error::Error for IdempotencyParameterMismatch {}
impl crate::s3_request_id::RequestIdExt for crate::types::error::IdempotencyParameterMismatch {
    fn extended_request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().extended_request_id()
    }
}
impl ::aws_types::request_id::RequestId for crate::types::error::IdempotencyParameterMismatch {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for IdempotencyParameterMismatch {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl IdempotencyParameterMismatch {
    /// Creates a new builder-style object to manufacture [`IdempotencyParameterMismatch`](crate::types::error::IdempotencyParameterMismatch).
    pub fn builder() -> crate::types::error::builders::IdempotencyParameterMismatchBuilder {
        crate::types::error::builders::IdempotencyParameterMismatchBuilder::default()
    }
}

/// A builder for [`IdempotencyParameterMismatch`](crate::types::error::IdempotencyParameterMismatch).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct IdempotencyParameterMismatchBuilder {
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl IdempotencyParameterMismatchBuilder {
    #[allow(missing_docs)] // documentation missing in model
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`IdempotencyParameterMismatch`](crate::types::error::IdempotencyParameterMismatch).
    pub fn build(self) -> crate::types::error::IdempotencyParameterMismatch {
        crate::types::error::IdempotencyParameterMismatch {
            message: self.message,
            meta: self.meta.unwrap_or_default(),
        }
    }
}
