/* automatically generated by rust-bindgen 0.66.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __BIONIC__: u32 = 1;
pub const __WORDSIZE: u32 = 32;
pub const __bos_level: u32 = 0;
pub const __ANDROID_API_FUTURE__: u32 = 10000;
pub const __ANDROID_API__: u32 = 10000;
pub const __ANDROID_API_G__: u32 = 9;
pub const __ANDROID_API_I__: u32 = 14;
pub const __ANDROID_API_J__: u32 = 16;
pub const __ANDROID_API_J_MR1__: u32 = 17;
pub const __ANDROID_API_J_MR2__: u32 = 18;
pub const __ANDROID_API_K__: u32 = 19;
pub const __ANDROID_API_L__: u32 = 21;
pub const __ANDROID_API_L_MR1__: u32 = 22;
pub const __ANDROID_API_M__: u32 = 23;
pub const __ANDROID_API_N__: u32 = 24;
pub const __ANDROID_API_N_MR1__: u32 = 25;
pub const __ANDROID_API_O__: u32 = 26;
pub const __ANDROID_API_O_MR1__: u32 = 27;
pub const __ANDROID_API_P__: u32 = 28;
pub const __ANDROID_API_Q__: u32 = 29;
pub const __ANDROID_API_R__: u32 = 30;
pub const __ANDROID_API_S__: u32 = 31;
pub const __ANDROID_API_T__: u32 = 33;
pub const __ANDROID_API_U__: u32 = 34;
pub const __ANDROID_NDK__: u32 = 1;
pub const __NDK_MAJOR__: u32 = 25;
pub const __NDK_MINOR__: u32 = 2;
pub const __NDK_BETA__: u32 = 0;
pub const __NDK_BUILD__: u32 = 9519653;
pub const __NDK_CANARY__: u32 = 0;
pub const WCHAR_MIN: u8 = 0u8;
pub const INT8_MIN: i32 = -128;
pub const INT8_MAX: u32 = 127;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST8_MAX: u32 = 127;
pub const UINT8_MAX: u32 = 255;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_FAST8_MAX: u32 = 255;
pub const INT16_MIN: i32 = -32768;
pub const INT16_MAX: u32 = 32767;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const UINT16_MAX: u32 = 65535;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const INT32_MIN: i32 = -2147483648;
pub const INT32_MAX: u32 = 2147483647;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 4294967295;
pub const WINT_MIN: u32 = 0;
pub const INTPTR_MIN: i32 = -2147483648;
pub const INTPTR_MAX: u32 = 2147483647;
pub const UINTPTR_MAX: u32 = 4294967295;
pub const PTRDIFF_MIN: i32 = -2147483648;
pub const PTRDIFF_MAX: u32 = 2147483647;
pub const SIZE_MAX: u32 = 4294967295;
pub const __BITS_PER_LONG: u32 = 32;
pub const __FD_SETSIZE: u32 = 1024;
pub const __GNUC_VA_LIST: u32 = 1;
pub const AMOTION_EVENT_ACTION_POINTER_INDEX_SHIFT: u32 = 8;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const __PRI_64_prefix: &[u8; 3] = b"ll\0";
pub const PRId8: &[u8; 2] = b"d\0";
pub const PRId16: &[u8; 2] = b"d\0";
pub const PRId32: &[u8; 2] = b"d\0";
pub const PRId64: &[u8; 4] = b"lld\0";
pub const PRIdLEAST8: &[u8; 2] = b"d\0";
pub const PRIdLEAST16: &[u8; 2] = b"d\0";
pub const PRIdLEAST32: &[u8; 2] = b"d\0";
pub const PRIdLEAST64: &[u8; 4] = b"lld\0";
pub const PRIdFAST8: &[u8; 2] = b"d\0";
pub const PRIdFAST64: &[u8; 4] = b"lld\0";
pub const PRIdMAX: &[u8; 3] = b"jd\0";
pub const PRIi8: &[u8; 2] = b"i\0";
pub const PRIi16: &[u8; 2] = b"i\0";
pub const PRIi32: &[u8; 2] = b"i\0";
pub const PRIi64: &[u8; 4] = b"lli\0";
pub const PRIiLEAST8: &[u8; 2] = b"i\0";
pub const PRIiLEAST16: &[u8; 2] = b"i\0";
pub const PRIiLEAST32: &[u8; 2] = b"i\0";
pub const PRIiLEAST64: &[u8; 4] = b"lli\0";
pub const PRIiFAST8: &[u8; 2] = b"i\0";
pub const PRIiFAST64: &[u8; 4] = b"lli\0";
pub const PRIiMAX: &[u8; 3] = b"ji\0";
pub const PRIo8: &[u8; 2] = b"o\0";
pub const PRIo16: &[u8; 2] = b"o\0";
pub const PRIo32: &[u8; 2] = b"o\0";
pub const PRIo64: &[u8; 4] = b"llo\0";
pub const PRIoLEAST8: &[u8; 2] = b"o\0";
pub const PRIoLEAST16: &[u8; 2] = b"o\0";
pub const PRIoLEAST32: &[u8; 2] = b"o\0";
pub const PRIoLEAST64: &[u8; 4] = b"llo\0";
pub const PRIoFAST8: &[u8; 2] = b"o\0";
pub const PRIoFAST64: &[u8; 4] = b"llo\0";
pub const PRIoMAX: &[u8; 3] = b"jo\0";
pub const PRIu8: &[u8; 2] = b"u\0";
pub const PRIu16: &[u8; 2] = b"u\0";
pub const PRIu32: &[u8; 2] = b"u\0";
pub const PRIu64: &[u8; 4] = b"llu\0";
pub const PRIuLEAST8: &[u8; 2] = b"u\0";
pub const PRIuLEAST16: &[u8; 2] = b"u\0";
pub const PRIuLEAST32: &[u8; 2] = b"u\0";
pub const PRIuLEAST64: &[u8; 4] = b"llu\0";
pub const PRIuFAST8: &[u8; 2] = b"u\0";
pub const PRIuFAST64: &[u8; 4] = b"llu\0";
pub const PRIuMAX: &[u8; 3] = b"ju\0";
pub const PRIx8: &[u8; 2] = b"x\0";
pub const PRIx16: &[u8; 2] = b"x\0";
pub const PRIx32: &[u8; 2] = b"x\0";
pub const PRIx64: &[u8; 4] = b"llx\0";
pub const PRIxLEAST8: &[u8; 2] = b"x\0";
pub const PRIxLEAST16: &[u8; 2] = b"x\0";
pub const PRIxLEAST32: &[u8; 2] = b"x\0";
pub const PRIxLEAST64: &[u8; 4] = b"llx\0";
pub const PRIxFAST8: &[u8; 2] = b"x\0";
pub const PRIxFAST64: &[u8; 4] = b"llx\0";
pub const PRIxMAX: &[u8; 3] = b"jx\0";
pub const PRIX8: &[u8; 2] = b"X\0";
pub const PRIX16: &[u8; 2] = b"X\0";
pub const PRIX32: &[u8; 2] = b"X\0";
pub const PRIX64: &[u8; 4] = b"llX\0";
pub const PRIXLEAST8: &[u8; 2] = b"X\0";
pub const PRIXLEAST16: &[u8; 2] = b"X\0";
pub const PRIXLEAST32: &[u8; 2] = b"X\0";
pub const PRIXLEAST64: &[u8; 4] = b"llX\0";
pub const PRIXFAST8: &[u8; 2] = b"X\0";
pub const PRIXFAST64: &[u8; 4] = b"llX\0";
pub const PRIXMAX: &[u8; 3] = b"jX\0";
pub const SCNd8: &[u8; 4] = b"hhd\0";
pub const SCNd16: &[u8; 3] = b"hd\0";
pub const SCNd32: &[u8; 2] = b"d\0";
pub const SCNd64: &[u8; 4] = b"lld\0";
pub const SCNdLEAST8: &[u8; 4] = b"hhd\0";
pub const SCNdLEAST16: &[u8; 3] = b"hd\0";
pub const SCNdLEAST32: &[u8; 2] = b"d\0";
pub const SCNdLEAST64: &[u8; 4] = b"lld\0";
pub const SCNdFAST8: &[u8; 4] = b"hhd\0";
pub const SCNdFAST64: &[u8; 4] = b"lld\0";
pub const SCNdMAX: &[u8; 3] = b"jd\0";
pub const SCNi8: &[u8; 4] = b"hhi\0";
pub const SCNi16: &[u8; 3] = b"hi\0";
pub const SCNi32: &[u8; 2] = b"i\0";
pub const SCNi64: &[u8; 4] = b"lli\0";
pub const SCNiLEAST8: &[u8; 4] = b"hhi\0";
pub const SCNiLEAST16: &[u8; 3] = b"hi\0";
pub const SCNiLEAST32: &[u8; 2] = b"i\0";
pub const SCNiLEAST64: &[u8; 4] = b"lli\0";
pub const SCNiFAST8: &[u8; 4] = b"hhi\0";
pub const SCNiFAST64: &[u8; 4] = b"lli\0";
pub const SCNiMAX: &[u8; 3] = b"ji\0";
pub const SCNo8: &[u8; 4] = b"hho\0";
pub const SCNo16: &[u8; 3] = b"ho\0";
pub const SCNo32: &[u8; 2] = b"o\0";
pub const SCNo64: &[u8; 4] = b"llo\0";
pub const SCNoLEAST8: &[u8; 4] = b"hho\0";
pub const SCNoLEAST16: &[u8; 3] = b"ho\0";
pub const SCNoLEAST32: &[u8; 2] = b"o\0";
pub const SCNoLEAST64: &[u8; 4] = b"llo\0";
pub const SCNoFAST8: &[u8; 4] = b"hho\0";
pub const SCNoFAST64: &[u8; 4] = b"llo\0";
pub const SCNoMAX: &[u8; 3] = b"jo\0";
pub const SCNu8: &[u8; 4] = b"hhu\0";
pub const SCNu16: &[u8; 3] = b"hu\0";
pub const SCNu32: &[u8; 2] = b"u\0";
pub const SCNu64: &[u8; 4] = b"llu\0";
pub const SCNuLEAST8: &[u8; 4] = b"hhu\0";
pub const SCNuLEAST16: &[u8; 3] = b"hu\0";
pub const SCNuLEAST32: &[u8; 2] = b"u\0";
pub const SCNuLEAST64: &[u8; 4] = b"llu\0";
pub const SCNuFAST8: &[u8; 4] = b"hhu\0";
pub const SCNuFAST64: &[u8; 4] = b"llu\0";
pub const SCNuMAX: &[u8; 3] = b"ju\0";
pub const SCNx8: &[u8; 4] = b"hhx\0";
pub const SCNx16: &[u8; 3] = b"hx\0";
pub const SCNx32: &[u8; 2] = b"x\0";
pub const SCNx64: &[u8; 4] = b"llx\0";
pub const SCNxLEAST8: &[u8; 4] = b"hhx\0";
pub const SCNxLEAST16: &[u8; 3] = b"hx\0";
pub const SCNxLEAST32: &[u8; 2] = b"x\0";
pub const SCNxLEAST64: &[u8; 4] = b"llx\0";
pub const SCNxFAST8: &[u8; 4] = b"hhx\0";
pub const SCNxFAST64: &[u8; 4] = b"llx\0";
pub const SCNxMAX: &[u8; 3] = b"jx\0";
pub const GAME_ACTIVITY_POINTER_INFO_AXIS_COUNT: u32 = 48;
pub const GAMEACTIVITY_MAX_NUM_POINTERS_IN_MOTION_EVENT: u32 = 8;
pub const GAMETEXTINPUT_MAJOR_VERSION: u32 = 2;
pub const GAMETEXTINPUT_MINOR_VERSION: u32 = 0;
pub const GAMETEXTINPUT_BUGFIX_VERSION: u32 = 0;
pub const GAMEACTIVITY_MAJOR_VERSION: u32 = 2;
pub const GAMEACTIVITY_MINOR_VERSION: u32 = 0;
pub const GAMEACTIVITY_BUGFIX_VERSION: u32 = 2;
pub const POLLIN: u32 = 1;
pub const POLLPRI: u32 = 2;
pub const POLLOUT: u32 = 4;
pub const POLLERR: u32 = 8;
pub const POLLHUP: u32 = 16;
pub const POLLNVAL: u32 = 32;
pub const POLLRDNORM: u32 = 64;
pub const POLLRDBAND: u32 = 128;
pub const POLLWRNORM: u32 = 256;
pub const POLLWRBAND: u32 = 512;
pub const POLLMSG: u32 = 1024;
pub const POLLREMOVE: u32 = 4096;
pub const POLLRDHUP: u32 = 8192;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 255;
pub const TMP_MAX: u32 = 308915776;
pub const CHAR_BIT: u32 = 8;
pub const LONG_BIT: u32 = 32;
pub const WORD_BIT: u32 = 32;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MIN: u32 = 0;
pub const CHAR_MAX: u32 = 255;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: u32 = 4294967295;
pub const LONG_MAX: u32 = 2147483647;
pub const LONG_MIN: i32 = -2147483648;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_LONG_MIN: i64 = -9223372036854775808;
pub const LONG_LONG_MAX: u64 = 9223372036854775807;
pub const ULONG_LONG_MAX: i32 = -1;
pub const UID_MAX: u32 = 4294967295;
pub const GID_MAX: u32 = 4294967295;
pub const SIZE_T_MAX: u32 = 4294967295;
pub const SSIZE_MAX: u32 = 2147483647;
pub const MB_LEN_MAX: u32 = 4;
pub const NZERO: u32 = 20;
pub const IOV_MAX: u32 = 1024;
pub const SEM_VALUE_MAX: u32 = 1073741823;
pub const _POSIX_VERSION: u32 = 200809;
pub const _POSIX2_VERSION: u32 = 200809;
pub const _XOPEN_VERSION: u32 = 700;
pub const __BIONIC_POSIX_FEATURE_MISSING: i32 = -1;
pub const _POSIX_ASYNCHRONOUS_IO: i32 = -1;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 1;
pub const _POSIX_CPUTIME: u32 = 200809;
pub const _POSIX_FSYNC: u32 = 200809;
pub const _POSIX_IPV6: u32 = 200809;
pub const _POSIX_MAPPED_FILES: u32 = 200809;
pub const _POSIX_MEMLOCK_RANGE: u32 = 200809;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200809;
pub const _POSIX_MESSAGE_PASSING: i32 = -1;
pub const _POSIX_MONOTONIC_CLOCK: u32 = 200809;
pub const _POSIX_NO_TRUNC: u32 = 1;
pub const _POSIX_PRIORITIZED_IO: i32 = -1;
pub const _POSIX_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_RAW_SOCKETS: u32 = 200809;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200809;
pub const _POSIX_REGEXP: u32 = 1;
pub const _POSIX_SAVED_IDS: u32 = 1;
pub const _POSIX_SEMAPHORES: u32 = 200809;
pub const _POSIX_SHARED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_SHELL: u32 = 1;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_SYNCHRONIZED_IO: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200809;
pub const _POSIX_THREAD_CPUTIME: u32 = 200809;
pub const _POSIX_THREAD_PRIO_INHERIT: i32 = -1;
pub const _POSIX_THREAD_PRIO_PROTECT: i32 = -1;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_INHERIT: i32 = -1;
pub const _POSIX_THREAD_ROBUST_PRIO_PROTECT: i32 = -1;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200809;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREADS: u32 = 200809;
pub const _POSIX_TIMERS: u32 = 200809;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_VDISABLE: u8 = 0u8;
pub const _POSIX2_C_BIND: u32 = 200809;
pub const _POSIX2_C_DEV: i32 = -1;
pub const _POSIX2_CHAR_TERM: u32 = 200809;
pub const _POSIX2_FORT_DEV: i32 = -1;
pub const _POSIX2_FORT_RUN: i32 = -1;
pub const _POSIX2_LOCALEDEF: i32 = -1;
pub const _POSIX2_SW_DEV: i32 = -1;
pub const _POSIX2_UPE: i32 = -1;
pub const _POSIX_V7_ILP32_OFF32: u32 = 1;
pub const _POSIX_V7_ILP32_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: i32 = -1;
pub const _POSIX_V7_LPBIG_OFFBIG: i32 = -1;
pub const _XOPEN_CRYPT: i32 = -1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: i32 = -1;
pub const _XOPEN_REALTIME: u32 = 1;
pub const _XOPEN_REALTIME_THREADS: u32 = 1;
pub const _XOPEN_SHM: u32 = 1;
pub const _XOPEN_STREAMS: i32 = -1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const HOST_NAME_MAX: u32 = 255;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const TTY_NAME_MAX: u32 = 32;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 128;
pub const _KERNEL_NSIG: u32 = 32;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGBUS: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGUSR1: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGUSR2: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGSTKFLT: u32 = 16;
pub const SIGCHLD: u32 = 17;
pub const SIGCONT: u32 = 18;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGURG: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGPOLL: u32 = 29;
pub const SIGPWR: u32 = 30;
pub const SIGSYS: u32 = 31;
pub const SIGUNUSED: u32 = 31;
pub const __SIGRTMIN: u32 = 32;
pub const SIGSWI: u32 = 32;
pub const SA_THIRTYTWO: u32 = 33554432;
pub const SA_RESTORER: u32 = 67108864;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_UNSUPPORTED: u32 = 1024;
pub const SA_EXPOSE_TAGBITS: u32 = 2048;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SI_MAX_SIZE: u32 = 128;
pub const SI_USER: u32 = 0;
pub const SI_KERNEL: u32 = 128;
pub const SI_QUEUE: i32 = -1;
pub const SI_TIMER: i32 = -2;
pub const SI_MESGQ: i32 = -3;
pub const SI_ASYNCIO: i32 = -4;
pub const SI_SIGIO: i32 = -5;
pub const SI_TKILL: i32 = -6;
pub const SI_DETHREAD: i32 = -7;
pub const SI_ASYNCNL: i32 = -60;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLOPN: u32 = 2;
pub const ILL_ILLADR: u32 = 3;
pub const ILL_ILLTRP: u32 = 4;
pub const ILL_PRVOPC: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const ILL_BADIADDR: u32 = 9;
pub const __ILL_BREAK: u32 = 10;
pub const __ILL_BNDMOD: u32 = 11;
pub const NSIGILL: u32 = 11;
pub const FPE_INTDIV: u32 = 1;
pub const FPE_INTOVF: u32 = 2;
pub const FPE_FLTDIV: u32 = 3;
pub const FPE_FLTOVF: u32 = 4;
pub const FPE_FLTUND: u32 = 5;
pub const FPE_FLTRES: u32 = 6;
pub const FPE_FLTINV: u32 = 7;
pub const FPE_FLTSUB: u32 = 8;
pub const __FPE_DECOVF: u32 = 9;
pub const __FPE_DECDIV: u32 = 10;
pub const __FPE_DECERR: u32 = 11;
pub const __FPE_INVASC: u32 = 12;
pub const __FPE_INVDEC: u32 = 13;
pub const FPE_FLTUNK: u32 = 14;
pub const FPE_CONDTRAP: u32 = 15;
pub const NSIGFPE: u32 = 15;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const SEGV_BNDERR: u32 = 3;
pub const SEGV_PKUERR: u32 = 4;
pub const SEGV_ACCADI: u32 = 5;
pub const SEGV_ADIDERR: u32 = 6;
pub const SEGV_ADIPERR: u32 = 7;
pub const SEGV_MTEAERR: u32 = 8;
pub const SEGV_MTESERR: u32 = 9;
pub const NSIGSEGV: u32 = 9;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const BUS_MCEERR_AR: u32 = 4;
pub const BUS_MCEERR_AO: u32 = 5;
pub const NSIGBUS: u32 = 5;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const TRAP_BRANCH: u32 = 3;
pub const TRAP_HWBKPT: u32 = 4;
pub const TRAP_UNK: u32 = 5;
pub const TRAP_PERF: u32 = 6;
pub const NSIGTRAP: u32 = 6;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const NSIGCHLD: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const NSIGPOLL: u32 = 6;
pub const SYS_SECCOMP: u32 = 1;
pub const SYS_USER_DISPATCH: u32 = 2;
pub const NSIGSYS: u32 = 2;
pub const EMT_TAGOVF: u32 = 1;
pub const NSIGEMT: u32 = 1;
pub const SIGEV_SIGNAL: u32 = 0;
pub const SIGEV_NONE: u32 = 1;
pub const SIGEV_THREAD: u32 = 2;
pub const SIGEV_THREAD_ID: u32 = 4;
pub const SIGEV_MAX_SIZE: u32 = 64;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 2;
pub const SS_AUTODISARM: u32 = 2147483648;
pub const SS_FLAG_BITS: u32 = 2147483648;
pub const _KERNEL__NSIG: u32 = 64;
pub const _NSIG: u32 = 65;
pub const NSIG: u32 = 65;
pub const PAGE_SIZE: u32 = 4096;
pub const PAGE_MASK: i32 = -4096;
pub const NGREG: u32 = 18;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_SGI_CYCLE: u32 = 10;
pub const CLOCK_TAI: u32 = 11;
pub const MAX_CLOCKS: u32 = 16;
pub const CLOCKS_MASK: u32 = 1;
pub const CLOCKS_MONO: u32 = 1;
pub const TIMER_ABSTIME: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const TIME_UTC: u32 = 1;
pub const CSIGNAL: u32 = 255;
pub const CLONE_VM: u32 = 256;
pub const CLONE_FS: u32 = 512;
pub const CLONE_FILES: u32 = 1024;
pub const CLONE_SIGHAND: u32 = 2048;
pub const CLONE_PIDFD: u32 = 4096;
pub const CLONE_PTRACE: u32 = 8192;
pub const CLONE_VFORK: u32 = 16384;
pub const CLONE_PARENT: u32 = 32768;
pub const CLONE_THREAD: u32 = 65536;
pub const CLONE_NEWNS: u32 = 131072;
pub const CLONE_SYSVSEM: u32 = 262144;
pub const CLONE_SETTLS: u32 = 524288;
pub const CLONE_PARENT_SETTID: u32 = 1048576;
pub const CLONE_CHILD_CLEARTID: u32 = 2097152;
pub const CLONE_DETACHED: u32 = 4194304;
pub const CLONE_UNTRACED: u32 = 8388608;
pub const CLONE_CHILD_SETTID: u32 = 16777216;
pub const CLONE_NEWCGROUP: u32 = 33554432;
pub const CLONE_NEWUTS: u32 = 67108864;
pub const CLONE_NEWIPC: u32 = 134217728;
pub const CLONE_NEWUSER: u32 = 268435456;
pub const CLONE_NEWPID: u32 = 536870912;
pub const CLONE_NEWNET: u32 = 1073741824;
pub const CLONE_IO: u32 = 2147483648;
pub const CLONE_CLEAR_SIGHAND: u64 = 4294967296;
pub const CLONE_INTO_CGROUP: u64 = 8589934592;
pub const CLONE_NEWTIME: u32 = 128;
pub const CLONE_ARGS_SIZE_VER0: u32 = 64;
pub const CLONE_ARGS_SIZE_VER1: u32 = 80;
pub const CLONE_ARGS_SIZE_VER2: u32 = 88;
pub const SCHED_NORMAL: u32 = 0;
pub const SCHED_FIFO: u32 = 1;
pub const SCHED_RR: u32 = 2;
pub const SCHED_BATCH: u32 = 3;
pub const SCHED_IDLE: u32 = 5;
pub const SCHED_DEADLINE: u32 = 6;
pub const SCHED_RESET_ON_FORK: u32 = 1073741824;
pub const SCHED_FLAG_RESET_ON_FORK: u32 = 1;
pub const SCHED_FLAG_RECLAIM: u32 = 2;
pub const SCHED_FLAG_DL_OVERRUN: u32 = 4;
pub const SCHED_FLAG_KEEP_POLICY: u32 = 8;
pub const SCHED_FLAG_KEEP_PARAMS: u32 = 16;
pub const SCHED_FLAG_UTIL_CLAMP_MIN: u32 = 32;
pub const SCHED_FLAG_UTIL_CLAMP_MAX: u32 = 64;
pub const SCHED_FLAG_KEEP_ALL: u32 = 24;
pub const SCHED_FLAG_UTIL_CLAMP: u32 = 96;
pub const SCHED_FLAG_ALL: u32 = 127;
pub const SCHED_OTHER: u32 = 0;
pub const PTHREAD_ONCE_INIT: u32 = 0;
pub const PTHREAD_BARRIER_SERIAL_THREAD: i32 = -1;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const PTHREAD_CREATE_DETACHED: u32 = 1;
pub const PTHREAD_CREATE_JOINABLE: u32 = 0;
pub const PTHREAD_EXPLICIT_SCHED: u32 = 0;
pub const PTHREAD_INHERIT_SCHED: u32 = 1;
pub const PTHREAD_PRIO_NONE: u32 = 0;
pub const PTHREAD_PRIO_INHERIT: u32 = 1;
pub const PTHREAD_PROCESS_PRIVATE: u32 = 0;
pub const PTHREAD_PROCESS_SHARED: u32 = 1;
pub const PTHREAD_SCOPE_SYSTEM: u32 = 0;
pub const PTHREAD_SCOPE_PROCESS: u32 = 1;
pub const NATIVE_APP_GLUE_MAX_INPUT_BUFFERS: u32 = 2;
extern "C" {
    pub fn android_get_application_target_sdk_version() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn android_get_device_api_level() -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __clang_max_align_nonce2: f64,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    const UNINIT: ::std::mem::MaybeUninit<max_align_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        16usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        8usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__clang_max_align_nonce1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__clang_max_align_nonce2) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __intptr_t = ::std::os::raw::c_int;
pub type __uintptr_t = ::std::os::raw::c_uint;
pub type int_least8_t = i8;
pub type uint_least8_t = u8;
pub type int_least16_t = i16;
pub type uint_least16_t = u16;
pub type int_least32_t = i32;
pub type uint_least32_t = u32;
pub type int_least64_t = i64;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type uint_fast8_t = u8;
pub type int_fast64_t = i64;
pub type uint_fast64_t = u64;
pub type int_fast16_t = i32;
pub type uint_fast16_t = u32;
pub type int_fast32_t = i32;
pub type uint_fast32_t = u32;
pub type uintmax_t = u64;
pub type intmax_t = i64;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 32usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_fd_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fds_bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_mode_t = ::std::os::raw::c_ushort;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_ushort;
pub type __kernel_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ushort;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_old_uid_t = __kernel_uid_t;
pub type __kernel_old_gid_t = __kernel_gid_t;
pub type __kernel_size_t = ::std::os::raw::c_uint;
pub type __kernel_ssize_t = ::std::os::raw::c_int;
pub type __kernel_ptrdiff_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_fsid_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).val) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fsid_t),
            "::",
            stringify!(val)
        )
    );
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::std::os::raw::c_uint;
pub type __gid_t = __kernel_gid32_t;
pub type gid_t = __gid_t;
pub type __uid_t = __kernel_uid32_t;
pub type uid_t = __uid_t;
pub type __pid_t = __kernel_pid_t;
pub type pid_t = __pid_t;
pub type __id_t = u32;
pub type id_t = __id_t;
pub type blkcnt_t = ::std::os::raw::c_ulong;
pub type blksize_t = ::std::os::raw::c_ulong;
pub type caddr_t = __kernel_caddr_t;
pub type clock_t = __kernel_clock_t;
pub type __clockid_t = __kernel_clockid_t;
pub type clockid_t = __clockid_t;
pub type daddr_t = __kernel_daddr_t;
pub type fsblkcnt_t = ::std::os::raw::c_ulong;
pub type fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __mode_t = __kernel_mode_t;
pub type mode_t = __mode_t;
pub type __key_t = __kernel_key_t;
pub type key_t = __key_t;
pub type __ino_t = __kernel_ino_t;
pub type ino_t = __ino_t;
pub type ino64_t = u64;
pub type __nlink_t = u32;
pub type nlink_t = __nlink_t;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type timer_t = __timer_t;
pub type __suseconds_t = __kernel_suseconds_t;
pub type suseconds_t = __suseconds_t;
pub type __useconds_t = u32;
pub type useconds_t = __useconds_t;
pub type dev_t = u32;
pub type __time_t = __kernel_time_t;
pub type time_t = __time_t;
pub type off_t = __kernel_off_t;
pub type loff_t = __kernel_loff_t;
pub type off64_t = loff_t;
pub type __socklen_t = i32;
pub type socklen_t = __socklen_t;
pub type __va_list = u32;
pub type uint_t = ::std::os::raw::c_uint;
pub type uint = ::std::os::raw::c_uint;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type u_int32_t = u32;
pub type u_int16_t = u16;
pub type u_int8_t = u8;
pub type u_int64_t = u64;
pub const AASSET_MODE_UNKNOWN: _bindgen_ty_1 = 0;
pub const AASSET_MODE_RANDOM: _bindgen_ty_1 = 1;
pub const AASSET_MODE_STREAMING: _bindgen_ty_1 = 2;
pub const AASSET_MODE_BUFFER: _bindgen_ty_1 = 3;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub const AKEYCODE_UNKNOWN: _bindgen_ty_2 = 0;
pub const AKEYCODE_SOFT_LEFT: _bindgen_ty_2 = 1;
pub const AKEYCODE_SOFT_RIGHT: _bindgen_ty_2 = 2;
pub const AKEYCODE_HOME: _bindgen_ty_2 = 3;
pub const AKEYCODE_BACK: _bindgen_ty_2 = 4;
pub const AKEYCODE_CALL: _bindgen_ty_2 = 5;
pub const AKEYCODE_ENDCALL: _bindgen_ty_2 = 6;
pub const AKEYCODE_0: _bindgen_ty_2 = 7;
pub const AKEYCODE_1: _bindgen_ty_2 = 8;
pub const AKEYCODE_2: _bindgen_ty_2 = 9;
pub const AKEYCODE_3: _bindgen_ty_2 = 10;
pub const AKEYCODE_4: _bindgen_ty_2 = 11;
pub const AKEYCODE_5: _bindgen_ty_2 = 12;
pub const AKEYCODE_6: _bindgen_ty_2 = 13;
pub const AKEYCODE_7: _bindgen_ty_2 = 14;
pub const AKEYCODE_8: _bindgen_ty_2 = 15;
pub const AKEYCODE_9: _bindgen_ty_2 = 16;
pub const AKEYCODE_STAR: _bindgen_ty_2 = 17;
pub const AKEYCODE_POUND: _bindgen_ty_2 = 18;
pub const AKEYCODE_DPAD_UP: _bindgen_ty_2 = 19;
pub const AKEYCODE_DPAD_DOWN: _bindgen_ty_2 = 20;
pub const AKEYCODE_DPAD_LEFT: _bindgen_ty_2 = 21;
pub const AKEYCODE_DPAD_RIGHT: _bindgen_ty_2 = 22;
pub const AKEYCODE_DPAD_CENTER: _bindgen_ty_2 = 23;
pub const AKEYCODE_VOLUME_UP: _bindgen_ty_2 = 24;
pub const AKEYCODE_VOLUME_DOWN: _bindgen_ty_2 = 25;
pub const AKEYCODE_POWER: _bindgen_ty_2 = 26;
pub const AKEYCODE_CAMERA: _bindgen_ty_2 = 27;
pub const AKEYCODE_CLEAR: _bindgen_ty_2 = 28;
pub const AKEYCODE_A: _bindgen_ty_2 = 29;
pub const AKEYCODE_B: _bindgen_ty_2 = 30;
pub const AKEYCODE_C: _bindgen_ty_2 = 31;
pub const AKEYCODE_D: _bindgen_ty_2 = 32;
pub const AKEYCODE_E: _bindgen_ty_2 = 33;
pub const AKEYCODE_F: _bindgen_ty_2 = 34;
pub const AKEYCODE_G: _bindgen_ty_2 = 35;
pub const AKEYCODE_H: _bindgen_ty_2 = 36;
pub const AKEYCODE_I: _bindgen_ty_2 = 37;
pub const AKEYCODE_J: _bindgen_ty_2 = 38;
pub const AKEYCODE_K: _bindgen_ty_2 = 39;
pub const AKEYCODE_L: _bindgen_ty_2 = 40;
pub const AKEYCODE_M: _bindgen_ty_2 = 41;
pub const AKEYCODE_N: _bindgen_ty_2 = 42;
pub const AKEYCODE_O: _bindgen_ty_2 = 43;
pub const AKEYCODE_P: _bindgen_ty_2 = 44;
pub const AKEYCODE_Q: _bindgen_ty_2 = 45;
pub const AKEYCODE_R: _bindgen_ty_2 = 46;
pub const AKEYCODE_S: _bindgen_ty_2 = 47;
pub const AKEYCODE_T: _bindgen_ty_2 = 48;
pub const AKEYCODE_U: _bindgen_ty_2 = 49;
pub const AKEYCODE_V: _bindgen_ty_2 = 50;
pub const AKEYCODE_W: _bindgen_ty_2 = 51;
pub const AKEYCODE_X: _bindgen_ty_2 = 52;
pub const AKEYCODE_Y: _bindgen_ty_2 = 53;
pub const AKEYCODE_Z: _bindgen_ty_2 = 54;
pub const AKEYCODE_COMMA: _bindgen_ty_2 = 55;
pub const AKEYCODE_PERIOD: _bindgen_ty_2 = 56;
pub const AKEYCODE_ALT_LEFT: _bindgen_ty_2 = 57;
pub const AKEYCODE_ALT_RIGHT: _bindgen_ty_2 = 58;
pub const AKEYCODE_SHIFT_LEFT: _bindgen_ty_2 = 59;
pub const AKEYCODE_SHIFT_RIGHT: _bindgen_ty_2 = 60;
pub const AKEYCODE_TAB: _bindgen_ty_2 = 61;
pub const AKEYCODE_SPACE: _bindgen_ty_2 = 62;
pub const AKEYCODE_SYM: _bindgen_ty_2 = 63;
pub const AKEYCODE_EXPLORER: _bindgen_ty_2 = 64;
pub const AKEYCODE_ENVELOPE: _bindgen_ty_2 = 65;
pub const AKEYCODE_ENTER: _bindgen_ty_2 = 66;
pub const AKEYCODE_DEL: _bindgen_ty_2 = 67;
pub const AKEYCODE_GRAVE: _bindgen_ty_2 = 68;
pub const AKEYCODE_MINUS: _bindgen_ty_2 = 69;
pub const AKEYCODE_EQUALS: _bindgen_ty_2 = 70;
pub const AKEYCODE_LEFT_BRACKET: _bindgen_ty_2 = 71;
pub const AKEYCODE_RIGHT_BRACKET: _bindgen_ty_2 = 72;
pub const AKEYCODE_BACKSLASH: _bindgen_ty_2 = 73;
pub const AKEYCODE_SEMICOLON: _bindgen_ty_2 = 74;
pub const AKEYCODE_APOSTROPHE: _bindgen_ty_2 = 75;
pub const AKEYCODE_SLASH: _bindgen_ty_2 = 76;
pub const AKEYCODE_AT: _bindgen_ty_2 = 77;
pub const AKEYCODE_NUM: _bindgen_ty_2 = 78;
pub const AKEYCODE_HEADSETHOOK: _bindgen_ty_2 = 79;
pub const AKEYCODE_FOCUS: _bindgen_ty_2 = 80;
pub const AKEYCODE_PLUS: _bindgen_ty_2 = 81;
pub const AKEYCODE_MENU: _bindgen_ty_2 = 82;
pub const AKEYCODE_NOTIFICATION: _bindgen_ty_2 = 83;
pub const AKEYCODE_SEARCH: _bindgen_ty_2 = 84;
pub const AKEYCODE_MEDIA_PLAY_PAUSE: _bindgen_ty_2 = 85;
pub const AKEYCODE_MEDIA_STOP: _bindgen_ty_2 = 86;
pub const AKEYCODE_MEDIA_NEXT: _bindgen_ty_2 = 87;
pub const AKEYCODE_MEDIA_PREVIOUS: _bindgen_ty_2 = 88;
pub const AKEYCODE_MEDIA_REWIND: _bindgen_ty_2 = 89;
pub const AKEYCODE_MEDIA_FAST_FORWARD: _bindgen_ty_2 = 90;
pub const AKEYCODE_MUTE: _bindgen_ty_2 = 91;
pub const AKEYCODE_PAGE_UP: _bindgen_ty_2 = 92;
pub const AKEYCODE_PAGE_DOWN: _bindgen_ty_2 = 93;
pub const AKEYCODE_PICTSYMBOLS: _bindgen_ty_2 = 94;
pub const AKEYCODE_SWITCH_CHARSET: _bindgen_ty_2 = 95;
pub const AKEYCODE_BUTTON_A: _bindgen_ty_2 = 96;
pub const AKEYCODE_BUTTON_B: _bindgen_ty_2 = 97;
pub const AKEYCODE_BUTTON_C: _bindgen_ty_2 = 98;
pub const AKEYCODE_BUTTON_X: _bindgen_ty_2 = 99;
pub const AKEYCODE_BUTTON_Y: _bindgen_ty_2 = 100;
pub const AKEYCODE_BUTTON_Z: _bindgen_ty_2 = 101;
pub const AKEYCODE_BUTTON_L1: _bindgen_ty_2 = 102;
pub const AKEYCODE_BUTTON_R1: _bindgen_ty_2 = 103;
pub const AKEYCODE_BUTTON_L2: _bindgen_ty_2 = 104;
pub const AKEYCODE_BUTTON_R2: _bindgen_ty_2 = 105;
pub const AKEYCODE_BUTTON_THUMBL: _bindgen_ty_2 = 106;
pub const AKEYCODE_BUTTON_THUMBR: _bindgen_ty_2 = 107;
pub const AKEYCODE_BUTTON_START: _bindgen_ty_2 = 108;
pub const AKEYCODE_BUTTON_SELECT: _bindgen_ty_2 = 109;
pub const AKEYCODE_BUTTON_MODE: _bindgen_ty_2 = 110;
pub const AKEYCODE_ESCAPE: _bindgen_ty_2 = 111;
pub const AKEYCODE_FORWARD_DEL: _bindgen_ty_2 = 112;
pub const AKEYCODE_CTRL_LEFT: _bindgen_ty_2 = 113;
pub const AKEYCODE_CTRL_RIGHT: _bindgen_ty_2 = 114;
pub const AKEYCODE_CAPS_LOCK: _bindgen_ty_2 = 115;
pub const AKEYCODE_SCROLL_LOCK: _bindgen_ty_2 = 116;
pub const AKEYCODE_META_LEFT: _bindgen_ty_2 = 117;
pub const AKEYCODE_META_RIGHT: _bindgen_ty_2 = 118;
pub const AKEYCODE_FUNCTION: _bindgen_ty_2 = 119;
pub const AKEYCODE_SYSRQ: _bindgen_ty_2 = 120;
pub const AKEYCODE_BREAK: _bindgen_ty_2 = 121;
pub const AKEYCODE_MOVE_HOME: _bindgen_ty_2 = 122;
pub const AKEYCODE_MOVE_END: _bindgen_ty_2 = 123;
pub const AKEYCODE_INSERT: _bindgen_ty_2 = 124;
pub const AKEYCODE_FORWARD: _bindgen_ty_2 = 125;
pub const AKEYCODE_MEDIA_PLAY: _bindgen_ty_2 = 126;
pub const AKEYCODE_MEDIA_PAUSE: _bindgen_ty_2 = 127;
pub const AKEYCODE_MEDIA_CLOSE: _bindgen_ty_2 = 128;
pub const AKEYCODE_MEDIA_EJECT: _bindgen_ty_2 = 129;
pub const AKEYCODE_MEDIA_RECORD: _bindgen_ty_2 = 130;
pub const AKEYCODE_F1: _bindgen_ty_2 = 131;
pub const AKEYCODE_F2: _bindgen_ty_2 = 132;
pub const AKEYCODE_F3: _bindgen_ty_2 = 133;
pub const AKEYCODE_F4: _bindgen_ty_2 = 134;
pub const AKEYCODE_F5: _bindgen_ty_2 = 135;
pub const AKEYCODE_F6: _bindgen_ty_2 = 136;
pub const AKEYCODE_F7: _bindgen_ty_2 = 137;
pub const AKEYCODE_F8: _bindgen_ty_2 = 138;
pub const AKEYCODE_F9: _bindgen_ty_2 = 139;
pub const AKEYCODE_F10: _bindgen_ty_2 = 140;
pub const AKEYCODE_F11: _bindgen_ty_2 = 141;
pub const AKEYCODE_F12: _bindgen_ty_2 = 142;
pub const AKEYCODE_NUM_LOCK: _bindgen_ty_2 = 143;
pub const AKEYCODE_NUMPAD_0: _bindgen_ty_2 = 144;
pub const AKEYCODE_NUMPAD_1: _bindgen_ty_2 = 145;
pub const AKEYCODE_NUMPAD_2: _bindgen_ty_2 = 146;
pub const AKEYCODE_NUMPAD_3: _bindgen_ty_2 = 147;
pub const AKEYCODE_NUMPAD_4: _bindgen_ty_2 = 148;
pub const AKEYCODE_NUMPAD_5: _bindgen_ty_2 = 149;
pub const AKEYCODE_NUMPAD_6: _bindgen_ty_2 = 150;
pub const AKEYCODE_NUMPAD_7: _bindgen_ty_2 = 151;
pub const AKEYCODE_NUMPAD_8: _bindgen_ty_2 = 152;
pub const AKEYCODE_NUMPAD_9: _bindgen_ty_2 = 153;
pub const AKEYCODE_NUMPAD_DIVIDE: _bindgen_ty_2 = 154;
pub const AKEYCODE_NUMPAD_MULTIPLY: _bindgen_ty_2 = 155;
pub const AKEYCODE_NUMPAD_SUBTRACT: _bindgen_ty_2 = 156;
pub const AKEYCODE_NUMPAD_ADD: _bindgen_ty_2 = 157;
pub const AKEYCODE_NUMPAD_DOT: _bindgen_ty_2 = 158;
pub const AKEYCODE_NUMPAD_COMMA: _bindgen_ty_2 = 159;
pub const AKEYCODE_NUMPAD_ENTER: _bindgen_ty_2 = 160;
pub const AKEYCODE_NUMPAD_EQUALS: _bindgen_ty_2 = 161;
pub const AKEYCODE_NUMPAD_LEFT_PAREN: _bindgen_ty_2 = 162;
pub const AKEYCODE_NUMPAD_RIGHT_PAREN: _bindgen_ty_2 = 163;
pub const AKEYCODE_VOLUME_MUTE: _bindgen_ty_2 = 164;
pub const AKEYCODE_INFO: _bindgen_ty_2 = 165;
pub const AKEYCODE_CHANNEL_UP: _bindgen_ty_2 = 166;
pub const AKEYCODE_CHANNEL_DOWN: _bindgen_ty_2 = 167;
pub const AKEYCODE_ZOOM_IN: _bindgen_ty_2 = 168;
pub const AKEYCODE_ZOOM_OUT: _bindgen_ty_2 = 169;
pub const AKEYCODE_TV: _bindgen_ty_2 = 170;
pub const AKEYCODE_WINDOW: _bindgen_ty_2 = 171;
pub const AKEYCODE_GUIDE: _bindgen_ty_2 = 172;
pub const AKEYCODE_DVR: _bindgen_ty_2 = 173;
pub const AKEYCODE_BOOKMARK: _bindgen_ty_2 = 174;
pub const AKEYCODE_CAPTIONS: _bindgen_ty_2 = 175;
pub const AKEYCODE_SETTINGS: _bindgen_ty_2 = 176;
pub const AKEYCODE_TV_POWER: _bindgen_ty_2 = 177;
pub const AKEYCODE_TV_INPUT: _bindgen_ty_2 = 178;
pub const AKEYCODE_STB_POWER: _bindgen_ty_2 = 179;
pub const AKEYCODE_STB_INPUT: _bindgen_ty_2 = 180;
pub const AKEYCODE_AVR_POWER: _bindgen_ty_2 = 181;
pub const AKEYCODE_AVR_INPUT: _bindgen_ty_2 = 182;
pub const AKEYCODE_PROG_RED: _bindgen_ty_2 = 183;
pub const AKEYCODE_PROG_GREEN: _bindgen_ty_2 = 184;
pub const AKEYCODE_PROG_YELLOW: _bindgen_ty_2 = 185;
pub const AKEYCODE_PROG_BLUE: _bindgen_ty_2 = 186;
pub const AKEYCODE_APP_SWITCH: _bindgen_ty_2 = 187;
pub const AKEYCODE_BUTTON_1: _bindgen_ty_2 = 188;
pub const AKEYCODE_BUTTON_2: _bindgen_ty_2 = 189;
pub const AKEYCODE_BUTTON_3: _bindgen_ty_2 = 190;
pub const AKEYCODE_BUTTON_4: _bindgen_ty_2 = 191;
pub const AKEYCODE_BUTTON_5: _bindgen_ty_2 = 192;
pub const AKEYCODE_BUTTON_6: _bindgen_ty_2 = 193;
pub const AKEYCODE_BUTTON_7: _bindgen_ty_2 = 194;
pub const AKEYCODE_BUTTON_8: _bindgen_ty_2 = 195;
pub const AKEYCODE_BUTTON_9: _bindgen_ty_2 = 196;
pub const AKEYCODE_BUTTON_10: _bindgen_ty_2 = 197;
pub const AKEYCODE_BUTTON_11: _bindgen_ty_2 = 198;
pub const AKEYCODE_BUTTON_12: _bindgen_ty_2 = 199;
pub const AKEYCODE_BUTTON_13: _bindgen_ty_2 = 200;
pub const AKEYCODE_BUTTON_14: _bindgen_ty_2 = 201;
pub const AKEYCODE_BUTTON_15: _bindgen_ty_2 = 202;
pub const AKEYCODE_BUTTON_16: _bindgen_ty_2 = 203;
pub const AKEYCODE_LANGUAGE_SWITCH: _bindgen_ty_2 = 204;
pub const AKEYCODE_MANNER_MODE: _bindgen_ty_2 = 205;
pub const AKEYCODE_3D_MODE: _bindgen_ty_2 = 206;
pub const AKEYCODE_CONTACTS: _bindgen_ty_2 = 207;
pub const AKEYCODE_CALENDAR: _bindgen_ty_2 = 208;
pub const AKEYCODE_MUSIC: _bindgen_ty_2 = 209;
pub const AKEYCODE_CALCULATOR: _bindgen_ty_2 = 210;
pub const AKEYCODE_ZENKAKU_HANKAKU: _bindgen_ty_2 = 211;
pub const AKEYCODE_EISU: _bindgen_ty_2 = 212;
pub const AKEYCODE_MUHENKAN: _bindgen_ty_2 = 213;
pub const AKEYCODE_HENKAN: _bindgen_ty_2 = 214;
pub const AKEYCODE_KATAKANA_HIRAGANA: _bindgen_ty_2 = 215;
pub const AKEYCODE_YEN: _bindgen_ty_2 = 216;
pub const AKEYCODE_RO: _bindgen_ty_2 = 217;
pub const AKEYCODE_KANA: _bindgen_ty_2 = 218;
pub const AKEYCODE_ASSIST: _bindgen_ty_2 = 219;
pub const AKEYCODE_BRIGHTNESS_DOWN: _bindgen_ty_2 = 220;
pub const AKEYCODE_BRIGHTNESS_UP: _bindgen_ty_2 = 221;
pub const AKEYCODE_MEDIA_AUDIO_TRACK: _bindgen_ty_2 = 222;
pub const AKEYCODE_SLEEP: _bindgen_ty_2 = 223;
pub const AKEYCODE_WAKEUP: _bindgen_ty_2 = 224;
pub const AKEYCODE_PAIRING: _bindgen_ty_2 = 225;
pub const AKEYCODE_MEDIA_TOP_MENU: _bindgen_ty_2 = 226;
pub const AKEYCODE_11: _bindgen_ty_2 = 227;
pub const AKEYCODE_12: _bindgen_ty_2 = 228;
pub const AKEYCODE_LAST_CHANNEL: _bindgen_ty_2 = 229;
pub const AKEYCODE_TV_DATA_SERVICE: _bindgen_ty_2 = 230;
pub const AKEYCODE_VOICE_ASSIST: _bindgen_ty_2 = 231;
pub const AKEYCODE_TV_RADIO_SERVICE: _bindgen_ty_2 = 232;
pub const AKEYCODE_TV_TELETEXT: _bindgen_ty_2 = 233;
pub const AKEYCODE_TV_NUMBER_ENTRY: _bindgen_ty_2 = 234;
pub const AKEYCODE_TV_TERRESTRIAL_ANALOG: _bindgen_ty_2 = 235;
pub const AKEYCODE_TV_TERRESTRIAL_DIGITAL: _bindgen_ty_2 = 236;
pub const AKEYCODE_TV_SATELLITE: _bindgen_ty_2 = 237;
pub const AKEYCODE_TV_SATELLITE_BS: _bindgen_ty_2 = 238;
pub const AKEYCODE_TV_SATELLITE_CS: _bindgen_ty_2 = 239;
pub const AKEYCODE_TV_SATELLITE_SERVICE: _bindgen_ty_2 = 240;
pub const AKEYCODE_TV_NETWORK: _bindgen_ty_2 = 241;
pub const AKEYCODE_TV_ANTENNA_CABLE: _bindgen_ty_2 = 242;
pub const AKEYCODE_TV_INPUT_HDMI_1: _bindgen_ty_2 = 243;
pub const AKEYCODE_TV_INPUT_HDMI_2: _bindgen_ty_2 = 244;
pub const AKEYCODE_TV_INPUT_HDMI_3: _bindgen_ty_2 = 245;
pub const AKEYCODE_TV_INPUT_HDMI_4: _bindgen_ty_2 = 246;
pub const AKEYCODE_TV_INPUT_COMPOSITE_1: _bindgen_ty_2 = 247;
pub const AKEYCODE_TV_INPUT_COMPOSITE_2: _bindgen_ty_2 = 248;
pub const AKEYCODE_TV_INPUT_COMPONENT_1: _bindgen_ty_2 = 249;
pub const AKEYCODE_TV_INPUT_COMPONENT_2: _bindgen_ty_2 = 250;
pub const AKEYCODE_TV_INPUT_VGA_1: _bindgen_ty_2 = 251;
pub const AKEYCODE_TV_AUDIO_DESCRIPTION: _bindgen_ty_2 = 252;
pub const AKEYCODE_TV_AUDIO_DESCRIPTION_MIX_UP: _bindgen_ty_2 = 253;
pub const AKEYCODE_TV_AUDIO_DESCRIPTION_MIX_DOWN: _bindgen_ty_2 = 254;
pub const AKEYCODE_TV_ZOOM_MODE: _bindgen_ty_2 = 255;
pub const AKEYCODE_TV_CONTENTS_MENU: _bindgen_ty_2 = 256;
pub const AKEYCODE_TV_MEDIA_CONTEXT_MENU: _bindgen_ty_2 = 257;
pub const AKEYCODE_TV_TIMER_PROGRAMMING: _bindgen_ty_2 = 258;
pub const AKEYCODE_HELP: _bindgen_ty_2 = 259;
pub const AKEYCODE_NAVIGATE_PREVIOUS: _bindgen_ty_2 = 260;
pub const AKEYCODE_NAVIGATE_NEXT: _bindgen_ty_2 = 261;
pub const AKEYCODE_NAVIGATE_IN: _bindgen_ty_2 = 262;
pub const AKEYCODE_NAVIGATE_OUT: _bindgen_ty_2 = 263;
pub const AKEYCODE_STEM_PRIMARY: _bindgen_ty_2 = 264;
pub const AKEYCODE_STEM_1: _bindgen_ty_2 = 265;
pub const AKEYCODE_STEM_2: _bindgen_ty_2 = 266;
pub const AKEYCODE_STEM_3: _bindgen_ty_2 = 267;
pub const AKEYCODE_DPAD_UP_LEFT: _bindgen_ty_2 = 268;
pub const AKEYCODE_DPAD_DOWN_LEFT: _bindgen_ty_2 = 269;
pub const AKEYCODE_DPAD_UP_RIGHT: _bindgen_ty_2 = 270;
pub const AKEYCODE_DPAD_DOWN_RIGHT: _bindgen_ty_2 = 271;
pub const AKEYCODE_MEDIA_SKIP_FORWARD: _bindgen_ty_2 = 272;
pub const AKEYCODE_MEDIA_SKIP_BACKWARD: _bindgen_ty_2 = 273;
pub const AKEYCODE_MEDIA_STEP_FORWARD: _bindgen_ty_2 = 274;
pub const AKEYCODE_MEDIA_STEP_BACKWARD: _bindgen_ty_2 = 275;
pub const AKEYCODE_SOFT_SLEEP: _bindgen_ty_2 = 276;
pub const AKEYCODE_CUT: _bindgen_ty_2 = 277;
pub const AKEYCODE_COPY: _bindgen_ty_2 = 278;
pub const AKEYCODE_PASTE: _bindgen_ty_2 = 279;
pub const AKEYCODE_SYSTEM_NAVIGATION_UP: _bindgen_ty_2 = 280;
pub const AKEYCODE_SYSTEM_NAVIGATION_DOWN: _bindgen_ty_2 = 281;
pub const AKEYCODE_SYSTEM_NAVIGATION_LEFT: _bindgen_ty_2 = 282;
pub const AKEYCODE_SYSTEM_NAVIGATION_RIGHT: _bindgen_ty_2 = 283;
pub const AKEYCODE_ALL_APPS: _bindgen_ty_2 = 284;
pub const AKEYCODE_REFRESH: _bindgen_ty_2 = 285;
pub const AKEYCODE_THUMBS_UP: _bindgen_ty_2 = 286;
pub const AKEYCODE_THUMBS_DOWN: _bindgen_ty_2 = 287;
pub const AKEYCODE_PROFILE_SWITCH: _bindgen_ty_2 = 288;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub const ALOOPER_PREPARE_ALLOW_NON_CALLBACKS: _bindgen_ty_3 = 1;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
pub const ALOOPER_POLL_WAKE: _bindgen_ty_4 = -1;
pub const ALOOPER_POLL_CALLBACK: _bindgen_ty_4 = -2;
pub const ALOOPER_POLL_TIMEOUT: _bindgen_ty_4 = -3;
pub const ALOOPER_POLL_ERROR: _bindgen_ty_4 = -4;
pub type _bindgen_ty_4 = ::std::os::raw::c_int;
pub const ALOOPER_EVENT_INPUT: _bindgen_ty_5 = 1;
pub const ALOOPER_EVENT_OUTPUT: _bindgen_ty_5 = 2;
pub const ALOOPER_EVENT_ERROR: _bindgen_ty_5 = 4;
pub const ALOOPER_EVENT_HANGUP: _bindgen_ty_5 = 8;
pub const ALOOPER_EVENT_INVALID: _bindgen_ty_5 = 16;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
pub type va_list = u32;
pub type __gnuc_va_list = u32;
#[repr(C)]
pub struct JavaVMAttachArgs {
    pub version: jint,
    pub name: *const ::std::os::raw::c_char,
    pub group: jobject,
}
#[test]
fn bindgen_test_layout_JavaVMAttachArgs() {
    const UNINIT: ::std::mem::MaybeUninit<JavaVMAttachArgs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<JavaVMAttachArgs>(),
        12usize,
        concat!("Size of: ", stringify!(JavaVMAttachArgs))
    );
    assert_eq!(
        ::std::mem::align_of::<JavaVMAttachArgs>(),
        4usize,
        concat!("Alignment of ", stringify!(JavaVMAttachArgs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMAttachArgs),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMAttachArgs),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).group) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMAttachArgs),
            "::",
            stringify!(group)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JavaVMOption {
    pub optionString: *const ::std::os::raw::c_char,
    pub extraInfo: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_JavaVMOption() {
    const UNINIT: ::std::mem::MaybeUninit<JavaVMOption> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<JavaVMOption>(),
        8usize,
        concat!("Size of: ", stringify!(JavaVMOption))
    );
    assert_eq!(
        ::std::mem::align_of::<JavaVMOption>(),
        4usize,
        concat!("Alignment of ", stringify!(JavaVMOption))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).optionString) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMOption),
            "::",
            stringify!(optionString)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extraInfo) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMOption),
            "::",
            stringify!(extraInfo)
        )
    );
}
#[repr(C)]
pub struct JavaVMInitArgs {
    pub version: jint,
    pub nOptions: jint,
    pub options: *mut JavaVMOption,
    pub ignoreUnrecognized: jboolean,
}
#[test]
fn bindgen_test_layout_JavaVMInitArgs() {
    const UNINIT: ::std::mem::MaybeUninit<JavaVMInitArgs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<JavaVMInitArgs>(),
        16usize,
        concat!("Size of: ", stringify!(JavaVMInitArgs))
    );
    assert_eq!(
        ::std::mem::align_of::<JavaVMInitArgs>(),
        4usize,
        concat!("Alignment of ", stringify!(JavaVMInitArgs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMInitArgs),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nOptions) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMInitArgs),
            "::",
            stringify!(nOptions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).options) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMInitArgs),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ignoreUnrecognized) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(JavaVMInitArgs),
            "::",
            stringify!(ignoreUnrecognized)
        )
    );
}
pub const AKEY_STATE_UNKNOWN: _bindgen_ty_6 = -1;
pub const AKEY_STATE_UP: _bindgen_ty_6 = 0;
pub const AKEY_STATE_DOWN: _bindgen_ty_6 = 1;
pub const AKEY_STATE_VIRTUAL: _bindgen_ty_6 = 2;
pub type _bindgen_ty_6 = ::std::os::raw::c_int;
pub const AMETA_NONE: _bindgen_ty_7 = 0;
pub const AMETA_ALT_ON: _bindgen_ty_7 = 2;
pub const AMETA_ALT_LEFT_ON: _bindgen_ty_7 = 16;
pub const AMETA_ALT_RIGHT_ON: _bindgen_ty_7 = 32;
pub const AMETA_SHIFT_ON: _bindgen_ty_7 = 1;
pub const AMETA_SHIFT_LEFT_ON: _bindgen_ty_7 = 64;
pub const AMETA_SHIFT_RIGHT_ON: _bindgen_ty_7 = 128;
pub const AMETA_SYM_ON: _bindgen_ty_7 = 4;
pub const AMETA_FUNCTION_ON: _bindgen_ty_7 = 8;
pub const AMETA_CTRL_ON: _bindgen_ty_7 = 4096;
pub const AMETA_CTRL_LEFT_ON: _bindgen_ty_7 = 8192;
pub const AMETA_CTRL_RIGHT_ON: _bindgen_ty_7 = 16384;
pub const AMETA_META_ON: _bindgen_ty_7 = 65536;
pub const AMETA_META_LEFT_ON: _bindgen_ty_7 = 131072;
pub const AMETA_META_RIGHT_ON: _bindgen_ty_7 = 262144;
pub const AMETA_CAPS_LOCK_ON: _bindgen_ty_7 = 1048576;
pub const AMETA_NUM_LOCK_ON: _bindgen_ty_7 = 2097152;
pub const AMETA_SCROLL_LOCK_ON: _bindgen_ty_7 = 4194304;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AInputEvent {
    _unused: [u8; 0],
}
pub const AINPUT_EVENT_TYPE_KEY: _bindgen_ty_8 = 1;
pub const AINPUT_EVENT_TYPE_MOTION: _bindgen_ty_8 = 2;
pub const AINPUT_EVENT_TYPE_FOCUS: _bindgen_ty_8 = 3;
pub const AINPUT_EVENT_TYPE_CAPTURE: _bindgen_ty_8 = 4;
pub const AINPUT_EVENT_TYPE_DRAG: _bindgen_ty_8 = 5;
pub const AINPUT_EVENT_TYPE_TOUCH_MODE: _bindgen_ty_8 = 6;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
pub const AKEY_EVENT_ACTION_DOWN: _bindgen_ty_9 = 0;
pub const AKEY_EVENT_ACTION_UP: _bindgen_ty_9 = 1;
pub const AKEY_EVENT_ACTION_MULTIPLE: _bindgen_ty_9 = 2;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
pub const AKEY_EVENT_FLAG_WOKE_HERE: _bindgen_ty_10 = 1;
pub const AKEY_EVENT_FLAG_SOFT_KEYBOARD: _bindgen_ty_10 = 2;
pub const AKEY_EVENT_FLAG_KEEP_TOUCH_MODE: _bindgen_ty_10 = 4;
pub const AKEY_EVENT_FLAG_FROM_SYSTEM: _bindgen_ty_10 = 8;
pub const AKEY_EVENT_FLAG_EDITOR_ACTION: _bindgen_ty_10 = 16;
pub const AKEY_EVENT_FLAG_CANCELED: _bindgen_ty_10 = 32;
pub const AKEY_EVENT_FLAG_VIRTUAL_HARD_KEY: _bindgen_ty_10 = 64;
pub const AKEY_EVENT_FLAG_LONG_PRESS: _bindgen_ty_10 = 128;
pub const AKEY_EVENT_FLAG_CANCELED_LONG_PRESS: _bindgen_ty_10 = 256;
pub const AKEY_EVENT_FLAG_TRACKING: _bindgen_ty_10 = 512;
pub const AKEY_EVENT_FLAG_FALLBACK: _bindgen_ty_10 = 1024;
pub type _bindgen_ty_10 = ::std::os::raw::c_uint;
pub const AMOTION_EVENT_ACTION_MASK: _bindgen_ty_11 = 255;
pub const AMOTION_EVENT_ACTION_POINTER_INDEX_MASK: _bindgen_ty_11 = 65280;
pub const AMOTION_EVENT_ACTION_DOWN: _bindgen_ty_11 = 0;
pub const AMOTION_EVENT_ACTION_UP: _bindgen_ty_11 = 1;
pub const AMOTION_EVENT_ACTION_MOVE: _bindgen_ty_11 = 2;
pub const AMOTION_EVENT_ACTION_CANCEL: _bindgen_ty_11 = 3;
pub const AMOTION_EVENT_ACTION_OUTSIDE: _bindgen_ty_11 = 4;
pub const AMOTION_EVENT_ACTION_POINTER_DOWN: _bindgen_ty_11 = 5;
pub const AMOTION_EVENT_ACTION_POINTER_UP: _bindgen_ty_11 = 6;
pub const AMOTION_EVENT_ACTION_HOVER_MOVE: _bindgen_ty_11 = 7;
pub const AMOTION_EVENT_ACTION_SCROLL: _bindgen_ty_11 = 8;
pub const AMOTION_EVENT_ACTION_HOVER_ENTER: _bindgen_ty_11 = 9;
pub const AMOTION_EVENT_ACTION_HOVER_EXIT: _bindgen_ty_11 = 10;
pub const AMOTION_EVENT_ACTION_BUTTON_PRESS: _bindgen_ty_11 = 11;
pub const AMOTION_EVENT_ACTION_BUTTON_RELEASE: _bindgen_ty_11 = 12;
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
pub const AMOTION_EVENT_FLAG_WINDOW_IS_OBSCURED: _bindgen_ty_12 = 1;
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
pub const AMOTION_EVENT_EDGE_FLAG_NONE: _bindgen_ty_13 = 0;
pub const AMOTION_EVENT_EDGE_FLAG_TOP: _bindgen_ty_13 = 1;
pub const AMOTION_EVENT_EDGE_FLAG_BOTTOM: _bindgen_ty_13 = 2;
pub const AMOTION_EVENT_EDGE_FLAG_LEFT: _bindgen_ty_13 = 4;
pub const AMOTION_EVENT_EDGE_FLAG_RIGHT: _bindgen_ty_13 = 8;
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
pub const AMOTION_EVENT_AXIS_X: _bindgen_ty_14 = 0;
pub const AMOTION_EVENT_AXIS_Y: _bindgen_ty_14 = 1;
pub const AMOTION_EVENT_AXIS_PRESSURE: _bindgen_ty_14 = 2;
pub const AMOTION_EVENT_AXIS_SIZE: _bindgen_ty_14 = 3;
pub const AMOTION_EVENT_AXIS_TOUCH_MAJOR: _bindgen_ty_14 = 4;
pub const AMOTION_EVENT_AXIS_TOUCH_MINOR: _bindgen_ty_14 = 5;
pub const AMOTION_EVENT_AXIS_TOOL_MAJOR: _bindgen_ty_14 = 6;
pub const AMOTION_EVENT_AXIS_TOOL_MINOR: _bindgen_ty_14 = 7;
pub const AMOTION_EVENT_AXIS_ORIENTATION: _bindgen_ty_14 = 8;
pub const AMOTION_EVENT_AXIS_VSCROLL: _bindgen_ty_14 = 9;
pub const AMOTION_EVENT_AXIS_HSCROLL: _bindgen_ty_14 = 10;
pub const AMOTION_EVENT_AXIS_Z: _bindgen_ty_14 = 11;
pub const AMOTION_EVENT_AXIS_RX: _bindgen_ty_14 = 12;
pub const AMOTION_EVENT_AXIS_RY: _bindgen_ty_14 = 13;
pub const AMOTION_EVENT_AXIS_RZ: _bindgen_ty_14 = 14;
pub const AMOTION_EVENT_AXIS_HAT_X: _bindgen_ty_14 = 15;
pub const AMOTION_EVENT_AXIS_HAT_Y: _bindgen_ty_14 = 16;
pub const AMOTION_EVENT_AXIS_LTRIGGER: _bindgen_ty_14 = 17;
pub const AMOTION_EVENT_AXIS_RTRIGGER: _bindgen_ty_14 = 18;
pub const AMOTION_EVENT_AXIS_THROTTLE: _bindgen_ty_14 = 19;
pub const AMOTION_EVENT_AXIS_RUDDER: _bindgen_ty_14 = 20;
pub const AMOTION_EVENT_AXIS_WHEEL: _bindgen_ty_14 = 21;
pub const AMOTION_EVENT_AXIS_GAS: _bindgen_ty_14 = 22;
pub const AMOTION_EVENT_AXIS_BRAKE: _bindgen_ty_14 = 23;
pub const AMOTION_EVENT_AXIS_DISTANCE: _bindgen_ty_14 = 24;
pub const AMOTION_EVENT_AXIS_TILT: _bindgen_ty_14 = 25;
pub const AMOTION_EVENT_AXIS_SCROLL: _bindgen_ty_14 = 26;
pub const AMOTION_EVENT_AXIS_RELATIVE_X: _bindgen_ty_14 = 27;
pub const AMOTION_EVENT_AXIS_RELATIVE_Y: _bindgen_ty_14 = 28;
pub const AMOTION_EVENT_AXIS_GENERIC_1: _bindgen_ty_14 = 32;
pub const AMOTION_EVENT_AXIS_GENERIC_2: _bindgen_ty_14 = 33;
pub const AMOTION_EVENT_AXIS_GENERIC_3: _bindgen_ty_14 = 34;
pub const AMOTION_EVENT_AXIS_GENERIC_4: _bindgen_ty_14 = 35;
pub const AMOTION_EVENT_AXIS_GENERIC_5: _bindgen_ty_14 = 36;
pub const AMOTION_EVENT_AXIS_GENERIC_6: _bindgen_ty_14 = 37;
pub const AMOTION_EVENT_AXIS_GENERIC_7: _bindgen_ty_14 = 38;
pub const AMOTION_EVENT_AXIS_GENERIC_8: _bindgen_ty_14 = 39;
pub const AMOTION_EVENT_AXIS_GENERIC_9: _bindgen_ty_14 = 40;
pub const AMOTION_EVENT_AXIS_GENERIC_10: _bindgen_ty_14 = 41;
pub const AMOTION_EVENT_AXIS_GENERIC_11: _bindgen_ty_14 = 42;
pub const AMOTION_EVENT_AXIS_GENERIC_12: _bindgen_ty_14 = 43;
pub const AMOTION_EVENT_AXIS_GENERIC_13: _bindgen_ty_14 = 44;
pub const AMOTION_EVENT_AXIS_GENERIC_14: _bindgen_ty_14 = 45;
pub const AMOTION_EVENT_AXIS_GENERIC_15: _bindgen_ty_14 = 46;
pub const AMOTION_EVENT_AXIS_GENERIC_16: _bindgen_ty_14 = 47;
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
pub const AMOTION_EVENT_BUTTON_PRIMARY: _bindgen_ty_15 = 1;
pub const AMOTION_EVENT_BUTTON_SECONDARY: _bindgen_ty_15 = 2;
pub const AMOTION_EVENT_BUTTON_TERTIARY: _bindgen_ty_15 = 4;
pub const AMOTION_EVENT_BUTTON_BACK: _bindgen_ty_15 = 8;
pub const AMOTION_EVENT_BUTTON_FORWARD: _bindgen_ty_15 = 16;
pub const AMOTION_EVENT_BUTTON_STYLUS_PRIMARY: _bindgen_ty_15 = 32;
pub const AMOTION_EVENT_BUTTON_STYLUS_SECONDARY: _bindgen_ty_15 = 64;
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
pub const AMOTION_EVENT_TOOL_TYPE_UNKNOWN: _bindgen_ty_16 = 0;
pub const AMOTION_EVENT_TOOL_TYPE_FINGER: _bindgen_ty_16 = 1;
pub const AMOTION_EVENT_TOOL_TYPE_STYLUS: _bindgen_ty_16 = 2;
pub const AMOTION_EVENT_TOOL_TYPE_MOUSE: _bindgen_ty_16 = 3;
pub const AMOTION_EVENT_TOOL_TYPE_ERASER: _bindgen_ty_16 = 4;
pub const AMOTION_EVENT_TOOL_TYPE_PALM: _bindgen_ty_16 = 5;
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
pub const AMotionClassification_AMOTION_EVENT_CLASSIFICATION_NONE: AMotionClassification = 0;
pub const AMotionClassification_AMOTION_EVENT_CLASSIFICATION_AMBIGUOUS_GESTURE:
    AMotionClassification = 1;
pub const AMotionClassification_AMOTION_EVENT_CLASSIFICATION_DEEP_PRESS: AMotionClassification = 2;
pub type AMotionClassification = u32;
pub const AINPUT_SOURCE_CLASS_MASK: _bindgen_ty_17 = 255;
pub const AINPUT_SOURCE_CLASS_NONE: _bindgen_ty_17 = 0;
pub const AINPUT_SOURCE_CLASS_BUTTON: _bindgen_ty_17 = 1;
pub const AINPUT_SOURCE_CLASS_POINTER: _bindgen_ty_17 = 2;
pub const AINPUT_SOURCE_CLASS_NAVIGATION: _bindgen_ty_17 = 4;
pub const AINPUT_SOURCE_CLASS_POSITION: _bindgen_ty_17 = 8;
pub const AINPUT_SOURCE_CLASS_JOYSTICK: _bindgen_ty_17 = 16;
pub type _bindgen_ty_17 = ::std::os::raw::c_uint;
pub const AINPUT_SOURCE_UNKNOWN: _bindgen_ty_18 = 0;
pub const AINPUT_SOURCE_KEYBOARD: _bindgen_ty_18 = 257;
pub const AINPUT_SOURCE_DPAD: _bindgen_ty_18 = 513;
pub const AINPUT_SOURCE_GAMEPAD: _bindgen_ty_18 = 1025;
pub const AINPUT_SOURCE_TOUCHSCREEN: _bindgen_ty_18 = 4098;
pub const AINPUT_SOURCE_MOUSE: _bindgen_ty_18 = 8194;
pub const AINPUT_SOURCE_STYLUS: _bindgen_ty_18 = 16386;
pub const AINPUT_SOURCE_BLUETOOTH_STYLUS: _bindgen_ty_18 = 49154;
pub const AINPUT_SOURCE_TRACKBALL: _bindgen_ty_18 = 65540;
pub const AINPUT_SOURCE_MOUSE_RELATIVE: _bindgen_ty_18 = 131076;
pub const AINPUT_SOURCE_TOUCHPAD: _bindgen_ty_18 = 1048584;
pub const AINPUT_SOURCE_TOUCH_NAVIGATION: _bindgen_ty_18 = 2097152;
pub const AINPUT_SOURCE_JOYSTICK: _bindgen_ty_18 = 16777232;
pub const AINPUT_SOURCE_HDMI: _bindgen_ty_18 = 33554433;
pub const AINPUT_SOURCE_SENSOR: _bindgen_ty_18 = 67108864;
pub const AINPUT_SOURCE_ROTARY_ENCODER: _bindgen_ty_18 = 4194304;
pub const AINPUT_SOURCE_ANY: _bindgen_ty_18 = 4294967040;
pub type _bindgen_ty_18 = ::std::os::raw::c_uint;
pub const AINPUT_KEYBOARD_TYPE_NONE: _bindgen_ty_19 = 0;
pub const AINPUT_KEYBOARD_TYPE_NON_ALPHABETIC: _bindgen_ty_19 = 1;
pub const AINPUT_KEYBOARD_TYPE_ALPHABETIC: _bindgen_ty_19 = 2;
pub type _bindgen_ty_19 = ::std::os::raw::c_uint;
pub const AINPUT_MOTION_RANGE_X: _bindgen_ty_20 = 0;
pub const AINPUT_MOTION_RANGE_Y: _bindgen_ty_20 = 1;
pub const AINPUT_MOTION_RANGE_PRESSURE: _bindgen_ty_20 = 2;
pub const AINPUT_MOTION_RANGE_SIZE: _bindgen_ty_20 = 3;
pub const AINPUT_MOTION_RANGE_TOUCH_MAJOR: _bindgen_ty_20 = 4;
pub const AINPUT_MOTION_RANGE_TOUCH_MINOR: _bindgen_ty_20 = 5;
pub const AINPUT_MOTION_RANGE_TOOL_MAJOR: _bindgen_ty_20 = 6;
pub const AINPUT_MOTION_RANGE_TOOL_MINOR: _bindgen_ty_20 = 7;
pub const AINPUT_MOTION_RANGE_ORIENTATION: _bindgen_ty_20 = 8;
pub type _bindgen_ty_20 = ::std::os::raw::c_uint;
extern "C" {
    pub fn AInputEvent_getType(event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AInputEvent_getDeviceId(event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AInputEvent_getSource(event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AInputEvent_release(event: *const AInputEvent);
}
extern "C" {
    pub fn AKeyEvent_getAction(key_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AKeyEvent_getFlags(key_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AKeyEvent_getKeyCode(key_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AKeyEvent_getScanCode(key_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AKeyEvent_getMetaState(key_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AKeyEvent_getRepeatCount(key_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AKeyEvent_getDownTime(key_event: *const AInputEvent) -> i64;
}
extern "C" {
    pub fn AKeyEvent_getEventTime(key_event: *const AInputEvent) -> i64;
}
extern "C" {
    pub fn AKeyEvent_fromJava(env: *mut JNIEnv, keyEvent: jobject) -> *const AInputEvent;
}
extern "C" {
    pub fn AMotionEvent_getAction(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getFlags(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getMetaState(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getButtonState(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getEdgeFlags(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getDownTime(motion_event: *const AInputEvent) -> i64;
}
extern "C" {
    pub fn AMotionEvent_getEventTime(motion_event: *const AInputEvent) -> i64;
}
extern "C" {
    pub fn AMotionEvent_getXOffset(motion_event: *const AInputEvent) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getYOffset(motion_event: *const AInputEvent) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getXPrecision(motion_event: *const AInputEvent) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getYPrecision(motion_event: *const AInputEvent) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getPointerCount(motion_event: *const AInputEvent) -> usize;
}
extern "C" {
    pub fn AMotionEvent_getPointerId(motion_event: *const AInputEvent, pointer_index: usize)
        -> i32;
}
extern "C" {
    pub fn AMotionEvent_getToolType(motion_event: *const AInputEvent, pointer_index: usize) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getRawX(motion_event: *const AInputEvent, pointer_index: usize) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getRawY(motion_event: *const AInputEvent, pointer_index: usize) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getX(motion_event: *const AInputEvent, pointer_index: usize) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getY(motion_event: *const AInputEvent, pointer_index: usize) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getPressure(motion_event: *const AInputEvent, pointer_index: usize) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getSize(motion_event: *const AInputEvent, pointer_index: usize) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getTouchMajor(
        motion_event: *const AInputEvent,
        pointer_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getTouchMinor(
        motion_event: *const AInputEvent,
        pointer_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getToolMajor(motion_event: *const AInputEvent, pointer_index: usize)
        -> f32;
}
extern "C" {
    pub fn AMotionEvent_getToolMinor(motion_event: *const AInputEvent, pointer_index: usize)
        -> f32;
}
extern "C" {
    pub fn AMotionEvent_getOrientation(
        motion_event: *const AInputEvent,
        pointer_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getAxisValue(
        motion_event: *const AInputEvent,
        axis: i32,
        pointer_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistorySize(motion_event: *const AInputEvent) -> usize;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalEventTime(
        motion_event: *const AInputEvent,
        history_index: usize,
    ) -> i64;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalRawX(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalRawY(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalX(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalY(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalPressure(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalSize(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalTouchMajor(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalTouchMinor(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalToolMajor(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalToolMinor(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalOrientation(
        motion_event: *const AInputEvent,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getHistoricalAxisValue(
        motion_event: *const AInputEvent,
        axis: i32,
        pointer_index: usize,
        history_index: usize,
    ) -> f32;
}
extern "C" {
    pub fn AMotionEvent_getActionButton(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_getClassification(motion_event: *const AInputEvent) -> i32;
}
extern "C" {
    pub fn AMotionEvent_fromJava(env: *mut JNIEnv, motionEvent: jobject) -> *const AInputEvent;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AInputQueue {
    _unused: [u8; 0],
}
extern "C" {
    pub fn AInputQueue_attachLooper(
        queue: *mut AInputQueue,
        looper: *mut ALooper,
        ident: ::std::os::raw::c_int,
        callback: ALooper_callbackFunc,
        data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn AInputQueue_detachLooper(queue: *mut AInputQueue);
}
extern "C" {
    pub fn AInputQueue_hasEvents(queue: *mut AInputQueue) -> i32;
}
extern "C" {
    pub fn AInputQueue_getEvent(queue: *mut AInputQueue, outEvent: *mut *mut AInputEvent) -> i32;
}
extern "C" {
    pub fn AInputQueue_preDispatchEvent(queue: *mut AInputQueue, event: *mut AInputEvent) -> i32;
}
extern "C" {
    pub fn AInputQueue_finishEvent(
        queue: *mut AInputQueue,
        event: *mut AInputEvent,
        handled: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn AInputQueue_fromJava(env: *mut JNIEnv, inputQueue: jobject) -> *mut AInputQueue;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: intmax_t,
    pub rem: intmax_t,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    const UNINIT: ::std::mem::MaybeUninit<imaxdiv_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).quot) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rem) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxabs(__i: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numerator: intmax_t, __denominator: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __s: *const ::std::os::raw::c_char,
        __end_ptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __s: *const ::std::os::raw::c_char,
        __end_ptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __s: *const wchar_t,
        __end_ptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __s: *const wchar_t,
        __end_ptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub const ADataSpace_ADATASPACE_UNKNOWN: ADataSpace = 0;
pub const ADataSpace_STANDARD_MASK: ADataSpace = 4128768;
pub const ADataSpace_STANDARD_UNSPECIFIED: ADataSpace = 0;
pub const ADataSpace_STANDARD_BT709: ADataSpace = 65536;
pub const ADataSpace_STANDARD_BT601_625: ADataSpace = 131072;
pub const ADataSpace_STANDARD_BT601_625_UNADJUSTED: ADataSpace = 196608;
pub const ADataSpace_STANDARD_BT601_525: ADataSpace = 262144;
pub const ADataSpace_STANDARD_BT601_525_UNADJUSTED: ADataSpace = 327680;
pub const ADataSpace_STANDARD_BT2020: ADataSpace = 393216;
pub const ADataSpace_STANDARD_BT2020_CONSTANT_LUMINANCE: ADataSpace = 458752;
pub const ADataSpace_STANDARD_BT470M: ADataSpace = 524288;
pub const ADataSpace_STANDARD_FILM: ADataSpace = 589824;
pub const ADataSpace_STANDARD_DCI_P3: ADataSpace = 655360;
pub const ADataSpace_STANDARD_ADOBE_RGB: ADataSpace = 720896;
pub const ADataSpace_TRANSFER_MASK: ADataSpace = 130023424;
pub const ADataSpace_TRANSFER_UNSPECIFIED: ADataSpace = 0;
pub const ADataSpace_TRANSFER_LINEAR: ADataSpace = 4194304;
pub const ADataSpace_TRANSFER_SRGB: ADataSpace = 8388608;
pub const ADataSpace_TRANSFER_SMPTE_170M: ADataSpace = 12582912;
pub const ADataSpace_TRANSFER_GAMMA2_2: ADataSpace = 16777216;
pub const ADataSpace_TRANSFER_GAMMA2_6: ADataSpace = 20971520;
pub const ADataSpace_TRANSFER_GAMMA2_8: ADataSpace = 25165824;
pub const ADataSpace_TRANSFER_ST2084: ADataSpace = 29360128;
pub const ADataSpace_TRANSFER_HLG: ADataSpace = 33554432;
pub const ADataSpace_RANGE_MASK: ADataSpace = 939524096;
pub const ADataSpace_RANGE_UNSPECIFIED: ADataSpace = 0;
pub const ADataSpace_RANGE_FULL: ADataSpace = 134217728;
pub const ADataSpace_RANGE_LIMITED: ADataSpace = 268435456;
pub const ADataSpace_RANGE_EXTENDED: ADataSpace = 402653184;
pub const ADataSpace_ADATASPACE_SCRGB_LINEAR: ADataSpace = 406913024;
pub const ADataSpace_ADATASPACE_SRGB: ADataSpace = 142671872;
pub const ADataSpace_ADATASPACE_SCRGB: ADataSpace = 411107328;
pub const ADataSpace_ADATASPACE_DISPLAY_P3: ADataSpace = 143261696;
pub const ADataSpace_ADATASPACE_BT2020_PQ: ADataSpace = 163971072;
pub const ADataSpace_ADATASPACE_BT2020_ITU_PQ: ADataSpace = 298188800;
pub const ADataSpace_ADATASPACE_ADOBE_RGB: ADataSpace = 151715840;
pub const ADataSpace_ADATASPACE_JFIF: ADataSpace = 146931712;
pub const ADataSpace_ADATASPACE_BT601_625: ADataSpace = 281149440;
pub const ADataSpace_ADATASPACE_BT601_525: ADataSpace = 281280512;
pub const ADataSpace_ADATASPACE_BT2020: ADataSpace = 147193856;
pub const ADataSpace_ADATASPACE_BT709: ADataSpace = 281083904;
pub const ADataSpace_ADATASPACE_DCI_P3: ADataSpace = 155844608;
pub const ADataSpace_ADATASPACE_SRGB_LINEAR: ADataSpace = 138477568;
pub const ADataSpace_ADATASPACE_BT2020_HLG: ADataSpace = 168165376;
pub const ADataSpace_ADATASPACE_BT2020_ITU_HLG: ADataSpace = 302383104;
pub const ADataSpace_DEPTH: ADataSpace = 4096;
pub const ADataSpace_DYNAMIC_DEPTH: ADataSpace = 4098;
pub type ADataSpace = ::std::os::raw::c_uint;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R8G8B8A8_UNORM: AHardwareBuffer_Format = 1;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R8G8B8X8_UNORM: AHardwareBuffer_Format = 2;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R8G8B8_UNORM: AHardwareBuffer_Format = 3;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R5G6B5_UNORM: AHardwareBuffer_Format = 4;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R16G16B16A16_FLOAT: AHardwareBuffer_Format =
    22;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R10G10B10A2_UNORM: AHardwareBuffer_Format =
    43;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_BLOB: AHardwareBuffer_Format = 33;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_D16_UNORM: AHardwareBuffer_Format = 48;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_D24_UNORM: AHardwareBuffer_Format = 49;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_D24_UNORM_S8_UINT: AHardwareBuffer_Format =
    50;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_D32_FLOAT: AHardwareBuffer_Format = 51;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_D32_FLOAT_S8_UINT: AHardwareBuffer_Format =
    52;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_S8_UINT: AHardwareBuffer_Format = 53;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_Y8Cb8Cr8_420: AHardwareBuffer_Format = 35;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_YCbCr_P010: AHardwareBuffer_Format = 54;
pub const AHardwareBuffer_Format_AHARDWAREBUFFER_FORMAT_R8_UNORM: AHardwareBuffer_Format = 56;
pub type AHardwareBuffer_Format = ::std::os::raw::c_uint;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_READ_NEVER:
    AHardwareBuffer_UsageFlags = 0;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_READ_RARELY:
    AHardwareBuffer_UsageFlags = 2;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_READ_OFTEN:
    AHardwareBuffer_UsageFlags = 3;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_READ_MASK:
    AHardwareBuffer_UsageFlags = 15;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_WRITE_NEVER:
    AHardwareBuffer_UsageFlags = 0;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_WRITE_RARELY:
    AHardwareBuffer_UsageFlags = 32;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_WRITE_OFTEN:
    AHardwareBuffer_UsageFlags = 48;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_CPU_WRITE_MASK:
    AHardwareBuffer_UsageFlags = 240;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_GPU_SAMPLED_IMAGE:
    AHardwareBuffer_UsageFlags = 256;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_GPU_FRAMEBUFFER:
    AHardwareBuffer_UsageFlags = 512;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_GPU_COLOR_OUTPUT:
    AHardwareBuffer_UsageFlags = 512;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_COMPOSER_OVERLAY:
    AHardwareBuffer_UsageFlags = 2048;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_PROTECTED_CONTENT:
    AHardwareBuffer_UsageFlags = 16384;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VIDEO_ENCODE:
    AHardwareBuffer_UsageFlags = 65536;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_SENSOR_DIRECT_DATA:
    AHardwareBuffer_UsageFlags = 8388608;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER:
    AHardwareBuffer_UsageFlags = 16777216;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_GPU_CUBE_MAP:
    AHardwareBuffer_UsageFlags = 33554432;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE:
    AHardwareBuffer_UsageFlags = 67108864;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_0: AHardwareBuffer_UsageFlags =
    268435456;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_1: AHardwareBuffer_UsageFlags =
    536870912;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_2: AHardwareBuffer_UsageFlags =
    1073741824;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_3: AHardwareBuffer_UsageFlags =
    2147483648;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_4: AHardwareBuffer_UsageFlags =
    281474976710656;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_5: AHardwareBuffer_UsageFlags =
    562949953421312;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_6: AHardwareBuffer_UsageFlags =
    1125899906842624;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_7: AHardwareBuffer_UsageFlags =
    2251799813685248;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_8: AHardwareBuffer_UsageFlags =
    4503599627370496;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_9: AHardwareBuffer_UsageFlags =
    9007199254740992;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_10: AHardwareBuffer_UsageFlags =
    18014398509481984;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_11: AHardwareBuffer_UsageFlags =
    36028797018963968;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_12: AHardwareBuffer_UsageFlags =
    72057594037927936;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_13: AHardwareBuffer_UsageFlags =
    144115188075855872;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_14: AHardwareBuffer_UsageFlags =
    288230376151711744;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_15: AHardwareBuffer_UsageFlags =
    576460752303423488;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_16: AHardwareBuffer_UsageFlags =
    1152921504606846976;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_17: AHardwareBuffer_UsageFlags =
    2305843009213693952;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_18: AHardwareBuffer_UsageFlags =
    4611686018427387904;
pub const AHardwareBuffer_UsageFlags_AHARDWAREBUFFER_USAGE_VENDOR_19: AHardwareBuffer_UsageFlags =
    9223372036854775808;
pub type AHardwareBuffer_UsageFlags = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AHardwareBuffer_Desc {
    pub width: u32,
    pub height: u32,
    pub layers: u32,
    pub format: u32,
    pub usage: u64,
    pub stride: u32,
    pub rfu0: u32,
    pub rfu1: u64,
}
#[test]
fn bindgen_test_layout_AHardwareBuffer_Desc() {
    const UNINIT: ::std::mem::MaybeUninit<AHardwareBuffer_Desc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<AHardwareBuffer_Desc>(),
        40usize,
        concat!("Size of: ", stringify!(AHardwareBuffer_Desc))
    );
    assert_eq!(
        ::std::mem::align_of::<AHardwareBuffer_Desc>(),
        8usize,
        concat!("Alignment of ", stringify!(AHardwareBuffer_Desc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).width) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).height) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).layers) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(layers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usage) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stride) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rfu0) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(rfu0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rfu1) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Desc),
            "::",
            stringify!(rfu1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AHardwareBuffer_Plane {
    pub data: *mut ::std::os::raw::c_void,
    pub pixelStride: u32,
    pub rowStride: u32,
}
#[test]
fn bindgen_test_layout_AHardwareBuffer_Plane() {
    const UNINIT: ::std::mem::MaybeUninit<AHardwareBuffer_Plane> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<AHardwareBuffer_Plane>(),
        12usize,
        concat!("Size of: ", stringify!(AHardwareBuffer_Plane))
    );
    assert_eq!(
        ::std::mem::align_of::<AHardwareBuffer_Plane>(),
        4usize,
        concat!("Alignment of ", stringify!(AHardwareBuffer_Plane))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Plane),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pixelStride) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Plane),
            "::",
            stringify!(pixelStride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rowStride) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Plane),
            "::",
            stringify!(rowStride)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AHardwareBuffer_Planes {
    pub planeCount: u32,
    pub planes: [AHardwareBuffer_Plane; 4usize],
}
#[test]
fn bindgen_test_layout_AHardwareBuffer_Planes() {
    const UNINIT: ::std::mem::MaybeUninit<AHardwareBuffer_Planes> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<AHardwareBuffer_Planes>(),
        52usize,
        concat!("Size of: ", stringify!(AHardwareBuffer_Planes))
    );
    assert_eq!(
        ::std::mem::align_of::<AHardwareBuffer_Planes>(),
        4usize,
        concat!("Alignment of ", stringify!(AHardwareBuffer_Planes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).planeCount) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Planes),
            "::",
            stringify!(planeCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).planes) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AHardwareBuffer_Planes),
            "::",
            stringify!(planes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AHardwareBuffer {
    _unused: [u8; 0],
}
extern "C" {
    pub fn AHardwareBuffer_allocate(
        desc: *const AHardwareBuffer_Desc,
        outBuffer: *mut *mut AHardwareBuffer,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_acquire(buffer: *mut AHardwareBuffer);
}
extern "C" {
    pub fn AHardwareBuffer_release(buffer: *mut AHardwareBuffer);
}
extern "C" {
    pub fn AHardwareBuffer_describe(
        buffer: *const AHardwareBuffer,
        outDesc: *mut AHardwareBuffer_Desc,
    );
}
extern "C" {
    pub fn AHardwareBuffer_lock(
        buffer: *mut AHardwareBuffer,
        usage: u64,
        fence: i32,
        rect: *const ARect,
        outVirtualAddress: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_unlock(
        buffer: *mut AHardwareBuffer,
        fence: *mut i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_sendHandleToUnixSocket(
        buffer: *const AHardwareBuffer,
        socketFd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_recvHandleFromUnixSocket(
        socketFd: ::std::os::raw::c_int,
        outBuffer: *mut *mut AHardwareBuffer,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_lockPlanes(
        buffer: *mut AHardwareBuffer,
        usage: u64,
        fence: i32,
        rect: *const ARect,
        outPlanes: *mut AHardwareBuffer_Planes,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_isSupported(desc: *const AHardwareBuffer_Desc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_lockAndGetInfo(
        buffer: *mut AHardwareBuffer,
        usage: u64,
        fence: i32,
        rect: *const ARect,
        outVirtualAddress: *mut *mut ::std::os::raw::c_void,
        outBytesPerPixel: *mut i32,
        outBytesPerStride: *mut i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn AHardwareBuffer_getId(
        buffer: *const AHardwareBuffer,
        outId: *mut u64,
    ) -> ::std::os::raw::c_int;
}
#[doc = " \\brief Describe information about a pointer, found in a\n GameActivityMotionEvent.\n\n You can read values directly from this structure, or use helper functions\n (`GameActivityPointerAxes_getX`, `GameActivityPointerAxes_getY` and\n `GameActivityPointerAxes_getAxisValue`).\n\n The X axis and Y axis are enabled by default but any other axis that you want\n to read **must** be enabled first, using\n `GameActivityPointerAxes_enableAxis`.\n\n \\see GameActivityMotionEvent"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameActivityPointerAxes {
    pub id: i32,
    pub toolType: i32,
    pub axisValues: [f32; 48usize],
    pub rawX: f32,
    pub rawY: f32,
}
#[test]
fn bindgen_test_layout_GameActivityPointerAxes() {
    const UNINIT: ::std::mem::MaybeUninit<GameActivityPointerAxes> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameActivityPointerAxes>(),
        208usize,
        concat!("Size of: ", stringify!(GameActivityPointerAxes))
    );
    assert_eq!(
        ::std::mem::align_of::<GameActivityPointerAxes>(),
        4usize,
        concat!("Alignment of ", stringify!(GameActivityPointerAxes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityPointerAxes),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).toolType) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityPointerAxes),
            "::",
            stringify!(toolType)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).axisValues) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityPointerAxes),
            "::",
            stringify!(axisValues)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rawX) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityPointerAxes),
            "::",
            stringify!(rawX)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rawY) as usize - ptr as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityPointerAxes),
            "::",
            stringify!(rawY)
        )
    );
}
extern "C" {
    #[doc = " \\brief Enable the specified axis, so that its value is reported in the\n GameActivityPointerAxes structures stored in a motion event.\n\n You must enable any axis that you want to read, apart from\n `AMOTION_EVENT_AXIS_X` and `AMOTION_EVENT_AXIS_Y` that are enabled by\n default.\n\n If the axis index is out of range, nothing is done."]
    pub fn GameActivityPointerAxes_enableAxis(axis: i32);
}
extern "C" {
    #[doc = " \\brief Disable the specified axis. Its value won't be reported in the\n GameActivityPointerAxes structures stored in a motion event anymore.\n\n Apart from X and Y, any axis that you want to read **must** be enabled first,\n using `GameActivityPointerAxes_enableAxis`.\n\n If the axis index is out of range, nothing is done."]
    pub fn GameActivityPointerAxes_disableAxis(axis: i32);
}
extern "C" {
    #[doc = " \\brief Get the value of the requested axis.\n\n Apart from X and Y, any axis that you want to read **must** be enabled first,\n using `GameActivityPointerAxes_enableAxis`.\n\n Find the valid enums for the axis (`AMOTION_EVENT_AXIS_X`,\n `AMOTION_EVENT_AXIS_Y`, `AMOTION_EVENT_AXIS_PRESSURE`...)\n in https://developer.android.com/ndk/reference/group/input.\n\n @param pointerInfo The structure containing information about the pointer,\n obtained from GameActivityMotionEvent.\n @param axis The axis to get the value from\n @return The value of the axis, or 0 if the axis is invalid or was not\n enabled."]
    pub fn GameActivityPointerAxes_getAxisValue(
        pointerInfo: *const GameActivityPointerAxes,
        axis: i32,
    ) -> f32;
}
#[doc = " \\brief Describe a motion event that happened on the GameActivity SurfaceView.\n\n This is 1:1 mapping to the information contained in a Java `MotionEvent`\n (see https://developer.android.com/reference/android/view/MotionEvent)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameActivityMotionEvent {
    pub deviceId: i32,
    pub source: i32,
    pub action: i32,
    pub eventTime: i64,
    pub downTime: i64,
    pub flags: i32,
    pub metaState: i32,
    pub actionButton: i32,
    pub buttonState: i32,
    pub classification: i32,
    pub edgeFlags: i32,
    pub pointerCount: u32,
    pub pointers: [GameActivityPointerAxes; 8usize],
    pub historySize: ::std::os::raw::c_int,
    pub historicalEventTimesMillis: *mut i64,
    pub historicalEventTimesNanos: *mut i64,
    pub historicalAxisValues: *mut f32,
    pub precisionX: f32,
    pub precisionY: f32,
}
#[test]
fn bindgen_test_layout_GameActivityMotionEvent() {
    const UNINIT: ::std::mem::MaybeUninit<GameActivityMotionEvent> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameActivityMotionEvent>(),
        1752usize,
        concat!("Size of: ", stringify!(GameActivityMotionEvent))
    );
    assert_eq!(
        ::std::mem::align_of::<GameActivityMotionEvent>(),
        8usize,
        concat!("Alignment of ", stringify!(GameActivityMotionEvent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deviceId) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(deviceId)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).source) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(action)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eventTime) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(eventTime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).downTime) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(downTime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).metaState) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(metaState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).actionButton) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(actionButton)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buttonState) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(buttonState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).classification) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(classification)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).edgeFlags) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(edgeFlags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pointerCount) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(pointerCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pointers) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(pointers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).historySize) as usize - ptr as usize },
        1724usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(historySize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).historicalEventTimesMillis) as usize - ptr as usize },
        1728usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(historicalEventTimesMillis)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).historicalEventTimesNanos) as usize - ptr as usize },
        1732usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(historicalEventTimesNanos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).historicalAxisValues) as usize - ptr as usize },
        1736usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(historicalAxisValues)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).precisionX) as usize - ptr as usize },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(precisionX)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).precisionY) as usize - ptr as usize },
        1744usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityMotionEvent),
            "::",
            stringify!(precisionY)
        )
    );
}
extern "C" {
    pub fn GameActivityMotionEvent_getHistoricalAxisValue(
        event: *const GameActivityMotionEvent,
        axis: ::std::os::raw::c_int,
        pointerIndex: ::std::os::raw::c_int,
        historyPos: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[doc = " \\brief Handle the freeing of the GameActivityMotionEvent struct."]
    pub fn GameActivityMotionEvent_destroy(c_event: *mut GameActivityMotionEvent);
}
extern "C" {
    #[doc = " \\brief Convert a Java `MotionEvent` to a `GameActivityMotionEvent`.\n\n This is done automatically by the GameActivity: see `onTouchEvent` to set\n a callback to consume the received events.\n This function can be used if you re-implement events handling in your own\n activity.\n Ownership of out_event is maintained by the caller."]
    pub fn GameActivityMotionEvent_fromJava(
        env: *mut JNIEnv,
        motionEvent: jobject,
        out_event: *mut GameActivityMotionEvent,
    );
}
#[doc = " \\brief Describe a key event that happened on the GameActivity SurfaceView.\n\n This is 1:1 mapping to the information contained in a Java `KeyEvent`\n (see https://developer.android.com/reference/android/view/KeyEvent).\n The only exception is the event times, which are reported as\n nanoseconds in this struct."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameActivityKeyEvent {
    pub deviceId: i32,
    pub source: i32,
    pub action: i32,
    pub eventTime: i64,
    pub downTime: i64,
    pub flags: i32,
    pub metaState: i32,
    pub modifiers: i32,
    pub repeatCount: i32,
    pub keyCode: i32,
    pub scanCode: i32,
}
#[test]
fn bindgen_test_layout_GameActivityKeyEvent() {
    const UNINIT: ::std::mem::MaybeUninit<GameActivityKeyEvent> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameActivityKeyEvent>(),
        56usize,
        concat!("Size of: ", stringify!(GameActivityKeyEvent))
    );
    assert_eq!(
        ::std::mem::align_of::<GameActivityKeyEvent>(),
        8usize,
        concat!("Alignment of ", stringify!(GameActivityKeyEvent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deviceId) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(deviceId)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).source) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(action)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eventTime) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(eventTime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).downTime) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(downTime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).metaState) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(metaState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).modifiers) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(modifiers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).repeatCount) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(repeatCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keyCode) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(keyCode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scanCode) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityKeyEvent),
            "::",
            stringify!(scanCode)
        )
    );
}
extern "C" {
    #[doc = " \\brief Convert a Java `KeyEvent` to a `GameActivityKeyEvent`.\n\n This is done automatically by the GameActivity: see `onKeyUp` and `onKeyDown`\n to set a callback to consume the received events.\n This function can be used if you re-implement events handling in your own\n activity.\n Ownership of out_event is maintained by the caller."]
    pub fn GameActivityKeyEvent_fromJava(
        env: *mut JNIEnv,
        motionEvent: jobject,
        out_event: *mut GameActivityKeyEvent,
    );
}
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_CAPTION_BAR: GameCommonInsetsType = 0;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_DISPLAY_CUTOUT: GameCommonInsetsType = 1;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_IME: GameCommonInsetsType = 2;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_MANDATORY_SYSTEM_GESTURES:
    GameCommonInsetsType = 3;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_NAVIGATION_BARS: GameCommonInsetsType = 4;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_STATUS_BARS: GameCommonInsetsType = 5;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_SYSTEM_BARS: GameCommonInsetsType = 6;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_SYSTEM_GESTURES: GameCommonInsetsType = 7;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_TAPABLE_ELEMENT: GameCommonInsetsType = 8;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_WATERFALL: GameCommonInsetsType = 9;
pub const GameCommonInsetsType_GAMECOMMON_INSETS_TYPE_COUNT: GameCommonInsetsType = 10;
#[doc = " The type of a component for which to retrieve insets. See\n https://developer.android.com/reference/androidx/core/view/WindowInsetsCompat.Type"]
pub type GameCommonInsetsType = ::std::os::raw::c_uint;
#[doc = " This struct holds a span within a region of text from start (inclusive) to\n end (exclusive). An empty span or cursor position is specified with\n start==end. An undefined span is specified with start = end = SPAN_UNDEFINED."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameTextInputSpan {
    #[doc = " The start of the region (inclusive)."]
    pub start: i32,
    #[doc = " The end of the region (exclusive)."]
    pub end: i32,
}
#[test]
fn bindgen_test_layout_GameTextInputSpan() {
    const UNINIT: ::std::mem::MaybeUninit<GameTextInputSpan> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameTextInputSpan>(),
        8usize,
        concat!("Size of: ", stringify!(GameTextInputSpan))
    );
    assert_eq!(
        ::std::mem::align_of::<GameTextInputSpan>(),
        4usize,
        concat!("Alignment of ", stringify!(GameTextInputSpan))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameTextInputSpan),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameTextInputSpan),
            "::",
            stringify!(end)
        )
    );
}
pub const GameTextInputSpanFlag_SPAN_UNDEFINED: GameTextInputSpanFlag = -1;
#[doc = " Values with special meaning in a GameTextInputSpan."]
pub type GameTextInputSpanFlag = ::std::os::raw::c_int;
#[doc = " This struct holds the state of an editable section of text.\n The text can have a selection and a composing region defined on it.\n A composing region is used by IMEs that allow input using multiple steps to\n compose a glyph or word. Use functions GameTextInput_getState and\n GameTextInput_setState to read and modify the state that an IME is editing."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameTextInputState {
    #[doc = " Text owned by the state, as a modified UTF-8 string. Null-terminated.\n https://en.wikipedia.org/wiki/UTF-8#Modified_UTF-8"]
    pub text_UTF8: *const ::std::os::raw::c_char,
    #[doc = " Length in bytes of text_UTF8, *not* including the null at end."]
    pub text_length: i32,
    #[doc = " A selection defined on the text."]
    pub selection: GameTextInputSpan,
    #[doc = " A composing region defined on the text."]
    pub composingRegion: GameTextInputSpan,
}
#[test]
fn bindgen_test_layout_GameTextInputState() {
    const UNINIT: ::std::mem::MaybeUninit<GameTextInputState> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameTextInputState>(),
        24usize,
        concat!("Size of: ", stringify!(GameTextInputState))
    );
    assert_eq!(
        ::std::mem::align_of::<GameTextInputState>(),
        4usize,
        concat!("Alignment of ", stringify!(GameTextInputState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).text_UTF8) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameTextInputState),
            "::",
            stringify!(text_UTF8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).text_length) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameTextInputState),
            "::",
            stringify!(text_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).selection) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameTextInputState),
            "::",
            stringify!(selection)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).composingRegion) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameTextInputState),
            "::",
            stringify!(composingRegion)
        )
    );
}
#[doc = " A callback called by GameTextInput_getState.\n @param context User-defined context.\n @param state State, owned by the library, that will be valid for the duration\n of the callback."]
pub type GameTextInputGetStateCallback = ::std::option::Option<
    unsafe extern "C" fn(context: *mut ::std::os::raw::c_void, state: *const GameTextInputState),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameTextInput {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Initialize the GameTextInput library.\n If called twice without GameTextInput_destroy being called, the same pointer\n will be returned and a warning will be issued.\n @param env A JNI env valid on the calling thread.\n @param max_string_size The maximum length of a string that can be edited. If\n zero, the maximum defaults to 65536 bytes. A buffer of this size is allocated\n at initialization.\n @return A handle to the library."]
    pub fn GameTextInput_init(env: *mut JNIEnv, max_string_size: u32) -> *mut GameTextInput;
}
extern "C" {
    #[doc = " When using GameTextInput, you need to create a gametextinput.InputConnection\n on the Java side and pass it using this function to the library, unless using\n GameActivity in which case this will be done for you. See the GameActivity\n source code or GameTextInput samples for examples of usage.\n @param input A valid GameTextInput library handle.\n @param inputConnection A gametextinput.InputConnection object."]
    pub fn GameTextInput_setInputConnection(input: *mut GameTextInput, inputConnection: jobject);
}
extern "C" {
    #[doc = " Unless using GameActivity, it is required to call this function from your\n Java gametextinput.Listener.stateChanged method to convert eventState and\n trigger any event callbacks. When using GameActivity, this does not need to\n be called as event processing is handled by the Activity.\n @param input A valid GameTextInput library handle.\n @param eventState A Java gametextinput.State object."]
    pub fn GameTextInput_processEvent(input: *mut GameTextInput, eventState: jobject);
}
extern "C" {
    #[doc = " Free any resources owned by the GameTextInput library.\n Any subsequent calls to the library will fail until GameTextInput_init is\n called again.\n @param input A valid GameTextInput library handle."]
    pub fn GameTextInput_destroy(input: *mut GameTextInput);
}
pub const ShowImeFlags_SHOW_IME_UNDEFINED: ShowImeFlags = 0;
pub const ShowImeFlags_SHOW_IMPLICIT: ShowImeFlags = 1;
pub const ShowImeFlags_SHOW_FORCED: ShowImeFlags = 2;
#[doc = " Flags to be passed to GameTextInput_showIme."]
pub type ShowImeFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Show the IME. Calls InputMethodManager.showSoftInput().\n @param input A valid GameTextInput library handle.\n @param flags Defined in ShowImeFlags above. For more information see:\n https://developer.android.com/reference/android/view/inputmethod/InputMethodManager"]
    pub fn GameTextInput_showIme(input: *mut GameTextInput, flags: u32);
}
pub const HideImeFlags_HIDE_IME_UNDEFINED: HideImeFlags = 0;
pub const HideImeFlags_HIDE_IMPLICIT_ONLY: HideImeFlags = 1;
pub const HideImeFlags_HIDE_NOT_ALWAYS: HideImeFlags = 2;
#[doc = " Flags to be passed to GameTextInput_hideIme."]
pub type HideImeFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Show the IME. Calls InputMethodManager.hideSoftInputFromWindow().\n @param input A valid GameTextInput library handle.\n @param flags Defined in HideImeFlags above. For more information see:\n https://developer.android.com/reference/android/view/inputmethod/InputMethodManager"]
    pub fn GameTextInput_hideIme(input: *mut GameTextInput, flags: u32);
}
extern "C" {
    #[doc = " Restarts the input method. Calls InputMethodManager.restartInput().\n @param input A valid GameTextInput library handle."]
    pub fn GameTextInput_restartInput(input: *mut GameTextInput);
}
extern "C" {
    #[doc = " Call a callback with the current GameTextInput state, which may have been\n modified by changes in the IME and calls to GameTextInput_setState. We use a\n callback rather than returning the state in order to simplify ownership of\n text_UTF8 strings. These strings are only valid during the calling of the\n callback.\n @param input A valid GameTextInput library handle.\n @param callback A function that will be called with valid state.\n @param context Context used by the callback."]
    pub fn GameTextInput_getState(
        input: *mut GameTextInput,
        callback: GameTextInputGetStateCallback,
        context: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Set the current GameTextInput state. This state is reflected to any active\n IME.\n @param input A valid GameTextInput library handle.\n @param state The state to set. Ownership is maintained by the caller and must\n remain valid for the duration of the call."]
    pub fn GameTextInput_setState(input: *mut GameTextInput, state: *const GameTextInputState);
}
#[doc = " Type of the callback needed by GameTextInput_setEventCallback that will be\n called every time the IME state changes.\n @param context User-defined context set in GameTextInput_setEventCallback.\n @param current_state Current IME state, owned by the library and valid during\n the callback."]
pub type GameTextInputEventCallback = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut ::std::os::raw::c_void,
        current_state: *const GameTextInputState,
    ),
>;
extern "C" {
    #[doc = " Optionally set a callback to be called whenever the IME state changes.\n Not necessary if you are using GameActivity, which handles these callbacks\n for you.\n @param input A valid GameTextInput library handle.\n @param callback Called by the library when the IME state changes.\n @param context Context passed as first argument to the callback."]
    pub fn GameTextInput_setEventCallback(
        input: *mut GameTextInput,
        callback: GameTextInputEventCallback,
        context: *mut ::std::os::raw::c_void,
    );
}
#[doc = " Type of the callback needed by GameTextInput_setImeInsetsCallback that will\n be called every time the IME window insets change.\n @param context User-defined context set in\n GameTextInput_setImeWIndowInsetsCallback.\n @param current_insets Current IME insets, owned by the library and valid\n during the callback."]
pub type GameTextInputImeInsetsCallback = ::std::option::Option<
    unsafe extern "C" fn(context: *mut ::std::os::raw::c_void, current_insets: *const ARect),
>;
extern "C" {
    #[doc = " Optionally set a callback to be called whenever the IME insets change.\n Not necessary if you are using GameActivity, which handles these callbacks\n for you.\n @param input A valid GameTextInput library handle.\n @param callback Called by the library when the IME insets change.\n @param context Context passed as first argument to the callback."]
    pub fn GameTextInput_setImeInsetsCallback(
        input: *mut GameTextInput,
        callback: GameTextInputImeInsetsCallback,
        context: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Get the current window insets for the IME.\n @param input A valid GameTextInput library handle.\n @param insets Filled with the current insets by this function."]
    pub fn GameTextInput_getImeInsets(input: *const GameTextInput, insets: *mut ARect);
}
extern "C" {
    #[doc = " Unless using GameActivity, it is required to call this function from your\n Java gametextinput.Listener.onImeInsetsChanged method to\n trigger any event callbacks. When using GameActivity, this does not need to\n be called as insets processing is handled by the Activity.\n @param input A valid GameTextInput library handle.\n @param eventState A Java gametextinput.State object."]
    pub fn GameTextInput_processImeInsets(input: *mut GameTextInput, insets: *const ARect);
}
extern "C" {
    #[doc = " Convert a GameTextInputState struct to a Java gametextinput.State object.\n Don't forget to delete the returned Java local ref when you're done.\n @param input A valid GameTextInput library handle.\n @param state Input state to convert.\n @return A Java object of class gametextinput.State. The caller is required to\n delete this local reference."]
    pub fn GameTextInputState_toJava(
        input: *const GameTextInput,
        state: *const GameTextInputState,
    ) -> jobject;
}
extern "C" {
    #[doc = " Convert from a Java gametextinput.State object into a C GameTextInputState\n struct.\n @param input A valid GameTextInput library handle.\n @param state A Java gametextinput.State object.\n @param callback A function called with the C struct, valid for the duration\n of the call.\n @param context Context passed to the callback."]
    pub fn GameTextInputState_fromJava(
        input: *const GameTextInput,
        state: jobject,
        callback: GameTextInputGetStateCallback,
        context: *mut ::std::os::raw::c_void,
    );
}
#[doc = " This structure defines the native side of an android.app.GameActivity.\n It is created by the framework, and handed to the application's native\n code as it is being launched."]
#[repr(C)]
pub struct GameActivity {
    #[doc = " Pointer to the callback function table of the native application.\n You can set the functions here to your own callbacks.  The callbacks\n pointer itself here should not be changed; it is allocated and managed\n for you by the framework."]
    pub callbacks: *mut GameActivityCallbacks,
    #[doc = " The global handle on the process's Java VM."]
    pub vm: *mut JavaVM,
    #[doc = " JNI context for the main thread of the app.  Note that this field\n can ONLY be used from the main thread of the process; that is, the\n thread that calls into the GameActivityCallbacks."]
    pub env: *mut JNIEnv,
    #[doc = " The GameActivity object handle."]
    pub javaGameActivity: jobject,
    #[doc = " Path to this application's internal data directory."]
    pub internalDataPath: *const ::std::os::raw::c_char,
    #[doc = " Path to this application's external (removable/mountable) data directory."]
    pub externalDataPath: *const ::std::os::raw::c_char,
    #[doc = " The platform's SDK version code."]
    pub sdkVersion: i32,
    #[doc = " This is the native instance of the application.  It is not used by\n the framework, but can be set by the application to its own instance\n state."]
    pub instance: *mut ::std::os::raw::c_void,
    #[doc = " Pointer to the Asset Manager instance for the application.  The\n application uses this to access binary assets bundled inside its own .apk\n file."]
    pub assetManager: *mut AAssetManager,
    #[doc = " Available starting with Honeycomb: path to the directory containing\n the application's OBB files (if any).  If the app doesn't have any\n OBB files, this directory may not exist."]
    pub obbPath: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_GameActivity() {
    const UNINIT: ::std::mem::MaybeUninit<GameActivity> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameActivity>(),
        40usize,
        concat!("Size of: ", stringify!(GameActivity))
    );
    assert_eq!(
        ::std::mem::align_of::<GameActivity>(),
        4usize,
        concat!("Alignment of ", stringify!(GameActivity))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callbacks) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(callbacks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vm) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(vm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).env) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(env)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).javaGameActivity) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(javaGameActivity)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).internalDataPath) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(internalDataPath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).externalDataPath) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(externalDataPath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sdkVersion) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(sdkVersion)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instance) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(instance)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).assetManager) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(assetManager)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).obbPath) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivity),
            "::",
            stringify!(obbPath)
        )
    );
}
#[doc = " A function the user should call from their callback with the data, its length\n and the library- supplied context."]
pub type SaveInstanceStateRecallback = ::std::option::Option<
    unsafe extern "C" fn(
        bytes: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        context: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " {@link GameActivityCallbacks}"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameActivityCallbacks {
    #[doc = " GameActivity has started.  See Java documentation for Activity.onStart()\n for more information."]
    pub onStart: ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " GameActivity has resumed.  See Java documentation for Activity.onResume()\n for more information."]
    pub onResume: ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " The framework is asking GameActivity to save its current instance state.\n See the Java documentation for Activity.onSaveInstanceState() for more\n information. The user should call the recallback with their data, its\n length and the provided context; they retain ownership of the data. Note\n that the saved state will be persisted, so it can not contain any active\n entities (pointers to memory, file descriptors, etc)."]
    pub onSaveInstanceState: ::std::option::Option<
        unsafe extern "C" fn(
            activity: *mut GameActivity,
            recallback: SaveInstanceStateRecallback,
            context: *mut ::std::os::raw::c_void,
        ),
    >,
    #[doc = " GameActivity has paused.  See Java documentation for Activity.onPause()\n for more information."]
    pub onPause: ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " GameActivity has stopped.  See Java documentation for Activity.onStop()\n for more information."]
    pub onStop: ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " GameActivity is being destroyed.  See Java documentation for\n Activity.onDestroy() for more information."]
    pub onDestroy: ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " Focus has changed in this GameActivity's window.  This is often used,\n for example, to pause a game when it loses input focus."]
    pub onWindowFocusChanged:
        ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity, hasFocus: bool)>,
    #[doc = " The drawing window for this native activity has been created.  You\n can use the given native window object to start drawing."]
    pub onNativeWindowCreated: ::std::option::Option<
        unsafe extern "C" fn(activity: *mut GameActivity, window: *mut ANativeWindow),
    >,
    #[doc = " The drawing window for this native activity has been resized.  You should\n retrieve the new size from the window and ensure that your rendering in\n it now matches."]
    pub onNativeWindowResized: ::std::option::Option<
        unsafe extern "C" fn(
            activity: *mut GameActivity,
            window: *mut ANativeWindow,
            newWidth: i32,
            newHeight: i32,
        ),
    >,
    #[doc = " The drawing window for this native activity needs to be redrawn.  To\n avoid transient artifacts during screen changes (such resizing after\n rotation), applications should not return from this function until they\n have finished drawing their window in its current state."]
    pub onNativeWindowRedrawNeeded: ::std::option::Option<
        unsafe extern "C" fn(activity: *mut GameActivity, window: *mut ANativeWindow),
    >,
    #[doc = " The drawing window for this native activity is going to be destroyed.\n You MUST ensure that you do not touch the window object after returning\n from this function: in the common case of drawing to the window from\n another thread, that means the implementation of this callback must\n properly synchronize with the other thread to stop its drawing before\n returning from here."]
    pub onNativeWindowDestroyed: ::std::option::Option<
        unsafe extern "C" fn(activity: *mut GameActivity, window: *mut ANativeWindow),
    >,
    #[doc = " The current device AConfiguration has changed.  The new configuration can\n be retrieved from assetManager."]
    pub onConfigurationChanged:
        ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " The system is running low on memory.  Use this callback to release\n resources you do not need, to help the system avoid killing more\n important processes."]
    pub onTrimMemory: ::std::option::Option<
        unsafe extern "C" fn(activity: *mut GameActivity, level: ::std::os::raw::c_int),
    >,
    #[doc = " Callback called for every MotionEvent done on the GameActivity\n SurfaceView. Ownership of `event` is maintained by the library and it is\n only valid during the callback."]
    pub onTouchEvent: ::std::option::Option<
        unsafe extern "C" fn(
            activity: *mut GameActivity,
            event: *const GameActivityMotionEvent,
        ) -> bool,
    >,
    #[doc = " Callback called for every key down event on the GameActivity SurfaceView.\n Ownership of `event` is maintained by the library and it is only valid\n during the callback."]
    pub onKeyDown: ::std::option::Option<
        unsafe extern "C" fn(
            activity: *mut GameActivity,
            event: *const GameActivityKeyEvent,
        ) -> bool,
    >,
    #[doc = " Callback called for every key up event on the GameActivity SurfaceView.\n Ownership of `event` is maintained by the library and it is only valid\n during the callback."]
    pub onKeyUp: ::std::option::Option<
        unsafe extern "C" fn(
            activity: *mut GameActivity,
            event: *const GameActivityKeyEvent,
        ) -> bool,
    >,
    #[doc = " Callback called for every soft-keyboard text input event.\n Ownership of `state` is maintained by the library and it is only valid\n during the callback."]
    pub onTextInputEvent: ::std::option::Option<
        unsafe extern "C" fn(activity: *mut GameActivity, state: *const GameTextInputState),
    >,
    #[doc = " Callback called when WindowInsets of the main app window have changed.\n Call GameActivity_getWindowInsets to retrieve the insets themselves."]
    pub onWindowInsetsChanged:
        ::std::option::Option<unsafe extern "C" fn(activity: *mut GameActivity)>,
    #[doc = " Callback called when the rectangle in the window where the content\n should be placed has changed."]
    pub onContentRectChanged: ::std::option::Option<
        unsafe extern "C" fn(activity: *mut GameActivity, rect: *const ARect),
    >,
}
#[test]
fn bindgen_test_layout_GameActivityCallbacks() {
    const UNINIT: ::std::mem::MaybeUninit<GameActivityCallbacks> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GameActivityCallbacks>(),
        76usize,
        concat!("Size of: ", stringify!(GameActivityCallbacks))
    );
    assert_eq!(
        ::std::mem::align_of::<GameActivityCallbacks>(),
        4usize,
        concat!("Alignment of ", stringify!(GameActivityCallbacks))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onStart) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onStart)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onResume) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onResume)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onSaveInstanceState) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onSaveInstanceState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onPause) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onPause)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onStop) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onStop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onDestroy) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onDestroy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onWindowFocusChanged) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onWindowFocusChanged)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onNativeWindowCreated) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onNativeWindowCreated)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onNativeWindowResized) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onNativeWindowResized)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onNativeWindowRedrawNeeded) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onNativeWindowRedrawNeeded)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onNativeWindowDestroyed) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onNativeWindowDestroyed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onConfigurationChanged) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onConfigurationChanged)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onTrimMemory) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onTrimMemory)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onTouchEvent) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onTouchEvent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onKeyDown) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onKeyDown)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onKeyUp) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onKeyUp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onTextInputEvent) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onTextInputEvent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onWindowInsetsChanged) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onWindowInsetsChanged)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onContentRectChanged) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(GameActivityCallbacks),
            "::",
            stringify!(onContentRectChanged)
        )
    );
}
#[doc = " This is the function that must be in the native code to instantiate the\n application's native activity.  It is called with the activity instance (see\n above); if the code is being instantiated from a previously saved instance,\n the savedState will be non-NULL and point to the saved data.  You must make\n any copy of this data you need -- it will be released after you return from\n this function."]
pub type GameActivity_createFunc = ::std::option::Option<
    unsafe extern "C" fn(
        activity: *mut GameActivity,
        savedState: *mut ::std::os::raw::c_void,
        savedStateSize: usize,
    ),
>;
extern "C" {
    #[doc = " Finish the given activity.  Its finish() method will be called, causing it\n to be stopped and destroyed.  Note that this method can be called from\n *any* thread; it will send a message to the main thread of the process\n where the Java finish call will take place."]
    pub fn GameActivity_finish(activity: *mut GameActivity);
}
#[doc = " As long as this window is visible to the user, allow the lock\n screen to activate while the screen is on.  This can be used\n independently, or in combination with {@link\n GAMEACTIVITY_FLAG_KEEP_SCREEN_ON} and/or {@link\n GAMEACTIVITY_FLAG_SHOW_WHEN_LOCKED}"]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_ALLOW_LOCK_WHILE_SCREEN_ON:
    GameActivitySetWindowFlags = 1;
#[doc = " Everything behind this window will be dimmed."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_DIM_BEHIND: GameActivitySetWindowFlags = 2;
#[doc = " Blur everything behind this window.\n @deprecated Blurring is no longer supported."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_BLUR_BEHIND: GameActivitySetWindowFlags = 4;
#[doc = " This window won't ever get key input focus, so the\n user can not send key or other button events to it.  Those will\n instead go to whatever focusable window is behind it.  This flag\n will also enable {@link GAMEACTIVITY_FLAG_NOT_TOUCH_MODAL} whether or not\n that is explicitly set.\n\n Setting this flag also implies that the window will not need to\n interact with\n a soft input method, so it will be Z-ordered and positioned\n independently of any active input method (typically this means it\n gets Z-ordered on top of the input method, so it can use the full\n screen for its content and cover the input method if needed.  You\n can use {@link GAMEACTIVITY_FLAG_ALT_FOCUSABLE_IM} to modify this\n behavior."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_NOT_FOCUSABLE: GameActivitySetWindowFlags =
    8;
#[doc = " This window can never receive touch events."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_NOT_TOUCHABLE: GameActivitySetWindowFlags =
    16;
#[doc = " Even when this window is focusable (its\n {@link GAMEACTIVITY_FLAG_NOT_FOCUSABLE} is not set), allow any pointer\n events outside of the window to be sent to the windows behind it.\n Otherwise it will consume all pointer events itself, regardless of\n whether they are inside of the window."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_NOT_TOUCH_MODAL: GameActivitySetWindowFlags =
    32;
#[doc = " When set, if the device is asleep when the touch\n screen is pressed, you will receive this first touch event.  Usually\n the first touch event is consumed by the system since the user can\n not see what they are pressing on.\n\n @deprecated This flag has no effect."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_TOUCHABLE_WHEN_WAKING:
    GameActivitySetWindowFlags = 64;
#[doc = " As long as this window is visible to the user, keep\n the device's screen turned on and bright."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_KEEP_SCREEN_ON: GameActivitySetWindowFlags =
    128;
#[doc = " Place the window within the entire screen, ignoring\n decorations around the border (such as the status bar).  The\n window must correctly position its contents to take the screen\n decoration into account."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_LAYOUT_IN_SCREEN:
    GameActivitySetWindowFlags = 256;
#[doc = " Allows the window to extend outside of the screen."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_LAYOUT_NO_LIMITS:
    GameActivitySetWindowFlags = 512;
#[doc = " Hide all screen decorations (such as the status\n bar) while this window is displayed.  This allows the window to\n use the entire display space for itself -- the status bar will\n be hidden when an app window with this flag set is on the top\n layer. A fullscreen window will ignore a value of {@link\n GAMEACTIVITY_SOFT_INPUT_ADJUST_RESIZE}; the window will stay\n fullscreen and will not resize."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_FULLSCREEN: GameActivitySetWindowFlags =
    1024;
#[doc = " Override {@link GAMEACTIVITY_FLAG_FULLSCREEN} and force the\n screen decorations (such as the status bar) to be shown."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_FORCE_NOT_FULLSCREEN:
    GameActivitySetWindowFlags = 2048;
#[doc = " Turn on dithering when compositing this window to\n the screen.\n @deprecated This flag is no longer used."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_DITHER: GameActivitySetWindowFlags = 4096;
#[doc = " Treat the content of the window as secure, preventing\n it from appearing in screenshots or from being viewed on non-secure\n displays."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_SECURE: GameActivitySetWindowFlags = 8192;
#[doc = " A special mode where the layout parameters are used\n to perform scaling of the surface when it is composited to the\n screen."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_SCALED: GameActivitySetWindowFlags = 16384;
#[doc = " Intended for windows that will often be used when the user is\n holding the screen against their face, it will aggressively\n filter the event stream to prevent unintended presses in this\n situation that may not be desired for a particular window, when\n such an event stream is detected, the application will receive\n a {@link AMOTION_EVENT_ACTION_CANCEL} to indicate this so\n applications can handle this accordingly by taking no action on\n the event until the finger is released."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_IGNORE_CHEEK_PRESSES:
    GameActivitySetWindowFlags = 32768;
#[doc = " A special option only for use in combination with\n {@link GAMEACTIVITY_FLAG_LAYOUT_IN_SCREEN}.  When requesting layout in\n the screen your window may appear on top of or behind screen decorations\n such as the status bar.  By also including this flag, the window\n manager will report the inset rectangle needed to ensure your\n content is not covered by screen decorations."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_LAYOUT_INSET_DECOR:
    GameActivitySetWindowFlags = 65536;
#[doc = " Invert the state of {@link GAMEACTIVITY_FLAG_NOT_FOCUSABLE} with\n respect to how this window interacts with the current method.\n That is, if FLAG_NOT_FOCUSABLE is set and this flag is set,\n then the window will behave as if it needs to interact with the\n input method and thus be placed behind/away from it; if {@link\n GAMEACTIVITY_FLAG_NOT_FOCUSABLE} is not set and this flag is set,\n then the window will behave as if it doesn't need to interact\n with the input method and can be placed to use more space and\n cover the input method."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_ALT_FOCUSABLE_IM:
    GameActivitySetWindowFlags = 131072;
#[doc = " If you have set {@link GAMEACTIVITY_FLAG_NOT_TOUCH_MODAL}, you\n can set this flag to receive a single special MotionEvent with\n the action\n {@link AMOTION_EVENT_ACTION_OUTSIDE} for\n touches that occur outside of your window.  Note that you will not\n receive the full down/move/up gesture, only the location of the\n first down as an {@link AMOTION_EVENT_ACTION_OUTSIDE}."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_WATCH_OUTSIDE_TOUCH:
    GameActivitySetWindowFlags = 262144;
#[doc = " Special flag to let windows be shown when the screen\n is locked. This will let application windows take precedence over\n key guard or any other lock screens. Can be used with\n {@link GAMEACTIVITY_FLAG_KEEP_SCREEN_ON} to turn screen on and display\n windows directly before showing the key guard window.  Can be used with\n {@link GAMEACTIVITY_FLAG_DISMISS_KEYGUARD} to automatically fully\n dismisss non-secure keyguards.  This flag only applies to the top-most\n full-screen window."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_SHOW_WHEN_LOCKED:
    GameActivitySetWindowFlags = 524288;
#[doc = " Ask that the system wallpaper be shown behind\n your window.  The window surface must be translucent to be able\n to actually see the wallpaper behind it; this flag just ensures\n that the wallpaper surface will be there if this window actually\n has translucent regions."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_SHOW_WALLPAPER: GameActivitySetWindowFlags =
    1048576;
#[doc = " When set as a window is being added or made\n visible, once the window has been shown then the system will\n poke the power manager's user activity (as if the user had woken\n up the device) to turn the screen on."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_TURN_SCREEN_ON: GameActivitySetWindowFlags =
    2097152;
#[doc = " When set the window will cause the keyguard to\n be dismissed, only if it is not a secure lock keyguard.  Because such\n a keyguard is not needed for security, it will never re-appear if\n the user navigates to another window (in contrast to\n {@link GAMEACTIVITY_FLAG_SHOW_WHEN_LOCKED}, which will only temporarily\n hide both secure and non-secure keyguards but ensure they reappear\n when the user moves to another UI that doesn't hide them).\n If the keyguard is currently active and is secure (requires an\n unlock pattern) than the user will still need to confirm it before\n seeing this window, unless {@link GAMEACTIVITY_FLAG_SHOW_WHEN_LOCKED} has\n also been set."]
pub const GameActivitySetWindowFlags_GAMEACTIVITY_FLAG_DISMISS_KEYGUARD:
    GameActivitySetWindowFlags = 4194304;
#[doc = " Flags for GameActivity_setWindowFlags,\n as per the Java API at android.view.WindowManager.LayoutParams."]
pub type GameActivitySetWindowFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Change the window flags of the given activity.  Calls getWindow().setFlags()\n of the given activity.\n Note that some flags must be set before the window decoration is created,\n see\n https://developer.android.com/reference/android/view/Window#setFlags(int,%20int).\n Note also that this method can be called from\n *any* thread; it will send a message to the main thread of the process\n where the Java finish call will take place."]
    pub fn GameActivity_setWindowFlags(
        activity: *mut GameActivity,
        addFlags: u32,
        removeFlags: u32,
    );
}
#[doc = " Implicit request to show the input window, not as the result\n of a direct request by the user."]
pub const GameActivityShowSoftInputFlags_GAMEACTIVITY_SHOW_SOFT_INPUT_IMPLICIT:
    GameActivityShowSoftInputFlags = 1;
#[doc = " The user has forced the input method open (such as by\n long-pressing menu) so it should not be closed until they\n explicitly do so."]
pub const GameActivityShowSoftInputFlags_GAMEACTIVITY_SHOW_SOFT_INPUT_FORCED:
    GameActivityShowSoftInputFlags = 2;
#[doc = " Flags for GameActivity_showSoftInput; see the Java InputMethodManager\n API for documentation."]
pub type GameActivityShowSoftInputFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Show the IME while in the given activity.  Calls\n InputMethodManager.showSoftInput() for the given activity.  Note that this\n method can be called from *any* thread; it will send a message to the main\n thread of the process where the Java call will take place."]
    pub fn GameActivity_showSoftInput(activity: *mut GameActivity, flags: u32);
}
extern "C" {
    #[doc = " Set the text entry state (see documentation of the GameTextInputState struct\n in the Game Text Input library reference).\n\n Ownership of the state is maintained by the caller."]
    pub fn GameActivity_setTextInputState(
        activity: *mut GameActivity,
        state: *const GameTextInputState,
    );
}
extern "C" {
    #[doc = " Get the last-received text entry state (see documentation of the\n GameTextInputState struct in the Game Text Input library reference).\n"]
    pub fn GameActivity_getTextInputState(
        activity: *mut GameActivity,
        callback: GameTextInputGetStateCallback,
        context: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Get a pointer to the GameTextInput library instance."]
    pub fn GameActivity_getTextInput(activity: *const GameActivity) -> *mut GameTextInput;
}
#[doc = " The soft input window should only be hidden if it was not\n explicitly shown by the user."]
pub const GameActivityHideSoftInputFlags_GAMEACTIVITY_HIDE_SOFT_INPUT_IMPLICIT_ONLY:
    GameActivityHideSoftInputFlags = 1;
#[doc = " The soft input window should normally be hidden, unless it was\n originally shown with {@link GAMEACTIVITY_SHOW_SOFT_INPUT_FORCED}."]
pub const GameActivityHideSoftInputFlags_GAMEACTIVITY_HIDE_SOFT_INPUT_NOT_ALWAYS:
    GameActivityHideSoftInputFlags = 2;
#[doc = " Flags for GameActivity_hideSoftInput; see the Java InputMethodManager\n API for documentation."]
pub type GameActivityHideSoftInputFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Hide the IME while in the given activity.  Calls\n InputMethodManager.hideSoftInput() for the given activity.  Note that this\n method can be called from *any* thread; it will send a message to the main\n thread of the process where the Java finish call will take place."]
    pub fn GameActivity_hideSoftInput(activity: *mut GameActivity, flags: u32);
}
extern "C" {
    #[doc = " Get the current window insets of the particular component. See\n https://developer.android.com/reference/androidx/core/view/WindowInsetsCompat.Type\n for more details.\n You can use these insets to influence what you show on the screen."]
    pub fn GameActivity_getWindowInsets(
        activity: *mut GameActivity,
        type_: GameCommonInsetsType,
        insets: *mut ARect,
    );
}
extern "C" {
    #[doc = " Set options on how the IME behaves when it is requested for text input.\n See\n https://developer.android.com/reference/android/view/inputmethod/EditorInfo\n for the meaning of inputType, actionId and imeOptions.\n\n Note that this function will attach the current thread to the JVM if it is\n not already attached, so the caller must detach the thread from the JVM\n before the thread is destroyed using DetachCurrentThread."]
    pub fn GameActivity_setImeEditorInfo(
        activity: *mut GameActivity,
        inputType: ::std::os::raw::c_int,
        actionId: ::std::os::raw::c_int,
        imeOptions: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " These are getters for Configuration class members. They may be called from\n any thread."]
    pub fn GameActivity_getOrientation(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getColorMode(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getDensityDpi(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getFontScale(activity: *mut GameActivity) -> f32;
}
extern "C" {
    pub fn GameActivity_getFontWeightAdjustment(
        activity: *mut GameActivity,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getHardKeyboardHidden(activity: *mut GameActivity)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getKeyboard(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getKeyboardHidden(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getMcc(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getMnc(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getNavigation(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getNavigationHidden(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getScreenHeightDp(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getScreenLayout(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getScreenWidthDp(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getSmallestScreenWidthDp(
        activity: *mut GameActivity,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getTouchscreen(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GameActivity_getUIMode(activity: *mut GameActivity) -> ::std::os::raw::c_int;
}
pub const ACONFIGURATION_ORIENTATION_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_ORIENTATION_PORT: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_ORIENTATION_LAND: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_ORIENTATION_SQUARE: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_TOUCHSCREEN_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_TOUCHSCREEN_NOTOUCH: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_TOUCHSCREEN_STYLUS: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_TOUCHSCREEN_FINGER: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_DENSITY_DEFAULT: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_DENSITY_LOW: _bindgen_ty_21 = 120;
pub const ACONFIGURATION_DENSITY_MEDIUM: _bindgen_ty_21 = 160;
pub const ACONFIGURATION_DENSITY_TV: _bindgen_ty_21 = 213;
pub const ACONFIGURATION_DENSITY_HIGH: _bindgen_ty_21 = 240;
pub const ACONFIGURATION_DENSITY_XHIGH: _bindgen_ty_21 = 320;
pub const ACONFIGURATION_DENSITY_XXHIGH: _bindgen_ty_21 = 480;
pub const ACONFIGURATION_DENSITY_XXXHIGH: _bindgen_ty_21 = 640;
pub const ACONFIGURATION_DENSITY_ANY: _bindgen_ty_21 = 65534;
pub const ACONFIGURATION_DENSITY_NONE: _bindgen_ty_21 = 65535;
pub const ACONFIGURATION_KEYBOARD_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_KEYBOARD_NOKEYS: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_KEYBOARD_QWERTY: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_KEYBOARD_12KEY: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_NAVIGATION_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_NAVIGATION_NONAV: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_NAVIGATION_DPAD: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_NAVIGATION_TRACKBALL: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_NAVIGATION_WHEEL: _bindgen_ty_21 = 4;
pub const ACONFIGURATION_KEYSHIDDEN_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_KEYSHIDDEN_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_KEYSHIDDEN_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_KEYSHIDDEN_SOFT: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_NAVHIDDEN_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_NAVHIDDEN_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_NAVHIDDEN_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_SCREENSIZE_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_SCREENSIZE_SMALL: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_SCREENSIZE_NORMAL: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_SCREENSIZE_LARGE: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_SCREENSIZE_XLARGE: _bindgen_ty_21 = 4;
pub const ACONFIGURATION_SCREENLONG_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_SCREENLONG_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_SCREENLONG_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_SCREENROUND_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_SCREENROUND_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_SCREENROUND_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_WIDE_COLOR_GAMUT_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_WIDE_COLOR_GAMUT_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_WIDE_COLOR_GAMUT_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_HDR_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_HDR_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_HDR_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_UI_MODE_TYPE_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_UI_MODE_TYPE_NORMAL: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_UI_MODE_TYPE_DESK: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_UI_MODE_TYPE_CAR: _bindgen_ty_21 = 3;
pub const ACONFIGURATION_UI_MODE_TYPE_TELEVISION: _bindgen_ty_21 = 4;
pub const ACONFIGURATION_UI_MODE_TYPE_APPLIANCE: _bindgen_ty_21 = 5;
pub const ACONFIGURATION_UI_MODE_TYPE_WATCH: _bindgen_ty_21 = 6;
pub const ACONFIGURATION_UI_MODE_TYPE_VR_HEADSET: _bindgen_ty_21 = 7;
pub const ACONFIGURATION_UI_MODE_NIGHT_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_UI_MODE_NIGHT_NO: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_UI_MODE_NIGHT_YES: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_SCREEN_WIDTH_DP_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_SCREEN_HEIGHT_DP_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_SMALLEST_SCREEN_WIDTH_DP_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_LAYOUTDIR_ANY: _bindgen_ty_21 = 0;
pub const ACONFIGURATION_LAYOUTDIR_LTR: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_LAYOUTDIR_RTL: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_MCC: _bindgen_ty_21 = 1;
pub const ACONFIGURATION_MNC: _bindgen_ty_21 = 2;
pub const ACONFIGURATION_LOCALE: _bindgen_ty_21 = 4;
pub const ACONFIGURATION_TOUCHSCREEN: _bindgen_ty_21 = 8;
pub const ACONFIGURATION_KEYBOARD: _bindgen_ty_21 = 16;
pub const ACONFIGURATION_KEYBOARD_HIDDEN: _bindgen_ty_21 = 32;
pub const ACONFIGURATION_NAVIGATION: _bindgen_ty_21 = 64;
pub const ACONFIGURATION_ORIENTATION: _bindgen_ty_21 = 128;
pub const ACONFIGURATION_DENSITY: _bindgen_ty_21 = 256;
pub const ACONFIGURATION_SCREEN_SIZE: _bindgen_ty_21 = 512;
pub const ACONFIGURATION_VERSION: _bindgen_ty_21 = 1024;
pub const ACONFIGURATION_SCREEN_LAYOUT: _bindgen_ty_21 = 2048;
pub const ACONFIGURATION_UI_MODE: _bindgen_ty_21 = 4096;
pub const ACONFIGURATION_SMALLEST_SCREEN_SIZE: _bindgen_ty_21 = 8192;
pub const ACONFIGURATION_LAYOUTDIR: _bindgen_ty_21 = 16384;
pub const ACONFIGURATION_SCREEN_ROUND: _bindgen_ty_21 = 32768;
pub const ACONFIGURATION_COLOR_MODE: _bindgen_ty_21 = 65536;
pub const ACONFIGURATION_MNC_ZERO: _bindgen_ty_21 = 65535;
pub type _bindgen_ty_21 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pollfd {
    pub fd: ::std::os::raw::c_int,
    pub events: ::std::os::raw::c_short,
    pub revents: ::std::os::raw::c_short,
}
#[test]
fn bindgen_test_layout_pollfd() {
    const UNINIT: ::std::mem::MaybeUninit<pollfd> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pollfd>(),
        8usize,
        concat!("Size of: ", stringify!(pollfd))
    );
    assert_eq!(
        ::std::mem::align_of::<pollfd>(),
        4usize,
        concat!("Alignment of ", stringify!(pollfd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pollfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).events) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pollfd),
            "::",
            stringify!(events)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).revents) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(pollfd),
            "::",
            stringify!(revents)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigcontext {
    pub trap_no: ::std::os::raw::c_ulong,
    pub error_code: ::std::os::raw::c_ulong,
    pub oldmask: ::std::os::raw::c_ulong,
    pub arm_r0: ::std::os::raw::c_ulong,
    pub arm_r1: ::std::os::raw::c_ulong,
    pub arm_r2: ::std::os::raw::c_ulong,
    pub arm_r3: ::std::os::raw::c_ulong,
    pub arm_r4: ::std::os::raw::c_ulong,
    pub arm_r5: ::std::os::raw::c_ulong,
    pub arm_r6: ::std::os::raw::c_ulong,
    pub arm_r7: ::std::os::raw::c_ulong,
    pub arm_r8: ::std::os::raw::c_ulong,
    pub arm_r9: ::std::os::raw::c_ulong,
    pub arm_r10: ::std::os::raw::c_ulong,
    pub arm_fp: ::std::os::raw::c_ulong,
    pub arm_ip: ::std::os::raw::c_ulong,
    pub arm_sp: ::std::os::raw::c_ulong,
    pub arm_lr: ::std::os::raw::c_ulong,
    pub arm_pc: ::std::os::raw::c_ulong,
    pub arm_cpsr: ::std::os::raw::c_ulong,
    pub fault_address: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_sigcontext() {
    const UNINIT: ::std::mem::MaybeUninit<sigcontext> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigcontext>(),
        84usize,
        concat!("Size of: ", stringify!(sigcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<sigcontext>(),
        4usize,
        concat!("Alignment of ", stringify!(sigcontext))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trap_no) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(trap_no)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error_code) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(error_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).oldmask) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(oldmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r0) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r1) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r2) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r3) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r4) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r5) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r6) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r7) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r8) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r9) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_r10) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_r10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_fp) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_fp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_ip) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_sp) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_sp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_lr) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_lr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_pc) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_pc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arm_cpsr) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(arm_cpsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fault_address) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(fault_address)
        )
    );
}
pub type sigset_t = ::std::os::raw::c_ulong;
pub type __signalfn_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __sighandler_t = __signalfn_t;
pub type __restorefn_t = ::std::option::Option<unsafe extern "C" fn()>;
pub type __sigrestore_t = __restorefn_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __kernel_sigaction {
    pub _u: __kernel_sigaction__bindgen_ty_1,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_ulong,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __kernel_sigaction__bindgen_ty_1 {
    pub _sa_handler: __sighandler_t,
    pub _sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout___kernel_sigaction__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_sigaction__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_sigaction__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__kernel_sigaction__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_sigaction__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__kernel_sigaction__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sa_handler) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sigaction__bindgen_ty_1),
            "::",
            stringify!(_sa_handler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sa_sigaction) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sigaction__bindgen_ty_1),
            "::",
            stringify!(_sa_sigaction)
        )
    );
}
#[test]
fn bindgen_test_layout___kernel_sigaction() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_sigaction> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(__kernel_sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_sigaction>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_sigaction))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._u) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sigaction),
            "::",
            stringify!(_u)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_mask) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_restorer) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sigaction),
            "::",
            stringify!(sa_restorer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_flags: ::std::os::raw::c_int,
    pub ss_size: __kernel_size_t,
}
#[test]
fn bindgen_test_layout_sigaltstack() {
    const UNINIT: ::std::mem::MaybeUninit<sigaltstack> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigaltstack>(),
        12usize,
        concat!("Size of: ", stringify!(sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaltstack>(),
        4usize,
        concat!("Alignment of ", stringify!(sigaltstack))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_sp) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
}
pub type stack_t = sigaltstack;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    const UNINIT: ::std::mem::MaybeUninit<sigval> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        4usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        4usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sival_int) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sival_ptr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
pub type sigval_t = sigval;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sifields {
    pub _kill: __sifields__bindgen_ty_1,
    pub _timer: __sifields__bindgen_ty_2,
    pub _rt: __sifields__bindgen_ty_3,
    pub _sigchld: __sifields__bindgen_ty_4,
    pub _sigfault: __sifields__bindgen_ty_5,
    pub _sigpoll: __sifields__bindgen_ty_6,
    pub _sigsys: __sifields__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_1 {
    pub _pid: __kernel_pid_t,
    pub _uid: __kernel_uid32_t,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_1),
            "::",
            stringify!(_pid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._uid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_1),
            "::",
            stringify!(_uid)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sifields__bindgen_ty_2 {
    pub _tid: __kernel_timer_t,
    pub _overrun: ::std::os::raw::c_int,
    pub _sigval: sigval_t,
    pub _sys_private: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._tid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_2),
            "::",
            stringify!(_tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._overrun) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_2),
            "::",
            stringify!(_overrun)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigval) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_2),
            "::",
            stringify!(_sigval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sys_private) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_2),
            "::",
            stringify!(_sys_private)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sifields__bindgen_ty_3 {
    pub _pid: __kernel_pid_t,
    pub _uid: __kernel_uid32_t,
    pub _sigval: sigval_t,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_3>(),
        12usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_3>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_3),
            "::",
            stringify!(_pid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._uid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_3),
            "::",
            stringify!(_uid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigval) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_3),
            "::",
            stringify!(_sigval)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_4 {
    pub _pid: __kernel_pid_t,
    pub _uid: __kernel_uid32_t,
    pub _status: ::std::os::raw::c_int,
    pub _utime: __kernel_clock_t,
    pub _stime: __kernel_clock_t,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_4() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_4> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_4>(),
        20usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_4>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_4))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_4),
            "::",
            stringify!(_pid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._uid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_4),
            "::",
            stringify!(_uid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._status) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_4),
            "::",
            stringify!(_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._utime) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_4),
            "::",
            stringify!(_utime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._stime) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_4),
            "::",
            stringify!(_stime)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sifields__bindgen_ty_5 {
    pub _addr: *mut ::std::os::raw::c_void,
    pub __bindgen_anon_1: __sifields__bindgen_ty_5__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sifields__bindgen_ty_5__bindgen_ty_1 {
    pub _trapno: ::std::os::raw::c_int,
    pub _addr_lsb: ::std::os::raw::c_short,
    pub _addr_bnd: __sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1,
    pub _addr_pkey: __sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2,
    pub _perf: __sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1 {
    pub _dummy_bnd: [::std::os::raw::c_char; 4usize],
    pub _lower: *mut ::std::os::raw::c_void,
    pub _upper: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._dummy_bnd) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_dummy_bnd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._lower) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_lower)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._upper) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_upper)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2 {
    pub _dummy_pkey: [::std::os::raw::c_char; 4usize],
    pub _pkey: __u32,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._dummy_pkey) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(_dummy_pkey)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pkey) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(_pkey)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3 {
    pub _data: ::std::os::raw::c_ulong,
    pub _type: __u32,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(_type)
        )
    );
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_5__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_5__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_5__bindgen_ty_1>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_5__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._trapno) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_trapno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr_lsb) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_addr_lsb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr_bnd) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_addr_bnd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr_pkey) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_addr_pkey)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._perf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_perf)
        )
    );
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_5() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_5> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_5>(),
        16usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_5>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_5))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_5),
            "::",
            stringify!(_addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_6 {
    pub _band: ::std::os::raw::c_long,
    pub _fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_6() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_6> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_6>(),
        8usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_6))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_6>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_6))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._band) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_6),
            "::",
            stringify!(_band)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._fd) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_6),
            "::",
            stringify!(_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sifields__bindgen_ty_7 {
    pub _call_addr: *mut ::std::os::raw::c_void,
    pub _syscall: ::std::os::raw::c_int,
    pub _arch: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___sifields__bindgen_ty_7() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields__bindgen_ty_7> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields__bindgen_ty_7>(),
        12usize,
        concat!("Size of: ", stringify!(__sifields__bindgen_ty_7))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields__bindgen_ty_7>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields__bindgen_ty_7))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._call_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_7),
            "::",
            stringify!(_call_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._syscall) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_7),
            "::",
            stringify!(_syscall)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._arch) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields__bindgen_ty_7),
            "::",
            stringify!(_arch)
        )
    );
}
#[test]
fn bindgen_test_layout___sifields() {
    const UNINIT: ::std::mem::MaybeUninit<__sifields> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sifields>(),
        20usize,
        concat!("Size of: ", stringify!(__sifields))
    );
    assert_eq!(
        ::std::mem::align_of::<__sifields>(),
        4usize,
        concat!("Alignment of ", stringify!(__sifields))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._kill) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_kill)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._timer) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_timer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._rt) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_rt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigchld) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_sigchld)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigfault) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_sigfault)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigpoll) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_sigpoll)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigsys) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sifields),
            "::",
            stringify!(_sigsys)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo {
    pub __bindgen_anon_1: siginfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo__bindgen_ty_1 {
    pub __bindgen_anon_1: siginfo__bindgen_ty_1__bindgen_ty_1,
    pub _si_pad: [::std::os::raw::c_int; 32usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo__bindgen_ty_1__bindgen_ty_1 {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub _sifields: __sifields,
}
#[test]
fn bindgen_test_layout_siginfo__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<siginfo__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<siginfo__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(siginfo__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_signo) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_errno) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_code) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sifields) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_sifields)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<siginfo__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<siginfo__bindgen_ty_1>(),
        128usize,
        concat!("Size of: ", stringify!(siginfo__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(siginfo__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._si_pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo__bindgen_ty_1),
            "::",
            stringify!(_si_pad)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo() {
    assert_eq!(
        ::std::mem::size_of::<siginfo>(),
        128usize,
        concat!("Size of: ", stringify!(siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo>(),
        4usize,
        concat!("Alignment of ", stringify!(siginfo))
    );
}
pub type siginfo_t = siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_value: sigval_t,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_notify: ::std::os::raw::c_int,
    pub _sigev_un: sigevent__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigevent__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 13usize],
    pub _tid: ::std::os::raw::c_int,
    pub _sigev_thread: sigevent__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent__bindgen_ty_1__bindgen_ty_1 {
    pub _function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval_t)>,
    pub _attribute: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigevent__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<sigevent__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigevent__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._function) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._attribute) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_attribute)
        )
    );
}
#[test]
fn bindgen_test_layout_sigevent__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<sigevent__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigevent__bindgen_ty_1>(),
        52usize,
        concat!("Size of: ", stringify!(sigevent__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(sigevent__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._tid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigev_thread) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_sigev_thread)
        )
    );
}
#[test]
fn bindgen_test_layout_sigevent() {
    const UNINIT: ::std::mem::MaybeUninit<sigevent> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        64usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        4usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_value) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_signo) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_notify) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sigev_un) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(_sigev_un)
        )
    );
}
pub type sigevent_t = sigevent;
pub type sig_atomic_t = ::std::os::raw::c_int;
pub type sig_t = __sighandler_t;
pub type sighandler_t = __sighandler_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigset64_t {
    pub __bits: [::std::os::raw::c_ulong; 2usize],
}
#[test]
fn bindgen_test_layout_sigset64_t() {
    const UNINIT: ::std::mem::MaybeUninit<sigset64_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigset64_t>(),
        8usize,
        concat!("Size of: ", stringify!(sigset64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sigset64_t>(),
        4usize,
        concat!("Alignment of ", stringify!(sigset64_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigset64_t),
            "::",
            stringify!(__bits)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __bindgen_anon_1: sigaction__bindgen_ty_1,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub sa_handler: sighandler_t,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_sigaction__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<sigaction__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigaction__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_handler) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_handler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_sigaction) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_sigaction)
        )
    );
}
#[test]
fn bindgen_test_layout_sigaction() {
    const UNINIT: ::std::mem::MaybeUninit<sigaction> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        4usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_mask) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_restorer) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_restorer)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction64 {
    pub __bindgen_anon_1: sigaction64__bindgen_ty_1,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
    pub sa_mask: sigset64_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction64__bindgen_ty_1 {
    pub sa_handler: sighandler_t,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_sigaction64__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<sigaction64__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigaction64__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(sigaction64__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction64__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(sigaction64__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_handler) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction64__bindgen_ty_1),
            "::",
            stringify!(sa_handler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_sigaction) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction64__bindgen_ty_1),
            "::",
            stringify!(sa_sigaction)
        )
    );
}
#[test]
fn bindgen_test_layout_sigaction64() {
    const UNINIT: ::std::mem::MaybeUninit<sigaction64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigaction64>(),
        20usize,
        concat!("Size of: ", stringify!(sigaction64))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction64>(),
        4usize,
        concat!("Alignment of ", stringify!(sigaction64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction64),
            "::",
            stringify!(sa_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_restorer) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction64),
            "::",
            stringify!(sa_restorer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_mask) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction64),
            "::",
            stringify!(sa_mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    const UNINIT: ::std::mem::MaybeUninit<timespec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        8usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        4usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_nsec) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct user_fpregs {
    pub fpregs: [user_fpregs_fp_reg; 8usize],
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub ftype: [::std::os::raw::c_uchar; 8usize],
    pub init_flag: ::std::os::raw::c_uint,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct user_fpregs_fp_reg {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 12usize]>,
}
#[test]
fn bindgen_test_layout_user_fpregs_fp_reg() {
    assert_eq!(
        ::std::mem::size_of::<user_fpregs_fp_reg>(),
        12usize,
        concat!("Size of: ", stringify!(user_fpregs_fp_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<user_fpregs_fp_reg>(),
        4usize,
        concat!("Alignment of ", stringify!(user_fpregs_fp_reg))
    );
}
impl user_fpregs_fp_reg {
    #[inline]
    pub fn sign1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn sign2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn exponent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 14u8) as u32) }
    }
    #[inline]
    pub fn set_exponent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 14u8, val as u64)
        }
    }
    #[inline]
    pub fn j(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_j(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mantissa1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn mantissa0(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(64usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa0(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(64usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sign1: ::std::os::raw::c_uint,
        unused: ::std::os::raw::c_uint,
        sign2: ::std::os::raw::c_uint,
        exponent: ::std::os::raw::c_uint,
        j: ::std::os::raw::c_uint,
        mantissa1: ::std::os::raw::c_uint,
        mantissa0: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 12usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 12usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let sign1: u32 = unsafe { ::std::mem::transmute(sign1) };
            sign1 as u64
        });
        __bindgen_bitfield_unit.set(1usize, 15u8, {
            let unused: u32 = unsafe { ::std::mem::transmute(unused) };
            unused as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let sign2: u32 = unsafe { ::std::mem::transmute(sign2) };
            sign2 as u64
        });
        __bindgen_bitfield_unit.set(17usize, 14u8, {
            let exponent: u32 = unsafe { ::std::mem::transmute(exponent) };
            exponent as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let j: u32 = unsafe { ::std::mem::transmute(j) };
            j as u64
        });
        __bindgen_bitfield_unit.set(32usize, 31u8, {
            let mantissa1: u32 = unsafe { ::std::mem::transmute(mantissa1) };
            mantissa1 as u64
        });
        __bindgen_bitfield_unit.set(64usize, 32u8, {
            let mantissa0: u32 = unsafe { ::std::mem::transmute(mantissa0) };
            mantissa0 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_user_fpregs() {
    const UNINIT: ::std::mem::MaybeUninit<user_fpregs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<user_fpregs>(),
        116usize,
        concat!("Size of: ", stringify!(user_fpregs))
    );
    assert_eq!(
        ::std::mem::align_of::<user_fpregs>(),
        4usize,
        concat!("Alignment of ", stringify!(user_fpregs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpregs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(user_fpregs),
            "::",
            stringify!(fpregs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ftype) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(user_fpregs),
            "::",
            stringify!(ftype)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init_flag) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(user_fpregs),
            "::",
            stringify!(init_flag)
        )
    );
}
impl user_fpregs {
    #[inline]
    pub fn fpsr(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_fpsr(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn fpcr(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_fpcr(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fpsr: ::std::os::raw::c_uint,
        fpcr: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 32u8, {
            let fpsr: u32 = unsafe { ::std::mem::transmute(fpsr) };
            fpsr as u64
        });
        __bindgen_bitfield_unit.set(32usize, 32u8, {
            let fpcr: u32 = unsafe { ::std::mem::transmute(fpcr) };
            fpcr as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct user_regs {
    pub uregs: [::std::os::raw::c_ulong; 18usize],
}
#[test]
fn bindgen_test_layout_user_regs() {
    const UNINIT: ::std::mem::MaybeUninit<user_regs> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<user_regs>(),
        72usize,
        concat!("Size of: ", stringify!(user_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<user_regs>(),
        4usize,
        concat!("Alignment of ", stringify!(user_regs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uregs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(user_regs),
            "::",
            stringify!(uregs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct user_vfp {
    pub fpregs: [::std::os::raw::c_ulonglong; 32usize],
    pub fpscr: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_user_vfp() {
    const UNINIT: ::std::mem::MaybeUninit<user_vfp> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<user_vfp>(),
        264usize,
        concat!("Size of: ", stringify!(user_vfp))
    );
    assert_eq!(
        ::std::mem::align_of::<user_vfp>(),
        8usize,
        concat!("Alignment of ", stringify!(user_vfp))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpregs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(user_vfp),
            "::",
            stringify!(fpregs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpscr) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(user_vfp),
            "::",
            stringify!(fpscr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct user_vfp_exc {
    pub fpexc: ::std::os::raw::c_ulong,
    pub fpinst: ::std::os::raw::c_ulong,
    pub fpinst2: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_user_vfp_exc() {
    const UNINIT: ::std::mem::MaybeUninit<user_vfp_exc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<user_vfp_exc>(),
        12usize,
        concat!("Size of: ", stringify!(user_vfp_exc))
    );
    assert_eq!(
        ::std::mem::align_of::<user_vfp_exc>(),
        4usize,
        concat!("Alignment of ", stringify!(user_vfp_exc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpexc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(user_vfp_exc),
            "::",
            stringify!(fpexc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpinst) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(user_vfp_exc),
            "::",
            stringify!(fpinst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpinst2) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(user_vfp_exc),
            "::",
            stringify!(fpinst2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct user {
    pub regs: user_regs,
    pub u_fpvalid: ::std::os::raw::c_int,
    pub u_tsize: ::std::os::raw::c_ulong,
    pub u_dsize: ::std::os::raw::c_ulong,
    pub u_ssize: ::std::os::raw::c_ulong,
    pub start_code: ::std::os::raw::c_ulong,
    pub start_stack: ::std::os::raw::c_ulong,
    pub signal: ::std::os::raw::c_long,
    pub reserved: ::std::os::raw::c_int,
    pub u_ar0: *mut user_regs,
    pub magic: ::std::os::raw::c_ulong,
    pub u_comm: [::std::os::raw::c_char; 32usize],
    pub u_debugreg: [::std::os::raw::c_int; 8usize],
    pub u_fp: user_fpregs,
    pub u_fp0: *mut user_fpregs,
}
#[test]
fn bindgen_test_layout_user() {
    const UNINIT: ::std::mem::MaybeUninit<user> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<user>(),
        296usize,
        concat!("Size of: ", stringify!(user))
    );
    assert_eq!(
        ::std::mem::align_of::<user>(),
        4usize,
        concat!("Alignment of ", stringify!(user))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).regs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_fpvalid) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_fpvalid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_tsize) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_tsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_dsize) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_dsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_ssize) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_ssize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_code) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(start_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_stack) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(start_stack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signal) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(signal)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_ar0) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_ar0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_comm) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_comm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_debugreg) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_debugreg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_fp) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_fp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u_fp0) as usize - ptr as usize },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(user),
            "::",
            stringify!(u_fp0)
        )
    );
}
pub const REG_R0: _bindgen_ty_22 = 0;
pub const REG_R1: _bindgen_ty_22 = 1;
pub const REG_R2: _bindgen_ty_22 = 2;
pub const REG_R3: _bindgen_ty_22 = 3;
pub const REG_R4: _bindgen_ty_22 = 4;
pub const REG_R5: _bindgen_ty_22 = 5;
pub const REG_R6: _bindgen_ty_22 = 6;
pub const REG_R7: _bindgen_ty_22 = 7;
pub const REG_R8: _bindgen_ty_22 = 8;
pub const REG_R9: _bindgen_ty_22 = 9;
pub const REG_R10: _bindgen_ty_22 = 10;
pub const REG_R11: _bindgen_ty_22 = 11;
pub const REG_R12: _bindgen_ty_22 = 12;
pub const REG_R13: _bindgen_ty_22 = 13;
pub const REG_R14: _bindgen_ty_22 = 14;
pub const REG_R15: _bindgen_ty_22 = 15;
pub type _bindgen_ty_22 = ::std::os::raw::c_uint;
pub type greg_t = ::std::os::raw::c_int;
pub type gregset_t = [greg_t; 18usize];
pub type fpregset_t = user_fpregs;
pub type mcontext_t = sigcontext;
#[repr(C)]
#[repr(align(8))]
#[derive(Copy, Clone)]
pub struct ucontext {
    pub uc_flags: ::std::os::raw::c_ulong,
    pub uc_link: *mut ucontext,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
    pub __bindgen_anon_1: ucontext__bindgen_ty_1,
    pub __padding: [::std::os::raw::c_char; 120usize],
    pub uc_regspace: [::std::os::raw::c_ulong; 128usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ucontext__bindgen_ty_1 {
    pub __bindgen_anon_1: ucontext__bindgen_ty_1__bindgen_ty_1,
    pub uc_sigmask64: sigset64_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucontext__bindgen_ty_1__bindgen_ty_1 {
    pub uc_sigmask: sigset_t,
    pub __padding_rt_sigset: u32,
}
#[test]
fn bindgen_test_layout_ucontext__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<ucontext__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ucontext__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(ucontext__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<ucontext__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(ucontext__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_sigmask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__padding_rt_sigset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__padding_rt_sigset)
        )
    );
}
#[test]
fn bindgen_test_layout_ucontext__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<ucontext__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ucontext__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(ucontext__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<ucontext__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(ucontext__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_sigmask64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext__bindgen_ty_1),
            "::",
            stringify!(uc_sigmask64)
        )
    );
}
#[test]
fn bindgen_test_layout_ucontext() {
    const UNINIT: ::std::mem::MaybeUninit<ucontext> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ucontext>(),
        744usize,
        concat!("Size of: ", stringify!(ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(ucontext))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_link) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_stack) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_mcontext) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__padding) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(__padding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_regspace) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_regspace)
        )
    );
}
pub type ucontext_t = ucontext;
extern "C" {
    pub fn __libc_current_sigrtmin() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmax() -> ::std::os::raw::c_int;
}
extern "C" {
    pub static sys_siglist: [*const ::std::os::raw::c_char; 65usize];
}
extern "C" {
    pub static sys_signame: [*const ::std::os::raw::c_char; 65usize];
}
extern "C" {
    pub fn sigaction(
        __signal: ::std::os::raw::c_int,
        __new_action: *const sigaction,
        __old_action: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction64(
        __signal: ::std::os::raw::c_int,
        __new_action: *const sigaction64,
        __old_action: *mut sigaction64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siginterrupt(
        __signal: ::std::os::raw::c_int,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn signal(__signal: ::std::os::raw::c_int, __handler: sighandler_t) -> sighandler_t;
}
extern "C" {
    pub fn sigaddset(
        __set: *mut sigset_t,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset64(
        __set: *mut sigset64_t,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(
        __set: *mut sigset_t,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset64(
        __set: *mut sigset64_t,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigemptyset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigemptyset64(__set: *mut sigset64_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset64(__set: *mut sigset64_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(
        __set: *const sigset_t,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember64(
        __set: *const sigset64_t,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending64(__set: *mut sigset64_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigprocmask(
        __how: ::std::os::raw::c_int,
        __new_set: *const sigset_t,
        __old_set: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigprocmask64(
        __how: ::std::os::raw::c_int,
        __new_set: *const sigset64_t,
        __old_set: *mut sigset64_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsuspend(__mask: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsuspend64(__mask: *const sigset64_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        __set: *const sigset_t,
        __signal: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait64(
        __set: *const sigset64_t,
        __signal: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sighold(__signal: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigignore(__signal: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpause(__signal: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigrelse(__signal: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigset(__signal: ::std::os::raw::c_int, __handler: sighandler_t) -> sighandler_t;
}
extern "C" {
    pub fn raise(__signal: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn kill(__pid: pid_t, __signal: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn killpg(
        __pgrp: ::std::os::raw::c_int,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tgkill(
        __tgid: ::std::os::raw::c_int,
        __tid: ::std::os::raw::c_int,
        __signal: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaltstack(
        __new_signal_stack: *const stack_t,
        __old_signal_stack: *mut stack_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psiginfo(__info: *const siginfo_t, __msg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn psignal(__signal: ::std::os::raw::c_int, __msg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sigqueue(
        __pid: pid_t,
        __signal: ::std::os::raw::c_int,
        __value: sigval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigtimedwait(
        __set: *const sigset_t,
        __info: *mut siginfo_t,
        __timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigtimedwait64(
        __set: *const sigset64_t,
        __info: *mut siginfo_t,
        __timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwaitinfo(__set: *const sigset_t, __info: *mut siginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwaitinfo64(__set: *const sigset64_t, __info: *mut siginfo_t)
        -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_timespec {
    pub tv_sec: __kernel_time64_t,
    pub tv_nsec: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___kernel_timespec() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_timespec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_timespec>(),
        16usize,
        concat!("Size of: ", stringify!(__kernel_timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_timespec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_nsec) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_itimerspec {
    pub it_interval: __kernel_timespec,
    pub it_value: __kernel_timespec,
}
#[test]
fn bindgen_test_layout___kernel_itimerspec() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_itimerspec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_itimerspec>(),
        32usize,
        concat!("Size of: ", stringify!(__kernel_itimerspec))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_itimerspec>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_itimerspec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_interval) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_itimerspec),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_value) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_itimerspec),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_old_timespec {
    pub tv_sec: __kernel_old_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout___kernel_old_timespec() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_old_timespec> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_old_timespec>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_old_timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_old_timespec>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_old_timespec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_old_timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_nsec) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_old_timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_sock_timeval {
    pub tv_sec: __s64,
    pub tv_usec: __s64,
}
#[test]
fn bindgen_test_layout___kernel_sock_timeval() {
    const UNINIT: ::std::mem::MaybeUninit<__kernel_sock_timeval> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__kernel_sock_timeval>(),
        16usize,
        concat!("Size of: ", stringify!(__kernel_sock_timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_sock_timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_sock_timeval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sock_timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_usec) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_sock_timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __kernel_old_time_t,
    pub tv_usec: __kernel_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    const UNINIT: ::std::mem::MaybeUninit<timeval> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        8usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        4usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_usec) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
#[test]
fn bindgen_test_layout_itimerspec() {
    const UNINIT: ::std::mem::MaybeUninit<itimerspec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<itimerspec>(),
        16usize,
        concat!("Size of: ", stringify!(itimerspec))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerspec>(),
        4usize,
        concat!("Alignment of ", stringify!(itimerspec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_interval) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_value) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[test]
fn bindgen_test_layout_itimerval() {
    const UNINIT: ::std::mem::MaybeUninit<itimerval> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<itimerval>(),
        16usize,
        concat!("Size of: ", stringify!(itimerval))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerval>(),
        4usize,
        concat!("Alignment of ", stringify!(itimerval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_interval) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_value) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_timezone() {
    const UNINIT: ::std::mem::MaybeUninit<timezone> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timezone>(),
        8usize,
        concat!("Size of: ", stringify!(timezone))
    );
    assert_eq!(
        ::std::mem::align_of::<timezone>(),
        4usize,
        concat!("Alignment of ", stringify!(timezone))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tz_minuteswest) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_minuteswest)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tz_dsttime) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_dsttime)
        )
    );
}
pub type fd_mask = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [fd_mask; 32usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    const UNINIT: ::std::mem::MaybeUninit<fd_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fds_bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
extern "C" {
    pub fn __FD_CLR_chk(arg1: ::std::os::raw::c_int, arg2: *mut fd_set, arg3: usize);
}
extern "C" {
    pub fn __FD_SET_chk(arg1: ::std::os::raw::c_int, arg2: *mut fd_set, arg3: usize);
}
extern "C" {
    pub fn __FD_ISSET_chk(
        arg1: ::std::os::raw::c_int,
        arg2: *const fd_set,
        arg3: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn select(
        __max_fd_plus_one: ::std::os::raw::c_int,
        __read_fds: *mut fd_set,
        __write_fds: *mut fd_set,
        __exception_fds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __max_fd_plus_one: ::std::os::raw::c_int,
        __read_fds: *mut fd_set,
        __write_fds: *mut fd_set,
        __exception_fds: *mut fd_set,
        __timeout: *const timespec,
        __mask: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect64(
        __max_fd_plus_one: ::std::os::raw::c_int,
        __read_fds: *mut fd_set,
        __write_fds: *mut fd_set,
        __exception_fds: *mut fd_set,
        __timeout: *const timespec,
        __mask: *const sigset64_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gettimeofday(__tv: *mut timeval, __tz: *mut timezone) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn settimeofday(__tv: *const timeval, __tz: *const timezone) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getitimer(
        __which: ::std::os::raw::c_int,
        __current_value: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setitimer(
        __which: ::std::os::raw::c_int,
        __new_value: *const itimerval,
        __old_value: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimes(
        __path: *const ::std::os::raw::c_char,
        __times: *const timeval,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_t {
    _unused: [u8; 0],
}
pub type locale_t = *mut __locale_t;
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    const UNINIT: ::std::mem::MaybeUninit<tm> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        44usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        4usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_min) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_hour) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_mday) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_mon) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_year) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_wday) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_yday) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_isdst) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_gmtoff) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_zone) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
extern "C" {
    pub fn time(__t: *mut time_t) -> time_t;
}
extern "C" {
    pub fn nanosleep(
        __request: *const timespec,
        __remainder: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn asctime(__tm: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn asctime_r(
        __tm: *const tm,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn difftime(__lhs: time_t, __rhs: time_t) -> f64;
}
extern "C" {
    pub fn mktime(__tm: *mut tm) -> time_t;
}
extern "C" {
    pub fn localtime(__t: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(__t: *const time_t, __tm: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn gmtime(__t: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn gmtime_r(__t: *const time_t, __tm: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn strptime(
        __s: *const ::std::os::raw::c_char,
        __fmt: *const ::std::os::raw::c_char,
        __tm: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strptime_l(
        __s: *const ::std::os::raw::c_char,
        __fmt: *const ::std::os::raw::c_char,
        __tm: *mut tm,
        __l: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strftime(
        __buf: *mut ::std::os::raw::c_char,
        __n: usize,
        __fmt: *const ::std::os::raw::c_char,
        __tm: *const tm,
    ) -> usize;
}
extern "C" {
    pub fn strftime_l(
        __buf: *mut ::std::os::raw::c_char,
        __n: usize,
        __fmt: *const ::std::os::raw::c_char,
        __tm: *const tm,
        __l: locale_t,
    ) -> usize;
}
extern "C" {
    pub fn ctime(__t: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        __t: *const time_t,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn clock_getcpuclockid(__pid: pid_t, __clock: *mut clockid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getres(__clock: clockid_t, __resolution: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock: clockid_t, __ts: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_nanosleep(
        __clock: clockid_t,
        __flags: ::std::os::raw::c_int,
        __request: *const timespec,
        __remainder: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_settime(__clock: clockid_t, __ts: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_create(
        __clock: clockid_t,
        __event: *mut sigevent,
        __timer_ptr: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_delete(__timer: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_settime(
        __timer: timer_t,
        __flags: ::std::os::raw::c_int,
        __new_value: *const itimerspec,
        __old_value: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_gettime(__timer: timer_t, __ts: *mut itimerspec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_getoverrun(__timer: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timelocal(__tm: *mut tm) -> time_t;
}
extern "C" {
    pub fn timegm(__tm: *mut tm) -> time_t;
}
extern "C" {
    pub fn timespec_get(
        __ts: *mut timespec,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type nfds_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn poll(
        __fds: *mut pollfd,
        __count: nfds_t,
        __timeout_ms: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ppoll(
        __fds: *mut pollfd,
        __count: nfds_t,
        __timeout: *const timespec,
        __mask: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ppoll64(
        __fds: *mut pollfd,
        __count: nfds_t,
        __timeout: *const timespec,
        __mask: *const sigset64_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clone_args {
    pub flags: __u64,
    pub pidfd: __u64,
    pub child_tid: __u64,
    pub parent_tid: __u64,
    pub exit_signal: __u64,
    pub stack: __u64,
    pub stack_size: __u64,
    pub tls: __u64,
    pub set_tid: __u64,
    pub set_tid_size: __u64,
    pub cgroup: __u64,
}
#[test]
fn bindgen_test_layout_clone_args() {
    const UNINIT: ::std::mem::MaybeUninit<clone_args> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<clone_args>(),
        88usize,
        concat!("Size of: ", stringify!(clone_args))
    );
    assert_eq!(
        ::std::mem::align_of::<clone_args>(),
        8usize,
        concat!("Alignment of ", stringify!(clone_args))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pidfd) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(pidfd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).child_tid) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(child_tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_tid) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(parent_tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exit_signal) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(exit_signal)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stack) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(stack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stack_size) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(stack_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tls) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(tls)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_tid) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(set_tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_tid_size) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(set_tid_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cgroup) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(clone_args),
            "::",
            stringify!(cgroup)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sched_param {
    pub sched_priority: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sched_param() {
    const UNINIT: ::std::mem::MaybeUninit<sched_param> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sched_param>(),
        4usize,
        concat!("Size of: ", stringify!(sched_param))
    );
    assert_eq!(
        ::std::mem::align_of::<sched_param>(),
        4usize,
        concat!("Alignment of ", stringify!(sched_param))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sched_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(sched_priority)
        )
    );
}
extern "C" {
    pub fn sched_setscheduler(
        __pid: pid_t,
        __policy: ::std::os::raw::c_int,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getscheduler(__pid: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_yield() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_max(__policy: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_min(__policy: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_setparam(__pid: pid_t, __param: *const sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getparam(__pid: pid_t, __param: *mut sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_rr_get_interval(__pid: pid_t, __quantum: *mut timespec) -> ::std::os::raw::c_int;
}
pub const PTHREAD_MUTEX_NORMAL: _bindgen_ty_23 = 0;
pub const PTHREAD_MUTEX_RECURSIVE: _bindgen_ty_23 = 1;
pub const PTHREAD_MUTEX_ERRORCHECK: _bindgen_ty_23 = 2;
pub const PTHREAD_MUTEX_ERRORCHECK_NP: _bindgen_ty_23 = 2;
pub const PTHREAD_MUTEX_RECURSIVE_NP: _bindgen_ty_23 = 1;
pub const PTHREAD_MUTEX_DEFAULT: _bindgen_ty_23 = 0;
pub type _bindgen_ty_23 = ::std::os::raw::c_uint;
pub const PTHREAD_RWLOCK_PREFER_READER_NP: _bindgen_ty_24 = 0;
pub const PTHREAD_RWLOCK_PREFER_WRITER_NONRECURSIVE_NP: _bindgen_ty_24 = 1;
pub type _bindgen_ty_24 = ::std::os::raw::c_uint;
pub type __pthread_cleanup_func_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cleanup_t {
    pub __cleanup_prev: *mut __pthread_cleanup_t,
    pub __cleanup_routine: __pthread_cleanup_func_t,
    pub __cleanup_arg: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___pthread_cleanup_t() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_cleanup_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_cleanup_t>(),
        12usize,
        concat!("Size of: ", stringify!(__pthread_cleanup_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cleanup_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__pthread_cleanup_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cleanup_prev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_t),
            "::",
            stringify!(__cleanup_prev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cleanup_routine) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_t),
            "::",
            stringify!(__cleanup_routine)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cleanup_arg) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_t),
            "::",
            stringify!(__cleanup_arg)
        )
    );
}
extern "C" {
    pub fn __pthread_cleanup_push(
        c: *mut __pthread_cleanup_t,
        arg1: __pthread_cleanup_func_t,
        arg2: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn __pthread_cleanup_pop(arg1: *mut __pthread_cleanup_t, arg2: ::std::os::raw::c_int);
}
#[doc = " Data associated with an ALooper fd that will be returned as the \"outData\"\n when that source has data ready."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct android_poll_source {
    #[doc = " The identifier of this source.  May be LOOPER_ID_MAIN or\n LOOPER_ID_INPUT."]
    pub id: i32,
    #[doc = " The android_app this ident is associated with."]
    pub app: *mut android_app,
    #[doc = " Function to call to perform the standard processing of data from\n this source."]
    pub process: ::std::option::Option<
        unsafe extern "C" fn(app: *mut android_app, source: *mut android_poll_source),
    >,
}
#[test]
fn bindgen_test_layout_android_poll_source() {
    const UNINIT: ::std::mem::MaybeUninit<android_poll_source> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<android_poll_source>(),
        12usize,
        concat!("Size of: ", stringify!(android_poll_source))
    );
    assert_eq!(
        ::std::mem::align_of::<android_poll_source>(),
        4usize,
        concat!("Alignment of ", stringify!(android_poll_source))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(android_poll_source),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).app) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(android_poll_source),
            "::",
            stringify!(app)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).process) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(android_poll_source),
            "::",
            stringify!(process)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct android_input_buffer {
    #[doc = " Pointer to a read-only array of GameActivityMotionEvent.\n Only the first motionEventsCount events are valid."]
    pub motionEvents: *mut GameActivityMotionEvent,
    #[doc = " The number of valid motion events in `motionEvents`."]
    pub motionEventsCount: u64,
    #[doc = " The size of the `motionEvents` buffer."]
    pub motionEventsBufferSize: u64,
    #[doc = " Pointer to a read-only array of GameActivityKeyEvent.\n Only the first keyEventsCount events are valid."]
    pub keyEvents: *mut GameActivityKeyEvent,
    #[doc = " The number of valid \"Key\" events in `keyEvents`."]
    pub keyEventsCount: u64,
    #[doc = " The size of the `keyEvents` buffer."]
    pub keyEventsBufferSize: u64,
}
#[test]
fn bindgen_test_layout_android_input_buffer() {
    const UNINIT: ::std::mem::MaybeUninit<android_input_buffer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<android_input_buffer>(),
        48usize,
        concat!("Size of: ", stringify!(android_input_buffer))
    );
    assert_eq!(
        ::std::mem::align_of::<android_input_buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(android_input_buffer))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).motionEvents) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(android_input_buffer),
            "::",
            stringify!(motionEvents)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).motionEventsCount) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(android_input_buffer),
            "::",
            stringify!(motionEventsCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).motionEventsBufferSize) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(android_input_buffer),
            "::",
            stringify!(motionEventsBufferSize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keyEvents) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(android_input_buffer),
            "::",
            stringify!(keyEvents)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keyEventsCount) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(android_input_buffer),
            "::",
            stringify!(keyEventsCount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keyEventsBufferSize) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(android_input_buffer),
            "::",
            stringify!(keyEventsBufferSize)
        )
    );
}
#[doc = " Function pointer declaration for the filtering of key events.\n A function with this signature should be passed to\n android_app_set_key_event_filter and return false for any events that should\n not be handled by android_native_app_glue. These events will be handled by\n the system instead."]
pub type android_key_event_filter =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const GameActivityKeyEvent) -> bool>;
#[doc = " Function pointer definition for the filtering of motion events.\n A function with this signature should be passed to\n android_app_set_motion_event_filter and return false for any events that\n should not be handled by android_native_app_glue. These events will be\n handled by the system instead."]
pub type android_motion_event_filter =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const GameActivityMotionEvent) -> bool>;
#[doc = " The GameActivity interface provided by <game-activity/GameActivity.h>\n is based on a set of application-provided callbacks that will be called\n by the Activity's main thread when certain events occur.\n\n This means that each one of this callbacks _should_ _not_ block, or they\n risk having the system force-close the application. This programming\n model is direct, lightweight, but constraining.\n\n The 'android_native_app_glue' static library is used to provide a different\n execution model where the application can implement its own main event\n loop in a different thread instead. Here's how it works:\n\n 1/ The application must provide a function named \"android_main()\" that\n    will be called when the activity is created, in a new thread that is\n    distinct from the activity's main thread.\n\n 2/ android_main() receives a pointer to a valid \"android_app\" structure\n    that contains references to other important objects, e.g. the\n    GameActivity obejct instance the application is running in.\n\n 3/ the \"android_app\" object holds an ALooper instance that already\n    listens to activity lifecycle events (e.g. \"pause\", \"resume\").\n    See APP_CMD_XXX declarations below.\n\n    This corresponds to an ALooper identifier returned by\n    ALooper_pollOnce with value LOOPER_ID_MAIN.\n\n    Your application can use the same ALooper to listen to additional\n    file-descriptors.  They can either be callback based, or with return\n    identifiers starting with LOOPER_ID_USER.\n\n 4/ Whenever you receive a LOOPER_ID_MAIN event,\n    the returned data will point to an android_poll_source structure.  You\n    can call the process() function on it, and fill in android_app->onAppCmd\n    to be called for your own processing of the event.\n\n    Alternatively, you can call the low-level functions to read and process\n    the data directly...  look at the process_cmd() and process_input()\n    implementations in the glue to see how to do this.\n\n See the sample named \"native-activity\" that comes with the NDK with a\n full usage example.  Also look at the documentation of GameActivity."]
#[repr(C)]
pub struct android_app {
    #[doc = " An optional pointer to application-defined state."]
    pub userData: *mut ::std::os::raw::c_void,
    #[doc = " A required callback for processing main app commands (`APP_CMD_*`).\n This is called each frame if there are app commands that need processing."]
    pub onAppCmd: ::std::option::Option<unsafe extern "C" fn(app: *mut android_app, cmd: i32)>,
    #[doc = " The GameActivity object instance that this app is running in."]
    pub activity: *mut GameActivity,
    #[doc = " The current configuration the app is running in."]
    pub config: *mut AConfiguration,
    #[doc = " The last activity saved state, as provided at creation time.\n It is NULL if there was no state.  You can use this as you need; the\n memory will remain around until you call android_app_exec_cmd() for\n APP_CMD_RESUME, at which point it will be freed and savedState set to\n NULL. These variables should only be changed when processing a\n APP_CMD_SAVE_STATE, at which point they will be initialized to NULL and\n you can malloc your state and place the information here.  In that case\n the memory will be freed for you later."]
    pub savedState: *mut ::std::os::raw::c_void,
    #[doc = " The size of the activity saved state. It is 0 if `savedState` is NULL."]
    pub savedStateSize: usize,
    #[doc = " The ALooper associated with the app's thread."]
    pub looper: *mut ALooper,
    #[doc = " When non-NULL, this is the window surface that the app can draw in."]
    pub window: *mut ANativeWindow,
    #[doc = " Current content rectangle of the window; this is the area where the\n window's content should be placed to be seen by the user."]
    pub contentRect: ARect,
    #[doc = " Current state of the app's activity.  May be either APP_CMD_START,\n APP_CMD_RESUME, APP_CMD_PAUSE, or APP_CMD_STOP."]
    pub activityState: ::std::os::raw::c_int,
    #[doc = " This is non-zero when the application's GameActivity is being\n destroyed and waiting for the app thread to complete."]
    pub destroyRequested: ::std::os::raw::c_int,
    #[doc = " This is used for buffering input from GameActivity. Once ready, the\n application thread switches the buffers and processes what was\n accumulated."]
    pub inputBuffers: [android_input_buffer; 2usize],
    pub currentInputBuffer: ::std::os::raw::c_int,
    #[doc = " 0 if no text input event is outstanding, 1 if it is.\n Use `GameActivity_getTextInputState` to get information\n about the text entered by the user."]
    pub textInputState: ::std::os::raw::c_int,
    #[doc = " @cond INTERNAL"]
    pub mutex: pthread_mutex_t,
    pub cond: pthread_cond_t,
    pub msgread: ::std::os::raw::c_int,
    pub msgwrite: ::std::os::raw::c_int,
    pub thread: pthread_t,
    pub cmdPollSource: android_poll_source,
    pub running: ::std::os::raw::c_int,
    pub stateSaved: ::std::os::raw::c_int,
    pub destroyed: ::std::os::raw::c_int,
    pub redrawNeeded: ::std::os::raw::c_int,
    pub pendingWindow: *mut ANativeWindow,
    pub pendingContentRect: ARect,
    pub keyEventFilter: android_key_event_filter,
    pub motionEventFilter: android_motion_event_filter,
    pub inputAvailableWakeUp: bool,
    pub inputSwapPending: bool,
}
#[test]
fn bindgen_test_layout_android_app() {
    const UNINIT: ::std::mem::MaybeUninit<android_app> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<android_app>(),
        240usize,
        concat!("Size of: ", stringify!(android_app))
    );
    assert_eq!(
        ::std::mem::align_of::<android_app>(),
        8usize,
        concat!("Alignment of ", stringify!(android_app))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).userData) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(userData)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onAppCmd) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(onAppCmd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).activity) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(activity)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).config) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(config)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).savedState) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(savedState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).savedStateSize) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(savedStateSize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).looper) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(looper)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).window) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(window)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).contentRect) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(contentRect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).activityState) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(activityState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).destroyRequested) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(destroyRequested)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inputBuffers) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(inputBuffers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).currentInputBuffer) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(currentInputBuffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).textInputState) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(textInputState)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mutex) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(mutex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cond) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msgread) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(msgread)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msgwrite) as usize - ptr as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(msgwrite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(thread)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cmdPollSource) as usize - ptr as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(cmdPollSource)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).running) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(running)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stateSaved) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(stateSaved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).destroyed) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(destroyed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).redrawNeeded) as usize - ptr as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(redrawNeeded)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pendingWindow) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(pendingWindow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pendingContentRect) as usize - ptr as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(pendingContentRect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keyEventFilter) as usize - ptr as usize },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(keyEventFilter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).motionEventFilter) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(motionEventFilter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inputAvailableWakeUp) as usize - ptr as usize },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(inputAvailableWakeUp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inputSwapPending) as usize - ptr as usize },
        237usize,
        concat!(
            "Offset of field: ",
            stringify!(android_app),
            "::",
            stringify!(inputSwapPending)
        )
    );
}
#[doc = " Looper data ID of commands coming from the app's main thread, which\n is returned as an identifier from ALooper_pollOnce().  The data for this\n identifier is a pointer to an android_poll_source structure.\n These can be retrieved and processed with android_app_read_cmd()\n and android_app_exec_cmd()."]
pub const NativeAppGlueLooperId_LOOPER_ID_MAIN: NativeAppGlueLooperId = 1;
#[doc = " Unused. Reserved for future use when usage of AInputQueue will be\n supported."]
pub const NativeAppGlueLooperId_LOOPER_ID_INPUT: NativeAppGlueLooperId = 2;
#[doc = " Start of user-defined ALooper identifiers."]
pub const NativeAppGlueLooperId_LOOPER_ID_USER: NativeAppGlueLooperId = 3;
#[doc = " Looper ID of commands coming from the app's main thread, an AInputQueue or\n user-defined sources."]
pub type NativeAppGlueLooperId = ::std::os::raw::c_uint;
#[doc = " Unused. Reserved for future use when usage of AInputQueue will be\n supported."]
pub const NativeAppGlueAppCmd_UNUSED_APP_CMD_INPUT_CHANGED: NativeAppGlueAppCmd = 0;
#[doc = " Command from main thread: a new ANativeWindow is ready for use.  Upon\n receiving this command, android_app->window will contain the new window\n surface."]
pub const NativeAppGlueAppCmd_APP_CMD_INIT_WINDOW: NativeAppGlueAppCmd = 1;
#[doc = " Command from main thread: the existing ANativeWindow needs to be\n terminated.  Upon receiving this command, android_app->window still\n contains the existing window; after calling android_app_exec_cmd\n it will be set to NULL."]
pub const NativeAppGlueAppCmd_APP_CMD_TERM_WINDOW: NativeAppGlueAppCmd = 2;
#[doc = " Command from main thread: the current ANativeWindow has been resized.\n Please redraw with its new size."]
pub const NativeAppGlueAppCmd_APP_CMD_WINDOW_RESIZED: NativeAppGlueAppCmd = 3;
#[doc = " Command from main thread: the system needs that the current ANativeWindow\n be redrawn.  You should redraw the window before handing this to\n android_app_exec_cmd() in order to avoid transient drawing glitches."]
pub const NativeAppGlueAppCmd_APP_CMD_WINDOW_REDRAW_NEEDED: NativeAppGlueAppCmd = 4;
#[doc = " Command from main thread: the content area of the window has changed,\n such as from the soft input window being shown or hidden.  You can\n find the new content rect in android_app::contentRect."]
pub const NativeAppGlueAppCmd_APP_CMD_CONTENT_RECT_CHANGED: NativeAppGlueAppCmd = 5;
#[doc = " Command from main thread: the app's activity window has gained\n input focus."]
pub const NativeAppGlueAppCmd_APP_CMD_GAINED_FOCUS: NativeAppGlueAppCmd = 6;
#[doc = " Command from main thread: the app's activity window has lost\n input focus."]
pub const NativeAppGlueAppCmd_APP_CMD_LOST_FOCUS: NativeAppGlueAppCmd = 7;
#[doc = " Command from main thread: the current device configuration has changed."]
pub const NativeAppGlueAppCmd_APP_CMD_CONFIG_CHANGED: NativeAppGlueAppCmd = 8;
#[doc = " Command from main thread: the system is running low on memory.\n Try to reduce your memory use."]
pub const NativeAppGlueAppCmd_APP_CMD_LOW_MEMORY: NativeAppGlueAppCmd = 9;
#[doc = " Command from main thread: the app's activity has been started."]
pub const NativeAppGlueAppCmd_APP_CMD_START: NativeAppGlueAppCmd = 10;
#[doc = " Command from main thread: the app's activity has been resumed."]
pub const NativeAppGlueAppCmd_APP_CMD_RESUME: NativeAppGlueAppCmd = 11;
#[doc = " Command from main thread: the app should generate a new saved state\n for itself, to restore from later if needed.  If you have saved state,\n allocate it with malloc and place it in android_app.savedState with\n the size in android_app.savedStateSize.  The will be freed for you\n later."]
pub const NativeAppGlueAppCmd_APP_CMD_SAVE_STATE: NativeAppGlueAppCmd = 12;
#[doc = " Command from main thread: the app's activity has been paused."]
pub const NativeAppGlueAppCmd_APP_CMD_PAUSE: NativeAppGlueAppCmd = 13;
#[doc = " Command from main thread: the app's activity has been stopped."]
pub const NativeAppGlueAppCmd_APP_CMD_STOP: NativeAppGlueAppCmd = 14;
#[doc = " Command from main thread: the app's activity is being destroyed,\n and waiting for the app thread to clean up and exit before proceeding."]
pub const NativeAppGlueAppCmd_APP_CMD_DESTROY: NativeAppGlueAppCmd = 15;
#[doc = " Command from main thread: the app's insets have changed."]
pub const NativeAppGlueAppCmd_APP_CMD_WINDOW_INSETS_CHANGED: NativeAppGlueAppCmd = 16;
#[doc = " Commands passed from the application's main Java thread to the game's thread."]
pub type NativeAppGlueAppCmd = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Call when ALooper_pollAll() returns LOOPER_ID_MAIN, reading the next\n app command message."]
    pub fn android_app_read_cmd(android_app: *mut android_app) -> i8;
}
extern "C" {
    #[doc = " Call with the command returned by android_app_read_cmd() to do the\n initial pre-processing of the given command.  You can perform your own\n actions for the command after calling this function."]
    pub fn android_app_pre_exec_cmd(android_app: *mut android_app, cmd: i8);
}
extern "C" {
    #[doc = " Call with the command returned by android_app_read_cmd() to do the\n final post-processing of the given command.  You must have done your own\n actions for the command before calling this function."]
    pub fn android_app_post_exec_cmd(android_app: *mut android_app, cmd: i8);
}
extern "C" {
    #[doc = " Call this before processing input events to get the events buffer.\n The function returns NULL if there are no events to process."]
    pub fn android_app_swap_input_buffers(
        android_app: *mut android_app,
    ) -> *mut android_input_buffer;
}
extern "C" {
    #[doc = " Clear the array of motion events that were waiting to be handled, and release\n each of them.\n\n This method should be called after you have processed the motion events in\n your game loop. You should handle events at each iteration of your game loop."]
    pub fn android_app_clear_motion_events(inputBuffer: *mut android_input_buffer);
}
extern "C" {
    #[doc = " Clear the array of key events that were waiting to be handled, and release\n each of them.\n\n This method should be called after you have processed the key up events in\n your game loop. You should handle events at each iteration of your game loop."]
    pub fn android_app_clear_key_events(inputBuffer: *mut android_input_buffer);
}
extern "C" {
    #[doc = " This is a springboard into the Rust glue layer that wraps calling the\n main entry for the app itself."]
    pub fn _rust_glue_entry(app: *mut android_app);
}
extern "C" {
    #[doc = " Set the filter to use when processing key events.\n Any events for which the filter returns false will be ignored by\n android_native_app_glue. If filter is set to NULL, no filtering is done.\n\n The default key filter will filter out volume and camera button presses."]
    pub fn android_app_set_key_event_filter(
        app: *mut android_app,
        filter: android_key_event_filter,
    );
}
extern "C" {
    #[doc = " Set the filter to use when processing touch and motion events.\n Any events for which the filter returns false will be ignored by\n android_native_app_glue. If filter is set to NULL, no filtering is done.\n\n Note that the default motion event filter will only allow touchscreen events\n through, in order to mimic NativeActivity's behaviour, so for controller\n events to be passed to the app, set the filter to NULL."]
    pub fn android_app_set_motion_event_filter(
        app: *mut android_app,
        filter: android_motion_event_filter,
    );
}
extern "C" {
    #[doc = " Determines if a looper wake up was due to new input becoming available"]
    pub fn android_app_input_available_wake_up(app: *mut android_app) -> bool;
}
