#include "gtest/gtest.h"

#include "ROOT/TestSupport.hxx"

#include "TString.h"

TEST(TString, Basics)
{
   TString *s = nullptr;
   ROOT_EXPECT_ERROR(s = new TString("Test", -5), "TString::TString", "Negative length!");
   delete s;
   TString p("Test", 1);
   EXPECT_STREQ("T", p);
   TString a = "test";
   ROOT_EXPECT_ERROR(a.Append("s", -5), "TString::Replace", "Negative number of replacement characters!");
   EXPECT_STREQ("test", a);
}
