//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopmode?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "CFBase")]
pub type CFRunLoopMode = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloop?language=objc)
#[repr(C)]
pub struct CFRunLoop {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFRunLoop"]
    unsafe impl CFRunLoop {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopsource?language=objc)
#[repr(C)]
pub struct CFRunLoopSource {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFRunLoopSource"]
    unsafe impl CFRunLoopSource {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopobserver?language=objc)
#[repr(C)]
pub struct CFRunLoopObserver {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFRunLoopObserver"]
    unsafe impl CFRunLoopObserver {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooptimer?language=objc)
#[repr(C)]
pub struct CFRunLoopTimer {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFRunLoopTimer"]
    unsafe impl CFRunLoopTimer {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooprunresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFRunLoopRunResult(pub i32);
impl CFRunLoopRunResult {
    #[doc(alias = "kCFRunLoopRunFinished")]
    pub const Finished: Self = Self(1);
    #[doc(alias = "kCFRunLoopRunStopped")]
    pub const Stopped: Self = Self(2);
    #[doc(alias = "kCFRunLoopRunTimedOut")]
    pub const TimedOut: Self = Self(3);
    #[doc(alias = "kCFRunLoopRunHandledSource")]
    pub const HandledSource: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRunLoopRunResult {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRunLoopRunResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopactivity?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFRunLoopActivity(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFRunLoopActivity: CFOptionFlags {
        #[doc(alias = "kCFRunLoopEntry")]
        const Entry = 1<<0;
        #[doc(alias = "kCFRunLoopBeforeTimers")]
        const BeforeTimers = 1<<1;
        #[doc(alias = "kCFRunLoopBeforeSources")]
        const BeforeSources = 1<<2;
        #[doc(alias = "kCFRunLoopBeforeWaiting")]
        const BeforeWaiting = 1<<5;
        #[doc(alias = "kCFRunLoopAfterWaiting")]
        const AfterWaiting = 1<<6;
        #[doc(alias = "kCFRunLoopExit")]
        const Exit = 1<<7;
        #[doc(alias = "kCFRunLoopAllActivities")]
        const AllActivities = 0x0FFFFFFF;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFRunLoopActivity {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFRunLoopActivity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfrunloopdefaultmode?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFRunLoopDefaultMode: Option<&'static CFRunLoopMode>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfrunloopcommonmodes?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFRunLoopCommonModes: Option<&'static CFRunLoopMode>;
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFRunLoop {
    #[doc(alias = "CFRunLoopGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopGetTypeID() }
    }
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopGetCurrent() -> Option<CFRetained<CFRunLoop>> {
    extern "C-unwind" {
        fn CFRunLoopGetCurrent() -> Option<NonNull<CFRunLoop>>;
    }
    let ret = unsafe { CFRunLoopGetCurrent() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopGetMain() -> Option<CFRetained<CFRunLoop>> {
    extern "C-unwind" {
        fn CFRunLoopGetMain() -> Option<NonNull<CFRunLoop>>;
    }
    let ret = unsafe { CFRunLoopGetMain() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopCopyCurrentMode(
    rl: &CFRunLoop,
) -> Option<CFRetained<CFRunLoopMode>> {
    extern "C-unwind" {
        fn CFRunLoopCopyCurrentMode(rl: &CFRunLoop) -> Option<NonNull<CFRunLoopMode>>;
    }
    let ret = unsafe { CFRunLoopCopyCurrentMode(rl) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopCopyAllModes(
    rl: &CFRunLoop,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFRunLoopCopyAllModes(rl: &CFRunLoop) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFRunLoopCopyAllModes(rl) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopAddCommonMode(rl: &CFRunLoop, mode: Option<&CFRunLoopMode>);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate"))]
    pub fn CFRunLoopGetNextTimerFireDate(
        rl: &CFRunLoop,
        mode: Option<&CFRunLoopMode>,
    ) -> CFAbsoluteTime;
}

extern "C-unwind" {
    pub fn CFRunLoopRun();
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopRunInMode(
    mode: Option<&CFRunLoopMode>,
    seconds: CFTimeInterval,
    return_after_source_handled: bool,
) -> CFRunLoopRunResult {
    extern "C-unwind" {
        fn CFRunLoopRunInMode(
            mode: Option<&CFRunLoopMode>,
            seconds: CFTimeInterval,
            return_after_source_handled: Boolean,
        ) -> CFRunLoopRunResult;
    }
    unsafe { CFRunLoopRunInMode(mode, seconds, return_after_source_handled as _) }
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopIsWaiting(rl: &CFRunLoop) -> bool {
    extern "C-unwind" {
        fn CFRunLoopIsWaiting(rl: &CFRunLoop) -> Boolean;
    }
    let ret = unsafe { CFRunLoopIsWaiting(rl) };
    ret != 0
}

extern "C-unwind" {
    pub fn CFRunLoopWakeUp(rl: &CFRunLoop);
}

extern "C-unwind" {
    pub fn CFRunLoopStop(rl: &CFRunLoop);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "block2"))]
    pub fn CFRunLoopPerformBlock(
        rl: &CFRunLoop,
        mode: Option<&CFType>,
        block: Option<&block2::Block<dyn Fn()>>,
    );
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopContainsSource(
    rl: &CFRunLoop,
    source: Option<&CFRunLoopSource>,
    mode: Option<&CFRunLoopMode>,
) -> bool {
    extern "C-unwind" {
        fn CFRunLoopContainsSource(
            rl: &CFRunLoop,
            source: Option<&CFRunLoopSource>,
            mode: Option<&CFRunLoopMode>,
        ) -> Boolean;
    }
    let ret = unsafe { CFRunLoopContainsSource(rl, source, mode) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopAddSource(
        rl: &CFRunLoop,
        source: Option<&CFRunLoopSource>,
        mode: Option<&CFRunLoopMode>,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopRemoveSource(
        rl: &CFRunLoop,
        source: Option<&CFRunLoopSource>,
        mode: Option<&CFRunLoopMode>,
    );
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopContainsObserver(
    rl: &CFRunLoop,
    observer: Option<&CFRunLoopObserver>,
    mode: Option<&CFRunLoopMode>,
) -> bool {
    extern "C-unwind" {
        fn CFRunLoopContainsObserver(
            rl: &CFRunLoop,
            observer: Option<&CFRunLoopObserver>,
            mode: Option<&CFRunLoopMode>,
        ) -> Boolean;
    }
    let ret = unsafe { CFRunLoopContainsObserver(rl, observer, mode) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopAddObserver(
        rl: &CFRunLoop,
        observer: Option<&CFRunLoopObserver>,
        mode: Option<&CFRunLoopMode>,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopRemoveObserver(
        rl: &CFRunLoop,
        observer: Option<&CFRunLoopObserver>,
        mode: Option<&CFRunLoopMode>,
    );
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopContainsTimer(
    rl: &CFRunLoop,
    timer: Option<&CFRunLoopTimer>,
    mode: Option<&CFRunLoopMode>,
) -> bool {
    extern "C-unwind" {
        fn CFRunLoopContainsTimer(
            rl: &CFRunLoop,
            timer: Option<&CFRunLoopTimer>,
            mode: Option<&CFRunLoopMode>,
        ) -> Boolean;
    }
    let ret = unsafe { CFRunLoopContainsTimer(rl, timer, mode) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopAddTimer(
        rl: &CFRunLoop,
        timer: Option<&CFRunLoopTimer>,
        mode: Option<&CFRunLoopMode>,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopRemoveTimer(
        rl: &CFRunLoop,
        timer: Option<&CFRunLoopTimer>,
        mode: Option<&CFRunLoopMode>,
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopsourcecontext?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopSourceContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
    pub equal: Option<unsafe extern "C-unwind" fn(*const c_void, *const c_void) -> Boolean>,
    pub hash: Option<unsafe extern "C-unwind" fn(*const c_void) -> CFHashCode>,
    pub schedule:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut CFRunLoop, *const CFRunLoopMode)>,
    pub cancel:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut CFRunLoop, *const CFRunLoopMode)>,
    pub perform: Option<unsafe extern "C-unwind" fn(*mut c_void)>,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFRunLoopSourceContext {
    const ENCODING: Encoding = Encoding::Struct("?", &[
        <CFIndex>::ENCODING,
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const c_void>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const CFString>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,*const c_void,) -> Boolean>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> CFHashCode>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut CFRunLoop,*const CFRunLoopMode,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut CFRunLoop,*const CFRunLoopMode,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,)>>::ENCODING,
    ]);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFRunLoopSourceContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopsourcecontext1?language=objc)
#[cfg(all(feature = "CFBase", feature = "libc"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopSourceContext1 {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
    pub equal: Option<unsafe extern "C-unwind" fn(*const c_void, *const c_void) -> Boolean>,
    pub hash: Option<unsafe extern "C-unwind" fn(*const c_void) -> CFHashCode>,
    pub getPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub perform: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            CFIndex,
            *const CFAllocator,
            *mut c_void,
        ) -> *mut c_void,
    >,
}

#[cfg(all(feature = "CFBase", feature = "libc", feature = "objc2"))]
unsafe impl Encode for CFRunLoopSourceContext1 {
    const ENCODING: Encoding = Encoding::Struct("?", &[
        <CFIndex>::ENCODING,
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const c_void>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const CFString>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,*const c_void,) -> Boolean>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> CFHashCode>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,CFIndex,*const CFAllocator,*mut c_void,) -> *mut c_void>>::ENCODING,
    ]);
}

#[cfg(all(feature = "CFBase", feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for CFRunLoopSourceContext1 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFRunLoopSource {
    #[doc(alias = "CFRunLoopSourceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopSourceGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopSourceGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopSourceCreate(
    allocator: Option<&CFAllocator>,
    order: CFIndex,
    context: *mut CFRunLoopSourceContext,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFRunLoopSourceCreate(
            allocator: Option<&CFAllocator>,
            order: CFIndex,
            context: *mut CFRunLoopSourceContext,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFRunLoopSourceCreate(allocator, order, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopSourceGetOrder(source: &CFRunLoopSource) -> CFIndex;
}

extern "C-unwind" {
    pub fn CFRunLoopSourceInvalidate(source: &CFRunLoopSource);
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopSourceIsValid(source: &CFRunLoopSource) -> bool {
    extern "C-unwind" {
        fn CFRunLoopSourceIsValid(source: &CFRunLoopSource) -> Boolean;
    }
    let ret = unsafe { CFRunLoopSourceIsValid(source) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopSourceGetContext(
        source: &CFRunLoopSource,
        context: *mut CFRunLoopSourceContext,
    );
}

extern "C-unwind" {
    pub fn CFRunLoopSourceSignal(source: &CFRunLoopSource);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopobservercontext?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopObserverContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFRunLoopObserverContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFRunLoopObserverContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopobservercallback?language=objc)
#[cfg(feature = "CFBase")]
pub type CFRunLoopObserverCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFRunLoopObserver, CFRunLoopActivity, *mut c_void)>;

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFRunLoopObserver {
    #[doc(alias = "CFRunLoopObserverGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopObserverGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopObserverGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopObserverCreate(
    allocator: Option<&CFAllocator>,
    activities: CFOptionFlags,
    repeats: bool,
    order: CFIndex,
    callout: CFRunLoopObserverCallBack,
    context: *mut CFRunLoopObserverContext,
) -> Option<CFRetained<CFRunLoopObserver>> {
    extern "C-unwind" {
        fn CFRunLoopObserverCreate(
            allocator: Option<&CFAllocator>,
            activities: CFOptionFlags,
            repeats: Boolean,
            order: CFIndex,
            callout: CFRunLoopObserverCallBack,
            context: *mut CFRunLoopObserverContext,
        ) -> Option<NonNull<CFRunLoopObserver>>;
    }
    let ret = unsafe {
        CFRunLoopObserverCreate(allocator, activities, repeats as _, order, callout, context)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "block2"))]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopObserverCreateWithHandler(
    allocator: Option<&CFAllocator>,
    activities: CFOptionFlags,
    repeats: bool,
    order: CFIndex,
    block: Option<&block2::Block<dyn Fn(*mut CFRunLoopObserver, CFRunLoopActivity)>>,
) -> Option<CFRetained<CFRunLoopObserver>> {
    extern "C-unwind" {
        fn CFRunLoopObserverCreateWithHandler(
            allocator: Option<&CFAllocator>,
            activities: CFOptionFlags,
            repeats: Boolean,
            order: CFIndex,
            block: Option<&block2::Block<dyn Fn(*mut CFRunLoopObserver, CFRunLoopActivity)>>,
        ) -> Option<NonNull<CFRunLoopObserver>>;
    }
    let ret = unsafe {
        CFRunLoopObserverCreateWithHandler(allocator, activities, repeats as _, order, block)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopObserverGetActivities(observer: &CFRunLoopObserver) -> CFOptionFlags;
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopObserverDoesRepeat(observer: &CFRunLoopObserver) -> bool {
    extern "C-unwind" {
        fn CFRunLoopObserverDoesRepeat(observer: &CFRunLoopObserver) -> Boolean;
    }
    let ret = unsafe { CFRunLoopObserverDoesRepeat(observer) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopObserverGetOrder(observer: &CFRunLoopObserver) -> CFIndex;
}

extern "C-unwind" {
    pub fn CFRunLoopObserverInvalidate(observer: &CFRunLoopObserver);
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopObserverIsValid(observer: &CFRunLoopObserver) -> bool {
    extern "C-unwind" {
        fn CFRunLoopObserverIsValid(observer: &CFRunLoopObserver) -> Boolean;
    }
    let ret = unsafe { CFRunLoopObserverIsValid(observer) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopObserverGetContext(
        observer: &CFRunLoopObserver,
        context: *mut CFRunLoopObserverContext,
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooptimercontext?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopTimerContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFRunLoopTimerContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFRunLoopTimerContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooptimercallback?language=objc)
pub type CFRunLoopTimerCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFRunLoopTimer, *mut c_void)>;

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFRunLoopTimer {
    #[doc(alias = "CFRunLoopTimerGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopTimerGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopTimerGetTypeID() }
    }
}

#[cfg(all(feature = "CFBase", feature = "CFDate"))]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopTimerCreate(
    allocator: Option<&CFAllocator>,
    fire_date: CFAbsoluteTime,
    interval: CFTimeInterval,
    flags: CFOptionFlags,
    order: CFIndex,
    callout: CFRunLoopTimerCallBack,
    context: *mut CFRunLoopTimerContext,
) -> Option<CFRetained<CFRunLoopTimer>> {
    extern "C-unwind" {
        fn CFRunLoopTimerCreate(
            allocator: Option<&CFAllocator>,
            fire_date: CFAbsoluteTime,
            interval: CFTimeInterval,
            flags: CFOptionFlags,
            order: CFIndex,
            callout: CFRunLoopTimerCallBack,
            context: *mut CFRunLoopTimerContext,
        ) -> Option<NonNull<CFRunLoopTimer>>;
    }
    let ret = unsafe {
        CFRunLoopTimerCreate(
            allocator, fire_date, interval, flags, order, callout, context,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFDate", feature = "block2"))]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopTimerCreateWithHandler(
    allocator: Option<&CFAllocator>,
    fire_date: CFAbsoluteTime,
    interval: CFTimeInterval,
    flags: CFOptionFlags,
    order: CFIndex,
    block: Option<&block2::Block<dyn Fn(*mut CFRunLoopTimer)>>,
) -> Option<CFRetained<CFRunLoopTimer>> {
    extern "C-unwind" {
        fn CFRunLoopTimerCreateWithHandler(
            allocator: Option<&CFAllocator>,
            fire_date: CFAbsoluteTime,
            interval: CFTimeInterval,
            flags: CFOptionFlags,
            order: CFIndex,
            block: Option<&block2::Block<dyn Fn(*mut CFRunLoopTimer)>>,
        ) -> Option<NonNull<CFRunLoopTimer>>;
    }
    let ret = unsafe {
        CFRunLoopTimerCreateWithHandler(allocator, fire_date, interval, flags, order, block)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    pub fn CFRunLoopTimerGetNextFireDate(timer: &CFRunLoopTimer) -> CFAbsoluteTime;
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    pub fn CFRunLoopTimerSetNextFireDate(timer: &CFRunLoopTimer, fire_date: CFAbsoluteTime);
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    pub fn CFRunLoopTimerGetInterval(timer: &CFRunLoopTimer) -> CFTimeInterval;
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopTimerDoesRepeat(timer: &CFRunLoopTimer) -> bool {
    extern "C-unwind" {
        fn CFRunLoopTimerDoesRepeat(timer: &CFRunLoopTimer) -> Boolean;
    }
    let ret = unsafe { CFRunLoopTimerDoesRepeat(timer) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopTimerGetOrder(timer: &CFRunLoopTimer) -> CFIndex;
}

extern "C-unwind" {
    pub fn CFRunLoopTimerInvalidate(timer: &CFRunLoopTimer);
}

#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopTimerIsValid(timer: &CFRunLoopTimer) -> bool {
    extern "C-unwind" {
        fn CFRunLoopTimerIsValid(timer: &CFRunLoopTimer) -> Boolean;
    }
    let ret = unsafe { CFRunLoopTimerIsValid(timer) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFRunLoopTimerGetContext(timer: &CFRunLoopTimer, context: *mut CFRunLoopTimerContext);
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    pub fn CFRunLoopTimerGetTolerance(timer: &CFRunLoopTimer) -> CFTimeInterval;
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    pub fn CFRunLoopTimerSetTolerance(timer: &CFRunLoopTimer, tolerance: CFTimeInterval);
}
