// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-fake-store'; DO NOT EDIT

package fake

import (
	"github.com/sacloud/iaas-api-go"
	"github.com/sacloud/iaas-api-go/accessor"
	"github.com/sacloud/iaas-api-go/types"
)

func getArchive(zone string) []*iaas.Archive {
	values := ds().List(ResourceArchive, zone)
	var ret []*iaas.Archive
	for _, v := range values {
		if v, ok := v.(*iaas.Archive); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getArchiveByID(zone string, id types.ID) *iaas.Archive {
	v := ds().Get(ResourceArchive, zone, id)
	if v, ok := v.(*iaas.Archive); ok {
		return v
	}
	return nil
}

func putArchive(zone string, value *iaas.Archive) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceArchive, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceArchive, zone, 0, value)
}

func getAuthStatus(zone string) []*iaas.AuthStatus {
	values := ds().List(ResourceAuthStatus, zone)
	var ret []*iaas.AuthStatus
	for _, v := range values {
		if v, ok := v.(*iaas.AuthStatus); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getAuthStatusByID(zone string, id types.ID) *iaas.AuthStatus {
	v := ds().Get(ResourceAuthStatus, zone, id)
	if v, ok := v.(*iaas.AuthStatus); ok {
		return v
	}
	return nil
}

func putAuthStatus(zone string, value *iaas.AuthStatus) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceAuthStatus, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceAuthStatus, zone, 0, value)
}

func getAutoBackup(zone string) []*iaas.AutoBackup {
	values := ds().List(ResourceAutoBackup, zone)
	var ret []*iaas.AutoBackup
	for _, v := range values {
		if v, ok := v.(*iaas.AutoBackup); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getAutoBackupByID(zone string, id types.ID) *iaas.AutoBackup {
	v := ds().Get(ResourceAutoBackup, zone, id)
	if v, ok := v.(*iaas.AutoBackup); ok {
		return v
	}
	return nil
}

func putAutoBackup(zone string, value *iaas.AutoBackup) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceAutoBackup, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceAutoBackup, zone, 0, value)
}

func getAutoScale(zone string) []*iaas.AutoScale {
	values := ds().List(ResourceAutoScale, zone)
	var ret []*iaas.AutoScale
	for _, v := range values {
		if v, ok := v.(*iaas.AutoScale); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getAutoScaleByID(zone string, id types.ID) *iaas.AutoScale {
	v := ds().Get(ResourceAutoScale, zone, id)
	if v, ok := v.(*iaas.AutoScale); ok {
		return v
	}
	return nil
}

func putAutoScale(zone string, value *iaas.AutoScale) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceAutoScale, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceAutoScale, zone, 0, value)
}

func getBill(zone string) []*iaas.Bill {
	values := ds().List(ResourceBill, zone)
	var ret []*iaas.Bill
	for _, v := range values {
		if v, ok := v.(*iaas.Bill); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getBillByID(zone string, id types.ID) *iaas.Bill {
	v := ds().Get(ResourceBill, zone, id)
	if v, ok := v.(*iaas.Bill); ok {
		return v
	}
	return nil
}

func putBill(zone string, value *iaas.Bill) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceBill, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceBill, zone, 0, value)
}

func getBridge(zone string) []*iaas.Bridge {
	values := ds().List(ResourceBridge, zone)
	var ret []*iaas.Bridge
	for _, v := range values {
		if v, ok := v.(*iaas.Bridge); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getBridgeByID(zone string, id types.ID) *iaas.Bridge {
	v := ds().Get(ResourceBridge, zone, id)
	if v, ok := v.(*iaas.Bridge); ok {
		return v
	}
	return nil
}

func putBridge(zone string, value *iaas.Bridge) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceBridge, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceBridge, zone, 0, value)
}

func getCDROM(zone string) []*iaas.CDROM {
	values := ds().List(ResourceCDROM, zone)
	var ret []*iaas.CDROM
	for _, v := range values {
		if v, ok := v.(*iaas.CDROM); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getCDROMByID(zone string, id types.ID) *iaas.CDROM {
	v := ds().Get(ResourceCDROM, zone, id)
	if v, ok := v.(*iaas.CDROM); ok {
		return v
	}
	return nil
}

func putCDROM(zone string, value *iaas.CDROM) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceCDROM, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceCDROM, zone, 0, value)
}

func getCertificateAuthority(zone string) []*iaas.CertificateAuthority {
	values := ds().List(ResourceCertificateAuthority, zone)
	var ret []*iaas.CertificateAuthority
	for _, v := range values {
		if v, ok := v.(*iaas.CertificateAuthority); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getCertificateAuthorityByID(zone string, id types.ID) *iaas.CertificateAuthority {
	v := ds().Get(ResourceCertificateAuthority, zone, id)
	if v, ok := v.(*iaas.CertificateAuthority); ok {
		return v
	}
	return nil
}

func putCertificateAuthority(zone string, value *iaas.CertificateAuthority) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceCertificateAuthority, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceCertificateAuthority, zone, 0, value)
}

func getContainerRegistry(zone string) []*iaas.ContainerRegistry {
	values := ds().List(ResourceContainerRegistry, zone)
	var ret []*iaas.ContainerRegistry
	for _, v := range values {
		if v, ok := v.(*iaas.ContainerRegistry); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getContainerRegistryByID(zone string, id types.ID) *iaas.ContainerRegistry {
	v := ds().Get(ResourceContainerRegistry, zone, id)
	if v, ok := v.(*iaas.ContainerRegistry); ok {
		return v
	}
	return nil
}

func putContainerRegistry(zone string, value *iaas.ContainerRegistry) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceContainerRegistry, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceContainerRegistry, zone, 0, value)
}

func getCoupon(zone string) []*iaas.Coupon {
	values := ds().List(ResourceCoupon, zone)
	var ret []*iaas.Coupon
	for _, v := range values {
		if v, ok := v.(*iaas.Coupon); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getCouponByID(zone string, id types.ID) *iaas.Coupon {
	v := ds().Get(ResourceCoupon, zone, id)
	if v, ok := v.(*iaas.Coupon); ok {
		return v
	}
	return nil
}

func putCoupon(zone string, value *iaas.Coupon) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceCoupon, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceCoupon, zone, 0, value)
}

func getDatabase(zone string) []*iaas.Database {
	values := ds().List(ResourceDatabase, zone)
	var ret []*iaas.Database
	for _, v := range values {
		if v, ok := v.(*iaas.Database); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getDatabaseByID(zone string, id types.ID) *iaas.Database {
	v := ds().Get(ResourceDatabase, zone, id)
	if v, ok := v.(*iaas.Database); ok {
		return v
	}
	return nil
}

func putDatabase(zone string, value *iaas.Database) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceDatabase, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceDatabase, zone, 0, value)
}

func getDisk(zone string) []*iaas.Disk {
	values := ds().List(ResourceDisk, zone)
	var ret []*iaas.Disk
	for _, v := range values {
		if v, ok := v.(*iaas.Disk); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getDiskByID(zone string, id types.ID) *iaas.Disk {
	v := ds().Get(ResourceDisk, zone, id)
	if v, ok := v.(*iaas.Disk); ok {
		return v
	}
	return nil
}

func putDisk(zone string, value *iaas.Disk) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceDisk, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceDisk, zone, 0, value)
}

func getDiskPlan(zone string) []*iaas.DiskPlan {
	values := ds().List(ResourceDiskPlan, zone)
	var ret []*iaas.DiskPlan
	for _, v := range values {
		if v, ok := v.(*iaas.DiskPlan); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getDiskPlanByID(zone string, id types.ID) *iaas.DiskPlan {
	v := ds().Get(ResourceDiskPlan, zone, id)
	if v, ok := v.(*iaas.DiskPlan); ok {
		return v
	}
	return nil
}

func putDiskPlan(zone string, value *iaas.DiskPlan) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceDiskPlan, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceDiskPlan, zone, 0, value)
}

func getDNS(zone string) []*iaas.DNS {
	values := ds().List(ResourceDNS, zone)
	var ret []*iaas.DNS
	for _, v := range values {
		if v, ok := v.(*iaas.DNS); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getDNSByID(zone string, id types.ID) *iaas.DNS {
	v := ds().Get(ResourceDNS, zone, id)
	if v, ok := v.(*iaas.DNS); ok {
		return v
	}
	return nil
}

func putDNS(zone string, value *iaas.DNS) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceDNS, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceDNS, zone, 0, value)
}

func getEnhancedDB(zone string) []*iaas.EnhancedDB {
	values := ds().List(ResourceEnhancedDB, zone)
	var ret []*iaas.EnhancedDB
	for _, v := range values {
		if v, ok := v.(*iaas.EnhancedDB); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getEnhancedDBByID(zone string, id types.ID) *iaas.EnhancedDB {
	v := ds().Get(ResourceEnhancedDB, zone, id)
	if v, ok := v.(*iaas.EnhancedDB); ok {
		return v
	}
	return nil
}

func putEnhancedDB(zone string, value *iaas.EnhancedDB) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceEnhancedDB, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceEnhancedDB, zone, 0, value)
}

func getESME(zone string) []*iaas.ESME {
	values := ds().List(ResourceESME, zone)
	var ret []*iaas.ESME
	for _, v := range values {
		if v, ok := v.(*iaas.ESME); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getESMEByID(zone string, id types.ID) *iaas.ESME {
	v := ds().Get(ResourceESME, zone, id)
	if v, ok := v.(*iaas.ESME); ok {
		return v
	}
	return nil
}

func putESME(zone string, value *iaas.ESME) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceESME, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceESME, zone, 0, value)
}

func getGSLB(zone string) []*iaas.GSLB {
	values := ds().List(ResourceGSLB, zone)
	var ret []*iaas.GSLB
	for _, v := range values {
		if v, ok := v.(*iaas.GSLB); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getGSLBByID(zone string, id types.ID) *iaas.GSLB {
	v := ds().Get(ResourceGSLB, zone, id)
	if v, ok := v.(*iaas.GSLB); ok {
		return v
	}
	return nil
}

func putGSLB(zone string, value *iaas.GSLB) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceGSLB, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceGSLB, zone, 0, value)
}

func getIcon(zone string) []*iaas.Icon {
	values := ds().List(ResourceIcon, zone)
	var ret []*iaas.Icon
	for _, v := range values {
		if v, ok := v.(*iaas.Icon); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getIconByID(zone string, id types.ID) *iaas.Icon {
	v := ds().Get(ResourceIcon, zone, id)
	if v, ok := v.(*iaas.Icon); ok {
		return v
	}
	return nil
}

func putIcon(zone string, value *iaas.Icon) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceIcon, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceIcon, zone, 0, value)
}

func getInterface(zone string) []*iaas.Interface {
	values := ds().List(ResourceInterface, zone)
	var ret []*iaas.Interface
	for _, v := range values {
		if v, ok := v.(*iaas.Interface); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getInterfaceByID(zone string, id types.ID) *iaas.Interface {
	v := ds().Get(ResourceInterface, zone, id)
	if v, ok := v.(*iaas.Interface); ok {
		return v
	}
	return nil
}

func putInterface(zone string, value *iaas.Interface) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceInterface, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceInterface, zone, 0, value)
}

func getInternet(zone string) []*iaas.Internet {
	values := ds().List(ResourceInternet, zone)
	var ret []*iaas.Internet
	for _, v := range values {
		if v, ok := v.(*iaas.Internet); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getInternetByID(zone string, id types.ID) *iaas.Internet {
	v := ds().Get(ResourceInternet, zone, id)
	if v, ok := v.(*iaas.Internet); ok {
		return v
	}
	return nil
}

func putInternet(zone string, value *iaas.Internet) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceInternet, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceInternet, zone, 0, value)
}

func getInternetPlan(zone string) []*iaas.InternetPlan {
	values := ds().List(ResourceInternetPlan, zone)
	var ret []*iaas.InternetPlan
	for _, v := range values {
		if v, ok := v.(*iaas.InternetPlan); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getInternetPlanByID(zone string, id types.ID) *iaas.InternetPlan {
	v := ds().Get(ResourceInternetPlan, zone, id)
	if v, ok := v.(*iaas.InternetPlan); ok {
		return v
	}
	return nil
}

func putInternetPlan(zone string, value *iaas.InternetPlan) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceInternetPlan, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceInternetPlan, zone, 0, value)
}

func getIPAddress(zone string) []*iaas.IPAddress {
	values := ds().List(ResourceIPAddress, zone)
	var ret []*iaas.IPAddress
	for _, v := range values {
		if v, ok := v.(*iaas.IPAddress); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getIPAddressByID(zone string, id types.ID) *iaas.IPAddress {
	v := ds().Get(ResourceIPAddress, zone, id)
	if v, ok := v.(*iaas.IPAddress); ok {
		return v
	}
	return nil
}

func putIPAddress(zone string, value *iaas.IPAddress) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceIPAddress, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceIPAddress, zone, 0, value)
}

func getIPv6Net(zone string) []*iaas.IPv6Net {
	values := ds().List(ResourceIPv6Net, zone)
	var ret []*iaas.IPv6Net
	for _, v := range values {
		if v, ok := v.(*iaas.IPv6Net); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getIPv6NetByID(zone string, id types.ID) *iaas.IPv6Net {
	v := ds().Get(ResourceIPv6Net, zone, id)
	if v, ok := v.(*iaas.IPv6Net); ok {
		return v
	}
	return nil
}

func putIPv6Net(zone string, value *iaas.IPv6Net) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceIPv6Net, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceIPv6Net, zone, 0, value)
}

func getIPv6Addr(zone string) []*iaas.IPv6Addr {
	values := ds().List(ResourceIPv6Addr, zone)
	var ret []*iaas.IPv6Addr
	for _, v := range values {
		if v, ok := v.(*iaas.IPv6Addr); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getIPv6AddrByID(zone string, id types.ID) *iaas.IPv6Addr {
	v := ds().Get(ResourceIPv6Addr, zone, id)
	if v, ok := v.(*iaas.IPv6Addr); ok {
		return v
	}
	return nil
}

func putIPv6Addr(zone string, value *iaas.IPv6Addr) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceIPv6Addr, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceIPv6Addr, zone, 0, value)
}

func getLicense(zone string) []*iaas.License {
	values := ds().List(ResourceLicense, zone)
	var ret []*iaas.License
	for _, v := range values {
		if v, ok := v.(*iaas.License); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getLicenseByID(zone string, id types.ID) *iaas.License {
	v := ds().Get(ResourceLicense, zone, id)
	if v, ok := v.(*iaas.License); ok {
		return v
	}
	return nil
}

func putLicense(zone string, value *iaas.License) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceLicense, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceLicense, zone, 0, value)
}

func getLicenseInfo(zone string) []*iaas.LicenseInfo {
	values := ds().List(ResourceLicenseInfo, zone)
	var ret []*iaas.LicenseInfo
	for _, v := range values {
		if v, ok := v.(*iaas.LicenseInfo); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getLicenseInfoByID(zone string, id types.ID) *iaas.LicenseInfo {
	v := ds().Get(ResourceLicenseInfo, zone, id)
	if v, ok := v.(*iaas.LicenseInfo); ok {
		return v
	}
	return nil
}

func putLicenseInfo(zone string, value *iaas.LicenseInfo) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceLicenseInfo, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceLicenseInfo, zone, 0, value)
}

func getLoadBalancer(zone string) []*iaas.LoadBalancer {
	values := ds().List(ResourceLoadBalancer, zone)
	var ret []*iaas.LoadBalancer
	for _, v := range values {
		if v, ok := v.(*iaas.LoadBalancer); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getLoadBalancerByID(zone string, id types.ID) *iaas.LoadBalancer {
	v := ds().Get(ResourceLoadBalancer, zone, id)
	if v, ok := v.(*iaas.LoadBalancer); ok {
		return v
	}
	return nil
}

func putLoadBalancer(zone string, value *iaas.LoadBalancer) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceLoadBalancer, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceLoadBalancer, zone, 0, value)
}

func getLocalRouter(zone string) []*iaas.LocalRouter {
	values := ds().List(ResourceLocalRouter, zone)
	var ret []*iaas.LocalRouter
	for _, v := range values {
		if v, ok := v.(*iaas.LocalRouter); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getLocalRouterByID(zone string, id types.ID) *iaas.LocalRouter {
	v := ds().Get(ResourceLocalRouter, zone, id)
	if v, ok := v.(*iaas.LocalRouter); ok {
		return v
	}
	return nil
}

func putLocalRouter(zone string, value *iaas.LocalRouter) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceLocalRouter, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceLocalRouter, zone, 0, value)
}

func getMobileGateway(zone string) []*iaas.MobileGateway {
	values := ds().List(ResourceMobileGateway, zone)
	var ret []*iaas.MobileGateway
	for _, v := range values {
		if v, ok := v.(*iaas.MobileGateway); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getMobileGatewayByID(zone string, id types.ID) *iaas.MobileGateway {
	v := ds().Get(ResourceMobileGateway, zone, id)
	if v, ok := v.(*iaas.MobileGateway); ok {
		return v
	}
	return nil
}

func putMobileGateway(zone string, value *iaas.MobileGateway) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceMobileGateway, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceMobileGateway, zone, 0, value)
}

func getNFS(zone string) []*iaas.NFS {
	values := ds().List(ResourceNFS, zone)
	var ret []*iaas.NFS
	for _, v := range values {
		if v, ok := v.(*iaas.NFS); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getNFSByID(zone string, id types.ID) *iaas.NFS {
	v := ds().Get(ResourceNFS, zone, id)
	if v, ok := v.(*iaas.NFS); ok {
		return v
	}
	return nil
}

func putNFS(zone string, value *iaas.NFS) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceNFS, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceNFS, zone, 0, value)
}

func getNote(zone string) []*iaas.Note {
	values := ds().List(ResourceNote, zone)
	var ret []*iaas.Note
	for _, v := range values {
		if v, ok := v.(*iaas.Note); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getNoteByID(zone string, id types.ID) *iaas.Note {
	v := ds().Get(ResourceNote, zone, id)
	if v, ok := v.(*iaas.Note); ok {
		return v
	}
	return nil
}

func putNote(zone string, value *iaas.Note) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceNote, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceNote, zone, 0, value)
}

func getPacketFilter(zone string) []*iaas.PacketFilter {
	values := ds().List(ResourcePacketFilter, zone)
	var ret []*iaas.PacketFilter
	for _, v := range values {
		if v, ok := v.(*iaas.PacketFilter); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getPacketFilterByID(zone string, id types.ID) *iaas.PacketFilter {
	v := ds().Get(ResourcePacketFilter, zone, id)
	if v, ok := v.(*iaas.PacketFilter); ok {
		return v
	}
	return nil
}

func putPacketFilter(zone string, value *iaas.PacketFilter) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourcePacketFilter, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourcePacketFilter, zone, 0, value)
}

func getPrivateHost(zone string) []*iaas.PrivateHost {
	values := ds().List(ResourcePrivateHost, zone)
	var ret []*iaas.PrivateHost
	for _, v := range values {
		if v, ok := v.(*iaas.PrivateHost); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getPrivateHostByID(zone string, id types.ID) *iaas.PrivateHost {
	v := ds().Get(ResourcePrivateHost, zone, id)
	if v, ok := v.(*iaas.PrivateHost); ok {
		return v
	}
	return nil
}

func putPrivateHost(zone string, value *iaas.PrivateHost) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourcePrivateHost, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourcePrivateHost, zone, 0, value)
}

func getPrivateHostPlan(zone string) []*iaas.PrivateHostPlan {
	values := ds().List(ResourcePrivateHostPlan, zone)
	var ret []*iaas.PrivateHostPlan
	for _, v := range values {
		if v, ok := v.(*iaas.PrivateHostPlan); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getPrivateHostPlanByID(zone string, id types.ID) *iaas.PrivateHostPlan {
	v := ds().Get(ResourcePrivateHostPlan, zone, id)
	if v, ok := v.(*iaas.PrivateHostPlan); ok {
		return v
	}
	return nil
}

func putPrivateHostPlan(zone string, value *iaas.PrivateHostPlan) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourcePrivateHostPlan, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourcePrivateHostPlan, zone, 0, value)
}

func getProxyLB(zone string) []*iaas.ProxyLB {
	values := ds().List(ResourceProxyLB, zone)
	var ret []*iaas.ProxyLB
	for _, v := range values {
		if v, ok := v.(*iaas.ProxyLB); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getProxyLBByID(zone string, id types.ID) *iaas.ProxyLB {
	v := ds().Get(ResourceProxyLB, zone, id)
	if v, ok := v.(*iaas.ProxyLB); ok {
		return v
	}
	return nil
}

func putProxyLB(zone string, value *iaas.ProxyLB) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceProxyLB, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceProxyLB, zone, 0, value)
}

func getRegion(zone string) []*iaas.Region {
	values := ds().List(ResourceRegion, zone)
	var ret []*iaas.Region
	for _, v := range values {
		if v, ok := v.(*iaas.Region); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getRegionByID(zone string, id types.ID) *iaas.Region {
	v := ds().Get(ResourceRegion, zone, id)
	if v, ok := v.(*iaas.Region); ok {
		return v
	}
	return nil
}

func putRegion(zone string, value *iaas.Region) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceRegion, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceRegion, zone, 0, value)
}

func getServer(zone string) []*iaas.Server {
	values := ds().List(ResourceServer, zone)
	var ret []*iaas.Server
	for _, v := range values {
		if v, ok := v.(*iaas.Server); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getServerByID(zone string, id types.ID) *iaas.Server {
	v := ds().Get(ResourceServer, zone, id)
	if v, ok := v.(*iaas.Server); ok {
		return v
	}
	return nil
}

func putServer(zone string, value *iaas.Server) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceServer, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceServer, zone, 0, value)
}

func getServerPlan(zone string) []*iaas.ServerPlan {
	values := ds().List(ResourceServerPlan, zone)
	var ret []*iaas.ServerPlan
	for _, v := range values {
		if v, ok := v.(*iaas.ServerPlan); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getServerPlanByID(zone string, id types.ID) *iaas.ServerPlan {
	v := ds().Get(ResourceServerPlan, zone, id)
	if v, ok := v.(*iaas.ServerPlan); ok {
		return v
	}
	return nil
}

func putServerPlan(zone string, value *iaas.ServerPlan) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceServerPlan, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceServerPlan, zone, 0, value)
}

func getServiceClass(zone string) []*iaas.ServiceClass {
	values := ds().List(ResourceServiceClass, zone)
	var ret []*iaas.ServiceClass
	for _, v := range values {
		if v, ok := v.(*iaas.ServiceClass); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getServiceClassByID(zone string, id types.ID) *iaas.ServiceClass {
	v := ds().Get(ResourceServiceClass, zone, id)
	if v, ok := v.(*iaas.ServiceClass); ok {
		return v
	}
	return nil
}

func putServiceClass(zone string, value *iaas.ServiceClass) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceServiceClass, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceServiceClass, zone, 0, value)
}

func getSIM(zone string) []*iaas.SIM {
	values := ds().List(ResourceSIM, zone)
	var ret []*iaas.SIM
	for _, v := range values {
		if v, ok := v.(*iaas.SIM); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSIMByID(zone string, id types.ID) *iaas.SIM {
	v := ds().Get(ResourceSIM, zone, id)
	if v, ok := v.(*iaas.SIM); ok {
		return v
	}
	return nil
}

func putSIM(zone string, value *iaas.SIM) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSIM, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSIM, zone, 0, value)
}

func getSimpleMonitor(zone string) []*iaas.SimpleMonitor {
	values := ds().List(ResourceSimpleMonitor, zone)
	var ret []*iaas.SimpleMonitor
	for _, v := range values {
		if v, ok := v.(*iaas.SimpleMonitor); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSimpleMonitorByID(zone string, id types.ID) *iaas.SimpleMonitor {
	v := ds().Get(ResourceSimpleMonitor, zone, id)
	if v, ok := v.(*iaas.SimpleMonitor); ok {
		return v
	}
	return nil
}

func putSimpleMonitor(zone string, value *iaas.SimpleMonitor) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSimpleMonitor, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSimpleMonitor, zone, 0, value)
}

func getSimpleNotificationDestination(zone string) []*iaas.SimpleNotificationDestination {
	values := ds().List(ResourceSimpleNotificationDestination, zone)
	var ret []*iaas.SimpleNotificationDestination
	for _, v := range values {
		if v, ok := v.(*iaas.SimpleNotificationDestination); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSimpleNotificationDestinationByID(zone string, id types.ID) *iaas.SimpleNotificationDestination {
	v := ds().Get(ResourceSimpleNotificationDestination, zone, id)
	if v, ok := v.(*iaas.SimpleNotificationDestination); ok {
		return v
	}
	return nil
}

func putSimpleNotificationDestination(zone string, value *iaas.SimpleNotificationDestination) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSimpleNotificationDestination, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSimpleNotificationDestination, zone, 0, value)
}

func getSimpleNotificationGroup(zone string) []*iaas.SimpleNotificationGroup {
	values := ds().List(ResourceSimpleNotificationGroup, zone)
	var ret []*iaas.SimpleNotificationGroup
	for _, v := range values {
		if v, ok := v.(*iaas.SimpleNotificationGroup); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSimpleNotificationGroupByID(zone string, id types.ID) *iaas.SimpleNotificationGroup {
	v := ds().Get(ResourceSimpleNotificationGroup, zone, id)
	if v, ok := v.(*iaas.SimpleNotificationGroup); ok {
		return v
	}
	return nil
}

func putSimpleNotificationGroup(zone string, value *iaas.SimpleNotificationGroup) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSimpleNotificationGroup, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSimpleNotificationGroup, zone, 0, value)
}

func getSSHKey(zone string) []*iaas.SSHKey {
	values := ds().List(ResourceSSHKey, zone)
	var ret []*iaas.SSHKey
	for _, v := range values {
		if v, ok := v.(*iaas.SSHKey); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSSHKeyByID(zone string, id types.ID) *iaas.SSHKey {
	v := ds().Get(ResourceSSHKey, zone, id)
	if v, ok := v.(*iaas.SSHKey); ok {
		return v
	}
	return nil
}

func putSSHKey(zone string, value *iaas.SSHKey) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSSHKey, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSSHKey, zone, 0, value)
}

func getSubnet(zone string) []*iaas.Subnet {
	values := ds().List(ResourceSubnet, zone)
	var ret []*iaas.Subnet
	for _, v := range values {
		if v, ok := v.(*iaas.Subnet); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSubnetByID(zone string, id types.ID) *iaas.Subnet {
	v := ds().Get(ResourceSubnet, zone, id)
	if v, ok := v.(*iaas.Subnet); ok {
		return v
	}
	return nil
}

func putSubnet(zone string, value *iaas.Subnet) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSubnet, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSubnet, zone, 0, value)
}

func getSwitch(zone string) []*iaas.Switch {
	values := ds().List(ResourceSwitch, zone)
	var ret []*iaas.Switch
	for _, v := range values {
		if v, ok := v.(*iaas.Switch); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getSwitchByID(zone string, id types.ID) *iaas.Switch {
	v := ds().Get(ResourceSwitch, zone, id)
	if v, ok := v.(*iaas.Switch); ok {
		return v
	}
	return nil
}

func putSwitch(zone string, value *iaas.Switch) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceSwitch, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceSwitch, zone, 0, value)
}

func getVPCRouter(zone string) []*iaas.VPCRouter {
	values := ds().List(ResourceVPCRouter, zone)
	var ret []*iaas.VPCRouter
	for _, v := range values {
		if v, ok := v.(*iaas.VPCRouter); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getVPCRouterByID(zone string, id types.ID) *iaas.VPCRouter {
	v := ds().Get(ResourceVPCRouter, zone, id)
	if v, ok := v.(*iaas.VPCRouter); ok {
		return v
	}
	return nil
}

func putVPCRouter(zone string, value *iaas.VPCRouter) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceVPCRouter, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceVPCRouter, zone, 0, value)
}

func getZone(zone string) []*iaas.Zone {
	values := ds().List(ResourceZone, zone)
	var ret []*iaas.Zone
	for _, v := range values {
		if v, ok := v.(*iaas.Zone); ok {
			ret = append(ret, v)
		}
	}
	return ret
}

func getZoneByID(zone string, id types.ID) *iaas.Zone {
	v := ds().Get(ResourceZone, zone, id)
	if v, ok := v.(*iaas.Zone); ok {
		return v
	}
	return nil
}

func putZone(zone string, value *iaas.Zone) {
	var v interface{} = value
	if id, ok := v.(accessor.ID); ok {
		ds().Put(ResourceZone, zone, id.GetID(), value)
		return
	}
	ds().Put(ResourceZone, zone, 0, value)
}
