/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.analyze;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.testkit.analyze.ContendedRegisterAnalyzeAction;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

class UncontendedRegisterAnalyzeAction
extends HandledTransportAction<Request, ActionResponse.Empty> {
    private static final Logger logger = LogManager.getLogger(UncontendedRegisterAnalyzeAction.class);
    static final String NAME = "cluster:admin/repository/analyze/register/uncontended";
    private final RepositoriesService repositoriesService;

    UncontendedRegisterAnalyzeAction(TransportService transportService, ActionFilters actionFilters, RepositoriesService repositoriesService) {
        super(NAME, transportService, actionFilters, Request::new, (Executor)transportService.getThreadPool().executor("snapshot"));
        this.repositoriesService = repositoriesService;
    }

    protected void doExecute(Task task, Request request, ActionListener<ActionResponse.Empty> listener) {
        logger.trace("handling [{}]", (Object)request);
        UncontendedRegisterAnalyzeAction.updateRegister(request, ContendedRegisterAnalyzeAction.bytesFromLong(request.getExpectedValue() + 1L), this.repositoriesService.repository(request.getRepositoryName()), (ActionListener<Void>)ActionListener.assertOnce((ActionListener)listener.map(ignored -> ActionResponse.Empty.INSTANCE)));
    }

    static void verifyFinalValue(Request request, Repository repository, ActionListener<Void> listener) {
        logger.trace("handling final value [{}]", (Object)request);
        UncontendedRegisterAnalyzeAction.updateRegister(request, (BytesReference)BytesArray.EMPTY, repository, (ActionListener<Void>)ActionListener.assertOnce(listener));
    }

    private static void updateRegister(final Request request, BytesReference newValue, final Repository repository, final ActionListener<Void> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"snapshot"}));
        if (!(repository instanceof BlobStoreRepository)) {
            throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is not a blob-store repository");
        }
        if (repository.isReadOnly()) {
            throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is read-only");
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        BlobPath path = blobStoreRepository.basePath().add(request.getContainerPath());
        BlobContainer blobContainer = blobStoreRepository.blobStore().blobContainer(path);
        blobContainer.compareAndExchangeRegister(OperationPurpose.REPOSITORY_ANALYSIS, request.getRegisterName(), ContendedRegisterAnalyzeAction.bytesFromLong(request.getExpectedValue()), newValue, (ActionListener)new ActionListener<OptionalBytesReference>(){

            public void onResponse(OptionalBytesReference optionalBytesReference) {
                ActionListener.completeWith((ActionListener)listener, () -> {
                    if (!optionalBytesReference.isPresent()) {
                        throw new RepositoryVerificationException(repository.getMetadata().name(), Strings.format((String)"uncontended register operation failed: expected [%d] but did not observe any value", (Object[])new Object[]{request.getExpectedValue()}));
                    }
                    long witness = ContendedRegisterAnalyzeAction.longFromBytes(optionalBytesReference.bytesReference());
                    if (witness != request.getExpectedValue()) {
                        throw new RepositoryVerificationException(repository.getMetadata().name(), Strings.format((String)"uncontended register operation failed: expected [%d] but observed [%d]", (Object[])new Object[]{request.getExpectedValue(), witness}));
                    }
                    return null;
                });
            }

            public void onFailure(Exception e) {
                if (e instanceof UnsupportedOperationException) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    static class Request
    extends ActionRequest {
        private final String repositoryName;
        private final String containerPath;
        private final String registerName;
        private final long expectedValue;

        Request(String repositoryName, String containerPath, String registerName, long expectedValue) {
            this.repositoryName = repositoryName;
            this.containerPath = containerPath;
            this.registerName = registerName;
            this.expectedValue = expectedValue;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            assert (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0));
            this.repositoryName = in.readString();
            this.containerPath = in.readString();
            this.registerName = in.readString();
            this.expectedValue = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0));
            super.writeTo(out);
            out.writeString(this.repositoryName);
            out.writeString(this.containerPath);
            out.writeString(this.registerName);
            out.writeVLong(this.expectedValue);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        String getRepositoryName() {
            return this.repositoryName;
        }

        String getContainerPath() {
            return this.containerPath;
        }

        String getRegisterName() {
            return this.registerName;
        }

        long getExpectedValue() {
            return this.expectedValue;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            return Strings.format((String)"UncontendedRegisterAnalyzeAction.Request{repositoryName='%s', containerPath='%s', registerName='%s', expectedValue='%d'}", (Object[])new Object[]{this.repositoryName, this.containerPath, this.registerName, this.expectedValue});
        }
    }
}

