/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.downsample.DownsampleIndexerAction;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.downsample.DownsampleMetrics;
import org.elasticsearch.xpack.downsample.DownsampleShardPersistentTaskExecutor;
import org.elasticsearch.xpack.downsample.DownsampleShardTaskParams;
import org.elasticsearch.xpack.downsample.RestDownsampleAction;
import org.elasticsearch.xpack.downsample.TransportDownsampleAction;
import org.elasticsearch.xpack.downsample.TransportDownsampleIndexerAction;

public class Downsample
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin {
    public static final String DOWNSAMPLE_TASK_THREAD_POOL_NAME = "downsample_indexing";
    private static final int DOWNSAMPLE_TASK_THREAD_POOL_QUEUE_SIZE = 256;
    public static final String DOWNSAMPLE_MIN_NUMBER_OF_REPLICAS_NAME = "downsample.min_number_of_replicas";

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        FixedExecutorBuilder downsample = new FixedExecutorBuilder(settings, DOWNSAMPLE_TASK_THREAD_POOL_NAME, ThreadPool.oneEighthAllocatedProcessors((int)EsExecutors.allocatedProcessors((Settings)settings)), 256, "xpack.downsample.thread_pool", EsExecutors.TaskTrackingConfig.DO_NOT_TRACK);
        return List.of(downsample);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)DownsampleIndexerAction.INSTANCE, TransportDownsampleIndexerAction.class), new ActionPlugin.ActionHandler((ActionType)DownsampleAction.INSTANCE, TransportDownsampleAction.class), new ActionPlugin.ActionHandler((ActionType)DownsampleShardPersistentTaskExecutor.DelegatingAction.INSTANCE, DownsampleShardPersistentTaskExecutor.DelegatingAction.TA.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestDownsampleAction());
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        return List.of(new DownsampleShardPersistentTaskExecutor(client, "rollup-shard", threadPool.executor(DOWNSAMPLE_TASK_THREAD_POOL_NAME)));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("rollup-shard", new String[0]), DownsampleShardPersistentTaskState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("rollup-shard", new String[0]), DownsampleShardTaskParams::fromXContent));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "rollup-shard", DownsampleShardPersistentTaskState::readFromStream), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "rollup-shard", DownsampleShardTaskParams::new));
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        return List.of(DownsampleMetrics.class);
    }
}

