/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.util.HashMap;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.CorePropertiesHandler;

class ExtendedPropertiesHandler
extends CorePropertiesHandler {
    static final String EP_NS = "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties";

    public ExtendedPropertiesHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    void addProperties() {
        HashMap<String, Property> ep = (HashMap<String, Property>)this.properties.get(EP_NS);
        if (ep == null) {
            ep = new HashMap<String, Property>();
        }
        ep.put("AppVersion", OfficeOpenXMLExtended.APP_VERSION);
        ep.put("Application", OfficeOpenXMLExtended.APPLICATION);
        ep.put("Comments", OfficeOpenXMLExtended.COMMENTS);
        ep.put("Company", OfficeOpenXMLExtended.COMPANY);
        ep.put("DocSecurity", OfficeOpenXMLExtended.DOC_SECURITY);
        ep.put("HiddenSlides", OfficeOpenXMLExtended.HIDDEN_SLIDES);
        ep.put("Manager", OfficeOpenXMLExtended.MANAGER);
        ep.put("Notes", OfficeOpenXMLExtended.NOTES);
        ep.put("PresentationFormat", OfficeOpenXMLExtended.PRESENTATION_FORMAT);
        ep.put("Template", OfficeOpenXMLExtended.TEMPLATE);
        ep.put("TotalTime", OfficeOpenXMLExtended.TOTAL_TIME);
        ep.put("Pages", Office.PAGE_COUNT);
        ep.put("Words", Office.WORD_COUNT);
        ep.put("Characters", Office.CHARACTER_COUNT);
        ep.put("CharactersWithSpaces", Office.CHARACTER_COUNT_WITH_SPACES);
        ep.put("Paragraphs", Office.PARAGRAPH_COUNT);
        ep.put("Lines", Office.LINE_COUNT);
        this.properties.put(EP_NS, ep);
    }

    @Override
    public String getContentType() {
        return "application/vnd.openxmlformats-officedocument.extended-properties+xml";
    }
}

