/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.security.action.user.SetEnabledRequestBuilder;
import org.elasticsearch.xpack.security.rest.action.user.NativeUserBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestSetEnabledAction
extends NativeUserBaseRestHandler {
    public RestSetEnabledAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/{username}/_enable").replaces(RestRequest.Method.POST, "/_xpack/security/user/{username}/_enable", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/user/{username}/_enable").replaces(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_enable", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/{username}/_disable").replaces(RestRequest.Method.POST, "/_xpack/security/user/{username}/_disable", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/user/{username}/_disable").replaces(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_disable", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_set_enabled_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean enabled = request.path().endsWith("_enable");
        assert (enabled || request.path().endsWith("_disable"));
        String username = request.param("username");
        return channel -> new SetEnabledRequestBuilder((ElasticsearchClient)client).username(username).enabled(enabled).execute((ActionListener)new RestBuilderListener<ActionResponse.Empty>(channel){

            public RestResponse buildResponse(ActionResponse.Empty setEnabledResponse, XContentBuilder builder) throws Exception {
                return new RestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }
}

