/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Locale;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.xpack.core.XPackSettings;

final class TokenSSLBootstrapCheck
implements BootstrapCheck {
    TokenSSLBootstrapCheck() {
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        Boolean httpsEnabled = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(context.settings());
        Boolean tokenServiceEnabled = (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(context.settings());
        if (!httpsEnabled.booleanValue() && tokenServiceEnabled.booleanValue()) {
            String message = String.format(Locale.ROOT, "HTTPS is required in order to use the token service; please enable HTTPS using the [%s] setting or disable the token service using the [%s] setting", XPackSettings.HTTP_SSL_ENABLED.getKey(), XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey());
            return BootstrapCheck.BootstrapCheckResult.failure((String)message);
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public ReferenceDocs referenceDocs() {
        return ReferenceDocs.BOOTSTRAP_CHECK_TOKEN_SSL;
    }
}

