/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.compute.EsqlRefCountingListener;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.exchange.ExchangeBuffer;
import org.elasticsearch.compute.operator.exchange.ExchangeResponse;
import org.elasticsearch.compute.operator.exchange.ExchangeSource;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.tasks.TaskCancelledException;

public final class ExchangeSourceHandler {
    private final ExchangeBuffer buffer;
    private final Executor fetchExecutor;
    private final PendingInstances outstandingSinks;
    private final PendingInstances outstandingSources;
    private volatile boolean aborted = false;
    private final AtomicInteger nextSinkId = new AtomicInteger();
    private final Map<Integer, RemoteSink> remoteSinks = ConcurrentCollections.newConcurrentMap();

    public ExchangeSourceHandler(int maxBufferSize, Executor fetchExecutor) {
        this.buffer = new ExchangeBuffer(maxBufferSize);
        this.fetchExecutor = fetchExecutor;
        this.outstandingSinks = new PendingInstances(() -> this.buffer.finish(false));
        this.outstandingSources = new PendingInstances(() -> this.finishEarly(true, (ActionListener<Void>)ActionListener.noop()));
    }

    private void checkFailure() {
        if (this.aborted) {
            throw new TaskCancelledException("remote sinks failed");
        }
    }

    public ExchangeSource createExchangeSource() {
        return new ExchangeSourceImpl();
    }

    public void addRemoteSink(final RemoteSink remoteSink, final boolean failFast, final Runnable onPageFetched, final int instances, ActionListener<Void> listener) {
        int sinkId = this.nextSinkId.incrementAndGet();
        this.remoteSinks.put(sinkId, remoteSink);
        final ActionListener sinkListener = ActionListener.assertAtLeastOnce((ActionListener)ActionListener.notifyOnce((ActionListener)ActionListener.runBefore(listener, () -> this.remoteSinks.remove(sinkId))));
        final Releasable emptySink = this.addEmptySink();
        this.fetchExecutor.execute((Runnable)new AbstractRunnable(){

            public void onAfter() {
                emptySink.close();
            }

            public void onFailure(Exception e) {
                if (failFast) {
                    ExchangeSourceHandler.this.aborted = true;
                }
                ExchangeSourceHandler.this.buffer.waitForReading().listener().onResponse(null);
                remoteSink.close((ActionListener<Void>)ActionListener.running(() -> sinkListener.onFailure(e)));
            }

            protected void doRun() {
                try (EsqlRefCountingListener refs = new EsqlRefCountingListener((ActionListener<Void>)sinkListener);){
                    for (int i = 0; i < instances; ++i) {
                        RemoteSinkFetcher fetcher = new RemoteSinkFetcher(remoteSink, failFast, onPageFetched, refs.acquire());
                        fetcher.fetchPage();
                    }
                }
            }
        });
    }

    public Releasable addEmptySink() {
        this.outstandingSinks.trackNewInstance();
        return this.outstandingSinks::finishInstance;
    }

    public void finishEarly(boolean drainingPages, ActionListener<Void> listener) {
        this.buffer.finish(drainingPages);
        try (EsqlRefCountingListener refs = new EsqlRefCountingListener(listener);){
            for (RemoteSink remoteSink : this.remoteSinks.values()) {
                remoteSink.close(refs.acquire());
            }
        }
    }

    private static class PendingInstances {
        private final AtomicInteger instances = new AtomicInteger();
        private final SubscribableListener<Void> completion = new SubscribableListener();

        PendingInstances(Runnable onComplete) {
            this.completion.addListener(ActionListener.running((Runnable)onComplete));
        }

        void trackNewInstance() {
            int refs = this.instances.incrementAndGet();
            assert (refs > 0);
        }

        void finishInstance() {
            int refs = this.instances.decrementAndGet();
            assert (refs >= 0);
            if (refs == 0) {
                this.completion.onResponse(null);
            }
        }
    }

    private class ExchangeSourceImpl
    implements ExchangeSource {
        private boolean finished;

        ExchangeSourceImpl() {
            ExchangeSourceHandler.this.outstandingSources.trackNewInstance();
        }

        @Override
        public Page pollPage() {
            ExchangeSourceHandler.this.checkFailure();
            return ExchangeSourceHandler.this.buffer.pollPage();
        }

        @Override
        public boolean isFinished() {
            ExchangeSourceHandler.this.checkFailure();
            return this.finished || ExchangeSourceHandler.this.buffer.isFinished();
        }

        @Override
        public IsBlockedResult waitForReading() {
            return ExchangeSourceHandler.this.buffer.waitForReading();
        }

        @Override
        public void finish() {
            if (!this.finished) {
                this.finished = true;
                ExchangeSourceHandler.this.outstandingSources.finishInstance();
            }
        }

        @Override
        public int bufferSize() {
            return ExchangeSourceHandler.this.buffer.size();
        }
    }

    private final class RemoteSinkFetcher {
        private volatile boolean finished = false;
        private final RemoteSink remoteSink;
        private final boolean failFast;
        private final Runnable onPageFetched;
        private final ActionListener<Void> completionListener;

        RemoteSinkFetcher(RemoteSink remoteSink, boolean failFast, Runnable onPageFetched, ActionListener<Void> completionListener) {
            ExchangeSourceHandler.this.outstandingSinks.trackNewInstance();
            this.remoteSink = remoteSink;
            this.onPageFetched = onPageFetched;
            this.failFast = failFast;
            this.completionListener = completionListener;
        }

        void fetchPage() {
            LoopControl loopControl = new LoopControl();
            while (loopControl.isRunning()) {
                loopControl.exiting();
                boolean toFinishSinks = ExchangeSourceHandler.this.buffer.noMoreInputs() || ExchangeSourceHandler.this.aborted;
                this.remoteSink.fetchPageAsync(toFinishSinks, (ActionListener<ExchangeResponse>)ActionListener.wrap(resp -> {
                    Page page = resp.takePage();
                    if (page != null) {
                        this.onPageFetched.run();
                        ExchangeSourceHandler.this.buffer.addPage(page);
                    }
                    if (resp.finished()) {
                        this.onSinkComplete();
                    } else {
                        IsBlockedResult future = ExchangeSourceHandler.this.buffer.waitForWriting();
                        if (future.listener().isDone()) {
                            if (!loopControl.tryResume()) {
                                this.fetchPage();
                            }
                        } else {
                            future.listener().addListener(ActionListener.wrap(unused -> {
                                if (!loopControl.tryResume()) {
                                    this.fetchPage();
                                }
                            }, this::onSinkFailed));
                        }
                    }
                }, this::onSinkFailed));
            }
            loopControl.exited();
        }

        void onSinkFailed(Exception e) {
            if (this.failFast) {
                ExchangeSourceHandler.this.aborted = true;
            }
            ExchangeSourceHandler.this.buffer.waitForReading().listener().onResponse(null);
            if (!this.finished) {
                this.finished = true;
                this.remoteSink.close((ActionListener<Void>)ActionListener.running(() -> {
                    ExchangeSourceHandler.this.outstandingSinks.finishInstance();
                    this.completionListener.onFailure(e);
                }));
            }
        }

        void onSinkComplete() {
            if (!this.finished) {
                this.finished = true;
                ExchangeSourceHandler.this.outstandingSinks.finishInstance();
                this.completionListener.onResponse(null);
            }
        }
    }

    private static class LoopControl {
        private final Thread startedThread;
        private Status status = Status.RUNNING;

        LoopControl() {
            this.startedThread = Thread.currentThread();
        }

        boolean isRunning() {
            return this.status == Status.RUNNING;
        }

        boolean tryResume() {
            if (this.startedThread == Thread.currentThread() && this.status != Status.EXITED) {
                this.status = Status.RUNNING;
                return true;
            }
            return false;
        }

        void exiting() {
            this.status = Status.EXITING;
        }

        void exited() {
            this.status = Status.EXITED;
        }

        static enum Status {
            RUNNING,
            EXITING,
            EXITED;

        }
    }
}

