/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

public final class WelfordAlgorithm {
    private double mean;
    private double m2;
    private long count;

    public double mean() {
        return this.mean;
    }

    public double m2() {
        return this.m2;
    }

    public long count() {
        return this.count;
    }

    public WelfordAlgorithm() {
        this(0.0, 0.0, 0L);
    }

    public WelfordAlgorithm(double mean, double m2, long count) {
        this.mean = mean;
        this.m2 = m2;
        this.count = count;
    }

    public void add(int value) {
        this.add((double)value);
    }

    public void add(long value) {
        this.add((double)value);
    }

    public void add(double value) {
        double delta = value - this.mean;
        ++this.count;
        this.mean += delta / (double)this.count;
        this.m2 += delta * (value - this.mean);
    }

    public void add(double meanValue, double m2Value, long countValue) {
        if (countValue == 0L) {
            return;
        }
        if (this.count == 0L) {
            this.mean = meanValue;
            this.m2 = m2Value;
            this.count = countValue;
            return;
        }
        double delta = this.mean - meanValue;
        this.m2 += m2Value + delta * delta * (double)this.count * (double)countValue / (double)(this.count + countValue);
        this.mean = (this.mean * (double)this.count + meanValue * (double)countValue) / (double)(this.count + countValue);
        this.count += countValue;
    }

    public double evaluate() {
        return this.count < 2L ? 0.0 : Math.sqrt(this.m2 / (double)this.count);
    }
}

