/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class TimeProcessor
extends DateTimeProcessor {
    public static final String NAME = "time";

    public TimeProcessor(DateTimeProcessor.DateTimeExtractor extractor, ZoneId zoneId) {
        super(extractor, zoneId);
    }

    public TimeProcessor(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        if (input instanceof OffsetTime) {
            return this.doProcess(DateUtils.asTimeAtZone((OffsetTime)input, this.zoneId()));
        }
        return super.process(input);
    }

    private Object doProcess(OffsetTime time) {
        return this.extractor().extract(time);
    }

    public static Integer doProcess(OffsetTime dateTime, String tzId, String extractorName) {
        return DateTimeProcessor.doProcess(DateUtils.asTimeAtZone(dateTime, ZoneId.of(tzId)), extractorName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.extractor(), this.zoneId()});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TimeProcessor other = (TimeProcessor)obj;
        return Objects.equals((Object)this.extractor(), (Object)other.extractor()) && Objects.equals(this.zoneId(), other.zoneId());
    }
}

