/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene86;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene60.MetadataOnlyBKDReader;

public final class Lucene86MetadataOnlyPointsReader
extends PointsReader {
    final SegmentReadState readState;
    final Map<Integer, PointValues> readers = new HashMap<Integer, PointValues>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene86MetadataOnlyPointsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"kdm");
        boolean success = false;
        try {
            block17: {
                try (ChecksumIndexInput metaIn = EndiannessReverserUtil.openChecksumInput((Directory)readState.directory, (String)metaFileName, (IOContext)readState.context);){
                    Throwable priorE = null;
                    try {
                        int fieldNumber;
                        CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"Lucene86PointsFormatMeta", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
                        while ((fieldNumber = metaIn.readInt()) != -1) {
                            if (fieldNumber < 0) {
                                throw new CorruptIndexException("Illegal field number: " + fieldNumber, (DataInput)metaIn);
                            }
                            MetadataOnlyBKDReader reader = new MetadataOnlyBKDReader((IndexInput)metaIn, true);
                            this.readers.put(fieldNumber, reader);
                        }
                        metaIn.readLong();
                        metaIn.readLong();
                    }
                    catch (Throwable t) {
                        try {
                            priorE = t;
                            break block17;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                        }
                    }
                    CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    public void checkIntegrity() {
    }

    public void close() throws IOException {
        this.readers.clear();
    }
}

