/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.multiterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BucketAndOrd;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.multiterms.InternalMultiTerms;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregationBuilder;

class MultiTermsAggregator
extends DeferableBucketAggregator {
    protected final List<DocValueFormat> formats;
    protected final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    protected final BucketOrder order;
    protected final Comparator<BucketAndOrd<InternalMultiTerms.Bucket>> partiallyBuiltBucketComparator;
    protected final Set<Aggregator> aggsUsedForSorting;
    protected final Aggregator.SubAggCollectionMode collectMode;
    private final List<TermValuesSource> values;
    private final boolean showTermDocCountError;
    private final boolean needsScore;
    private final List<InternalMultiTerms.KeyConverter> keyConverters;
    private final BytesKeyedBucketOrds bucketOrds;

    protected MultiTermsAggregator(String name, AggregatorFactories factories, AggregationContext context, Aggregator parent, List<ValuesSourceConfig> configs, List<DocValueFormat> formats, boolean showTermDocCountError, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.bucketCountThresholds = bucketCountThresholds;
        this.order = order;
        this.partiallyBuiltBucketComparator = order == null ? null : order.partiallyBuiltBucketComparator((Aggregator)this);
        this.formats = formats;
        this.showTermDocCountError = showTermDocCountError;
        this.collectMode = this.subAggsNeedScore() && TermsAggregator.descendsFromNestedAggregator((Aggregator)parent) || context.isInSortOrderExecutionRequired() ? Aggregator.SubAggCollectionMode.DEPTH_FIRST : collectMode;
        this.aggsUsedForSorting = TermsAggregator.aggsUsedForSorting((Aggregator)this, (BucketOrder)order);
        this.needsScore = configs.stream().anyMatch(c -> c.getValuesSource().needsScores());
        this.values = configs.stream().map(c -> ((MultiTermsAggregationBuilder.MultiTermValuesSupplier)context.getValuesSourceRegistry().getAggregator(MultiTermsAggregationBuilder.REGISTRY_KEY, c)).build((ValuesSourceConfig)c)).collect(Collectors.toList());
        this.keyConverters = this.values.stream().map(TermValuesSource::keyConverter).collect(Collectors.toList());
        this.bucketOrds = BytesKeyedBucketOrds.build((BigArrays)context.bigArrays(), (CardinalityUpperBound)cardinality);
    }

    private boolean subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return true;
        }
        return false;
    }

    public ScoreMode scoreMode() {
        if (this.needsScore) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return this.collectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST && !this.aggsUsedForSorting.contains(aggregator);
    }

    List<TermValues> termValuesList(LeafReaderContext ctx) throws IOException {
        ArrayList<TermValues> termValuesList = new ArrayList<TermValues>();
        for (TermValuesSource termValuesSource : this.values) {
            termValuesList.add(termValuesSource.getValues(ctx));
        }
        return termValuesList;
    }

    static List<List<Object>> docTerms(List<TermValues> termValuesList, int doc) throws IOException {
        ArrayList<List<Object>> terms = new ArrayList<List<Object>>();
        for (TermValues termValues : termValuesList) {
            List<Object> collectValues = termValues.collectValues(doc);
            if (collectValues == null) {
                return null;
            }
            terms.add(collectValues);
        }
        return terms;
    }

    static BytesRef packKey(List<Object> terms) {
        BytesRef bytesRef;
        BytesStreamOutput output = new BytesStreamOutput();
        try {
            output.writeCollection(terms, StreamOutput::writeGenericValue);
            bytesRef = output.bytes().toBytesRef();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw ExceptionsHelper.convertToRuntime((Exception)ex);
            }
        }
        output.close();
        return bytesRef;
    }

    static List<Object> unpackTerms(BytesRef termsBytes) {
        List list;
        block8: {
            StreamInput input = new BytesArray(termsBytes).streamInput();
            try {
                list = input.readCollectionAsList(StreamInput::readGenericValue);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToRuntime((Exception)ex);
                }
            }
            input.close();
        }
        return list;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final List<TermValues> termValuesList = this.termValuesList(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, this.values){

            public void collect(final int doc, final long owningBucketOrd) throws IOException {
                final List<List<Object>> terms = MultiTermsAggregator.docTerms(termValuesList, doc);
                if (terms != null) {
                    final ArrayList path = new ArrayList(terms.size());
                    new CheckedConsumer<Integer, IOException>(){

                        public void accept(Integer start) throws IOException {
                            for (Object term : (List)terms.get(start)) {
                                if (start.intValue() == path.size()) {
                                    path.add(term);
                                } else {
                                    path.set(start, term);
                                }
                                if (start < terms.size() - 1) {
                                    this.accept(start + 1);
                                    continue;
                                }
                                long bucketOrd = MultiTermsAggregator.this.bucketOrds.add(owningBucketOrd, MultiTermsAggregator.packKey(path));
                                if (bucketOrd < 0L) {
                                    bucketOrd = -1L - bucketOrd;
                                    MultiTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                    continue;
                                }
                                MultiTermsAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                    }.accept(0);
                }
            }
        };
    }

    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        try (LongArray otherDocCounts = this.bigArrays().newLongArray(owningBucketOrds.size(), true);){
            InternalAggregation[] internalAggregationArray;
            block35: {
                ObjectArray topBucketsPerOrd = this.bigArrays().newObjectArray(owningBucketOrds.size());
                try {
                    try (IntArray bucketsToCollect = this.bigArrays().newIntArray(owningBucketOrds.size());){
                        long ordsToCollect = 0L;
                        for (long ordIdx2 = 0L; ordIdx2 < owningBucketOrds.size(); ++ordIdx2) {
                            int size = (int)Math.min(this.bucketOrds.bucketsInOrd(owningBucketOrds.get(ordIdx2)), (long)this.bucketCountThresholds.getShardSize());
                            ordsToCollect += (long)size;
                            bucketsToCollect.set(ordIdx2, size);
                        }
                        try (LongArray ordsArray = this.bigArrays().newLongArray(ordsToCollect);){
                            long ordsCollected = 0L;
                            for (long ordIdx3 = 0L; ordIdx3 < owningBucketOrds.size(); ++ordIdx3) {
                                long owningBucketOrd = owningBucketOrds.get(ordIdx3);
                                long bucketsInOrd = this.bucketOrds.bucketsInOrd(owningBucketOrd);
                                int size = (int)Math.min(bucketsInOrd, (long)this.bucketCountThresholds.getShardSize());
                                try (BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.bigArrays(), this.partiallyBuiltBucketComparator);){
                                    BucketAndOrd spare = null;
                                    BytesRef spareKey = null;
                                    BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrd);
                                    while (ordsEnum.next()) {
                                        long docCount = this.bucketDocCount(ordsEnum.ord());
                                        otherDocCounts.increment(ordIdx3, docCount);
                                        if (docCount < this.bucketCountThresholds.getShardMinDocCount()) continue;
                                        if (spare == null) {
                                            this.checkRealMemoryCBForInternalBucket();
                                            spare = new BucketAndOrd((Object)new InternalMultiTerms.Bucket(null, 0L, null, this.showTermDocCountError, 0L, this.formats, this.keyConverters));
                                            spareKey = new BytesRef();
                                        }
                                        ordsEnum.readValue(spareKey);
                                        ((InternalMultiTerms.Bucket)((Object)spare.bucket)).terms = MultiTermsAggregator.unpackTerms(spareKey);
                                        ((InternalMultiTerms.Bucket)((Object)spare.bucket)).docCount = docCount;
                                        spare.ord = ordsEnum.ord();
                                        spare = (BucketAndOrd)ordered.insertWithOverflow((Object)spare);
                                    }
                                    int orderedSize = (int)ordered.size();
                                    InternalMultiTerms.Bucket[] buckets = new InternalMultiTerms.Bucket[orderedSize];
                                    for (int i = orderedSize - 1; i >= 0; --i) {
                                        BucketAndOrd bucketAndOrd = (BucketAndOrd)ordered.pop();
                                        buckets[i] = (InternalMultiTerms.Bucket)((Object)bucketAndOrd.bucket);
                                        ordsArray.set(ordsCollected + (long)i, bucketAndOrd.ord);
                                        otherDocCounts.increment(ordIdx3, -buckets[i].getDocCount());
                                    }
                                    topBucketsPerOrd.set(ordIdx3, (Object)buckets);
                                    ordsCollected += (long)orderedSize;
                                    continue;
                                }
                            }
                            this.buildSubAggsForAllBuckets(topBucketsPerOrd, ordsArray, (b, a) -> {
                                b.aggregations = a;
                            });
                        }
                    }
                    internalAggregationArray = this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> this.buildResult(otherDocCounts.get((long)ordIdx), (InternalMultiTerms.Bucket[])topBucketsPerOrd.get((long)ordIdx)));
                    if (topBucketsPerOrd == null) break block35;
                }
                catch (Throwable throwable) {
                    if (topBucketsPerOrd != null) {
                        try {
                            topBucketsPerOrd.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                topBucketsPerOrd.close();
            }
            return internalAggregationArray;
        }
    }

    InternalMultiTerms buildResult(long otherDocCount, InternalMultiTerms.Bucket[] topBuckets) {
        BucketOrder reduceOrder;
        if (!InternalOrder.isKeyOrder((BucketOrder)this.order)) {
            reduceOrder = InternalOrder.key((boolean)true);
            Arrays.sort(topBuckets, reduceOrder.comparator());
        } else {
            reduceOrder = this.order;
        }
        return new InternalMultiTerms(this.name, reduceOrder, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), 0L, this.formats, this.keyConverters, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMultiTerms(this.name, this.order, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, this.formats, this.keyConverters, this.metadata());
    }

    static TermValuesSource buildNumericTermValues(ValuesSourceConfig config) {
        ValuesSource.Numeric vs = (ValuesSource.Numeric)config.getValuesSource();
        if (vs.isFloatingPoint()) {
            return new DoubleTermValuesSource(config);
        }
        return new LongTermValuesSource(config);
    }

    static interface TermValuesSource {
        public TermValues getValues(LeafReaderContext var1) throws IOException;

        public InternalMultiTerms.KeyConverter keyConverter();
    }

    static interface TermValues {
        public List<Object> collectValues(int var1) throws IOException;
    }

    static class DoubleTermValuesSource
    implements TermValuesSource {
        final ValuesSource.Numeric source;

        DoubleTermValuesSource(ValuesSourceConfig config) {
            this.source = (ValuesSource.Numeric)config.getValuesSource();
        }

        @Override
        public TermValues getValues(LeafReaderContext ctx) throws IOException {
            SortedNumericDoubleValues values = this.source.doubleValues(ctx);
            NumericDoubleValues singleton = FieldData.unwrapSingleton((SortedNumericDoubleValues)values);
            return singleton != null ? this.getValues(singleton) : this.getValues(values);
        }

        public TermValues getValues(SortedNumericDoubleValues values) {
            return doc -> {
                if (values.advanceExact(doc)) {
                    ArrayList<Double> objects = new ArrayList<Double>();
                    int valuesCount = values.docValueCount();
                    double previous = Double.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        double val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        objects.add(val);
                        previous = val;
                    }
                    return objects;
                }
                return null;
            };
        }

        public TermValues getValues(NumericDoubleValues values) {
            return doc -> {
                if (values.advanceExact(doc)) {
                    return List.of(Double.valueOf(values.doubleValue()));
                }
                return null;
            };
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return InternalMultiTerms.KeyConverter.DOUBLE;
        }
    }

    static class LongTermValuesSource
    implements TermValuesSource {
        final ValuesSource.Numeric source;
        final InternalMultiTerms.KeyConverter converter;

        LongTermValuesSource(ValuesSourceConfig config) {
            this.source = (ValuesSource.Numeric)config.getValuesSource();
            this.converter = config.format() == DocValueFormat.UNSIGNED_LONG_SHIFTED ? InternalMultiTerms.KeyConverter.UNSIGNED_LONG : InternalMultiTerms.KeyConverter.LONG;
        }

        @Override
        public TermValues getValues(LeafReaderContext ctx) throws IOException {
            SortedNumericDocValues values = this.source.longValues(ctx);
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            return singleton != null ? this.getValues(singleton) : this.getValues(values);
        }

        public TermValues getValues(SortedNumericDocValues values) {
            return doc -> {
                if (values.advanceExact(doc)) {
                    ArrayList<Long> objects = new ArrayList<Long>();
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        objects.add(val);
                        previous = val;
                    }
                    return objects;
                }
                return null;
            };
        }

        public TermValues getValues(NumericDocValues values) {
            return doc -> {
                if (values.advanceExact(doc)) {
                    return List.of(Long.valueOf(values.longValue()));
                }
                return null;
            };
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return this.converter;
        }
    }

    static class IPTermValuesSource
    extends BinaryTermValuesSource {
        IPTermValuesSource(ValuesSourceConfig source) {
            super(source);
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return InternalMultiTerms.KeyConverter.IP;
        }
    }

    static class StringTermValuesSource
    extends BinaryTermValuesSource {
        StringTermValuesSource(ValuesSourceConfig source) {
            super(source);
        }

        @Override
        public InternalMultiTerms.KeyConverter keyConverter() {
            return InternalMultiTerms.KeyConverter.STRING;
        }
    }

    static abstract class BinaryTermValuesSource
    implements TermValuesSource {
        private final ValuesSource source;
        final BytesRefBuilder previous = new BytesRefBuilder();

        BinaryTermValuesSource(ValuesSourceConfig source) {
            this.source = source.getValuesSource();
        }

        @Override
        public TermValues getValues(LeafReaderContext ctx) throws IOException {
            SortedBinaryDocValues values = this.source.bytesValues(ctx);
            BinaryDocValues singleton = FieldData.unwrapSingleton((SortedBinaryDocValues)values);
            return singleton != null ? this.getValues(singleton) : this.getValues(values);
        }

        private TermValues getValues(SortedBinaryDocValues values) {
            return doc -> {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    ArrayList<BytesRef> objects = new ArrayList<BytesRef>(valuesCount);
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (i > 0 && this.previous.get().equals((Object)bytes)) continue;
                        this.previous.copyBytes(bytes);
                        objects.add(BytesRef.deepCopyOf((BytesRef)bytes));
                    }
                    return objects;
                }
                return null;
            };
        }

        private TermValues getValues(BinaryDocValues values) {
            return doc -> {
                if (values.advanceExact(doc)) {
                    return List.of(BytesRef.deepCopyOf((BytesRef)values.binaryValue()));
                }
                return null;
            };
        }
    }
}

