/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.UpdateWatcherSettingsAction;

public class TransportUpdateWatcherSettingsAction
extends TransportMasterNodeAction<UpdateWatcherSettingsAction.Request, AcknowledgedResponse> {
    static final String WATCHER_INDEX_NAME = ".watches";
    static final IndicesRequest WATCHER_INDEX_REQUEST = new IndicesRequest(){

        public String[] indices() {
            return new String[]{TransportUpdateWatcherSettingsAction.WATCHER_INDEX_NAME};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.LENIENT_EXPAND_OPEN;
        }
    };
    private static final Logger logger = LogManager.getLogger(TransportUpdateWatcherSettingsAction.class);
    private final MetadataUpdateSettingsService updateSettingsService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportUpdateWatcherSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, MetadataUpdateSettingsService updateSettingsService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/watcher/settings/update", transportService, clusterService, threadPool, actionFilters, UpdateWatcherSettingsAction.Request::readFrom, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.updateSettingsService = updateSettingsService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void masterOperation(Task task, final UpdateWatcherSettingsAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        IndexMetadata watcherIndexMd = state.metadata().index(WATCHER_INDEX_NAME);
        if (watcherIndexMd == null) {
            listener.onFailure((Exception)((Object)new ResourceNotFoundException("no Watches found on which to modify settings", new Object[0])));
            return;
        }
        Settings newSettings = Settings.builder().loadFromMap(request.settings()).build();
        UpdateSettingsClusterStateUpdateRequest clusterStateUpdateRequest = new UpdateSettingsClusterStateUpdateRequest(request.masterNodeTimeout(), request.ackTimeout(), newSettings, UpdateSettingsClusterStateUpdateRequest.OnExisting.OVERWRITE, UpdateSettingsClusterStateUpdateRequest.OnStaticSetting.REJECT, new Index[]{watcherIndexMd.getIndex()});
        this.updateSettingsService.updateSettings(clusterStateUpdateRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                if (acknowledgedResponse.isAcknowledged()) {
                    logger.info("successfully updated Watcher service settings to {}", new Object[]{request.settings()});
                } else {
                    logger.warn("updating Watcher service settings to {} was not acknowledged", new Object[]{request.settings()});
                }
                listener.onResponse((Object)acknowledgedResponse);
            }

            public void onFailure(Exception e) {
                logger.debug(() -> "failed to update settings for Watcher service", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(UpdateWatcherSettingsAction.Request request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (globalBlock != null) {
            return globalBlock;
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, WATCHER_INDEX_REQUEST));
    }
}

