/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datatiers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class NodeDataTiersUsage
extends BaseNodeResponse {
    private final Map<String, UsageStats> usageStatsByTier;

    public NodeDataTiersUsage(StreamInput in) throws IOException {
        super(in);
        this.usageStatsByTier = in.readMap(UsageStats::read);
    }

    public NodeDataTiersUsage(DiscoveryNode node, Map<String, UsageStats> usageStatsByTier) {
        super(node);
        this.usageStatsByTier = usageStatsByTier;
    }

    public Map<String, UsageStats> getUsageStatsByTier() {
        return Map.copyOf(this.usageStatsByTier);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.usageStatsByTier, StreamOutput::writeWriteable);
    }

    public static class UsageStats
    implements Writeable {
        private final List<Long> primaryShardSizes;
        private int totalShardCount;
        private long docCount;
        private long totalSize;

        public UsageStats() {
            this.primaryShardSizes = new ArrayList<Long>();
            this.totalShardCount = 0;
            this.docCount = 0L;
            this.totalSize = 0L;
        }

        public UsageStats(List<Long> primaryShardSizes, int totalShardCount, long docCount, long totalSize) {
            this.primaryShardSizes = primaryShardSizes;
            this.totalShardCount = totalShardCount;
            this.docCount = docCount;
            this.totalSize = totalSize;
        }

        static UsageStats read(StreamInput in) throws IOException {
            return new UsageStats(in.readCollectionAsList(StreamInput::readVLong), in.readVInt(), in.readVLong(), in.readVLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.primaryShardSizes, StreamOutput::writeVLong);
            out.writeVInt(this.totalShardCount);
            out.writeVLong(this.docCount);
            out.writeVLong(this.totalSize);
        }

        public void addPrimaryShardSize(long primaryShardSize) {
            this.primaryShardSizes.add(primaryShardSize);
        }

        public void incrementTotalSize(long totalSize) {
            this.totalSize += totalSize;
        }

        public void incrementDocCount(long docCount) {
            this.docCount += docCount;
        }

        public void incrementTotalShardCount(int totalShardCount) {
            this.totalShardCount += totalShardCount;
        }

        public List<Long> getPrimaryShardSizes() {
            return this.primaryShardSizes;
        }

        public int getTotalShardCount() {
            return this.totalShardCount;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public long getTotalSize() {
            return this.totalSize;
        }
    }
}

