/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.script.field;

import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.fielddata.MultiPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.PointDocValuesField;
import org.elasticsearch.xpack.spatial.common.CartesianBoundingBox;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;

public class CartesianPointDocValuesField
extends PointDocValuesField<CartesianPoint> {
    private CartesianPointScriptValues points = null;

    public CartesianPointDocValuesField(MultiPointValues<CartesianPoint> input, String name) {
        super(input, name, CartesianPoint::new, (BoundingBox)new CartesianBoundingBox(new CartesianPoint(), new CartesianPoint()), (SpatialPoint[])new CartesianPoint[0]);
    }

    protected void resetPointAt(int i, CartesianPoint point) {
        ((CartesianPoint[])this.values)[i].reset(point.getX(), point.getY());
    }

    protected void resetCentroidAndBounds(CartesianPoint point, CartesianPoint topLeft, CartesianPoint bottomRight) {
        ((CartesianPoint)this.centroid).reset(point.getX() / (double)this.count, point.getY() / (double)this.count);
        ((CartesianPoint)this.boundingBox.topLeft()).reset(topLeft.getX(), topLeft.getY());
        ((CartesianPoint)this.boundingBox.bottomRight()).reset(bottomRight.getX(), bottomRight.getY());
    }

    protected double getXFrom(CartesianPoint point) {
        return point.getX();
    }

    protected double getYFrom(CartesianPoint point) {
        return point.getY();
    }

    protected CartesianPoint pointOf(double x, double y) {
        return new CartesianPoint(x, y);
    }

    protected double planeDistance(double x1, double y1, CartesianPoint point) {
        double x = point.getX() - x1;
        double y = point.getY() - y1;
        return Math.sqrt(x * x + y * y);
    }

    public ScriptDocValues<CartesianPoint> toScriptDocValues() {
        if (this.points == null) {
            this.points = new CartesianPointScriptValues((ScriptDocValues.GeometrySupplier<CartesianPoint, CartesianPoint>)this);
        }
        return this.points;
    }

    public class CartesianPointScriptValues
    extends CartesianGeometry<CartesianPoint> {
        private final ScriptDocValues.GeometrySupplier<CartesianPoint, CartesianPoint> geometrySupplier;

        public CartesianPointScriptValues(ScriptDocValues.GeometrySupplier<CartesianPoint, CartesianPoint> supplier) {
            super(supplier);
            this.geometrySupplier = supplier;
        }

        public CartesianPoint getValue() {
            return this.get(0);
        }

        public double getX() {
            return this.getValue().getX();
        }

        public double[] getXs() {
            double[] xs = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                xs[i] = this.get(i).getX();
            }
            return xs;
        }

        public double[] getYs() {
            double[] ys = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                ys[i] = this.get(i).getY();
            }
            return ys;
        }

        public double getY() {
            return this.getValue().getY();
        }

        public CartesianPoint get(int index) {
            if (this.supplier.size() == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            CartesianPoint point = (CartesianPoint)this.supplier.getInternal(index);
            return new CartesianPoint(point.getX(), point.getY());
        }

        public int size() {
            return this.supplier.size();
        }

        public double planeDistance(double x, double y) {
            CartesianPoint point = this.getValue();
            double dx = x - point.getX();
            double dy = y - point.getY();
            return Math.sqrt(dx * dx + dy * dy);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public int getDimensionalType() {
            return this.size() == 0 ? -1 : 0;
        }

        @Override
        public CartesianPoint getCentroid() {
            return this.size() == 0 ? null : (CartesianPoint)this.geometrySupplier.getInternalCentroid();
        }

        @Override
        public CartesianBoundingBox getBoundingBox() {
            return this.size() == 0 ? null : (CartesianBoundingBox)this.geometrySupplier.getInternalBoundingBox();
        }

        @Override
        public CartesianPoint getLabelPosition() {
            return this.size() == 0 ? null : (CartesianPoint)this.geometrySupplier.getInternalLabelPosition();
        }
    }

    public static abstract class CartesianGeometry<V>
    extends ScriptDocValues.BaseGeometry<CartesianPoint, V> {
        public CartesianGeometry(ScriptDocValues.Supplier<V> supplier) {
            super(supplier);
        }

        public abstract CartesianBoundingBox getBoundingBox();

        public abstract CartesianPoint getLabelPosition();

        public abstract CartesianPoint getCentroid();
    }
}

