/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class CopyLifecycleIndexMetadataAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "indices:admin/index/copy_lifecycle_index_metadata";
    public static final ActionType<AcknowledgedResponse> INSTANCE = new CopyLifecycleIndexMetadataAction();

    private CopyLifecycleIndexMetadataAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest {
        private final String sourceIndex;
        private final String destIndex;

        public Request(TimeValue masterNodeTimeout, String sourceIndex, String destIndex) {
            super(masterNodeTimeout, DEFAULT_ACK_TIMEOUT);
            this.sourceIndex = sourceIndex;
            this.destIndex = destIndex;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sourceIndex = in.readString();
            this.destIndex = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sourceIndex);
            out.writeString(this.destIndex);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String sourceIndex() {
            return this.sourceIndex;
        }

        public String destIndex() {
            return this.destIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.sourceIndex, request.sourceIndex) && Objects.equals(this.destIndex, request.destIndex);
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex, this.destIndex);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String getDescription() {
            return "copying lifecycle metadata for index " + this.sourceIndex;
        }

        public String[] indices() {
            return new String[]{this.sourceIndex, this.destIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }
    }
}

