/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncStatusRequest;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.AsyncStatusResponse;
import org.elasticsearch.xpack.search.AsyncSearchTask;

public class TransportGetAsyncStatusAction
extends HandledTransportAction<GetAsyncStatusRequest, AsyncStatusResponse> {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ThreadContext threadContext;
    private final AsyncTaskIndexService<AsyncSearchResponse> store;

    @Inject
    public TransportGetAsyncStatusAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays) {
        super("cluster:monitor/async_search/status", transportService, actionFilters, GetAsyncStatusRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadContext = threadPool.getThreadContext();
        this.store = new AsyncTaskIndexService(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", AsyncSearchResponse::new, registry, bigArrays);
    }

    protected void doExecute(Task task, GetAsyncStatusRequest request, ActionListener<AsyncStatusResponse> listener) {
        AsyncExecutionId searchId = AsyncExecutionId.decode((String)request.getId());
        DiscoveryNode node = this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
        DiscoveryNode localNode = this.clusterService.state().getNodes().getLocalNode();
        ActionListener listenerWithHeaders = listener.map(response -> {
            this.threadContext.addResponseHeader("X-Elasticsearch-Async-Is-Running", response.isRunning() ? "?1" : "?0");
            this.threadContext.addResponseHeader("X-Elasticsearch-Async-Id", response.getId());
            return response;
        });
        if (node == null || Objects.equals(node, localNode)) {
            if (request.getKeepAlive() != null && request.getKeepAlive().getMillis() > 0L) {
                long expirationTime = System.currentTimeMillis() + request.getKeepAlive().getMillis();
                this.store.updateExpirationTime(searchId.getDocId(), expirationTime, ActionListener.wrap(p -> {
                    AsyncSearchTask asyncSearchTask = (AsyncSearchTask)AsyncTaskIndexService.getTask((TaskManager)this.taskManager, (AsyncExecutionId)searchId, AsyncSearchTask.class);
                    if (asyncSearchTask != null) {
                        asyncSearchTask.setExpirationTime(expirationTime);
                    }
                    this.store.retrieveStatus(request, this.taskManager, AsyncSearchTask.class, AsyncSearchTask::getStatusResponse, AsyncStatusResponse::getStatusFromStoredSearch, listenerWithHeaders);
                }, exc -> {
                    RestStatus status = ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)exc));
                    if (status != RestStatus.NOT_FOUND) {
                        this.logger.error(() -> Strings.format((String)"failed to update expiration time for async-search [%s]", (Object[])new Object[]{searchId.getEncoded()}), (Throwable)exc);
                        listenerWithHeaders.onFailure(exc);
                    } else {
                        listenerWithHeaders.onFailure((Exception)new ResourceNotFoundException(searchId.getEncoded(), new Object[0]));
                    }
                }));
            } else {
                this.store.retrieveStatus(request, this.taskManager, AsyncSearchTask.class, AsyncSearchTask::getStatusResponse, AsyncStatusResponse::getStatusFromStoredSearch, listenerWithHeaders);
            }
        } else {
            this.transportService.sendRequest(node, "cluster:monitor/async_search/status", (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listenerWithHeaders, AsyncStatusResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE));
        }
    }
}

