/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.rerank;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public record GoogleVertexAiRerankRequestTaskSettings(@Nullable Integer topN) {
    public static final GoogleVertexAiRerankRequestTaskSettings EMPTY_SETTINGS = new GoogleVertexAiRerankRequestTaskSettings(null);

    public static GoogleVertexAiRerankRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        Integer topN = ServiceUtils.extractOptionalPositiveInteger(map, "top_n", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiRerankRequestTaskSettings(topN);
    }
}

