/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.queries;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.search.SparseVectorQueryBuilder;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;
import org.elasticsearch.xpack.inference.queries.SemanticQueryRewriteInterceptor;

public class SemanticSparseVectorQueryRewriteInterceptor
extends SemanticQueryRewriteInterceptor {
    public static final NodeFeature SEMANTIC_SPARSE_VECTOR_QUERY_REWRITE_INTERCEPTION_SUPPORTED = new NodeFeature("search.semantic_sparse_vector_query_rewrite_interception_supported");

    @Override
    protected String getFieldName(QueryBuilder queryBuilder) {
        assert (queryBuilder instanceof SparseVectorQueryBuilder);
        SparseVectorQueryBuilder sparseVectorQueryBuilder = (SparseVectorQueryBuilder)queryBuilder;
        return sparseVectorQueryBuilder.getFieldName();
    }

    @Override
    protected String getQuery(QueryBuilder queryBuilder) {
        assert (queryBuilder instanceof SparseVectorQueryBuilder);
        SparseVectorQueryBuilder sparseVectorQueryBuilder = (SparseVectorQueryBuilder)queryBuilder;
        return sparseVectorQueryBuilder.getQuery();
    }

    @Override
    protected QueryBuilder buildInferenceQuery(QueryBuilder queryBuilder, SemanticQueryRewriteInterceptor.InferenceIndexInformationForField indexInformation) {
        Map<String, List<String>> inferenceIdsIndices = indexInformation.getInferenceIdsIndices();
        if (inferenceIdsIndices.size() == 1) {
            String searchInferenceId = inferenceIdsIndices.keySet().iterator().next();
            return this.buildNestedQueryFromSparseVectorQuery(queryBuilder, searchInferenceId);
        }
        return this.buildInferenceQueryWithMultipleInferenceIds(queryBuilder, inferenceIdsIndices);
    }

    private QueryBuilder buildInferenceQueryWithMultipleInferenceIds(QueryBuilder queryBuilder, Map<String, List<String>> inferenceIdsIndices) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        for (String inferenceId : inferenceIdsIndices.keySet()) {
            boolQueryBuilder.should(this.createSubQueryForIndices((Collection<String>)inferenceIdsIndices.get(inferenceId), this.buildNestedQueryFromSparseVectorQuery(queryBuilder, inferenceId)));
        }
        return boolQueryBuilder;
    }

    @Override
    protected QueryBuilder buildCombinedInferenceAndNonInferenceQuery(QueryBuilder queryBuilder, SemanticQueryRewriteInterceptor.InferenceIndexInformationForField indexInformation) {
        assert (queryBuilder instanceof SparseVectorQueryBuilder);
        SparseVectorQueryBuilder sparseVectorQueryBuilder = (SparseVectorQueryBuilder)queryBuilder;
        Map<String, List<String>> inferenceIdsIndices = indexInformation.getInferenceIdsIndices();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.should(this.createSubQueryForIndices(indexInformation.nonInferenceIndices(), this.createSubQueryForIndices(indexInformation.nonInferenceIndices(), (QueryBuilder)sparseVectorQueryBuilder)));
        for (String inferenceId : inferenceIdsIndices.keySet()) {
            boolQueryBuilder.should(this.createSubQueryForIndices((Collection<String>)inferenceIdsIndices.get(inferenceId), this.buildNestedQueryFromSparseVectorQuery((QueryBuilder)sparseVectorQueryBuilder, inferenceId)));
        }
        return boolQueryBuilder;
    }

    private QueryBuilder buildNestedQueryFromSparseVectorQuery(QueryBuilder queryBuilder, String searchInferenceId) {
        assert (queryBuilder instanceof SparseVectorQueryBuilder);
        SparseVectorQueryBuilder sparseVectorQueryBuilder = (SparseVectorQueryBuilder)queryBuilder;
        return QueryBuilders.nestedQuery((String)SemanticTextField.getChunksFieldName(sparseVectorQueryBuilder.getFieldName()), (QueryBuilder)new SparseVectorQueryBuilder(SemanticTextField.getEmbeddingsFieldName(sparseVectorQueryBuilder.getFieldName()), sparseVectorQueryBuilder.getQueryVectors(), sparseVectorQueryBuilder.getInferenceId() == null && sparseVectorQueryBuilder.getQuery() != null ? searchInferenceId : sparseVectorQueryBuilder.getInferenceId(), sparseVectorQueryBuilder.getQuery(), Boolean.valueOf(sparseVectorQueryBuilder.shouldPruneTokens()), sparseVectorQueryBuilder.getTokenPruningConfig()), (ScoreMode)ScoreMode.Max);
    }

    public String getQueryName() {
        return "sparse_vector";
    }
}

