/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.logging;

import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.logging.Throttler;

public class ThrottlerManager
implements Closeable {
    private static final TimeValue DEFAULT_STATS_RESET_INTERVAL_TIME = TimeValue.timeValueDays((long)1L);
    public static final Setting<TimeValue> STATS_RESET_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.inference.logging.reset_interval", (TimeValue)DEFAULT_STATS_RESET_INTERVAL_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_WAIT_DURATION_TIME = TimeValue.timeValueHours((long)1L);
    public static final Setting<TimeValue> LOGGER_WAIT_DURATION_SETTING = Setting.timeSetting((String)"xpack.inference.logging.wait_duration", (TimeValue)DEFAULT_WAIT_DURATION_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ThreadPool threadPool;
    private Throttler throttler;
    private LoggerSettings loggerSettings;

    public ThrottlerManager(Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        Objects.requireNonNull(settings);
        Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.loggerSettings = LoggerSettings.fromSettings(settings);
        this.throttler = new Throttler(this.loggerSettings.resetInterval(), this.loggerSettings.waitDuration(), threadPool);
        this.addSettingsUpdateConsumers(clusterService);
    }

    private void addSettingsUpdateConsumers(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(STATS_RESET_INTERVAL_SETTING, this::setResetInterval);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOGGER_WAIT_DURATION_SETTING, this::setWaitDuration);
    }

    void setWaitDuration(TimeValue waitDuration) {
        this.loggerSettings = this.loggerSettings.createWithWaitDuration(waitDuration);
        this.throttler.setDurationToWait(waitDuration);
    }

    void setResetInterval(TimeValue resetInterval) {
        this.loggerSettings = this.loggerSettings.createWithResetInterval(resetInterval);
        this.throttler.close();
        this.throttler = new Throttler(this.loggerSettings.resetInterval(), this.loggerSettings.waitDuration(), this.threadPool);
    }

    Throttler getThrottler() {
        return this.throttler;
    }

    public void warn(Logger logger, String message, Throwable e) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(e);
        this.throttler.execute(message, messageToLog -> logger.warn(messageToLog, e));
    }

    public void warn(Logger logger, String message) {
        Objects.requireNonNull(message);
        this.throttler.execute(message, arg_0 -> ((Logger)logger).warn(arg_0));
    }

    @Override
    public void close() {
        this.throttler.close();
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(STATS_RESET_INTERVAL_SETTING, LOGGER_WAIT_DURATION_SETTING);
    }

    private record LoggerSettings(TimeValue resetInterval, TimeValue waitDuration) {
        LoggerSettings {
            Objects.requireNonNull(resetInterval);
            Objects.requireNonNull(waitDuration);
        }

        static LoggerSettings fromSettings(Settings settings) {
            return new LoggerSettings((TimeValue)STATS_RESET_INTERVAL_SETTING.get(settings), (TimeValue)LOGGER_WAIT_DURATION_SETTING.get(settings));
        }

        LoggerSettings createWithResetInterval(TimeValue resetInterval) {
            return new LoggerSettings(resetInterval, this.waitDuration);
        }

        LoggerSettings createWithWaitDuration(TimeValue waitDuration) {
            return new LoggerSettings(this.resetInterval, waitDuration);
        }
    }
}

