/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.elastic;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.elastic.ElasticInferenceServiceActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.ElasticInferenceServiceSparseEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceServiceActionCreator
implements ElasticInferenceServiceActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;
    private final TraceContext traceContext;
    private final InputType inputType;

    public ElasticInferenceServiceActionCreator(Sender sender, ServiceComponents serviceComponents, TraceContext traceContext, InputType inputType) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
        this.traceContext = traceContext;
        this.inputType = inputType;
    }

    @Override
    public ExecutableAction create(ElasticInferenceServiceSparseEmbeddingsModel model) {
        ElasticInferenceServiceSparseEmbeddingsRequestManager requestManager = new ElasticInferenceServiceSparseEmbeddingsRequestManager(model, this.serviceComponents, this.traceContext, this.inputType);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(String.format(Locale.ROOT, "%s sparse embeddings", "Elastic Inference Service"));
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }
}

