/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action;

import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;

public class SingleInputSenderExecutableAction
extends SenderExecutableAction {
    private final String requestTypeForInputValidationError;

    public SingleInputSenderExecutableAction(Sender sender, RequestManager requestManager, String failedToSendRequestErrorMessage, String requestTypeForInputValidationError) {
        super(sender, requestManager, failedToSendRequestErrorMessage);
        this.requestTypeForInputValidationError = Objects.requireNonNull(requestTypeForInputValidationError);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (inferenceInputs.inputSize() > 1) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException(this.requestTypeForInputValidationError + " only accepts 1 input", RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        super.execute(inferenceInputs, timeout, listener);
    }
}

