/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.cli.command.AbstractCliCommand;
import org.elasticsearch.xpack.sql.cli.command.CliSession;

public class FetchSizeCliCommand
extends AbstractCliCommand {
    public FetchSizeCliCommand() {
        super(Pattern.compile("fetch(?: |_)size *= *(.+)", 2));
    }

    @Override
    protected boolean doHandle(CliTerminal terminal, CliSession cliSession, Matcher m, String line) {
        try {
            cliSession.cfg().setFetchSize(Integer.parseInt(m.group(1)));
        }
        catch (NumberFormatException e) {
            terminal.line().error("Invalid fetch size [").param(m.group(1)).error("]").end();
            return true;
        }
        catch (IllegalArgumentException e) {
            terminal.line().error("Invalid fetch size [").param(m.group(1)).error("]. " + e.getMessage()).end();
            return true;
        }
        terminal.line().text("fetch size set to ").em(Integer.toString(cliSession.cfg().getFetchSize())).end();
        return true;
    }
}

