/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.FixedMultiBucketAggregatorsReducer;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalRange<B extends Bucket, R extends InternalRange<B, R>>
extends InternalMultiBucketAggregation<R, B>
implements Range {
    static final Factory FACTORY = new Factory();
    private final List<B> ranges;
    protected final DocValueFormat format;
    protected final boolean keyed;

    public InternalRange(String name, List<B> ranges, DocValueFormat format, boolean keyed, Map<String, Object> metadata) {
        super(name, metadata);
        this.ranges = ranges;
        this.format = format;
        this.keyed = keyed;
    }

    public InternalRange(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> ranges = new ArrayList<B>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.getTransportVersion().equals(TransportVersions.V_8_0_0) ? in.readString() : (in.getTransportVersion().onOrAfter(TransportVersions.V_7_17_1) ? in.readOptionalString() : in.readString());
            double from = in.readDouble();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0)) {
                Double originalFrom = in.readOptionalDouble();
                from = originalFrom != null ? originalFrom : Double.NEGATIVE_INFINITY;
            }
            double to = in.readDouble();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0)) {
                Double originalTo = in.readOptionalDouble();
                to = originalTo != null ? originalTo : Double.POSITIVE_INFINITY;
            }
            long docCount = in.readVLong();
            InternalAggregations aggregations = InternalAggregations.readFrom(in);
            ranges.add(this.getFactory().createBucket(key, from, to, docCount, aggregations, this.format));
        }
        this.ranges = ranges;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeCollection(this.ranges);
    }

    @Override
    public String getWriteableName() {
        return "range";
    }

    @Override
    public List<B> getBuckets() {
        return this.ranges;
    }

    public Factory<B, R> getFactory() {
        return FACTORY;
    }

    @Override
    public R create(List<B> buckets) {
        return (R)this.getFactory().create(buckets, this);
    }

    @Override
    public B createBucket(InternalAggregations aggregations, B prototype) {
        return this.getFactory().createBucket(aggregations, prototype);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            final FixedMultiBucketAggregatorsReducer<B> reducer;
            {
                this.reducer = new FixedMultiBucketAggregatorsReducer<B>(reduceContext, size, InternalRange.this.getBuckets()){

                    @Override
                    protected Bucket createBucket(Bucket proto, long docCount, InternalAggregations aggregations) {
                        return InternalRange.this.getFactory().createBucket(proto.key, proto.from, proto.to, docCount, aggregations, proto.format);
                    }
                };
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalRange ranges = (InternalRange)aggregation;
                this.reducer.accept(ranges.ranges);
            }

            @Override
            public InternalAggregation get() {
                return InternalRange.this.getFactory().create(InternalRange.this.name, this.reducer.get(), InternalRange.this.format, InternalRange.this.keyed, InternalRange.this.getMetadata());
            }

            @Override
            public void close() {
                Releasables.close(this.reducer);
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        Factory factory = this.getFactory();
        return factory.create(this.name, this.ranges.stream().map(b -> factory.createBucket(b.getKey(), b.from, b.to, samplingContext.scaleUp(b.getDocCount()), InternalAggregations.finalizeSampling(b.getAggregations(), samplingContext), b.format)).toList(), this.format, this.keyed, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket range : this.ranges) {
            range.bucketToXContent(builder, params, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ranges, this.format, this.keyed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalRange that = (InternalRange)obj;
        return Objects.equals(this.ranges, that.ranges) && Objects.equals(this.format, that.format) && Objects.equals(this.keyed, that.keyed);
    }

    public static class Factory<B extends Bucket, R extends InternalRange<B, R>> {
        public ValuesSourceType getValueSourceType() {
            return CoreValuesSourceType.NUMERIC;
        }

        public R create(String name, List<B> ranges, DocValueFormat format, boolean keyed, Map<String, Object> metadata) {
            return (R)new InternalRange(name, ranges, format, keyed, metadata);
        }

        public B createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, DocValueFormat format) {
            return (B)new Bucket(key, from, to, docCount, aggregations, format);
        }

        public R create(List<B> ranges, R prototype) {
            return (R)new InternalRange(((InternalRange)prototype).name, ranges, ((InternalRange)prototype).format, ((InternalRange)prototype).keyed, ((InternalRange)prototype).metadata);
        }

        public B createBucket(InternalAggregations aggregations, B prototype) {
            return (B)new Bucket(((Bucket)prototype).getKey(), ((Bucket)prototype).from, ((Bucket)prototype).to, ((Bucket)prototype).getDocCount(), aggregations, ((Bucket)prototype).format);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucketWritable
    implements Range.Bucket {
        protected final transient DocValueFormat format;
        protected final double from;
        protected final double to;
        private final long docCount;
        private final InternalAggregations aggregations;
        private final String key;

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, DocValueFormat format) {
            this.format = format;
            this.key = key;
            this.from = from;
            this.to = to;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        public String getKeyAsString() {
            return this.key == null ? Bucket.generateKey(this.from, this.to, this.format) : this.key;
        }

        @Override
        public Object getFrom() {
            return this.from;
        }

        @Override
        public Object getTo() {
            return this.to;
        }

        public DocValueFormat getFormat() {
            return this.format;
        }

        @Override
        public String getFromAsString() {
            if (Double.isInfinite(this.from)) {
                return null;
            }
            return this.format.format(this.from).toString();
        }

        @Override
        public String getToAsString() {
            if (Double.isInfinite(this.to)) {
                return null;
            }
            return this.format.format(this.to).toString();
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder bucketToXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed) throws IOException {
            String key = this.getKeyAsString();
            if (keyed) {
                builder.startObject(key);
            } else {
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), key);
            }
            if (!Double.isInfinite(this.from)) {
                builder.field(Aggregation.CommonFields.FROM.getPreferredName(), this.from);
                if (this.format != DocValueFormat.RAW) {
                    builder.field(Aggregation.CommonFields.FROM_AS_STRING.getPreferredName(), this.format.format(this.from));
                }
            }
            if (!Double.isInfinite(this.to)) {
                builder.field(Aggregation.CommonFields.TO.getPreferredName(), this.to);
                if (this.format != DocValueFormat.RAW) {
                    builder.field(Aggregation.CommonFields.TO_AS_STRING.getPreferredName(), this.format.format(this.to));
                }
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        private static String generateKey(double from, double to, DocValueFormat format) {
            return String.valueOf(Double.isInfinite(from) ? "*" : format.format(from)) + "-" + String.valueOf(Double.isInfinite(to) ? "*" : format.format(to));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().equals(TransportVersions.V_8_0_0)) {
                out.writeString(this.key == null ? Bucket.generateKey(this.from, this.to, this.format) : this.key);
            } else if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_17_1)) {
                out.writeOptionalString(this.key);
            } else {
                out.writeString(this.key == null ? Bucket.generateKey(this.from, this.to, this.format) : this.key);
            }
            out.writeDouble(this.from);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0)) {
                out.writeOptionalDouble(this.from);
            }
            out.writeDouble(this.to);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0)) {
                out.writeOptionalDouble(this.to);
            }
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Bucket that = (Bucket)other;
            return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.from, this.to, this.docCount, this.aggregations, this.key);
        }
    }
}

