/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramBucket;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalVariableWidthHistogram
extends InternalMultiBucketAggregation<InternalVariableWidthHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final DocValueFormat format;
    private final int targetNumBuckets;
    final EmptyBucketInfo emptyBucketInfo;

    InternalVariableWidthHistogram(String name, List<Bucket> buckets, EmptyBucketInfo emptyBucketInfo, int targetNumBuckets, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, metaData);
        this.buckets = buckets;
        this.emptyBucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.targetNumBuckets = targetNumBuckets;
    }

    public InternalVariableWidthHistogram(StreamInput in) throws IOException {
        super(in);
        this.emptyBucketInfo = new EmptyBucketInfo(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.buckets = in.readCollectionAsList(stream -> Bucket.readFrom(stream, this.format));
        this.targetNumBuckets = in.readVInt();
        if (in.getTransportVersion().between(TransportVersions.V_8_13_0, TransportVersions.V_8_14_0)) {
            this.buckets.sort(Comparator.comparingDouble(b -> b.centroid));
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.emptyBucketInfo.writeTo(out);
        out.writeNamedWriteable(this.format);
        out.writeCollection(this.buckets);
        out.writeVInt(this.targetNumBuckets);
    }

    @Override
    public String getWriteableName() {
        return "variable_width_histogram";
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    public int getTargetBuckets() {
        return this.targetNumBuckets;
    }

    public EmptyBucketInfo getEmptyBucketInfo() {
        return this.emptyBucketInfo;
    }

    @Override
    public InternalVariableWidthHistogram create(List<Bucket> buckets) {
        return new InternalVariableWidthHistogram(this.name, buckets, this.emptyBucketInfo, this.targetNumBuckets, this.format, this.metadata);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.centroid, prototype.bounds, prototype.docCount, prototype.format, aggregations);
    }

    @Override
    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.doubleValue(), new Bucket.BucketBounds(key.doubleValue(), key.doubleValue()), docCount, this.format, aggregations);
    }

    @Override
    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).centroid;
    }

    private Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        try (BucketReducer<Bucket> reducer = new BucketReducer<Bucket>(buckets.get(0), context, buckets.size());){
            for (Bucket bucket : buckets) {
                min = Math.min(min, bucket.bounds.min);
                max = Math.max(max, bucket.bounds.max);
                sum += (double)bucket.docCount * bucket.centroid;
                reducer.accept(bucket);
            }
            double centroid = sum / (double)reducer.getDocCount();
            Bucket.BucketBounds bounds = new Bucket.BucketBounds(min, max);
            Bucket bucket = new Bucket(centroid, bounds, reducer.getDocCount(), this.format, reducer.getAggregations());
            return bucket;
        }
    }

    public List<Bucket> reduceBuckets(PriorityQueue<IteratorAndCurrent<Bucket>> pq, AggregationReduceContext reduceContext) {
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            double key = ((Bucket)((IteratorAndCurrent)pq.top()).current()).centroid();
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            do {
                IteratorAndCurrent top;
                if (Double.compare(((Bucket)(top = (IteratorAndCurrent)pq.top()).current()).centroid(), key) != 0) {
                    Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    reducedBuckets.add(reduced);
                    currentBuckets.clear();
                    key = ((Bucket)top.current()).centroid();
                }
                currentBuckets.add((Bucket)top.current());
                if (top.hasNext()) {
                    Bucket prev = (Bucket)top.current();
                    top.next();
                    assert (((Bucket)top.current()).compareKey(prev) >= 0) : "shards must return data sorted by centroid";
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reduceContext.consumeBucketsAndMaybeBreak(1);
                reducedBuckets.add(reduced);
            }
        }
        this.mergeBucketsIfNeeded(reducedBuckets, this.targetNumBuckets, reduceContext);
        return reducedBuckets;
    }

    private void mergeBucketsWithPlan(List<Bucket> buckets, List<BucketRange> plan, AggregationReduceContext reduceContext) {
        for (int i = plan.size() - 1; i >= 0; --i) {
            BucketRange range = plan.get(i);
            int startIdx = range.startIdx;
            int endIdx = range.endIdx;
            if (startIdx == endIdx) continue;
            ArrayList<Bucket> toMerge = new ArrayList<Bucket>();
            for (int idx = endIdx; idx > startIdx; --idx) {
                toMerge.add(buckets.get(idx));
                buckets.remove(idx);
            }
            toMerge.add(buckets.get(startIdx));
            int toRemove = toMerge.stream().mapToInt(b -> InternalVariableWidthHistogram.countInnerBucket(b) + 1).sum();
            reduceContext.consumeBucketsAndMaybeBreak(-toRemove + 1);
            Bucket merged_bucket = this.reduceBucket(toMerge, reduceContext);
            buckets.set(startIdx, merged_bucket);
        }
    }

    private void mergeBucketsIfNeeded(List<Bucket> buckets, int targetNumBuckets, AggregationReduceContext reduceContext) {
        ArrayList<BucketRange> ranges = new ArrayList<BucketRange>();
        int i = 0;
        while (i < buckets.size()) {
            BucketRange range = new BucketRange();
            range.centroid = buckets.get((int)i).centroid;
            range.docCount = buckets.get(i).getDocCount();
            range.startIdx = i;
            range.endIdx = i++;
            ranges.add(range);
        }
        while (ranges.size() > targetNumBuckets) {
            int closestIdx = 0;
            double smallest_distance = Double.POSITIVE_INFINITY;
            for (int i2 = 0; i2 < ranges.size() - 1; ++i2) {
                double new_distance = ((BucketRange)ranges.get((int)(i2 + 1))).centroid - ((BucketRange)ranges.get((int)i2)).centroid;
                if (!(new_distance < smallest_distance)) continue;
                closestIdx = i2;
                smallest_distance = new_distance;
            }
            ((BucketRange)ranges.get(closestIdx)).mergeWith((BucketRange)ranges.get(closestIdx + 1));
            ranges.remove(closestIdx + 1);
        }
        this.mergeBucketsWithPlan(buckets, ranges, reduceContext);
    }

    private void mergeBucketsWithSameMin(List<Bucket> buckets, AggregationReduceContext reduceContext) {
        BucketRange range;
        ArrayList<BucketRange> ranges = new ArrayList<BucketRange>();
        int i = 0;
        while (i < buckets.size()) {
            range = new BucketRange();
            range.min = buckets.get(i).min();
            range.startIdx = i;
            range.endIdx = i++;
            ranges.add(range);
        }
        i = 0;
        while (i < ranges.size() - 1) {
            range = (BucketRange)ranges.get(i);
            BucketRange nextRange = (BucketRange)ranges.get(i + 1);
            if (range.min == nextRange.min) {
                range.mergeWith(nextRange);
                ranges.remove(i + 1);
                continue;
            }
            ++i;
        }
        this.mergeBucketsWithPlan(buckets, ranges, reduceContext);
    }

    private static void adjustBoundsForOverlappingBuckets(List<Bucket> buckets) {
        for (int i = 1; i < buckets.size(); ++i) {
            Bucket curBucket = buckets.get(i);
            Bucket prevBucket = buckets.get(i - 1);
            if (!(curBucket.bounds.min < prevBucket.bounds.max)) continue;
            prevBucket.bounds.max = curBucket.bounds.min = (prevBucket.bounds.max + curBucket.bounds.min) / 2.0;
        }
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            private final PriorityQueue<IteratorAndCurrent<Bucket>> pq;
            {
                this.pq = new PriorityQueue<IteratorAndCurrent<Bucket>>(size){

                    protected boolean lessThan(IteratorAndCurrent<Bucket> a, IteratorAndCurrent<Bucket> b) {
                        return Double.compare(a.current().centroid, b.current().centroid) < 0;
                    }
                };
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalVariableWidthHistogram histogram = (InternalVariableWidthHistogram)aggregation;
                if (!histogram.buckets.isEmpty()) {
                    this.pq.add(new IteratorAndCurrent<Bucket>(histogram.buckets.iterator()));
                }
            }

            @Override
            public InternalAggregation get() {
                List<Bucket> reducedBuckets = InternalVariableWidthHistogram.this.reduceBuckets(this.pq, reduceContext);
                if (reduceContext.isFinalReduce()) {
                    InternalVariableWidthHistogram.this.buckets.sort(Comparator.comparing(Bucket::min));
                    InternalVariableWidthHistogram.this.mergeBucketsWithSameMin(reducedBuckets, reduceContext);
                    InternalVariableWidthHistogram.adjustBoundsForOverlappingBuckets(reducedBuckets);
                }
                return new InternalVariableWidthHistogram(InternalVariableWidthHistogram.this.getName(), reducedBuckets, InternalVariableWidthHistogram.this.emptyBucketInfo, InternalVariableWidthHistogram.this.targetNumBuckets, InternalVariableWidthHistogram.this.format, InternalVariableWidthHistogram.this.metadata);
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalVariableWidthHistogram(this.getName(), this.buckets.stream().map(b -> b.finalizeSampling(samplingContext)).toList(), this.emptyBucketInfo, this.targetNumBuckets, this.format, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalVariableWidthHistogram(this.name, buckets2, this.emptyBucketInfo, this.targetNumBuckets, this.format, this.getMetadata());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalVariableWidthHistogram that = (InternalVariableWidthHistogram)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.emptyBucketInfo, that.emptyBucketInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.emptyBucketInfo);
    }

    static class EmptyBucketInfo {
        final InternalAggregations subAggregations;

        EmptyBucketInfo(InternalAggregations subAggregations) {
            this.subAggregations = subAggregations;
        }

        EmptyBucketInfo(StreamInput in) throws IOException {
            this(InternalAggregations.readFrom(in));
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.subAggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyBucketInfo that = (EmptyBucketInfo)obj;
            return Objects.equals(this.subAggregations, that.subAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.subAggregations);
        }
    }

    public static class Bucket
    extends AbstractHistogramBucket
    implements KeyComparable<Bucket> {
        private final BucketBounds bounds;
        private final double centroid;

        public Bucket(double centroid, BucketBounds bounds, long docCount, DocValueFormat format, InternalAggregations aggregations) {
            super(docCount, aggregations, format);
            this.centroid = centroid;
            this.bounds = bounds;
        }

        public static Bucket readFrom(StreamInput in, DocValueFormat format) throws IOException {
            double centroid = in.readDouble();
            long docCount = in.readVLong();
            BucketBounds bounds = new BucketBounds(in);
            InternalAggregations aggregations = InternalAggregations.readFrom(in);
            return new Bucket(centroid, bounds, docCount, format, aggregations);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.centroid);
            out.writeVLong(this.docCount);
            this.bounds.writeTo(out);
            this.aggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return this.centroid == that.centroid && this.bounds.equals(that.bounds) && this.docCount == that.docCount && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.centroid, this.bounds, this.docCount, this.aggregations);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.centroid).toString();
        }

        @Override
        public Object getKey() {
            return this.centroid;
        }

        public double min() {
            return this.bounds.min;
        }

        public double max() {
            return this.bounds.max;
        }

        public double centroid() {
            return this.centroid;
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String keyAsString = this.format.format((Double)this.getKey()).toString();
            builder.startObject();
            builder.field(Aggregation.CommonFields.MIN.getPreferredName(), this.min());
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.MIN_AS_STRING.getPreferredName(), this.format.format(this.min()));
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKey());
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.MAX.getPreferredName(), this.max());
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.MAX_AS_STRING.getPreferredName(), this.format.format(this.max()));
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        @Override
        public int compareKey(Bucket other) {
            return Double.compare(this.centroid, other.centroid);
        }

        Bucket finalizeSampling(SamplingContext samplingContext) {
            return new Bucket(this.centroid, this.bounds, samplingContext.scaleUp(this.docCount), this.format, InternalAggregations.finalizeSampling(this.aggregations, samplingContext));
        }

        public static class BucketBounds {
            public double min;
            public double max;

            public BucketBounds(double min, double max) {
                assert (min <= max);
                this.min = min;
                this.max = max;
            }

            public BucketBounds(StreamInput in) throws IOException {
                this(in.readDouble(), in.readDouble());
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeDouble(this.min);
                out.writeDouble(this.max);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                BucketBounds that = (BucketBounds)obj;
                return this.min == that.min && this.max == that.max;
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), this.min, this.max);
            }
        }
    }

    static class BucketRange {
        int startIdx;
        int endIdx;
        double min;
        double max;
        double centroid;
        long docCount;

        BucketRange() {
        }

        public void mergeWith(BucketRange other) {
            this.startIdx = Math.min(this.startIdx, other.startIdx);
            this.endIdx = Math.max(this.endIdx, other.endIdx);
            if (this.docCount + other.docCount > 0L) {
                this.centroid = (this.centroid * (double)this.docCount + other.centroid * (double)other.docCount) / (double)(this.docCount + other.docCount);
                this.docCount += other.docCount;
            }
            this.min = Math.min(this.min, other.min);
            this.max = Math.max(this.max, other.max);
        }
    }
}

