/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;

public class IndexModeFieldMapper
extends MetadataFieldMapper {
    static final NodeFeature QUERYING_INDEX_MODE = new NodeFeature("mapper.query_index_mode", true);
    public static final String NAME = "_index_mode";
    public static final String CONTENT_TYPE = "_index_mode";
    private static final IndexModeFieldMapper INSTANCE = new IndexModeFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> INSTANCE);

    public IndexModeFieldMapper() {
        super(IndexModeFieldType.INSTANCE);
    }

    @Override
    protected String contentType() {
        return "_index_mode";
    }

    static final class IndexModeFieldType
    extends ConstantFieldType {
        static final IndexModeFieldType INSTANCE = new IndexModeFieldType();

        private IndexModeFieldType() {
            super("_index_mode", Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_index_mode";
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryRewriteContext context) {
            String indexMode = context.getIndexSettings().getMode().getName();
            return Regex.simpleMatch(pattern, indexMode, caseInsensitive);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            String indexMode = fieldDataContext.indexSettings().getMode().getName();
            return new ConstantIndexFieldData.Builder(indexMode, this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            String indexMode = blContext.indexSettings().getMode().getName();
            return BlockLoader.constantBytes(new BytesRef((CharSequence)indexMode));
        }

        @Override
        public ValueFetcher valueFetcher(final SearchExecutionContext context, String format) {
            return new ValueFetcher(){
                private final List<Object> indexMode;
                {
                    this.indexMode = List.of(context.getIndexSettings().getMode().getName());
                }

                @Override
                public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) {
                    return this.indexMode;
                }

                @Override
                public StoredFieldsSpec storedFieldsSpec() {
                    return StoredFieldsSpec.NO_REQUIREMENTS;
                }
            };
        }
    }
}

