/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.es818.OptimizedScalarQuantizer;

abstract class BinarizedByteVectorValues
extends DocIdSetIterator {
    BinarizedByteVectorValues() {
    }

    public abstract OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms();

    public abstract byte[] vectorValue() throws IOException;

    public abstract int dimension();

    public abstract int size();

    public final long cost() {
        return this.size();
    }

    public abstract OptimizedScalarQuantizer getQuantizer();

    public abstract float[] getCentroid() throws IOException;

    int discretizedDimensions() {
        return BQVectorUtils.discretize(this.dimension(), 64);
    }

    public abstract VectorScorer scorer(float[] var1) throws IOException;

    float getCentroidDP() throws IOException {
        float[] centroid = this.getCentroid();
        return VectorUtil.dotProduct((float[])centroid, (float[])centroid);
    }
}

