/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeleteExpiredDataAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)("/_ml/_delete_expired_data/{" + String.valueOf(Job.ID) + "}")).replaces(RestRequest.Method.DELETE, "/_xpack/ml/_delete_expired_data/{" + String.valueOf(Job.ID) + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)"/_ml/_delete_expired_data").replaces(RestRequest.Method.DELETE, "/_xpack/ml/_delete_expired_data", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_delete_expired_data_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String timeoutParam;
        DeleteExpiredDataAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (restRequest.hasContent()) {
            try (XContentParser parser = restRequest.contentParser();){
                request = DeleteExpiredDataAction.Request.parseRequest((String)jobId, (XContentParser)parser);
            }
        }
        request = new DeleteExpiredDataAction.Request();
        request.setJobId(jobId);
        String perSecondParam = restRequest.param(DeleteExpiredDataAction.Request.REQUESTS_PER_SECOND.getPreferredName());
        if (perSecondParam != null) {
            try {
                request.setRequestsPerSecond(Float.valueOf(Float.parseFloat(perSecondParam)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse float parameter [" + DeleteExpiredDataAction.Request.REQUESTS_PER_SECOND.getPreferredName() + "] with value [" + perSecondParam + "]", e);
            }
        }
        if ((timeoutParam = restRequest.param(DeleteExpiredDataAction.Request.TIMEOUT.getPreferredName())) != null) {
            request.setTimeout(restRequest.paramAsTime(timeoutParam, null));
        }
        return channel -> client.execute((ActionType)DeleteExpiredDataAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

