/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.utils.TaskRetriever;

public class TransportDeleteTrainedModelAction
extends AcknowledgedTransportMasterNodeAction<DeleteTrainedModelAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTrainedModelAction.class);
    private final Client client;
    private final TrainedModelProvider trainedModelProvider;
    private final InferenceAuditor auditor;
    private final IngestService ingestService;

    @Inject
    public TransportDeleteTrainedModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelProvider configProvider, InferenceAuditor auditor, IngestService ingestService) {
        super("cluster:admin/xpack/ml/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteTrainedModelAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.trainedModelProvider = configProvider;
        this.ingestService = ingestService;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void masterOperation(Task task, DeleteTrainedModelAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> Strings.format((String)"[%s] Request to delete trained model%s", (Object[])new Object[]{request.getId(), request.isForce() ? " (force)" : ""}));
        String id = request.getId();
        TransportDeleteTrainedModelAction.cancelDownloadTask(this.client, id, (ActionListener<ListTasksResponse>)listener.delegateFailureAndWrap((l, ignored) -> this.deleteModel(request, state, (ActionListener<AcknowledgedResponse>)l)), request.ackTimeout());
    }

    static void cancelDownloadTask(Client client, String modelId, ActionListener<ListTasksResponse> listener, TimeValue timeout) {
        logger.debug(() -> Strings.format((String)"[%s] Checking if download task exists and cancelling it", (Object[])new Object[]{modelId}));
        OriginSettingClient mlClient = new OriginSettingClient(client, "ml");
        ActionListener taskListener = ActionListener.wrap(taskInfo -> TransportDeleteTrainedModelAction.executeTaskCancellation((Client)mlClient, modelId, taskInfo, listener, timeout), e -> listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to retrieve existing task information for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId}))));
        TaskRetriever.getDownloadTaskInfo((Client)mlClient, modelId, false, timeout, () -> null, (ActionListener<TaskInfo>)taskListener);
    }

    static List<String> getModelAliases(ClusterState clusterState, String modelId) {
        ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState((ClusterState)clusterState);
        ArrayList<String> modelAliases = new ArrayList<String>();
        for (Map.Entry modelAliasEntry : currentMetadata.modelAliases().entrySet()) {
            if (!((ModelAliasMetadata.ModelAliasEntry)modelAliasEntry.getValue()).getModelId().equals(modelId)) continue;
            modelAliases.add((String)modelAliasEntry.getKey());
        }
        return modelAliases;
    }

    private void deleteModel(DeleteTrainedModelAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String id = request.getId();
        IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom("ingest");
        Set referencedModels = InferenceProcessorInfoExtractor.getModelIdsFromInferenceProcessors((IngestMetadata)currentIngestMetadata);
        if (!request.isForce() && referencedModels.contains(id)) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot delete model [{}] as it is still referenced by ingest processors; use force to delete the model", RestStatus.CONFLICT, new Object[]{id})));
            return;
        }
        List<String> modelAliases = TransportDeleteTrainedModelAction.getModelAliases(state, id);
        if (!request.isForce()) {
            Optional<String> referencedModelAlias = modelAliases.stream().filter(referencedModels::contains).findFirst();
            if (referencedModelAlias.isPresent()) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot delete model [{}] as it has a model_alias [{}] that is still referenced by ingest processors; use force to delete the model", RestStatus.CONFLICT, new Object[]{id, referencedModelAlias.get()})));
                return;
            }
        }
        if (TrainedModelAssignmentMetadata.fromState((ClusterState)state).modelIsDeployed(request.getId())) {
            if (request.isForce()) {
                this.forceStopDeployment(request.getId(), (ActionListener<StopTrainedModelDeploymentAction.Response>)listener.delegateFailureAndWrap((l, stopDeploymentResponse) -> this.deleteAliasesAndModel(request, modelAliases, (ActionListener<AcknowledgedResponse>)l)));
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot delete model [{}] as it is currently deployed; use force to delete the model", RestStatus.CONFLICT, new Object[]{id})));
            }
        } else {
            this.deleteAliasesAndModel(request, modelAliases, listener);
        }
    }

    private void forceStopDeployment(String modelId, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        StopTrainedModelDeploymentAction.Request request = new StopTrainedModelDeploymentAction.Request(modelId);
        request.setForce(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)StopTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, listener);
    }

    private void deleteAliasesAndModel(final DeleteTrainedModelAction.Request request, final List<String> modelAliases, ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> "[" + request.getId() + "] Deleting model");
        ActionListener nameDeletionListener = listener.delegateFailureAndWrap((delegate, ack) -> this.trainedModelProvider.deleteTrainedModel(request.getId(), (ActionListener<Boolean>)delegate.delegateFailureAndWrap((l, r) -> {
            this.auditor.info(request.getId(), "trained model deleted");
            l.onResponse((Object)AcknowledgedResponse.TRUE);
        })));
        if (modelAliases.isEmpty()) {
            nameDeletionListener.onResponse((Object)AcknowledgedResponse.of((boolean)true));
            return;
        }
        this.submitUnbatchedTask("delete-trained-model-alias", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask((AcknowledgedRequest)request, nameDeletionListener){

            public ClusterState execute(ClusterState currentState) {
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState((ClusterState)currentState);
                if (currentMetadata.modelAliases().isEmpty()) {
                    return currentState;
                }
                HashMap newMetadata = new HashMap(currentMetadata.modelAliases());
                logger.info("[{}] delete model model_aliases {}", (Object)request.getId(), (Object)modelAliases);
                modelAliases.forEach(newMetadata::remove);
                ModelAliasMetadata modelAliasMetadata = new ModelAliasMetadata(newMetadata);
                builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("trained_model_alias", (Metadata.Custom)modelAliasMetadata).build());
                return builder.build();
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    private static void executeTaskCancellation(Client client, String modelId, TaskInfo taskInfo, ActionListener<ListTasksResponse> listener, TimeValue timeout) {
        if (taskInfo != null) {
            ActionListener cancelListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof ResourceNotFoundException) {
                    logger.debug(() -> Strings.format((String)"[%s] Task no longer exists when attempting to cancel it", (Object[])new Object[]{modelId}));
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to cancel task for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId})));
                }
            });
            logger.debug(() -> Strings.format((String)"[%s] Download task exists, cancelling it", (Object[])new Object[]{modelId}));
            ((CancelTasksRequestBuilder)((CancelTasksRequestBuilder)client.admin().cluster().prepareCancelTasks(new String[0]).setTargetTaskId(taskInfo.taskId())).setTimeout(timeout)).waitForCompletion(true).execute(cancelListener);
        } else {
            logger.debug(() -> Strings.format((String)"[%s] No download task exists, proceeding with deletion", (Object[])new Object[]{modelId}));
            listener.onResponse(null);
        }
    }

    protected ClusterBlockException checkBlock(DeleteTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

