/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.text.Format;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Locale;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.StandardType;
import org.ojalgo.type.context.FormatContext;
import org.ojalgo.type.context.TypeContext;
import org.ojalgo.type.format.DatePart;
import org.ojalgo.type.format.DateStyle;

public final class DateContext
extends FormatContext<Date> {
    private static final DatePart DEFAULT_PART = DatePart.DATETIME;
    private static final DateStyle DEFAULT_STYLE = DateStyle.SHORT;
    private final DatePart myPart;
    private final DateStyle myStyle;

    public static Format toFormat(DatePart part, DateStyle style, Locale locale) {
        return part != null ? part.getFormat(style, locale) : DEFAULT_PART.getFormat(style, locale);
    }

    public DateContext() {
        super(StandardType.SQL_DATETIME.getFormat());
        this.myPart = DEFAULT_PART;
        this.myStyle = DEFAULT_STYLE;
    }

    public DateContext(DatePart part) {
        this(part, DEFAULT_STYLE, Locale.getDefault());
    }

    public DateContext(DatePart part, DateStyle style, Locale locale) {
        super(part != null ? part.getFormat(style, locale) : DEFAULT_PART.getFormat(style, locale));
        this.myPart = part != null ? part : DEFAULT_PART;
        this.myStyle = style != null ? style : DEFAULT_STYLE;
    }

    @Override
    public Date enforce(Date object) {
        switch (this.myPart) {
            case DATE: {
                LocalDate tmpDateOnly = new CalendarDate(object.getTime()).toLocalDate(ZoneOffset.UTC);
                return new Date(tmpDateOnly.getYear() - 1900, tmpDateOnly.getMonthValue() - 1, tmpDateOnly.getDayOfMonth());
            }
            case TIME: {
                LocalTime tmpTimeOnly = new CalendarDate(object.getTime()).toLocalTime(ZoneOffset.UTC);
                return new Date(0, 0, 1, tmpTimeOnly.getHour(), tmpTimeOnly.getMinute(), tmpTimeOnly.getSecond());
            }
        }
        long tmpDateAndTime = new CalendarDate((long)object.getTime()).millis;
        return new Date(tmpDateAndTime);
    }

    public DatePart getPart() {
        return this.myPart;
    }

    public DateStyle getStyle() {
        return this.myStyle;
    }

    public CalendarDateUnit getUnit() {
        switch (this.myPart) {
            case DATE: {
                return CalendarDateUnit.DAY;
            }
        }
        return CalendarDateUnit.SECOND;
    }

    public TypeContext<Date> withFormat(DatePart part, DateStyle style, Locale locale) {
        DatePart tmpPart = part != null ? part : this.getPart();
        DateStyle tmpStyle = style != null ? style : this.getStyle();
        Locale tmpLocale = locale != null ? locale : Locale.getDefault();
        return this.withFormat(DateContext.toFormat(tmpPart, tmpStyle, tmpLocale));
    }

    @Override
    protected void configureFormat(Format format, Object object) {
    }

    @Override
    protected String handleFormatException(Format format, Object object) {
        return "";
    }

    @Override
    protected Date handleParseException(Format format, String string) {
        return new Date();
    }
}

