/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class TermsQuery
extends Query {
    private final String term;
    private final Set<Object> values;

    public TermsQuery(Source source, String term, Set<Object> values) {
        super(source);
        this.term = term;
        this.values = values;
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.termsQuery((String)this.term, this.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term, this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermsQuery other = (TermsQuery)obj;
        return Objects.equals(this.term, other.term) && Objects.equals(this.values, other.values);
    }

    @Override
    protected String innerToString() {
        return this.term + ":" + String.valueOf(this.values);
    }
}

