/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.network.ThreadWatchdog;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4MessageInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Netty4Transport transport;
    private final InboundPipeline pipeline;
    private final ThreadWatchdog.ActivityTracker activityTracker;

    public Netty4MessageInboundHandler(Netty4Transport transport, InboundPipeline inboundPipeline, ThreadWatchdog.ActivityTracker activityTracker) {
        this.transport = transport;
        this.pipeline = inboundPipeline;
        this.activityTracker = activityTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        assert (Transports.assertTransportThread());
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + String.valueOf(msg.getClass());
        ByteBuf buffer = (ByteBuf)msg;
        Netty4TcpChannel channel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        this.activityTracker.startActivity();
        try (ReleasableBytesReference reference = Netty4Utils.toReleasableBytesReference(buffer);){
            this.pipeline.handleBytes((TcpChannel)channel, reference);
        }
        finally {
            this.activityTracker.stopActivity();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        Netty4TcpChannel tcpChannel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Releasables.closeExpectNoException((Releasable)this.pipeline);
        super.channelInactive(ctx);
    }
}

