/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.java.metrics.cyclomaticComplexity;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.jvm.java.metrics.cyclomaticComplexity.JavaCyclomaticComplexityMethodVisitor;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.PsiKt;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.inspections.VisitorLanguage;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.inspections.cyclomaticComplexity.CyclomaticComplexityMethodData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/jvm/java/metrics/cyclomaticComplexity/JavaCyclomaticComplexityMetricFileVisitor;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/inspections/cyclomaticComplexity/CyclomaticComplexityMetricFileVisitor;", "<init>", "()V", "language", "", "getLanguage", "()Ljava/lang/String;", "visit", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/inspections/cyclomaticComplexity/CyclomaticComplexityMethodData;", "file", "Lcom/intellij/psi/PsiFile;", "CyclomaticComplexityMetricFileVisitor", "intellij.qodana.jvm.java"})
public final class JavaCyclomaticComplexityMetricFileVisitor
implements org.jetbrains.qodana.staticAnalysis.inspections.metrics.inspections.cyclomaticComplexity.CyclomaticComplexityMetricFileVisitor {
    @Override
    @NotNull
    public String getLanguage() {
        return VisitorLanguage.JAVA.getId();
    }

    @Override
    @NotNull
    public List<CyclomaticComplexityMethodData> visit(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CyclomaticComplexityMetricFileVisitor fileVisitor = new CyclomaticComplexityMetricFileVisitor();
        PsiKt.iterateFileContents$default(file, (PsiElementVisitor)fileVisitor, null, null, 6, null);
        return fileVisitor.getMethodData();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/jvm/java/metrics/cyclomaticComplexity/JavaCyclomaticComplexityMetricFileVisitor$CyclomaticComplexityMetricFileVisitor;", "Lcom/intellij/psi/JavaElementVisitor;", "<init>", "()V", "_methodData", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/inspections/cyclomaticComplexity/CyclomaticComplexityMethodData;", "methodData", "", "getMethodData", "()Ljava/util/List;", "visitCallableElement", "", "callableElement", "Lcom/intellij/psi/PsiElement;", "name", "", "resolveName", "psiElement", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "visitLambdaExpression", "expression", "Lcom/intellij/psi/PsiLambdaExpression;", "intellij.qodana.jvm.java"})
    private static final class CyclomaticComplexityMetricFileVisitor
    extends JavaElementVisitor {
        @NotNull
        private final List<CyclomaticComplexityMethodData> _methodData = new ArrayList();
        @NotNull
        private final List<CyclomaticComplexityMethodData> methodData = this._methodData;

        @NotNull
        public final List<CyclomaticComplexityMethodData> getMethodData() {
            return this.methodData;
        }

        private final void visitCallableElement(PsiElement callableElement, String name) {
            JavaCyclomaticComplexityMethodVisitor methodVisitor = new JavaCyclomaticComplexityMethodVisitor();
            callableElement.acceptChildren((PsiElementVisitor)methodVisitor);
            int cyclomaticComplexityValue = methodVisitor.getCyclomaticComplexityValue();
            int n = callableElement.getTextRange().getStartOffset();
            CyclomaticComplexityMethodData methodData = new CyclomaticComplexityMethodData(name, n, cyclomaticComplexityValue);
            this._methodData.add(methodData);
        }

        private final String resolveName(PsiElement psiElement) {
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true), CyclomaticComplexityMetricFileVisitor::resolveName$lambda$0), CyclomaticComplexityMetricFileVisitor::resolveName$lambda$1))), (CharSequence)"$", null, null, (int)0, null, null, (int)62, null);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            String name = "function: " + this.resolveName((PsiElement)method);
            this.visitCallableElement((PsiElement)method, name);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            String name = "lambda: " + this.resolveName((PsiElement)expression);
            this.visitCallableElement((PsiElement)expression, name);
        }

        private static final boolean resolveName$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof PsiMethod || it instanceof PsiClass || it instanceof PsiVariable;
        }

        private static final String resolveName$lambda$1(PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiMethod psiMethod = element instanceof PsiMethod ? (PsiMethod)element : null;
            String functionName = psiMethod != null ? psiMethod.getName() : null;
            PsiClass psiClass = element instanceof PsiClass ? (PsiClass)element : null;
            String className = psiClass != null ? psiClass.getName() : null;
            PsiVariable psiVariable = element instanceof PsiVariable ? (PsiVariable)element : null;
            String variableName = psiVariable != null ? psiVariable.getName() : null;
            String string = functionName;
            if (string == null && (string = className) == null) {
                string = variableName;
            }
            return string;
        }
    }
}

