/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi.support;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.logging.Level;

public class ICUBidiReorderer
implements BidiReorderer {
    ArabicShaping shaper = new ArabicShaping(8);
    ArabicShaping deshaper = new ArabicShaping(16);

    @Override
    public String reorderRTLTextToLTR(String text2) {
        return Bidi.writeReverse((String)text2, (int)2);
    }

    @Override
    public String shapeText(String text2) {
        try {
            return this.shaper.shape(text2);
        }
        catch (ArabicShapingException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.GENERAL_EXCEPTION_SHAPING_TEXT, e);
            return text2;
        }
    }

    @Override
    public String deshapeText(String text2) {
        try {
            return this.deshaper.shape(text2);
        }
        catch (ArabicShapingException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.GENERAL_EXCEPTION_DESHAPING_TEXT, e);
            return text2;
        }
    }

    @Override
    public boolean isLiveImplementation() {
        return true;
    }
}

