/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipAndTrickManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.DocumentationSuggestion;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.PopupSuggestion;
import training.featuresSuggester.TipSuggestion;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.statistics.FeatureSuggesterStatistics;
import training.featuresSuggester.ui.SuggestionPresenter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltraining/featuresSuggester/ui/NotificationSuggestionPresenter;", "Ltraining/featuresSuggester/ui/SuggestionPresenter;", "<init>", "()V", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "showSuggestion", "", "project", "Lcom/intellij/openapi/project/Project;", "suggestion", "Ltraining/featuresSuggester/PopupSuggestion;", "disposable", "Lcom/intellij/openapi/Disposable;", "createDontSuggestAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "notification", "Lcom/intellij/notification/Notification;", "createGoToDocumentationAction", "Ltraining/featuresSuggester/DocumentationSuggestion;", "createShowTipAction", "Ltraining/featuresSuggester/TipSuggestion;", "intellij.featuresTrainer"})
public final class NotificationSuggestionPresenter
implements SuggestionPresenter {
    @NotNull
    private final NotificationGroup notificationGroup;

    public NotificationSuggestionPresenter() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE Feature Suggester");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        this.notificationGroup = notificationGroup;
    }

    @Override
    public void showSuggestion(@NotNull Project project, @NotNull PopupSuggestion suggestion, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Notification notification = this.notificationGroup.createNotification(FeatureSuggesterBundle.INSTANCE.message("notification.title", new Object[0]), suggestion.getMessage(), NotificationType.INFORMATION);
        PopupSuggestion popupSuggestion = suggestion;
        if (popupSuggestion instanceof TipSuggestion) {
            AnAction action = this.createShowTipAction(project, notification, (TipSuggestion)suggestion);
            if (action != null) {
                notification.addAction(action);
            }
        } else if (popupSuggestion instanceof DocumentationSuggestion) {
            notification.addAction(this.createGoToDocumentationAction(notification, (DocumentationSuggestion)suggestion));
        }
        notification.addAction(this.createDontSuggestAction(notification, suggestion));
        notification.notify(project);
        new Alarm(disposable).addRequest(() -> ((Notification)notification).expire(), 10000, ModalityState.any());
        FeatureSuggesterStatistics.INSTANCE.logNotificationShowed(suggestion.getSuggesterId());
    }

    private final AnAction createDontSuggestAction(Notification notification, PopupSuggestion suggestion) {
        String string = FeatureSuggesterBundle.INSTANCE.message("notification.dont.suggest", new Object[0]);
        return new AnAction(suggestion, notification, string){
            final /* synthetic */ PopupSuggestion $suggestion;
            final /* synthetic */ Notification $notification;
            {
                this.$suggestion = $suggestion;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FeatureSuggesterSettings settings = FeatureSuggesterSettings.Companion.instance();
                settings.setEnabled(this.$suggestion.getSuggesterId(), false);
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.INSTANCE.logNotificationDontSuggest(this.$suggestion.getSuggesterId());
            }
        };
    }

    private final AnAction createGoToDocumentationAction(Notification notification, DocumentationSuggestion suggestion) {
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getProductName()};
        String string = FeatureSuggesterBundle.INSTANCE.message("notification.open.help", objectArray);
        return new AnAction(suggestion, notification, string){
            final /* synthetic */ DocumentationSuggestion $suggestion;
            final /* synthetic */ Notification $notification;
            {
                this.$suggestion = $suggestion;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.open((String)this.$suggestion.getDocumentURL());
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.INSTANCE.logNotificationLearnMore(this.$suggestion.getSuggesterId());
            }
        };
    }

    private final AnAction createShowTipAction(Project project, Notification notification, TipSuggestion suggestion) {
        TipAndTrickBean tipAndTrickBean = TipAndTrickBean.findById((String)suggestion.getSuggestingTipId());
        if (tipAndTrickBean == null) {
            return null;
        }
        TipAndTrickBean tip = tipAndTrickBean;
        String string = FeatureSuggesterBundle.INSTANCE.message("notification.learn.more", new Object[0]);
        return new AnAction(project, tip, notification, suggestion, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ TipAndTrickBean $tip;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ TipSuggestion $suggestion;
            {
                this.$project = $project;
                this.$tip = $tip;
                this.$notification = $notification;
                this.$suggestion = $suggestion;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = this.$project;
                Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                BuildersKt.launch$default((CoroutineScope)((ComponentManagerEx)project).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$tip, this.$notification, this.$suggestion, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ TipAndTrickBean $tip;
                    final /* synthetic */ Notification $notification;
                    final /* synthetic */ TipSuggestion $suggestion;
                    {
                        this.$project = $project;
                        this.$tip = $tip;
                        this.$notification = $notification;
                        this.$suggestion = $suggestion;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = TipAndTrickManager.Companion.getInstance().showTipDialog(this.$project, this.$tip, (Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.$notification.hideBalloon();
                                FeatureSuggesterStatistics.INSTANCE.logNotificationLearnMore(this.$suggestion.getSuggesterId());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
    }
}

