/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.requests;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdNonConflictingPatchItemId;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.RdTransparentEditorChange;
import com.jetbrains.rd.ide.model.RdTransparentItem;
import com.jetbrains.rd.ide.model.TextControlId;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u001e\u0010\u000e\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0001\u001a$\u0010\u0010\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0014H\u0002\u001a$\u0010\u0016\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007H\u0002\u001a$\u0010\u0018\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007H\u0002\u00a8\u0006\u0019"}, d2={"isIntersecting", "", "Lcom/jetbrains/rd/ide/model/RdPatch;", "other", "intersectable", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemId;", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "updatingChange", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "oldVersion", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "newVersion", "speculativelyEquals", "allowEquivalentChanges", "areChangesEquivalent", "left", "right", "areDocumentChangesEqual", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "checkSubChange", "areCaretChangesEquivalent", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "areCaretChangesEquivalentPerEditorId", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nRdPatchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdPatchUtils.kt\ncom/jetbrains/rd/ide/requests/RdPatchUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n1557#2:142\n1628#2,3:143\n865#2,2:146\n774#2:148\n865#2,2:149\n774#2:151\n865#2,2:152\n808#2,11:154\n808#2,11:165\n1485#2:176\n1510#2,3:177\n1513#2,3:187\n1485#2:190\n1510#2,3:191\n1513#2,3:201\n381#3,7:180\n381#3,7:194\n168#4,3:204\n58#5:207\n36#5,2:208\n*S KotlinDebug\n*F\n+ 1 RdPatchUtils.kt\ncom/jetbrains/rd/ide/requests/RdPatchUtilsKt\n*L\n19#1:142\n19#1:143,3\n19#1:146,2\n28#1:148\n28#1:149,2\n29#1:151\n29#1:152,2\n38#1:154,11\n39#1:165,11\n103#1:176\n103#1:177,3\n103#1:187,3\n104#1:190\n104#1:191,3\n104#1:201,3\n103#1:180,7\n104#1:194,7\n106#1:204,3\n119#1:207\n119#1:208,2\n*E\n"})
public final class RdPatchUtilsKt {
    public static final boolean isIntersecting(@NotNull RdPatch $this$isIntersecting, @NotNull RdPatch other) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntersecting, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Set<RdPatchItemId> thisExpected = RdPatchUtilsKt.intersectable($this$isIntersecting.getExpectedItemVersions());
        Set<RdPatchItemId> thisUpdated = RdPatchUtilsKt.intersectable($this$isIntersecting.getUpdatedItemVersions());
        Set<RdPatchItemId> otherExpected = RdPatchUtilsKt.intersectable(other.getExpectedItemVersions());
        Set<RdPatchItemId> otherUpdated = RdPatchUtilsKt.intersectable(other.getUpdatedItemVersions());
        return !((Collection)CollectionsKt.intersect((Iterable)thisExpected, (Iterable)otherUpdated)).isEmpty() || !((Collection)CollectionsKt.intersect((Iterable)thisUpdated, (Iterable)otherExpected)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<RdPatchItemId> intersectable(@NotNull List<? extends RdPatchItemVersion> $this$intersectable) {
        void var2_3;
        void $this$filterTo$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$intersectable, (String)"<this>");
        Iterable $this$map$iv = $this$intersectable;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdPatchItemVersion rdPatchItemVersion = (RdPatchItemVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            RdPatchItemId it = (RdPatchItemId)element$iv;
            boolean bl = false;
            if (!(!(it instanceof RdNonConflictingPatchItemId))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var2_3;
    }

    public static final boolean updatingChange(@NotNull RdPatchItem $this$updatingChange, @NotNull RdEditorVersion oldVersion, @NotNull RdEditorVersion newVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$updatingChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return !($this$updatingChange instanceof RdTransparentEditorChange) && !Intrinsics.areEqual((Object)oldVersion, (Object)newVersion);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean speculativelyEquals(@Nullable RdPatch $this$speculativelyEquals, @Nullable RdPatch other, boolean allowEquivalentChanges) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        if ($this$speculativelyEquals == other) {
            return true;
        }
        if ($this$speculativelyEquals == null || other == null) {
            return false;
        }
        Iterable $this$filter$iv = $this$speculativelyEquals.getChanges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RdPatchItem it = (RdPatchItem)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof RdTransparentItem))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List a_ = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = other.getChanges();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RdPatchItem it = (RdPatchItem)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof RdTransparentItem))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List b_ = (List)destination$iv$iv2;
        if (Intrinsics.areEqual((Object)a_, (Object)b_)) {
            return true;
        }
        return allowEquivalentChanges && RdPatchUtilsKt.areChangesEquivalent(a_, b_);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean areChangesEquivalent(List<? extends RdPatchItem> left, List<? extends RdPatchItem> right) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv = left;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof RdSelectionChangeBase)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List leftCaretChanges = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = right;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RdSelectionChangeBase)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List rightCaretChanges = (List)destination$iv$iv2;
        if (RdPatchUtilsKt.areCaretChangesEquivalent(leftCaretChanges, rightCaretChanges)) {
            List leftChanges = CollectionsKt.minus((Iterable)left, (Iterable)leftCaretChanges);
            List rightChanges = CollectionsKt.minus((Iterable)right, (Iterable)rightCaretChanges);
            if (leftChanges.size() != rightChanges.size()) {
                return false;
            }
            int n = ((Collection)leftChanges).size();
            for (int i2 = 0; i2 < n; ++i2) {
                RdPatchItem rightChange;
                RdPatchItem leftChange = (RdPatchItem)leftChanges.get(i2);
                if (Intrinsics.areEqual((Object)leftChange, (Object)(rightChange = (RdPatchItem)rightChanges.get(i2))) || leftChange instanceof RdDocumentChange && rightChange instanceof RdDocumentChange && RdPatchUtilsKt.areDocumentChangesEqual((RdDocumentChange)leftChange, (RdDocumentChange)rightChange)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static final boolean areDocumentChangesEqual(RdDocumentChange left, RdDocumentChange right) {
        if (Intrinsics.areEqual((Object)left.getDocumentId(), (Object)right.getDocumentId()) && left.getOffset() == right.getOffset() && left.getMoveOffset() == right.getMoveOffset() && Intrinsics.areEqual((Object)left.getNewText(), (Object)right.getNewText()) && Intrinsics.areEqual((Object)left.getOldText(), (Object)right.getOldText())) {
            return true;
        }
        if (left.getOldText().length() == right.getOldText().length()) {
            return false;
        }
        if (left.getOldText().length() > right.getOldText().length() && left.getNewText().length() > right.getNewText().length()) {
            return RdPatchUtilsKt.checkSubChange(left, right);
        }
        if (left.getOldText().length() < right.getOldText().length() && left.getNewText().length() < right.getNewText().length()) {
            return RdPatchUtilsKt.checkSubChange(right, left);
        }
        return false;
    }

    private static final boolean checkSubChange(RdDocumentChange left, RdDocumentChange right) {
        boolean bl;
        boolean bl2 = bl = left.getOldText().length() > right.getOldText().length() && left.getNewText().length() > right.getNewText().length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int start = right.getOffset() - left.getOffset();
        if (start < 0) {
            return false;
        }
        int oldLength = right.getOldText().length();
        int newLength = right.getNewText().length();
        return StringUtil.equals((CharSequence)StringsKt.take((String)left.getOldText(), (int)start), (CharSequence)StringsKt.take((String)left.getNewText(), (int)start)) && StringUtil.equals((CharSequence)StringsKt.drop((String)StringsKt.drop((String)left.getOldText(), (int)start), (int)oldLength), (CharSequence)StringsKt.drop((String)left.getNewText(), (int)(start + newLength))) && StringUtil.equals((CharSequence)StringsKt.take((String)StringsKt.drop((String)left.getOldText(), (int)start), (int)oldLength), (CharSequence)right.getOldText()) && StringUtil.equals((CharSequence)StringsKt.take((String)StringsKt.drop((String)left.getNewText(), (int)start), (int)newLength), (CharSequence)right.getNewText());
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean areCaretChangesEquivalent(List<? extends RdSelectionChangeBase> left, List<? extends RdSelectionChangeBase> right) {
        boolean bl;
        block10: {
            void $this$groupByTo$iv$iv;
            void $this$groupByTo$iv$iv2;
            Iterable $this$groupBy$iv = left;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                RdSelectionChangeBase it = (RdSelectionChangeBase)element$iv$iv;
                boolean bl2 = false;
                TextControlId key$iv$iv = it.getEditorId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map leftEditorToChanges = destination$iv$iv;
            Iterable $this$groupBy$iv2 = right;
            boolean $i$f$groupBy2 = false;
            destination$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                RdSelectionChangeBase it = (RdSelectionChangeBase)element$iv$iv;
                boolean bl4 = false;
                TextControlId key$iv$iv = it.getEditorId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map rightEditorToChanges = destination$iv$iv2;
            Map $this$all$iv = leftEditorToChanges;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    List rightPerEditorChanges;
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl6 = false;
                    List list = (List)rightEditorToChanges.get(it.getKey());
                    if (list == null) {
                        list = rightPerEditorChanges = CollectionsKt.emptyList();
                    }
                    if (RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId((List)it.getValue(), rightPerEditorChanges)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean areCaretChangesEquivalentPerEditorId(List<? extends RdSelectionChangeBase> left, List<? extends RdSelectionChangeBase> right) {
        List<RdCaret> leftInitialCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(left, true);
        List<RdCaret> rightInitialCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(right, true);
        List<RdCaret> leftFinalCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(left, false);
        List<RdCaret> rightFinalCarets = RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets(right, false);
        if (leftInitialCarets == null || rightInitialCarets == null) {
            return Intrinsics.areEqual(leftInitialCarets, leftFinalCarets) && Intrinsics.areEqual(rightInitialCarets, rightFinalCarets);
        }
        return Intrinsics.areEqual(leftFinalCarets, rightFinalCarets);
    }

    private static final List<RdCaret> areCaretChangesEquivalentPerEditorId$tryGetCarets(RdSelectionChangeBase $this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets, boolean old) {
        List<RdCaret> list;
        RdSelectionChangeBase rdSelectionChangeBase = $this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            list = (old ? ((RdCaretStateChange)$this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets).getOldState() : ((RdCaretStateChange)$this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets).getNewState()).getCarets();
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshotBase) {
            list = ((RdCaretStateSnapshotBase)$this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets).getState().getCarets();
        } else {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown caret change: " + $this$areCaretChangesEquivalentPerEditorId_u24tryGetCarets);
            list = null;
        }
        return list;
    }

    private static final List areCaretChangesEquivalentPerEditorId$getCarets$lambda$7(boolean $initial, RdSelectionChangeBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$tryGetCarets(it, $initial);
    }

    private static final List<RdCaret> areCaretChangesEquivalentPerEditorId$getCarets(List<? extends RdSelectionChangeBase> $this$areCaretChangesEquivalentPerEditorId_u24getCarets, boolean initial) {
        List list = initial ? $this$areCaretChangesEquivalentPerEditorId_u24getCarets : CollectionsKt.asReversed($this$areCaretChangesEquivalentPerEditorId_u24getCarets);
        return (List)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> RdPatchUtilsKt.areCaretChangesEquivalentPerEditorId$getCarets$lambda$7(initial, arg_0)));
    }
}

