/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.AddOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.ClimbUpOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.FilterNode;
import com.intellij.codeInsight.template.emmet.nodes.MoreOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.MulOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.TextNode;
import com.intellij.codeInsight.template.emmet.nodes.UnaryMulOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenEmptyNode;
import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.NumberToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingTokens;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class EmmetParser {
    private final List<? extends ZenCodingToken> myTokens;
    protected final CustomTemplateCallback myCallback;
    protected final ZenCodingGenerator myGenerator;
    private int myIndex = 0;

    public EmmetParser(List<? extends ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator) {
        this.myTokens = tokens;
        this.myCallback = callback;
        this.myGenerator = generator;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Nullable
    public ZenCodingNode parse() {
        ZenCodingNode add = this.parseAddOrMore();
        if (add == null) {
            return null;
        }
        ZenCodingNode result2 = add;
        ZenCodingToken token;
        while ((token = this.getToken()) == ZenCodingTokens.PIPE) {
            this.advance();
            token = this.getToken();
            if (!(token instanceof IdentifierToken)) {
                return null;
            }
            String filterSuffix = ((IdentifierToken)token).getText();
            if (ZenCodingUtil.checkFilterSuffix(filterSuffix)) {
                result2 = new FilterNode(result2, filterSuffix);
            }
            this.advance();
        }
        return result2;
    }

    @Nullable
    protected ZenCodingNode parseAddOrMore() {
        ZenCodingNode mul = this.parseMul(this.parseExpression());
        ZenCodingToken operationToken = this.getToken();
        if (operationToken == ZenCodingTokens.OPENING_R_BRACKET) {
            mul = this.parseMul(new MoreOperationNode(EmmetParser.notNullNode(mul), EmmetParser.notNullNode(this.parseExpression())));
            operationToken = this.getToken();
        }
        if (!(operationToken instanceof OperationToken)) {
            return mul;
        }
        char sign = ((OperationToken)operationToken).getSign();
        if (sign == '^') {
            return this.parseClimbUpOperation(mul);
        }
        if (sign == '+') {
            this.advance();
            ZenCodingNode add2 = this.parseAddOrMore();
            if (add2 == null) {
                return mul;
            }
            return new AddOperationNode(EmmetParser.notNullNode(mul), add2);
        }
        if (sign == '>') {
            return this.parseMoreOperation(mul);
        }
        return null;
    }

    @Nullable
    protected ZenCodingNode parseClimbUpOperation(@Nullable ZenCodingNode leftPart) {
        this.advance();
        ZenCodingNode rightPart = this.parseAddOrMore();
        if (rightPart == null) {
            return leftPart;
        }
        return new ClimbUpOperationNode(EmmetParser.notNullNode(leftPart), rightPart);
    }

    @Nullable
    protected ZenCodingNode parseMoreOperation(@Nullable ZenCodingNode leftPart) {
        this.advance();
        ZenCodingNode rightPart = this.parseAddOrMore();
        if (rightPart == null) {
            return leftPart;
        }
        return new MoreOperationNode(EmmetParser.notNullNode(leftPart), rightPart);
    }

    private static ZenCodingNode notNullNode(ZenCodingNode node) {
        return node != null ? node : ZenEmptyNode.INSTANCE;
    }

    protected int advance() {
        return this.myIndex++;
    }

    @Nullable
    private ZenCodingNode parseMul(@Nullable ZenCodingNode expression) {
        ZenCodingToken operationToken = this.getToken();
        if (expression != null && operationToken instanceof OperationToken && ((OperationToken)operationToken).getSign() == '*') {
            this.advance();
            ZenCodingToken numberToken = this.getToken();
            if (numberToken instanceof NumberToken) {
                this.advance();
                return new MulOperationNode(expression, ((NumberToken)numberToken).getNumber());
            }
            return new UnaryMulOperationNode(expression);
        }
        return expression;
    }

    @Nullable
    private ZenCodingNode parseExpression() {
        ZenCodingToken token = this.getToken();
        if (token == ZenCodingTokens.OPENING_R_BRACKET) {
            this.advance();
            ZenCodingNode add = this.parseAddOrMore();
            if (add == null) {
                return null;
            }
            ZenCodingToken closingBrace = this.getToken();
            if (closingBrace != ZenCodingTokens.CLOSING_R_BRACKET) {
                return null;
            }
            this.advance();
            return add;
        }
        if (token instanceof TextToken) {
            this.advance();
            return new TextNode((TextToken)token);
        }
        ZenCodingNode templateNode = this.parseTemplate();
        if (templateNode == null) {
            return null;
        }
        token = this.getToken();
        if (token instanceof TextToken) {
            this.advance();
            return new MoreOperationNode(templateNode, new TextNode((TextToken)token));
        }
        return templateNode;
    }

    @Nullable
    protected ZenCodingNode parseTemplate() {
        ZenCodingToken token = this.getToken();
        if (!(token instanceof IdentifierToken)) {
            return null;
        }
        String templateKey = ((IdentifierToken)token).getText();
        this.advance();
        TemplateImpl template = this.myCallback.findApplicableTemplate(templateKey);
        if (template == null && !ZenCodingUtil.isXML11ValidQName(templateKey)) {
            return null;
        }
        TemplateToken templateToken = new TemplateToken(templateKey);
        if (!this.setTemplate(templateToken, template)) {
            return null;
        }
        return new TemplateNode(templateToken);
    }

    protected boolean setTemplate(TemplateToken token, TemplateImpl template) {
        if (template == null) {
            template = this.myGenerator.createTemplateByKey(token.getKey(), token.isForceSingleTag());
        }
        if (template == null) {
            return false;
        }
        token.setTemplate(template, this.myCallback);
        return true;
    }

    @Nullable
    protected ZenCodingToken getToken() {
        if (this.myIndex < this.myTokens.size()) {
            return this.myTokens.get(this.myIndex);
        }
        return null;
    }

    @Nullable
    protected ZenCodingToken nextToken(int i) {
        if (this.myIndex + i < this.myTokens.size()) {
            return this.myTokens.get(this.myIndex + i);
        }
        return null;
    }

    protected int getCurrentPosition() {
        return this.myIndex;
    }

    protected void restorePosition(int position) {
        this.myIndex = position;
    }
}

