/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core;

import ai.grazie.emb.FloatTextEmbedding;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMixedListInfo;
import com.intellij.ide.actions.searcheverywhere.SearchRestartReason;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.searchEverywhereMl.SearchEverywhereMlExperiment;
import com.intellij.searchEverywhereMl.TextEmbeddingProvider;
import com.intellij.searchEverywhereMl.ranking.core.FeaturesLoggingRandomisation;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereFoundElementInfoWithMl;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLContextInfo;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLStatisticsCollector;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlFeaturesCache;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlSearchState;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCacheDataProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereContributorStatisticianKt;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereStatisticianService;
import com.intellij.searchEverywhereMl.ranking.core.id.MissingKeyProviderCollector;
import com.intellij.searchEverywhereMl.ranking.core.id.SearchEverywhereMlOrderedItemIdProvider;
import com.intellij.searchEverywhereMl.ranking.core.model.SearchEverywhereModelProvider;
import com.intellij.searchEverywhereMl.ranking.core.performance.PerformanceTracker;
import com.intellij.searchEverywhereMl.ranking.core.utils.NaturalLanguageKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJn\u0010-\u001a\u00020.2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u001e2\u0012\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0:2\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u000205JJ\u0010@\u001a\u00020.2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010/\u001a\u0002002\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00010;2\u0006\u0010D\u001a\u0002052\u0012\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0:J,\u0010F\u001a\u00020.2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010/\u001a\u0002002\u0012\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0:J\u0006\u0010G\u001a\u00020.J\b\u0010H\u001a\u0004\u0018\u00010(J\u0018\u0010I\u001a\u0004\u0018\u00010!2\u0006\u00108\u001a\u00020\u001e2\u0006\u0010J\u001a\u000205R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u001c\u001a'\u0012\u000e\u0012\f0\u001e\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\b \u0012\u000e\u0012\f0!\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\b 0\u001d\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "mixedListInfo", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "sessionId", "", "loggingRandomisation", "Lcom/intellij/searchEverywhereMl/ranking/core/FeaturesLoggingRandomisation;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;ILcom/intellij/searchEverywhereMl/ranking/core/FeaturesLoggingRandomisation;)V", "getMixedListInfo", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "itemIdProvider", "Lcom/intellij/searchEverywhereMl/ranking/core/id/SearchEverywhereMlOrderedItemIdProvider;", "getItemIdProvider", "()Lcom/intellij/searchEverywhereMl/ranking/core/id/SearchEverywhereMlOrderedItemIdProvider;", "sessionStartTime", "", "getSessionStartTime", "()J", "providersCache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "modelProviderWithCache", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SearchEverywhereModelProvider;", "featureCache", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMlFeaturesCache;", "embeddingCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "Lai/grazie/emb/FloatTextEmbedding;", "cachedContextInfo", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLContextInfo;", "getCachedContextInfo", "()Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLContextInfo;", "currentSearchState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMlSearchState;", "logger", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLStatisticsCollector;", "performanceTracker", "Lcom/intellij/searchEverywhereMl/ranking/core/performance/PerformanceTracker;", "onSearchRestart", "", "experimentStrategy", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment;", "reason", "Lcom/intellij/ide/actions/searcheverywhere/SearchRestartReason;", "tabId", "orderByMl", "", "keysTyped", "backspacesTyped", "searchQuery", "previousElementsProvider", "Lkotlin/Function0;", "", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereFoundElementInfoWithMl;", "searchScope", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "isSearchEverywhere", "onItemSelected", "indexes", "", "selectedItems", "closePopup", "elementsProvider", "onSearchFinished", "notifySearchResultsUpdated", "getCurrentSearchState", "getSearchQueryEmbedding", "split", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMLSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n40#2,3:165\n1863#3,2:168\n1863#3,2:170\n1#4:172\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession\n*L\n99#1:165,3\n100#1:168,2\n105#1:170,2\n*E\n"})
public final class SearchEverywhereMLSearchSession {
    @NotNull
    private final SearchEverywhereMixedListInfo mixedListInfo;
    private final int sessionId;
    @NotNull
    private final FeaturesLoggingRandomisation loggingRandomisation;
    @NotNull
    private final SearchEverywhereMlOrderedItemIdProvider itemIdProvider;
    private final long sessionStartTime;
    @Nullable
    private final FeaturesProviderCache providersCache;
    @NotNull
    private final SearchEverywhereModelProvider modelProviderWithCache;
    @NotNull
    private final SearchEverywhereMlFeaturesCache featureCache;
    @NotNull
    private final ConcurrentMap<String, FloatTextEmbedding> embeddingCache;
    @NotNull
    private final SearchEverywhereMLContextInfo cachedContextInfo;
    @NotNull
    private final AtomicReference<SearchEverywhereMlSearchState> currentSearchState;
    @NotNull
    private final SearchEverywhereMLStatisticsCollector logger;
    @NotNull
    private final PerformanceTracker performanceTracker;

    public SearchEverywhereMLSearchSession(@Nullable Project project, @NotNull SearchEverywhereMixedListInfo mixedListInfo, int sessionId, @NotNull FeaturesLoggingRandomisation loggingRandomisation) {
        Intrinsics.checkNotNullParameter((Object)mixedListInfo, (String)"mixedListInfo");
        Intrinsics.checkNotNullParameter((Object)loggingRandomisation, (String)"loggingRandomisation");
        this.mixedListInfo = mixedListInfo;
        this.sessionId = sessionId;
        this.loggingRandomisation = loggingRandomisation;
        this.itemIdProvider = new SearchEverywhereMlOrderedItemIdProvider((Function1<Object, Unit>)((Function1)SearchEverywhereMLSearchSession::itemIdProvider$lambda$0));
        this.sessionStartTime = System.currentTimeMillis();
        this.providersCache = new FeaturesProviderCacheDataProvider().getDataToCache(project);
        this.modelProviderWithCache = new SearchEverywhereModelProvider();
        this.featureCache = new SearchEverywhereMlFeaturesCache();
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.embeddingCache = concurrentMap;
        this.cachedContextInfo = new SearchEverywhereMLContextInfo(project);
        this.currentSearchState = new AtomicReference();
        this.logger = SearchEverywhereMLStatisticsCollector.INSTANCE;
        this.performanceTracker = new PerformanceTracker();
    }

    @NotNull
    public final SearchEverywhereMixedListInfo getMixedListInfo() {
        return this.mixedListInfo;
    }

    @NotNull
    public final SearchEverywhereMlOrderedItemIdProvider getItemIdProvider() {
        return this.itemIdProvider;
    }

    public final long getSessionStartTime() {
        return this.sessionStartTime;
    }

    @NotNull
    public final SearchEverywhereMLContextInfo getCachedContextInfo() {
        return this.cachedContextInfo;
    }

    public final void onSearchRestart(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull SearchRestartReason reason, @NotNull String tabId, boolean orderByMl, int keysTyped, int backspacesTyped, @NotNull String searchQuery, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> previousElementsProvider, @Nullable ScopeDescriptor searchScope, boolean isSearchEverywhere) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter(previousElementsProvider, (String)"previousElementsProvider");
        int prevTimeToResult = this.performanceTracker.getTimeElapsed();
        SearchEverywhereMlSearchState prevState = this.currentSearchState.getAndUpdate(arg_0 -> SearchEverywhereMLSearchSession.onSearchRestart$lambda$1(reason, experimentStrategy, this, tabId, orderByMl, keysTyped, backspacesTyped, searchQuery, project, searchScope, isSearchEverywhere, arg_0));
        if (prevState != null && experimentStrategy.isLoggingEnabledForTab(prevState.getTabId())) {
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(prevState.getTabId());
            this.logger.onSearchRestarted$intellij_searchEverywhereMl_ranking_core(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, this.cachedContextInfo, prevState, this.featureCache, prevTimeToResult, this.mixedListInfo, previousElementsProvider);
        }
    }

    public final void onItemSelected(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull int[] indexes, @NotNull List<? extends Object> selectedItems, boolean closePopup, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> elementsProvider) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        Intrinsics.checkNotNullParameter(elementsProvider, (String)"elementsProvider");
        SearchEverywhereMlSearchState state = this.getCurrentSearchState();
        if (state != null && experimentStrategy.isLoggingEnabledForTab(state.getTabId())) {
            if (project != null) {
                Object it;
                boolean $i$f$service = false;
                Class<SearchEverywhereStatisticianService> serviceClass$iv = SearchEverywhereStatisticianService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                SearchEverywhereStatisticianService statisticianService = (SearchEverywhereStatisticianService)object;
                Iterable $this$forEach$iv = selectedItems;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    it = element$iv = iterator.next();
                    boolean bl = false;
                    statisticianService.increaseUseCount(it);
                }
                if (Intrinsics.areEqual((Object)state.getTabId(), (Object)"SearchEverywhereContributor.All")) {
                    $this$forEach$iv = CollectionsKt.slice((List)((List)elementsProvider.invoke()), (Iterable)ArraysKt.asIterable((int[])indexes));
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (SearchEverywhereFoundElementInfoWithMl)((Object)element$iv);
                        boolean bl = false;
                        String string = ((SearchEverywhereFoundElementInfoWithMl)((Object)it)).contributor.getSearchProviderId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchProviderId(...)");
                        SearchEverywhereContributorStatisticianKt.increaseContributorUseCount(string);
                    }
                }
            }
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(state.getTabId());
            this.logger.onItemSelected$intellij_searchEverywhereMl_ranking_core(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, state, this.featureCache, indexes, selectedItems, closePopup, this.performanceTracker.getTimeElapsed(), this.mixedListInfo, elementsProvider);
        }
        if (closePopup) {
            MissingKeyProviderCollector.INSTANCE.report(this.sessionId);
        }
    }

    public final void onSearchFinished(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> elementsProvider) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter(elementsProvider, (String)"elementsProvider");
        SearchEverywhereMlSearchState state = this.getCurrentSearchState();
        if (state != null && experimentStrategy.isLoggingEnabledForTab(state.getTabId())) {
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(state.getTabId());
            this.logger.onSearchFinished$intellij_searchEverywhereMl_ranking_core(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, state, this.featureCache, this.performanceTracker.getTimeElapsed(), this.mixedListInfo, elementsProvider);
        }
        MissingKeyProviderCollector.INSTANCE.report(this.sessionId);
    }

    public final void notifySearchResultsUpdated() {
        this.performanceTracker.stop();
    }

    @Nullable
    public final SearchEverywhereMlSearchState getCurrentSearchState() {
        return this.currentSearchState.get();
    }

    @Nullable
    public final FloatTextEmbedding getSearchQueryEmbedding(@NotNull String searchQuery, boolean split) {
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        FloatTextEmbedding floatTextEmbedding = (FloatTextEmbedding)this.embeddingCache.get(searchQuery);
        if (floatTextEmbedding == null) {
            FloatTextEmbedding floatTextEmbedding2;
            TextEmbeddingProvider textEmbeddingProvider = TextEmbeddingProvider.Companion.getProvider();
            if (textEmbeddingProvider != null && (floatTextEmbedding2 = textEmbeddingProvider.embed(split ? NaturalLanguageKt.convertNameToNaturalLanguage(searchQuery) : searchQuery)) != null) {
                FloatTextEmbedding floatTextEmbedding3;
                FloatTextEmbedding it = floatTextEmbedding3 = floatTextEmbedding2;
                boolean bl = false;
                ((Map)this.embeddingCache).put(searchQuery, it);
                floatTextEmbedding = floatTextEmbedding3;
            } else {
                floatTextEmbedding = null;
            }
        }
        return floatTextEmbedding;
    }

    private static final Unit itemIdProvider$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MissingKeyProviderCollector.INSTANCE.addMissingProviderForClass(it.getClass());
        return Unit.INSTANCE;
    }

    private static final SearchEverywhereMlSearchState onSearchRestart$lambda$1(SearchRestartReason $reason, SearchEverywhereMlExperiment $experimentStrategy, SearchEverywhereMLSearchSession this$0, String $tabId, boolean $orderByMl, int $keysTyped, int $backspacesTyped, String $searchQuery, Project $project, ScopeDescriptor $searchScope, boolean $isSearchEverywhere, SearchEverywhereMlSearchState prevState) {
        long startTime = System.currentTimeMillis();
        SearchRestartReason searchReason = prevState == null ? SearchRestartReason.SEARCH_STARTED : $reason;
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = prevState;
        int nextSearchIndex = (searchEverywhereMlSearchState != null ? searchEverywhereMlSearchState.getSearchIndex() : 0) + 1;
        int experimentGroup = $experimentStrategy.getExperimentGroup();
        this$0.performanceTracker.start();
        return new SearchEverywhereMlSearchState(this$0.sessionStartTime, startTime, nextSearchIndex, searchReason, $tabId, experimentGroup, $orderByMl, $keysTyped, $backspacesTyped, $searchQuery, this$0.modelProviderWithCache, this$0.providersCache, $project, $searchScope, $isSearchEverywhere);
    }
}

