/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyParamSpecType
implements PyTypeParameterType {
    @NotNull
    private final String myName;
    @Nullable
    private final PyQualifiedNameOwner myDeclarationElement;
    @Nullable
    private final List<PyCallableParameter> myParameters;
    @Nullable
    private final PyType myDefaultType;
    @Nullable
    private final PyQualifiedNameOwner myScopeOwner;

    public PyParamSpecType(@NotNull String name2) {
        if (name2 == null) {
            PyParamSpecType.$$$reportNull$$$0(0);
        }
        this(name2, null, null, null, null);
    }

    private PyParamSpecType(@NotNull String name2, @Nullable PyQualifiedNameOwner declarationElement, @Nullable List<PyCallableParameter> parameters, @Nullable PyType defaultType, @Nullable PyQualifiedNameOwner scopeOwner) {
        if (name2 == null) {
            PyParamSpecType.$$$reportNull$$$0(1);
        }
        this.myName = name2;
        this.myDeclarationElement = declarationElement;
        this.myParameters = parameters;
        this.myDefaultType = defaultType;
        this.myScopeOwner = scopeOwner;
    }

    @NotNull
    public PyParamSpecType withParameters(@Nullable List<PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyParamSpecType.$$$reportNull$$$0(2);
        }
        return new PyParamSpecType(this.myName, this.myDeclarationElement, PyParamSpecType.getNonPsiParameters(parameters, context), this.myDefaultType, this.myScopeOwner);
    }

    @NotNull
    public PyParamSpecType withDeclarationElement(@Nullable PyQualifiedNameOwner declarationElement) {
        return new PyParamSpecType(this.myName, declarationElement, this.myParameters, this.myDefaultType, this.myScopeOwner);
    }

    @NotNull
    public PyParamSpecType withScopeOwner(@Nullable PyQualifiedNameOwner scopeOwner) {
        return new PyParamSpecType(this.myName, this.myDeclarationElement, this.myParameters, this.myDefaultType, scopeOwner);
    }

    @NotNull
    public PyParamSpecType withDefaultType(@Nullable PyType defaultType) {
        return new PyParamSpecType(this.myName, this.myDeclarationElement, this.myParameters, defaultType, this.myScopeOwner);
    }

    @Nullable
    private static List<PyCallableParameter> getNonPsiParameters(@Nullable List<PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyParamSpecType.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            return null;
        }
        return ContainerUtil.map(parameters, it -> {
            if (it.isPositionalContainer()) {
                return PyCallableParameterImpl.positionalNonPsi(it.getName(), it.getType(context));
            }
            if (it.isKeywordContainer()) {
                return PyCallableParameterImpl.keywordNonPsi(it.getName(), it.getType(context));
            }
            return PyCallableParameterImpl.nonPsi(it.getName(), it.getType(context));
        });
    }

    @Nullable
    public List<PyCallableParameter> getParameters() {
        return this.myParameters;
    }

    @Override
    @Nullable
    public PyQualifiedNameOwner getDeclarationElement() {
        return this.myDeclarationElement;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name2 == null) {
            PyParamSpecType.$$$reportNull$$$0(4);
        }
        if (direction == null) {
            PyParamSpecType.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            PyParamSpecType.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myParameters == null) {
            String string = String.format("ParamSpec(\"%s\")", this.myName);
            if (string == null) {
                PyParamSpecType.$$$reportNull$$$0(7);
            }
            return string;
        }
        TypeEvalContext context = TypeEvalContext.codeInsightFallback(null);
        String string = String.format("[%s]", StringUtil.join(this.myParameters, param -> {
            if (param != null) {
                PyType type2 = param.getType(context);
                return type2 != null ? type2.getName() : "Any";
            }
            return "Any";
        }, (String)", "));
        if (string == null) {
            PyParamSpecType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public PyQualifiedNameOwner getScopeOwner() {
        return this.myScopeOwner;
    }

    @Override
    @Nullable
    public PyType getDefaultType() {
        return this.myDefaultType;
    }

    @NotNull
    public String getVariableName() {
        String string = this.myName;
        if (string == null) {
            PyParamSpecType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyParamSpecType type2 = (PyParamSpecType)o;
        return this.myName.equals(type2.myName) && Objects.equals(this.myScopeOwner, type2.myScopeOwner) && Objects.equals(this.myParameters, type2.myParameters);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyParamSpecType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyParamSpecType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNonPsiParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

