/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.data.util.VcsCommitsDataLoader;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J6\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u0013\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/ui/table/column/util/CachingVcsCommitsDataLoader;", "T", "Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;", "loader", "cacheSize", "", "<init>", "(Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;J)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/vcs/log/CommitId;", "kotlin.jvm.PlatformType", "Lcom/github/benmanes/caffeine/cache/Cache;", "loadData", "", "commits", "", "onChange", "Lkotlin/Function1;", "", "getData", "commit", "(Lcom/intellij/vcs/log/CommitId;)Ljava/lang/Object;", "dispose", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class CachingVcsCommitsDataLoader<T>
implements VcsCommitsDataLoader<T> {
    @NotNull
    private final VcsCommitsDataLoader<T> loader;
    private final Cache<CommitId, T> cache;

    public CachingVcsCommitsDataLoader(@NotNull VcsCommitsDataLoader<T> loader, long cacheSize) {
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        this.loader = loader;
        this.cache = Caffeine.newBuilder().maximumSize(cacheSize).build();
        Disposer.register((Disposable)this, (Disposable)this.loader);
    }

    public /* synthetic */ CachingVcsCommitsDataLoader(VcsCommitsDataLoader vcsCommitsDataLoader, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 150L;
        }
        this(vcsCommitsDataLoader, l);
    }

    @Override
    public void loadData(@NotNull List<CommitId> commits, @NotNull Function1<? super Map<CommitId, ? extends T>, Unit> onChange) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
        this.loader.loadData(commits, arg_0 -> CachingVcsCommitsDataLoader.loadData$lambda$0(this, onChange, arg_0));
    }

    @RequiresEdt
    @Nullable
    public final T getData(@NotNull CommitId commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return (T)this.cache.getIfPresent((Object)commit);
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private static final Unit loadData$lambda$0(CachingVcsCommitsDataLoader this$0, Function1 $onChange, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cache.putAll(it);
        $onChange.invoke((Object)it);
        return Unit.INSTANCE;
    }
}

