/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.CharsetEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ApplyTextFilePatch
extends ApplyFilePatchBase<TextFilePatch> {
    public ApplyTextFilePatch(TextFilePatch patch) {
        super(patch);
    }

    @Override
    @NotNull
    protected ApplyFilePatch.Result applyChange(final @NotNull Project project, final @NotNull VirtualFile fileToPatch, final @NotNull FilePath pathBeforeRename, final @Nullable Supplier<? extends CharSequence> baseContents) throws IOException {
        ApplyPatchStatus status;
        Document document;
        if (project == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(0);
        }
        if (fileToPatch == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(1);
        }
        if (pathBeforeRename == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(2);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(fileToPatch)) == null) {
            throw new IOException("Failed to set contents for updated file " + fileToPatch.getPath());
        }
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(document.getText(), ((TextFilePatch)this.myPatch).getHunks());
        if (appliedPatch != null) {
            if (appliedPatch.status == ApplyPatchStatus.ALREADY_APPLIED) {
                return new ApplyFilePatch.Result(appliedPatch.status);
            }
            if (appliedPatch.status == ApplyPatchStatus.SUCCESS) {
                VcsFacade.getInstance().runHeavyModificationTask(project, document, () -> document.setText((CharSequence)appliedPatch.patchedText));
                FileDocumentManager.getInstance().saveDocument(document);
                return new ApplyFilePatch.Result(appliedPatch.status);
            }
        }
        ApplyPatchStatus applyPatchStatus = status = appliedPatch != null ? appliedPatch.status : ApplyPatchStatus.FAILURE;
        assert (status == ApplyPatchStatus.PARTIAL || status == ApplyPatchStatus.FAILURE);
        return new ApplyFilePatch.Result(status){

            @Override
            public ApplyPatchForBaseRevisionTexts getMergeData() {
                return ApplyPatchForBaseRevisionTexts.create(project, fileToPatch, pathBeforeRename, (TextFilePatch)ApplyTextFilePatch.this.myPatch, baseContents != null ? (CharSequence)baseContents.get() : null);
            }
        };
    }

    @Override
    protected void applyCreate(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable CommitContext commitContext) throws IOException {
        String charsetName;
        Document document;
        if (project == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(3);
        }
        if (newFile == null) {
            ApplyTextFilePatch.$$$reportNull$$$0(4);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(newFile)) == null) {
            throw new IOException("Failed to set contents for new file " + newFile.getPath());
        }
        String string = charsetName = commitContext == null ? null : CharsetEP.getCharset(newFile.getPath(), commitContext);
        if (charsetName != null) {
            try {
                newFile.setCharset(Charset.forName(charsetName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        document.setText((CharSequence)((TextFilePatch)this.myPatch).getSingleHunkPatchText());
        FileDocumentManager.getInstance().saveDocument(document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToPatch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeRename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/apply/ApplyTextFilePatch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCreate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

