/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaUtil;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class YamlMetaClass
extends YamlMetaType {
    private final List<Field> myFeatures;
    private final List<Field> myFeaturesRO;

    public YamlMetaClass(@NonNls @NotNull String typeName) {
        if (typeName == null) {
            YamlMetaClass.$$$reportNull$$$0(0);
        }
        super(typeName);
        this.myFeatures = new LinkedList<Field>();
        this.myFeaturesRO = Collections.unmodifiableList(this.myFeatures);
    }

    protected YamlMetaClass(@NotNull String typeName, @NotNull String displayName) {
        if (typeName == null) {
            YamlMetaClass.$$$reportNull$$$0(1);
        }
        if (displayName == null) {
            YamlMetaClass.$$$reportNull$$$0(2);
        }
        super(typeName, displayName);
        this.myFeatures = new LinkedList<Field>();
        this.myFeaturesRO = Collections.unmodifiableList(this.myFeatures);
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(3);
        }
        if (this.getFeatures().isEmpty()) {
            return null;
        }
        Optional<Field> byExactName = this.getFeatures().stream().filter(f -> !f.isByPattern() && name.equals(f.getName())).findAny();
        return byExactName.orElse((Field)ContainerUtil.find(this.getFeatures(), f -> f.isByPattern() && f.acceptsFieldName(name)));
    }

    @Override
    @NotNull
    public List<String> computeMissingFields(@NotNull Set<String> existingFields) {
        if (existingFields == null) {
            YamlMetaClass.$$$reportNull$$$0(4);
        }
        List<String> list = this.myFeatures.stream().filter(Field::isRequired).map(Field::getName).filter(name -> !existingFields.contains(name)).collect(Collectors.toList());
        if (list == null) {
            YamlMetaClass.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Field> computeKeyCompletions(@Nullable YAMLMapping existingMapping) {
        List list = ContainerUtil.filter(this.myFeatures, Field::isEditable);
        if (list == null) {
            YamlMetaClass.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<Field> getFeatures() {
        List<Field> list = this.myFeaturesRO;
        if (list == null) {
            YamlMetaClass.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected final Field addStringFeature(@NotNull String name) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(8);
        }
        Field field = this.addFeature(new Field(name, YamlStringType.getInstance()));
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(9);
        }
        return field;
    }

    @NotNull
    protected Field addBooleanFeature(@NotNull String name) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(10);
        }
        return this.addScalarFeature(name, YamlBooleanType.getSharedInstance());
    }

    @NotNull
    protected final Field addScalarFeature(@NotNull YamlScalarType type) {
        if (type == null) {
            YamlMetaClass.$$$reportNull$$$0(11);
        }
        return this.addScalarFeature(type.getTypeName(), type);
    }

    @NotNull
    protected final Field addScalarFeature(@NotNull String name, @NotNull YamlScalarType type) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(12);
        }
        if (type == null) {
            YamlMetaClass.$$$reportNull$$$0(13);
        }
        Field field = this.addFeature(new Field(name, type));
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(14);
        }
        return field;
    }

    @NotNull
    protected final Field addObjectFeature(@NotNull YamlMetaClass metaClass) {
        if (metaClass == null) {
            YamlMetaClass.$$$reportNull$$$0(15);
        }
        Field field = this.addFeature(new Field(metaClass.getTypeName(), metaClass));
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(16);
        }
        return field;
    }

    protected <T extends Field> T addFeature(@NotNull T child) {
        if (child == null) {
            YamlMetaClass.$$$reportNull$$$0(17);
        }
        this.myFeatures.add(child);
        return child;
    }

    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlMetaClass.$$$reportNull$$$0(18);
        }
        if (relation == null) {
            YamlMetaClass.$$$reportNull$$$0(19);
        }
        if (iteration == null) {
            YamlMetaClass.$$$reportNull$$$0(20);
        }
        switch (relation) {
            case SCALAR_VALUE: {
                throw new IllegalArgumentException("Default relation " + relation + " requested for complex type: " + this);
            }
            case OBJECT_CONTENTS: {
                this.doBuildInsertionSuffixMarkup(markup, false, iteration);
                break;
            }
            case SEQUENCE_ITEM: {
                this.doBuildInsertionSuffixMarkup(markup, true, iteration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation: " + relation);
            }
        }
    }

    @Override
    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        if (value == null) {
            YamlMetaClass.$$$reportNull$$$0(21);
        }
        if (problemsHolder == null) {
            YamlMetaClass.$$$reportNull$$$0(22);
        }
        super.validateValue(value, problemsHolder);
        if (value instanceof YAMLScalar && !YamlMetaUtil.isNull(value)) {
            problemsHolder.registerProblem((PsiElement)value, YAMLBundle.message((String)"YamlMetaClass.error.scalar.value", (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY), new LocalQuickFix[0]);
        }
    }

    private void doBuildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, boolean manyNotOne, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlMetaClass.$$$reportNull$$$0(23);
        }
        if (iteration == null) {
            YamlMetaClass.$$$reportNull$$$0(24);
        }
        markup.append(":");
        markup.doTabbedBlock(manyNotOne ? 2 : 1, () -> {
            markup.newLineAndTabs(manyNotOne);
            List allRequired = ContainerUtil.filter(this.myFeatures, field -> field.isRequired() || iteration.isNextOnPath((Field)field));
            if (allRequired.isEmpty() && iteration.isEndOfPathReached()) {
                markup.appendCaret();
            } else {
                Iterator iterator = allRequired.iterator();
                while (iterator.hasNext()) {
                    Field field2 = (Field)iterator.next();
                    YamlMetaClass.buildCompleteKeyMarkup(markup, field2, iteration.nextIterationFor(field2));
                    if (!iterator.hasNext()) continue;
                    markup.newLineAndTabs();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 9, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFields";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaClass";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteration";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMissingFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeKeyCompletions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addStringFeature";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addScalarFeature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addObjectFeature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureByName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeMissingFields";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStringFeature";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addBooleanFeature";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addScalarFeature";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addObjectFeature";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFeature";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildInsertionSuffixMarkup";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateValue";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doBuildInsertionSuffixMarkup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 9, 14, 16 -> new IllegalStateException(string);
        };
    }
}

