/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension5;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceAcquirer;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContextListener;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.DefaultServerOutputReader;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLQueryTransformer;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLScript;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.sql.transformers.SQLQueryTransformerCount;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.jobs.DataSourceMonitorJob;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceSystemAgent;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.CompositeSelectionProvider;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.TabFolderReorder;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.dbeaver.ui.controls.resultset.IQueryExecuteController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainerExt;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetValueReflector;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.EditorPartContextualProperty;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IActionContributor;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.IStatefulEditor;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorFeatures;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputConsoleViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorParametersProvider;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLScriptBindingType;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddIn;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddInDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddInsRegistry;
import org.jkiss.dbeaver.ui.editors.sql.commands.MultipleResultsPerTabMenuContribution;
import org.jkiss.dbeaver.ui.editors.sql.execute.SQLQueryJob;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.log.SQLLogPanel;
import org.jkiss.dbeaver.ui.editors.sql.plan.ExplainPlanViewer;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationPanelDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationRegistry;
import org.jkiss.dbeaver.ui.editors.sql.scripts.ScriptsHandlerImpl;
import org.jkiss.dbeaver.ui.editors.sql.suggestion.SQLSuggestionTextPainter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLEditorCompletionContext;
import org.jkiss.dbeaver.ui.editors.sql.variables.AssignVariableAction;
import org.jkiss.dbeaver.ui.editors.sql.variables.SQLVariablesPanel;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.Pair;

public class SQLEditor
extends SQLEditorBase
implements IDataSourceContainerUpdate,
DBPEventListener,
ISaveablePart2,
DBPDataSourceTask,
DBPDataSourceAcquirer,
IResultSetProvider,
ISmartTransactionManager,
IStatefulEditor {
    private static final long SCRIPT_UI_UPDATE_PERIOD = 100L;
    private static final int QUERIES_COUNT_FOR_NO_FETCH_RESULT_SET_CONFIRMATION = 100;
    private static final String PANEL_ITEM_PREFIX = "SQLPanelToggle:";
    private static final String EMBEDDED_BINDING_PREFIX = "-- CONNECTION: ";
    private static final Pattern EMBEDDED_BINDING_PREFIX_PATTERN = Pattern.compile("--\\s*CONNECTION:\\s*(.+)", 2);
    private static final Image IMG_DATA_GRID = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID);
    private static final Image IMG_DATA_GRID_LOCKED = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID_LOCKED);
    private static final Image IMG_EXPLAIN_PLAN = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_EXPLAIN_PLAN);
    private static final Image IMG_LOG = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_LOG);
    private static final Image IMG_VARIABLES = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_VARIABLE);
    private static final Image IMG_OUTPUT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT);
    private static final Image IMG_OUTPUT_ALERT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT_ALERT);
    private static final String SIDE_TOP_TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.editors.sql.toolbar.side.top";
    private static final String SIDE_BOTTOM_TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.editors.sql.toolbar.side.bottom";
    private static final String MULTIPLE_RESULTS_PER_TAB_PROPERTY = "org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab.isEnabled";
    private static final QualifiedName MULTIPLE_RESULTS_PER_TAB_PROP_NAME = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab.isEnabled");
    public static final String VIEW_PART_PROP_NAME = "org.jkiss.dbeaver.ui.editors.sql.SQLEditor";
    public static final String DEFAULT_TITLE_PATTERN = "<${connectionName}> ${fileName}";
    public static final String DEFAULT_SCRIPT_FILE_NAME = "Script";
    private static final EditorPartContextualProperty multipleResultsPerTabProperty = EditorPartContextualProperty.setup((String)"org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab.isEnabled", (QualifiedName)MULTIPLE_RESULTS_PER_TAB_PROP_NAME, (String)"SQLEditor.resultSet.multipleResultsPerTab", (String)CommonUtils.toString((Object)false));
    private static volatile TransactionStatusUpdateJob transactionStatusUpdateJob;
    static final String STATS_CATEGORY_TRANSACTION_TIMEOUT = "TransactionTimeout";
    private ResultSetOrientation resultSetOrientation = ResultSetOrientation.HORIZONTAL;
    private CustomSashForm resultsSash;
    private Composite sqlEditorPanel;
    @Nullable
    private Composite presentationStack;
    private SashForm sqlExtraPanelSash;
    private CTabFolder sqlExtraPanelFolder;
    private ToolBarManager sqlExtraPanelToolbar;
    private CTabFolder resultTabs;
    private TabFolderReorder resultTabsReorder;
    private CTabItem activeResultsTab;
    private SQLLogPanel logViewer;
    private SQLEditorOutputViewer outputViewer;
    private SQLVariablesPanel variablesViewer;
    @Nullable
    private QueryProcessor curQueryProcessor;
    private final List<QueryProcessor> queryProcessors = new ArrayList<QueryProcessor>();
    private DBPDataSourceContainer dataSourceContainer;
    private DBPDataSource curDataSource;
    private volatile DBCExecutionContext isolatedExecutionContext;
    private volatile DBCExecutionContext lastExecutionContext;
    private volatile DBPContextProvider executionContextProvider;
    private SQLScriptContext globalScriptContext;
    private volatile boolean syntaxLoaded = false;
    private final FindReplaceTarget findReplaceTarget = new FindReplaceTarget();
    private final List<SQLQuery> runningQueries = new ArrayList<SQLQuery>();
    private QueryResultsContainer curResultsContainer;
    private Image baseEditorImage;
    private Image editorImage;
    private ToolBarManager topBarMan;
    private ToolBarManager bottomBarMan;
    private VerticalFolder presentationSwitchFolder;
    private VerticalButton switchPresentationSQLButton;
    private VerticalButton[] switchPresentationExtraButtons;
    private ExtraPresentationManager extraPresentationManager;
    private final List<SQLEditorListener> listeners = new ArrayList<SQLEditorListener>();
    private final List<ServerOutputInfo> serverOutputs = new ArrayList<ServerOutputInfo>();
    private ScriptAutoSaveJob scriptAutoSavejob;
    private boolean isResultSetAutoFocusEnabled = true;
    private boolean isShowScriptRulerOnExecution = true;
    private Boolean isDisableFetchResultSet = null;
    private boolean datasourceChanged;
    private volatile boolean isPartControlInitialized = false;
    private final ArrayList<SQLEditorAddIn> addIns = new ArrayList();
    private SQLSuggestionTextPainter suggestionTextPainter;
    private final DisposeListener resultTabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            Object data = e.widget.getData();
            if (data instanceof QueryResultsContainer) {
                QueryResultsContainer queryResultsContainer = (QueryResultsContainer)data;
                QueryProcessor processor = queryResultsContainer.queryProcessor;
                List<QueryResultsContainer> containers = processor.getResultContainers();
                int index = containers.indexOf(data) + 1;
                while (index < containers.size()) {
                    QueryResultsContainer container = containers.get(index);
                    if (container.resultSetNumber == index) {
                        --container.resultSetNumber;
                    }
                    ++index;
                }
            }
            if (SQLEditor.this.resultTabs.getItemCount() == 0 && SQLEditor.this.resultsSash.getMaximizedControl() == null) {
                SQLEditor.this.toggleResultPanel(false, true);
            }
        }
    };

    public SQLSuggestionTextPainter getSuggestionTextPainter() {
        return this.suggestionTextPainter;
    }

    public void setResultSetAutoFocusEnabled(boolean value) {
        this.isResultSetAutoFocusEnabled = value;
    }

    public boolean getShowScriptRulerOnExecution() {
        return this.isShowScriptRulerOnExecution;
    }

    public void setShowScriptRulerOnExecution(boolean value) {
        this.isShowScriptRulerOnExecution = value;
    }

    @Override
    protected String[] getKeyBindingContexts() {
        return new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.script", "org.jkiss.dbeaver.ui.context.resultset", "org.jkiss.dbeaver.ui.editors.sql.script.focused"};
    }

    @Override
    @Nullable
    public DBPDataSource getDataSource() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container == null ? null : container.getDataSource();
    }

    public DBCExecutionContext getExecutionContext() {
        if (this.isolatedExecutionContext != null) {
            return this.isolatedExecutionContext;
        }
        if (this.executionContextProvider != null) {
            return this.executionContextProvider.getExecutionContext();
        }
        if (this.dataSourceContainer != null && !SQLEditorUtils.isOpenSeparateConnection(this.dataSourceContainer)) {
            return DBUtils.getDefaultContext((DBSObject)this.getDataSource(), (boolean)false);
        }
        return null;
    }

    @Override
    @Nullable
    protected DBPDataSourceContainer getDataSourceContainerForSyntaxRuleReloading() {
        return this.dataSourceContainer;
    }

    public SQLScriptContext getGlobalScriptContext() {
        return this.globalScriptContext;
    }

    @Nullable
    public DBPProject getProject() {
        IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        return file == null ? DBWorkbench.getPlatform().getWorkspace().getActiveProject() : DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
    }

    private boolean isProjectResourceEditable() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            DBPProject project = this.getProject();
            return project == null || project.hasRealmPermission("project-resource-edit");
        }
        return true;
    }

    @Override
    protected boolean isReadOnly() {
        return super.isReadOnly() || !this.isProjectResourceEditable();
    }

    public boolean isEditable() {
        return super.isEditable() && this.isProjectResourceEditable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public int[] getCurrentLines() {
        List<SQLQuery> list = this.runningQueries;
        synchronized (list) {
            ArrayList<Integer> lines;
            block11: {
                IDocument document;
                block10: {
                    document = this.getDocument();
                    if (document != null && !this.runningQueries.isEmpty()) break block10;
                    return null;
                }
                lines = new ArrayList<Integer>(this.runningQueries.size() * 2);
                for (SQLQuery statementInfo : this.runningQueries) {
                    try {
                        int firstLine = document.getLineOfOffset(statementInfo.getOffset());
                        int lastLine = document.getLineOfOffset(statementInfo.getOffset() + statementInfo.getLength());
                        int k = firstLine;
                        while (k <= lastLine) {
                            lines.add(k);
                            ++k;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (!lines.isEmpty()) break block11;
                return null;
            }
            int[] results = new int[lines.size()];
            int i = 0;
            while (i < lines.size()) {
                results[i] = (Integer)lines.get(i);
                ++i;
            }
            return results;
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public boolean setDataSourceContainer(@Nullable DBPDataSourceContainer container) {
        IEditorInput input;
        if (container == this.dataSourceContainer) {
            return false;
        }
        if (!this.datasourceChanged && this.curDataSource != null) {
            this.datasourceChanged = true;
        }
        this.releaseContainer();
        this.closeAllJobs();
        this.dataSourceContainer = container;
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
        }
        if ((input = this.getEditorInput()) != null) {
            DBPDataSourceContainer savedContainer = EditorUtils.getInputDataSource((IEditorInput)input);
            if (savedContainer != container) {
                DBCExecutionContext newExecutionContext = DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
                EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)new SQLNavigatorContext(container, newExecutionContext));
                this.executionContextProvider = null;
            } else {
                DBCExecutionContext iec = EditorUtils.getInputExecutionContext((IEditorInput)input);
                if (iec != null) {
                    this.executionContextProvider = () -> iec;
                }
            }
            IFile file = EditorUtils.getFileFromInput((IEditorInput)input);
            if (file != null && this.dataSourceContainer != null) {
                NavigatorResources.refreshNavigatorResource((DBPProject)this.dataSourceContainer.getProject(), (IResource)file, (Object)container);
            } else {
                IWorkbenchPage page = this.getSite().getPage();
                if (page != null) {
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference er = iEditorReferenceArray[n2];
                        if (er.getEditor(false) == this) {
                            page.hideEditor(er);
                            page.showEditor(er);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
        this.checkConnected(false, status -> UIUtils.asyncExec(() -> {
            if (!status.isOK()) {
                DBWorkbench.getPlatformUI().showError("Can't connect to database", "Connection to '" + container.getName() + "' cannot be established.", status);
            }
        }));
        this.setPartName(this.getEditorName());
        this.fireDataSourceChange();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.acquire((DBPDataSourceTask)this);
        }
        if (SQLEditorBase.isWriteEmbeddedBinding()) {
            UIUtils.syncExec(this::embedDataSourceAssociation);
        }
        return true;
    }

    private boolean updateDataSourceContainer() {
        IWorkbenchPart activePart;
        DBPDataSourceContainer inputDataSource = null;
        if (SQLEditorBase.isReadEmbeddedBinding()) {
            inputDataSource = this.getDataSourceFromContent();
        }
        if (inputDataSource == null) {
            inputDataSource = EditorUtils.getInputDataSource((IEditorInput)this.getEditorInput());
        }
        if (inputDataSource == null && (activePart = this.getSite().getWorkbenchWindow().getActivePage().getActivePart()) != this && activePart instanceof DBPDataSourceContainerProvider) {
            DBPDataSourceContainerProvider dsp = (DBPDataSourceContainerProvider)activePart;
            inputDataSource = dsp.getDataSourceContainer();
        }
        return this.setDataSourceContainer(inputDataSource);
    }

    private void updateExecutionContext(Runnable onSuccess) {
        if (this.dataSourceContainer == null) {
            this.releaseExecutionContext();
        } else {
            DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
            if (dataSource == null) {
                this.releaseExecutionContext();
            } else if (this.curDataSource != dataSource) {
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                if (this.executionContextProvider == null) {
                    DBPDataSourceContainer container = dataSource.getContainer();
                    if (SQLEditorUtils.isOpenSeparateConnection(container)) {
                        this.initSeparateConnection(dataSource, onSuccess, true);
                    } else if (onSuccess != null) {
                        onSuccess.run();
                    }
                }
            }
        }
        UIUtils.asyncExec(() -> this.fireDataSourceChanged(null));
    }

    private void initSeparateConnection(@NotNull DBPDataSource dataSource, Runnable onSuccess, boolean readDefaultsFromInstance) {
        DBSInstance selectedInstance;
        String[] contextDefaults;
        DBSInstance dsInstance = dataSource.getDefaultInstance();
        String[] stringArray = contextDefaults = this.isRestoreActiveSchemaFromScript() ? EditorUtils.getInputContextDefaults((DBPDataSourceContainer)dataSource.getContainer(), (IEditorInput)this.getEditorInput()) : null;
        if (!ArrayUtils.isEmpty(contextDefaults) && contextDefaults[0] != null && (selectedInstance = (DBSInstance)DBUtils.findObject((Collection)dataSource.getAvailableInstances(), (String)contextDefaults[0])) != null) {
            dsInstance = selectedInstance;
        }
        OpenContextJob job = new OpenContextJob(dsInstance, onSuccess, readDefaultsFromInstance);
        job.schedule();
    }

    private void releaseExecutionContext() {
        if (this.isolatedExecutionContext != null && this.isolatedExecutionContext.isConnected()) {
            new CloseContextJob(this.isolatedExecutionContext).schedule();
        }
        this.isolatedExecutionContext = null;
        this.curDataSource = null;
    }

    private void releaseContainer() {
        this.releaseExecutionContext();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            this.dataSourceContainer.release((DBPDataSourceTask)this);
            this.dataSourceContainer = null;
        }
    }

    private DBPDataSourceContainer getDataSourceFromContent() {
        DBPProject project = this.getProject();
        IDocument document = this.getDocument();
        if (project == null || document == null || document.getNumberOfLines() == 0) {
            return null;
        }
        try {
            DBPDataSourceContainer dataSource;
            String connSpec;
            IRegion region = document.getLineInformation(0);
            String line = document.get(region.getOffset(), region.getLength());
            Matcher matcher = EMBEDDED_BINDING_PREFIX_PATTERN.matcher(line);
            if (matcher.matches() && !CommonUtils.isEmpty((String)(connSpec = matcher.group(1).trim())) && (dataSource = DataSourceUtils.getDataSourceBySpec((DBPProject)project, (String)connSpec, null, (boolean)true, (boolean)false)) != null) {
                return dataSource;
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting datasource info from script's content", e);
        }
        return null;
    }

    private void embedDataSourceAssociation() {
        if (this.getDataSourceFromContent() == this.dataSourceContainer) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            log.error((Object)"Document is null");
            return;
        }
        try {
            String line;
            Matcher matcher;
            int totalLines = document.getNumberOfLines();
            IRegion region = null;
            if (totalLines > 0 && !(matcher = EMBEDDED_BINDING_PREFIX_PATTERN.matcher(line = document.get((region = document.getLineInformation(0)).getOffset(), region.getLength()))).matches()) {
                region = null;
            }
            if (this.dataSourceContainer == null) {
                if (region == null) {
                    return;
                }
                document.replace(region.getOffset(), region.getLength(), "");
            } else {
                SQLScriptBindingType bindingType = SQLScriptBindingType.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.script.bind.commentType"));
                StringBuilder assocSpecLine = new StringBuilder(EMBEDDED_BINDING_PREFIX);
                bindingType.appendSpec(this.dataSourceContainer, assocSpecLine);
                assocSpecLine.append(GeneralUtils.getDefaultLineSeparator());
                if (region != null) {
                    document.replace(region.getOffset(), region.getLength(), assocSpecLine.toString());
                } else {
                    document.replace(0, 0, assocSpecLine.toString());
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting datasource info from script's content", e);
        }
        UIUtils.asyncExec(() -> {
            TextViewer textViewer = this.getTextViewer();
            if (textViewer != null) {
                textViewer.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SQLEditorListener listener) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SQLEditorListener listener) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public boolean isActiveTask() {
        return this.getTotalQueryRunning() > 0;
    }

    @Override
    @NotNull
    public SQLDialect getSQLDialect() {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource != null) {
            return dataSource.getSQLDialect();
        }
        if (this.dataSourceContainer == null) {
            return BasicSQLDialect.INSTANCE;
        }
        SQLDialectMetadata scriptDialect = this.dataSourceContainer.getScriptDialect();
        try {
            return scriptDialect.createInstance();
        }
        catch (DBException dBException) {
            log.warn((Object)String.format("Can't create sql dialect for %s:%s", scriptDialect.getId(), scriptDialect.getLabel()));
            return BasicSQLDialect.INSTANCE;
        }
    }

    public boolean isSmartAutoCommit() {
        DBPDataSource dataSource;
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (container == null && (dataSource = this.getDataSource()) != null) {
            container = dataSource.getContainer();
        }
        if (container != null) {
            DBPPreferenceStore preferenceStore = container.getPreferenceStore();
            if (preferenceStore.contains("transaction.smart.commit")) {
                return preferenceStore.getBoolean("transaction.smart.commit");
            }
            return container.getConnectionConfiguration().getConnectionType().isSmartCommit();
        }
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("transaction.smart.commit");
    }

    @Override
    public boolean isFoldingEnabled() {
        return SQLEditorUtils.isSQLSyntaxParserEnabled(this.getEditorInput()) && this.getActivePreferenceStore().getBoolean("SQLEditor.Folding.enabled");
    }

    public void setSmartAutoCommit(boolean smartAutoCommit) {
        this.getActivePreferenceStore().setValue("transaction.smart.commit", smartAutoCommit);
        try {
            this.getActivePreferenceStore().save();
        }
        catch (IOException e) {
            log.error((Object)"Error saving smart auto-commit option", (Throwable)e);
        }
    }

    public void refreshActions() {
        this.updateMultipleResultsPerTabToolItem();
        if (this.topBarMan != null) {
            this.topBarMan.getControl().redraw();
        }
        if (this.bottomBarMan != null) {
            this.bottomBarMan.getControl().redraw();
        }
        MultipleResultsPerTabMenuContribution.syncWithEditor(this);
    }

    private boolean isRestoreActiveSchemaFromScript() {
        boolean isSeparateConnection;
        ModelPreferences.SeparateConnectionBehavior behavior = ModelPreferences.SeparateConnectionBehavior.parse((String)this.getActivePreferenceStore().getString("database.editor.separate.connection"));
        switch (behavior) {
            case ALWAYS: {
                boolean bl = true;
                break;
            }
            case NEVER: {
                boolean bl = false;
                break;
            }
            default: {
                boolean bl = isSeparateConnection = this.getDataSourceContainer() == null || !this.getDataSourceContainer().isForceUseSingleConnection();
            }
        }
        return this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveActiveSchema") && isSeparateConnection;
    }

    public boolean isDirty() {
        ISaveablePart sp;
        Boolean state;
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            if (!queryProcessor.isDirty() && queryProcessor.curJobRunning.get() <= 0) continue;
            return true;
        }
        if (QMUtils.isTransactionActive((DBCExecutionContext)this.isolatedExecutionContext)) {
            return true;
        }
        if (this.isNonPersistentEditor() && (state = ConfirmationDialog.getPersistedState((String)"save_sql_console", (int)3)) == Boolean.FALSE) {
            return false;
        }
        SQLEditorPresentation sQLEditorPresentation = this.extraPresentationManager.activePresentation;
        if (sQLEditorPresentation instanceof ISaveablePart && (sp = (ISaveablePart)sQLEditorPresentation).isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    @Nullable
    public SQLEditorPresentation getActivePresentation() {
        return this.extraPresentationManager.activePresentation;
    }

    @Nullable
    public SQLPresentationDescriptor getActivePresentationDescriptor() {
        return this.extraPresentationManager.activePresentationDescriptor;
    }

    @Nullable
    public IResultSetController getResultSetController() {
        CTabItem activeResultsTab;
        if (this.resultTabs != null && !this.resultTabs.isDisposed() && (activeResultsTab = this.getActiveResultsTab()) != null && UIUtils.isUIThread()) {
            Object tabControl = activeResultsTab.getData();
            if (tabControl instanceof QueryResultsContainer) {
                QueryResultsContainer qrc = (QueryResultsContainer)tabControl;
                return qrc.viewer;
            }
            if (tabControl instanceof SingleTabQueryProcessor) {
                SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)tabControl;
                return stqp.getFirstResults().viewer;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getAdapter(Class<T> required) {
        if (required == INavigatorModelView.class) {
            return null;
        }
        if (required == IResultSetController.class || required == ResultSetViewer.class) {
            return required.cast(this.getResultSetController());
        }
        if (this.resultTabs != null && !this.resultTabs.isDisposed()) {
            if (required == IFindReplaceTarget.class) {
                return required.cast((Object)this.findReplaceTarget);
            }
            CTabItem activeResultsTab = this.getActiveResultsTab();
            if (activeResultsTab != null && UIUtils.isUIThread()) {
                IAdaptable adaptable;
                Object adapter;
                Object tabControl = activeResultsTab.getData();
                if (tabControl instanceof QueryResultsContainer) {
                    QueryResultsContainer qrc = (QueryResultsContainer)tabControl;
                    tabControl = qrc.viewer;
                }
                if (tabControl instanceof SingleTabQueryProcessor) {
                    SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)tabControl;
                    tabControl = stqp.getFirstResults().viewer;
                }
                if (tabControl instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)tabControl).getAdapter(required)) != null) {
                    return (T)adapter;
                }
            }
        }
        return super.getAdapter(required);
    }

    public boolean checkConnected(boolean forceConnect, DBRProgressListener onFinish) {
        UIServiceConnections serviceConnections;
        boolean doConnect;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        boolean bl = doConnect = dataSourceContainer != null && (forceConnect || dataSourceContainer.getPreferenceStore().getBoolean("database.editor.connect.on.activate"));
        if (doConnect && !dataSourceContainer.isConnected() && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null) {
            UIUtils.asyncExec(() -> {
                ConnectVisualizer connectVisualizer = new ConnectVisualizer();
                serviceConnections.connectDataSource(dataSourceContainer, status -> {
                    UIUtils.asyncExec(this::reloadSyntaxRules);
                    if (onFinish != null) {
                        onFinish.onTaskFinished(status);
                    }
                    connectVisualizer.stop();
                });
            });
        }
        return dataSourceContainer != null && dataSourceContainer.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPartControl(Composite parent) {
        StyledText textWidget;
        SashForm editorContainer;
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.resultsSash = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)UIUtils.checkSashStyle((int)(this.resultSetOrientation.getSashOrientation() | 0x10000)));
        this.resultsSash.setShowBorders(true);
        CSSUtils.markConnectionTypeColor((Widget)this.resultsSash);
        this.resultsSash.setSashWidth(8);
        UIUtils.setHelp((Control)this.resultsSash, (String)"sql-editor");
        this.sqlEditorPanel = UIUtils.createPlaceholder((Composite)this.resultsSash, (int)3, (int)0);
        CSSUtils.markConnectionTypeColor((Widget)this.sqlEditorPanel);
        this.createControlsBar(this.sqlEditorPanel);
        this.sqlExtraPanelSash = new SashForm(this.sqlEditorPanel, 256);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 5;
        this.sqlExtraPanelSash.setLayoutData((Object)gd);
        StackLayout presentationStackLayout = null;
        if (!this.extraPresentationManager.presentations.isEmpty()) {
            this.presentationStack = new Composite((Composite)this.sqlExtraPanelSash, 0);
            this.presentationStack.setLayoutData((Object)new GridData(1808));
            presentationStackLayout = new StackLayout();
            this.presentationStack.setLayout((Layout)presentationStackLayout);
            editorContainer = this.presentationStack;
        } else {
            editorContainer = this.sqlExtraPanelSash;
        }
        super.createPartControl((Composite)editorContainer);
        this.getEditorControlWrapper().setLayoutData(new GridData(1808));
        this.sqlExtraPanelFolder = new CTabFolder((Composite)this.sqlExtraPanelSash, 0x8000C0);
        this.sqlExtraPanelFolder.setSelection(0);
        this.sqlExtraPanelFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = SQLEditor.this.sqlExtraPanelFolder.getSelection();
                if (item != null) {
                    IActionContributor ac = (IActionContributor)item.getData("actionContributor");
                    SQLEditor.this.updateExtraViewToolbar(ac);
                }
            }
        });
        this.sqlExtraPanelToolbar = new ToolBarManager();
        this.sqlExtraPanelToolbar.createControl((Composite)this.sqlExtraPanelFolder);
        this.sqlExtraPanelFolder.setTopRight((Control)this.sqlExtraPanelToolbar.getControl());
        this.restoreSashRatio(this.sqlExtraPanelSash, "SQLEditor.extraPanels.ratio");
        this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
        this.addSashRatioSaveListener(this.sqlExtraPanelSash, "SQLEditor.extraPanels.ratio");
        this.createPresentationSwitchBar(this.sqlEditorPanel);
        if (presentationStackLayout != null) {
            presentationStackLayout.topControl = this.presentationStack.getChildren()[0];
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
        DBPProject project = this.getProject();
        if (project != null && project.isRegistryLoaded()) {
            this.createResultTabs();
        } else {
            UIExecutionQueue.queueExec(this::createResultTabs);
        }
        this.setAction("ShowInformation", null);
        SourceViewer viewer = this.getViewer();
        if (viewer != null && (textWidget = viewer.getTextWidget()) != null) {
            textWidget.addModifyListener(this::onTextChange);
            textWidget.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SQLEditor.this.refreshActions();
                }
            });
        }
        this.suggestionTextPainter = new SQLSuggestionTextPainter((ITextViewer)this.getViewer());
        this.suggestionTextPainter.enable();
        textWidget = this.getViewer().getTextWidget();
        textWidget.addVerifyKeyListener(e -> {
            if ((e.keyCode == 0x1000004 || e.keyCode == 9 || e.keyCode == 13 || e.keyCode == 0x1000050) && this.suggestionTextPainter.hasContentToShow()) {
                e.doit = false;
                this.suggestionTextPainter.applyHint();
            }
        });
        textWidget.addVerifyKeyListener(e -> {
            if (e.keyCode == 27) {
                e.doit = false;
                this.suggestionTextPainter.removeHint();
            }
        });
        textWidget.addCaretListener(event -> {
            int suggestionOffset;
            int caretOffset;
            if (this.suggestionTextPainter.hasContentToShow() && (caretOffset = event.caretOffset) != (suggestionOffset = this.suggestionTextPainter.getCurrentPosition())) {
                this.suggestionTextPainter.removeHint();
            }
        });
        new ServerOutputReader().schedule();
        this.updateExecutionContext(null);
        UIExecutionQueue.queueExec(this::onDataSourceChange);
        Consumer<String> fontUpdater = s -> {
            Font font = BaseThemeSettings.instance.partTitleFont;
            if (this.resultTabs != null) {
                this.resultTabs.setFont(font);
            }
            if (this.presentationSwitchFolder != null) {
                VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
                int n = verticalButtonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VerticalButton button = verticalButtonArray[n2];
                    button.setFont(font);
                    ++n2;
                }
            }
        };
        BaseThemeSettings.instance.addPropertyListener("org.eclipse.ui.workbench.TAB_TEXT_FONT", fontUpdater, (Control)parent);
        fontUpdater.accept(null);
        if (transactionStatusUpdateJob == null) {
            SQLEditor sQLEditor = this;
            synchronized (sQLEditor) {
                if (transactionStatusUpdateJob == null) {
                    transactionStatusUpdateJob = new TransactionStatusUpdateJob();
                    transactionStatusUpdateJob.schedule();
                }
            }
        }
        this.isPartControlInitialized = true;
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)textWidget, (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    protected boolean isHideQueryText() {
        return false;
    }

    protected boolean canProcessQueries() {
        if (ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.sql.execution.disabled")) {
            UIUtils.showMessageBox((Shell)this.getSite().getShell(), (String)UIMessages.dialog_policy_sql_execution_title, (String)UIMessages.dialog_policy_sql_execution_msg, (int)8);
            return false;
        }
        return true;
    }

    private void onTextChange(ModifyEvent e) {
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnChange")) {
            this.doScriptAutoSave();
        }
        if (this.suggestionTextPainter != null) {
            this.suggestionTextPainter.removeHint();
        }
    }

    private void createControlsBar(Composite sqlEditorPanel) {
        Composite leftToolPanel = new Composite(sqlEditorPanel, 16384){

            public void setBackground(Color color) {
                super.setBackground(color);
            }
        };
        GridLayout panelsLayout = new GridLayout(1, true);
        panelsLayout.marginHeight = 2;
        panelsLayout.marginWidth = 1;
        panelsLayout.marginTop = 1;
        panelsLayout.marginBottom = 7;
        panelsLayout.verticalSpacing = 1;
        leftToolPanel.setLayout((Layout)panelsLayout);
        leftToolPanel.setLayoutData((Object)new GridData(1040));
        ToolBar topBar = new ToolBar(leftToolPanel, 0x800200);
        topBar.setData(VIEW_PART_PROP_NAME, (Object)this);
        this.topBarMan = new ToolBarManager(topBar);
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)this.topBarMan, SIDE_TOP_TOOLBAR_CONTRIBUTION_ID);
        }
        topBar.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        CSSUtils.markConnectionTypeColor((Widget)topBar);
        this.topBarMan.update(true);
        topBar.pack();
        UIUtils.createEmptyLabel((Composite)leftToolPanel, (int)1, (int)1).setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.bottomBarMan = new ToolBarManager(0x800200);
        this.bottomBarMan.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new SQLEditorBase.ShowPreferencesAction(this), (boolean)false));
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)this.bottomBarMan, SIDE_BOTTOM_TOOLBAR_CONTRIBUTION_ID);
        }
        ToolBar bottomBar = this.bottomBarMan.createControl(leftToolPanel);
        bottomBar.setLayoutData((Object)new GridData(0x1000000, 1024, true, false));
        CSSUtils.markConnectionTypeColor((Widget)bottomBar);
        bottomBar.pack();
        this.bottomBarMan.update(true);
        this.updateMultipleResultsPerTabToolItem();
    }

    private void createPresentationSwitchBar(Composite sqlEditorPanel) {
        Set<SQLPresentationDescriptor> presentations = this.extraPresentationManager.presentations.keySet();
        if (presentations.isEmpty()) {
            return;
        }
        this.presentationSwitchFolder = new VerticalFolder(sqlEditorPanel, 131072);
        this.presentationSwitchFolder.setLayoutData((Object)new GridData(1040));
        SelectionAdapter switchListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VerticalButton button = (VerticalButton)e.item;
                SQLPresentationDescriptor newPresentation = (SQLPresentationDescriptor)((Object)button.getData());
                SQLPresentationDescriptor curPresentation = SQLEditor.this.getExtraPresentationDescriptor();
                if (curPresentation != null && curPresentation == newPresentation) {
                    SQLEditor.this.showExtraPresentation((SQLPresentationDescriptor)null);
                } else {
                    SQLEditor.this.showExtraPresentation(newPresentation);
                }
            }
        };
        this.switchPresentationSQLButton = new VerticalButton(this.presentationSwitchFolder, 131104);
        this.switchPresentationSQLButton.setText(SQLEditorMessages.editors_sql_editor_presentation);
        this.switchPresentationSQLButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCRIPT));
        this.switchPresentationSQLButton.setChecked(true);
        this.switchPresentationSQLButton.addSelectionListener((SelectionListener)switchListener);
        ArrayList<VerticalButton> buttons = new ArrayList<VerticalButton>(presentations.size());
        for (SQLPresentationDescriptor presentation : presentations) {
            VerticalButton button = this.extraPresentationManager.createPresentationButton(presentation, this);
            button.addSelectionListener((SelectionListener)switchListener);
            buttons.add(button);
        }
        this.switchPresentationExtraButtons = (VerticalButton[])buttons.toArray(VerticalButton[]::new);
        UIUtils.createEmptyLabel((Composite)this.presentationSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
        this.createToggleLayoutButton();
    }

    public boolean validateEditorInputState() {
        boolean res = super.validateEditorInputState();
        if (res) {
            this.setFocusToTextControl();
        }
        return res;
    }

    @Override
    protected void updateStatusField(String category) {
        if (STATS_CATEGORY_TRANSACTION_TIMEOUT.equals(category)) {
            IStatusField field = this.getStatusField(category);
            if (field != null) {
                String status;
                try {
                    status = this.getTransactionStatusText();
                }
                catch (DBCException dBCException) {
                    status = null;
                }
                if (CommonUtils.isNotEmpty((String)status)) {
                    field.setText(status);
                    field.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_WARNING));
                } else {
                    field.setText(null);
                    field.setImage(null);
                }
            }
            return;
        }
        super.updateStatusField(category);
    }

    private void updateMultipleResultsPerTabToolItem() {
        ToolItem toolItem = this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab");
        if (toolItem != null) {
            boolean multipleResultsPerTab = this.isMultipleResultsPerTabEnabled();
            toolItem.setImage(multipleResultsPerTab ? MultipleResultsPerTabMenuContribution.FALSE_IMAGE : MultipleResultsPerTabMenuContribution.TRUE_IMAGE);
            toolItem.setSelection(multipleResultsPerTab);
        }
    }

    private boolean useTabPerQuery(boolean singleQuery) {
        return singleQuery || !this.isMultipleResultsPerTabEnabled();
    }

    public boolean isMultipleResultsPerTabEnabled() {
        return CommonUtils.toBoolean((Object)SQLEditor.multipleResultsPerTabProperty.getPropertyValue((EditorPart)this).value, (boolean)false);
    }

    public void toggleMultipleResultsPerTab() {
        boolean wasEnabled = this.isMultipleResultsPerTabEnabled();
        multipleResultsPerTabProperty.setPropertyValue((EditorPart)this, Boolean.toString(!wasEnabled));
    }

    private void createResultTabs() {
        this.resultTabs = new CTabFolder((Composite)this.resultsSash, 0x800080){

            public void setBackground(Color color) {
                if (SQLEditor.this.resultTabs != null && !SQLEditor.this.resultTabs.isDisposed()) {
                    UIUtils.asyncExec(() -> CSSUtils.markConnectionTypeColor((Widget)SQLEditor.this.resultTabs));
                } else {
                    super.setBackground(color);
                }
            }
        };
        CSSUtils.markConnectionTypeColor((Widget)this.resultTabs);
        this.resultTabsReorder = new TabFolderReorder(this.resultTabs);
        this.resultTabs.setLayoutData((Object)new GridData(1808));
        this.resultTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplainPlanViewer epv;
                SQLQuery planQuery;
                Object data;
                if (SQLEditor.this.extraPresentationManager.activePresentationPanel != null) {
                    SQLEditor.this.extraPresentationManager.activePresentationPanel.deactivatePanel();
                    SQLEditor.this.extraPresentationManager.activePresentationPanel = null;
                }
                if ((data = e.item.getData()) instanceof QueryResultsContainer) {
                    QueryResultsContainer qrc = (QueryResultsContainer)data;
                    SQLEditor.this.setActiveResultsContainer(qrc);
                } else if (data instanceof SingleTabQueryProcessor) {
                    SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)data;
                    SQLEditor.this.setActiveResultsContainer(stqp.getFirstResults());
                } else if (data instanceof SQLEditorPresentationPanel) {
                    SQLEditorPresentationPanel pp;
                    SQLEditor.this.extraPresentationManager.activePresentationPanel = pp = (SQLEditorPresentationPanel)data;
                    SQLEditor.this.extraPresentationManager.activePresentationPanel.activatePanel();
                } else if (data instanceof ExplainPlanViewer && (planQuery = (epv = (ExplainPlanViewer)((Object)data)).getQuery()) != null) {
                    SQLEditor.this.getSelectionProvider().setSelection((ISelection)new TextSelection(planQuery.getOffset(), 0));
                }
            }
        });
        this.addSashRatioSaveListener((SashForm)this.resultsSash, "SQLEditor.resultSet.ratio");
        this.resultTabs.addListener(1001, event -> {
            Object object;
            CTabItem item = (CTabItem)event.item;
            Object object2 = item.getData();
            if (object2 instanceof MultiTabsQueryResultsContainer) {
                MultiTabsQueryResultsContainer qrc = (MultiTabsQueryResultsContainer)object2;
                qrc.resultsTab = item;
            }
            if ((object = item.getData()) instanceof SingleTabQueryProcessor) {
                SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)object;
                stqp.resultsTab = item;
            }
        });
        this.restoreSashRatio((SashForm)this.resultsSash, "SQLEditor.resultSet.ratio");
        TextViewer textViewer = this.getTextViewer();
        if (textViewer != null) {
            textViewer.getTextWidget().addTraverseListener(e -> {
                ResultSetViewer viewer;
                if (e.detail == 16 && e.stateMask == SWT.MOD1 && (viewer = this.getActiveResultSetViewer()) != null && viewer.getActivePresentation().getControl().isVisible()) {
                    viewer.getActivePresentation().getControl().setFocus();
                    e.detail = 0;
                }
            });
        }
        this.resultTabs.setSimple(true);
        this.resultTabs.setFont(JFaceResources.getFont((String)"org.eclipse.ui.workbench.TAB_TEXT_FONT"));
        this.resultTabs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CTabItem item;
                if (e.button == 2 && (item = SQLEditor.this.resultTabs.getItem(new Point(e.x, e.y))) != null && item.getShowClose()) {
                    item.dispose();
                }
            }
        });
        this.resultTabs.addListener(8, event -> {
            if (event.button != 1) {
                return;
            }
            CTabItem selectedItem = this.resultTabs.getItem(new Point(event.getBounds().x, event.getBounds().y));
            if (selectedItem != null && selectedItem == this.resultTabs.getSelection()) {
                this.toggleEditorMaximize();
            }
        });
        this.createExtraViewControls();
        this.createQueryProcessor(true, true, true);
        if (this.isHideQueryText()) {
            this.resultsSash.setMaximizedControl((Control)this.resultTabs);
        } else {
            this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
        }
        this.resultTabs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SQLEditor.this.activeResultsTab = SQLEditor.this.resultTabs.getItem(new Point(e.x, e.y));
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.resultTabs);
        menuMgr.addMenuListener(manager -> {
            boolean activeTabHasMultipleResults;
            final CTabItem activeTab = this.getActiveResultsTab();
            final boolean activeTabHasSingleResult = activeTab != null && activeTab.getData() instanceof QueryResultsContainer;
            boolean bl = activeTabHasMultipleResults = activeTab != null && activeTab.getData() instanceof SingleTabQueryProcessor;
            if (activeTabHasSingleResult || activeTabHasMultipleResults) {
                QueryResultsContainer container;
                int pinnedTabsCount = 0;
                int resultTabsCount = 0;
                CTabItem[] cTabItemArray = this.resultTabs.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    if (item.getData() instanceof QueryProcessingComponent) {
                        ++resultTabsCount;
                        if (item.getData() instanceof QueryResultsContainer && ((QueryResultsContainer)item.getData()).isPinned()) {
                            ++pinnedTabsCount;
                        }
                    }
                    ++n2;
                }
                if (activeTab.getShowClose()) {
                    manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.close.tab"));
                    if (resultTabsCount - pinnedTabsCount > 1) {
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_all_tabs){

                            public void run() {
                                SQLEditor.this.closeExtraResultTabs(null, false, false);
                            }
                        });
                        if (activeTabHasSingleResult) {
                            manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_query_tabs){

                                public void run() {
                                    QueryProcessor processor = ((QueryResultsContainer)activeTab.getData()).queryProcessor;
                                    ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                    for (QueryResultsContainer container : processor.getResultContainers()) {
                                        if (container.isPinned() || container.queryProcessor != processor) continue;
                                        tabs.add(container.getResultsTab());
                                    }
                                    for (CTabItem tab : tabs) {
                                        tab.dispose();
                                    }
                                }
                            });
                        }
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_other_tabs){

                            public void run() {
                                ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                CTabItem[] cTabItemArray = SQLEditor.this.resultTabs.getItems();
                                int n = cTabItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CTabItem tab = cTabItemArray[n2];
                                    if (tab.getShowClose() && tab != activeTab && !SQLEditor.this.isPinned(tab)) {
                                        tabs.add(tab);
                                    }
                                    ++n2;
                                }
                                for (CTabItem tab : tabs) {
                                    tab.dispose();
                                }
                                if (activeTabHasSingleResult) {
                                    SQLEditor.this.setActiveResultsContainer((QueryResultsContainer)activeTab.getData());
                                }
                                if (activeTabHasMultipleResults) {
                                    SQLEditor.this.setActiveResultsContainer(((SingleTabQueryProcessor)activeTab.getData()).getFirstResults());
                                }
                            }
                        });
                        if (this.resultTabs.indexOf(activeTab) - pinnedTabsCount > 0) {
                            manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_tabs_to_the_left){

                                public void run() {
                                    ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                    int i = 0;
                                    int last = SQLEditor.this.resultTabs.indexOf(activeTab);
                                    while (i < last) {
                                        CTabItem tab = SQLEditor.this.resultTabs.getItem(i);
                                        if (!SQLEditor.this.isPinned(tab)) {
                                            tabs.add(tab);
                                        }
                                        ++i;
                                    }
                                    for (CTabItem tab : tabs) {
                                        tab.dispose();
                                    }
                                }
                            });
                        }
                        if (this.resultTabs.indexOf(activeTab) < resultTabsCount - pinnedTabsCount - 1) {
                            manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_tabs_to_the_right){

                                public void run() {
                                    ArrayList<CTabItem> tabs = new ArrayList<CTabItem>();
                                    int i = SQLEditor.this.resultTabs.indexOf(activeTab) + 1;
                                    while (i < SQLEditor.this.resultTabs.getItemCount()) {
                                        CTabItem tab = SQLEditor.this.resultTabs.getItem(i);
                                        if (!SQLEditor.this.isPinned(tab)) {
                                            tabs.add(tab);
                                        }
                                        ++i;
                                    }
                                    for (CTabItem tab : tabs) {
                                        tab.dispose();
                                    }
                                }
                            });
                        }
                    }
                }
                QueryResultsContainer queryResultsContainer = container = activeTabHasSingleResult ? (QueryResultsContainer)activeTab.getData() : null;
                if (container != null && container.hasData()) {
                    boolean isPinned = container.isPinned();
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggle.pinned.tab"));
                    if (isPinned && pinnedTabsCount > 1) {
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_unpin_all_tabs){

                            public void run() {
                                CTabItem[] cTabItemArray = SQLEditor.this.resultTabs.getItems();
                                int n = cTabItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CTabItem item = cTabItemArray[n2];
                                    if (item.getData() instanceof QueryResultsContainer && ((QueryResultsContainer)item.getData()).isPinned()) {
                                        ((QueryResultsContainer)item.getData()).setPinned(false);
                                    }
                                    ++n2;
                                }
                            }
                        });
                    }
                    manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_set_name){

                        public void run() {
                            EnterNameDialog dialog = new EnterNameDialog(SQLEditor.this.resultTabs.getShell(), SQLEditorMessages.action_result_tabs_set_name_title, activeTab.getText());
                            if (dialog.open() == 0) {
                                container.setTabName(dialog.getResult());
                            }
                        }
                    });
                    if (!container.isStatistics()) {
                        manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_detach_tab){

                            public void run() {
                                container.detach();
                            }
                        });
                    }
                    if (container.getQuery() != null) {
                        manager.add((IContributionItem)new Separator());
                        AssignVariableAction action = new AssignVariableAction(this, container.getQuery().getText());
                        action.setEditable(false);
                        manager.add((IAction)action);
                    }
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.maximize.result.panel"));
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.resultTabs.setMenu(menu);
    }

    private void addSashRatioSaveListener(SashForm sash, String prefId) {
        Control control = sash.getChildren()[0];
        control.addListener(11, event -> {
            if (!control.isDisposed()) {
                int[] weights = sash.getWeights();
                IPreferenceStore prefs = this.getPreferenceStore();
                if (prefs != null && weights.length == 2) {
                    prefs.setValue(prefId, weights[0] + "-" + weights[1]);
                }
            }
        });
    }

    private void restoreSashRatio(SashForm sash, String prefId) {
        String[] weightsStr;
        String resultsPanelRatio = this.getPreferenceStore().getString(prefId);
        if (!CommonUtils.isEmpty((String)resultsPanelRatio) && (weightsStr = resultsPanelRatio.split("-")).length > 1) {
            int[] weights = new int[]{CommonUtils.toInt((Object)weightsStr[0]), CommonUtils.toInt((Object)weightsStr[1])};
            if (weights[1] < weights[0] / 15 || weights[0] < weights[1] / 15) {
                log.debug((Object)"Restore default sash weights");
            } else {
                sash.setWeights(weights);
            }
        }
    }

    private void setActiveResultsContainer(QueryResultsContainer data) {
        this.curResultsContainer = data;
        this.curQueryProcessor = this.curResultsContainer.queryProcessor;
    }

    private boolean isPinned(CTabItem tabItem) {
        if (tabItem.getData() instanceof QueryResultsContainer) {
            return ((QueryResultsContainer)tabItem.getData()).isPinned();
        }
        return false;
    }

    public void toggleExtraPanelsLayout() {
        CTabItem outTab = this.getExtraViewTab((Control)this.outputViewer);
        CTabItem logTab = this.getExtraViewTab((Control)this.logViewer);
        CTabItem varTab = this.getExtraViewTab((Control)this.variablesViewer);
        if (outTab != null) {
            outTab.dispose();
        }
        if (logTab != null) {
            logTab.dispose();
        }
        if (varTab != null) {
            varTab.dispose();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String epLocation = this.getExtraPanelsLocation();
        epLocation = "results".equals(epLocation) ? "right" : "results";
        preferenceStore.setValue("SQLEditor.extraPanels.location", epLocation);
        this.createExtraViewControls();
        if (outTab != null) {
            this.showOutputPanel(true);
        }
        if (logTab != null) {
            this.showExecutionLogPanel(true);
        }
        if (varTab != null) {
            this.showVariablesPanel(true);
        }
    }

    public String getExtraPanelsLocation() {
        return this.getPreferenceStore().getString("SQLEditor.extraPanels.location");
    }

    private void createExtraViewControls() {
        if (this.logViewer != null) {
            this.logViewer.dispose();
            this.logViewer = null;
        }
        if (this.variablesViewer != null) {
            this.variablesViewer.dispose();
            this.variablesViewer = null;
        }
        if (this.outputViewer != null) {
            this.outputViewer.dispose();
            this.outputViewer = null;
        }
        if (this.sqlExtraPanelFolder != null) {
            CTabItem[] cTabItemArray = this.sqlExtraPanelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem ti = cTabItemArray[n2];
                ti.dispose();
                ++n2;
            }
        }
        CTabFolder folder = this.getFolderForExtraPanels();
        this.logViewer = new SQLLogPanel((Composite)folder, this);
        this.variablesViewer = new SQLVariablesPanel((Composite)folder, this);
        this.outputViewer = new SQLEditorOutputViewer(this.getSite(), (Composite)folder, 16384);
        this.outputViewer.setExecutionContext(this.isolatedExecutionContext);
        if (this.getFolderForExtraPanels() != this.sqlExtraPanelFolder) {
            this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
        }
    }

    public CTabFolder getResultTabsContainer() {
        return this.resultTabs;
    }

    private CTabFolder getFolderForExtraPanels() {
        CTabFolder folder = this.sqlExtraPanelFolder;
        String epLocation = this.getExtraPanelsLocation();
        if ("results".equals(epLocation)) {
            folder = this.resultTabs;
        }
        return folder;
    }

    private CTabItem getExtraViewTab(Control control) {
        CTabFolder tabFolder = this.getFolderForExtraPanels();
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == control) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void showExtraView(@NotNull String commandId, @NotNull String name, @NotNull String toolTip, @NotNull Image image, @NotNull Control view, @Nullable IActionContributor actionContributor, @Nullable Boolean show) {
        boolean isTabsToTheRight;
        ToolItem viewItem = this.getViewToolItem(commandId);
        if (viewItem == null) {
            log.warn((Object)("Tool item for command " + commandId + " not found"));
            return;
        }
        CTabFolder tabFolder = this.getFolderForExtraPanels();
        CTabItem curItem = this.getExtraViewTab(view);
        if (curItem != null) {
            if (show == null || !show.booleanValue()) {
                viewItem.setSelection(false);
                curItem.dispose();
            }
            return;
        }
        if (show != null && !show.booleanValue()) {
            return;
        }
        boolean bl = isTabsToTheRight = tabFolder == this.sqlExtraPanelFolder;
        if (isTabsToTheRight) {
            if (this.sqlExtraPanelSash.getMaximizedControl() != null) {
                this.sqlExtraPanelSash.setMaximizedControl(null);
            }
        } else {
            this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
            this.showResultsPanel(true);
        }
        if (view == this.outputViewer) {
            this.updateOutputViewerIcon(false);
            this.outputViewer.resetNewOutput();
        }
        viewItem.setSelection(true);
        CTabItem item = new CTabItem(tabFolder, 64);
        item.setControl(view);
        item.setText(name);
        item.setToolTipText(toolTip);
        item.setImage(image);
        item.setData((Object)view);
        item.setData("actionContributor", (Object)actionContributor);
        item.addDisposeListener(e -> {
            if (!viewItem.isDisposed()) {
                viewItem.setSelection(false);
            }
            if (tabFolder.getItemCount() == 0) {
                this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
            }
        });
        tabFolder.setSelection(item);
        if (isTabsToTheRight) {
            this.updateExtraViewToolbar(actionContributor);
        }
    }

    private void updateExtraViewToolbar(IActionContributor actionContributor) {
        this.sqlExtraPanelToolbar.removeAll();
        if (actionContributor != null) {
            actionContributor.contributeActions((IContributionManager)this.sqlExtraPanelToolbar);
        }
        this.sqlExtraPanelToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggle.extraPanels", (int)32, (DBPImage)UIIcon.ARROW_DOWN));
        this.sqlExtraPanelToolbar.update(true);
    }

    @Nullable
    private ToolItem getViewToolItem(@NotNull String commandId) {
        ToolItem viewItem;
        ToolItem toolItem = viewItem = this.topBarMan == null ? null : UIUtils.findToolItemByCommandId((ToolBarManager)this.topBarMan, (String)commandId);
        if (viewItem == null) {
            viewItem = this.bottomBarMan == null ? null : UIUtils.findToolItemByCommandId((ToolBarManager)this.bottomBarMan, (String)commandId);
        }
        return viewItem;
    }

    private CTabItem getActiveResultsTab() {
        return this.activeResultsTab == null || this.activeResultsTab.isDisposed() ? (this.resultTabs == null ? null : this.resultTabs.getSelection()) : this.activeResultsTab;
    }

    public void closeActiveTab() {
        CTabItem tabItem = this.getActiveResultsTab();
        if (tabItem != null && tabItem.getShowClose()) {
            tabItem.dispose();
            this.activeResultsTab = null;
        }
    }

    public void toggleActiveTabPinned() {
        CTabItem activeTab = this.getActiveResultsTab();
        QueryResultsContainer container = (QueryResultsContainer)activeTab.getData();
        if (!container.hasData()) {
            return;
        }
        boolean isPinned = container.isPinned();
        container.setPinned(!isPinned);
        CTabItem currTabItem = activeTab;
        if (isPinned) {
            int i = this.resultTabs.indexOf(activeTab) + 1;
            while (i < this.resultTabs.getItemCount()) {
                CTabItem nextTabItem = this.resultTabs.getItem(i);
                if (!nextTabItem.getShowClose()) {
                    this.resultTabsReorder.swapTabs(currTabItem, nextTabItem);
                    currTabItem = nextTabItem;
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = this.resultTabs.indexOf(activeTab) - 1;
            while (i >= 0) {
                CTabItem nextTabItem = this.resultTabs.getItem(i);
                if (nextTabItem.getShowClose()) {
                    this.resultTabsReorder.swapTabs(currTabItem, nextTabItem);
                    currTabItem = nextTabItem;
                    --i;
                    continue;
                }
                break;
            }
        }
    }

    public boolean isActiveTabPinned() {
        CTabItem tabItem = this.getActiveResultsTab();
        return tabItem != null && ((QueryResultsContainer)tabItem.getData()).isPinned();
    }

    public void showOutputPanel(@Nullable Boolean show) {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.output", SQLEditorMessages.editors_sql_output, SQLEditorMessages.editors_sql_output_tip, IMG_OUTPUT, (Control)this.outputViewer, manager -> manager.add((IAction)new OutputAutoShowToggleAction()), show);
    }

    public void showExecutionLogPanel(@Nullable Boolean show) {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.log", SQLEditorMessages.editors_sql_execution_log, SQLEditorMessages.editors_sql_execution_log_tip, IMG_LOG, (Control)this.logViewer, null, show);
    }

    public void showVariablesPanel(@Nullable Boolean show) {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.variables", SQLEditorMessages.editors_sql_variables, SQLEditorMessages.editors_sql_variables_tip, IMG_VARIABLES, (Control)this.variablesViewer, null, show);
        UIUtils.asyncExec(() -> this.variablesViewer.refreshVariables());
    }

    public <T> T getExtraPresentationPanel(Class<T> panelClass) {
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            if (tabItem.getData() instanceof SQLEditorPresentationPanel && tabItem.getData().getClass() == panelClass) {
                return panelClass.cast(tabItem.getData());
            }
            ++n2;
        }
        return null;
    }

    public boolean showPresentationPanel(SQLEditorPresentationPanel panel) {
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == panel) {
                this.setResultTabSelection(item);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setResultTabSelection(CTabItem item) {
        if (item != null && (this.isResultSetAutoFocusEnabled || !(item.getData() instanceof QueryProcessingComponent) || this.resultTabs.getItemCount() == 1)) {
            this.resultTabs.setSelection(item);
        }
    }

    public SQLEditorPresentationPanel showPresentationPanel(String panelID) {
        IAction action;
        IContributionItem contributionItem;
        IContributionItem[] iContributionItemArray = this.topBarMan.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            contributionItem = iContributionItemArray[n2];
            if (contributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)contributionItem).getAction()) instanceof PresentationPanelToggleAction && ((PresentationPanelToggleAction)action).panel.getId().equals(panelID)) {
                action.run();
                return this.extraPresentationManager.activePresentationPanel;
            }
            ++n2;
        }
        iContributionItemArray = this.bottomBarMan.getItems();
        n = iContributionItemArray.length;
        n2 = 0;
        while (n2 < n) {
            contributionItem = iContributionItemArray[n2];
            if (contributionItem instanceof ActionContributionItem && (action = ((ActionContributionItem)contributionItem).getAction()) instanceof PresentationPanelToggleAction && ((PresentationPanelToggleAction)action).panel.getId().equals(panelID)) {
                action.run();
                return this.extraPresentationManager.activePresentationPanel;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasMaximizedControl() {
        return this.resultsSash.getMaximizedControl() != null;
    }

    @Nullable
    public SQLPresentationDescriptor getExtraPresentationDescriptor() {
        return this.extraPresentationManager.activePresentationDescriptor;
    }

    public void showExtraPresentation(@NotNull String presentationId) {
        SQLPresentationDescriptor presentation = SQLPresentationRegistry.getInstance().getPresentation(presentationId);
        if (presentation != null) {
            this.showExtraPresentation(presentation);
        }
    }

    public void showExtraPresentation(@Nullable SQLPresentationDescriptor presentation) {
        if (this.extraPresentationManager.activePresentationDescriptor == presentation || this.presentationStack == null) {
            return;
        }
        if (presentation != null && !presentation.isEnabled((IWorkbenchSite)this.getSite())) {
            return;
        }
        StackLayout stackLayout = (StackLayout)this.presentationStack.getLayout();
        try {
            if (!this.extraPresentationManager.setActivePresentation(presentation)) {
                return;
            }
        }
        catch (DBException e) {
            log.error((Object)"Error creating presentation", (Throwable)e);
        }
        this.resultsSash.setRedraw(false);
        try {
            if (this.extraPresentationManager.activePresentation == null) {
                stackLayout.topControl = this.presentationStack.getChildren()[0];
                this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
            } else {
                stackLayout.topControl = this.extraPresentationManager.getActivePresentationControl();
                this.getSite().setSelectionProvider(this.extraPresentationManager.activePresentation.getSelectionProvider());
            }
            boolean sideBarChanged = false;
            Control[] controlArray = this.presentationSwitchFolder.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control vb = controlArray[n2];
                if (vb.getData() instanceof SQLPresentationPanelDescriptor) {
                    vb.dispose();
                    sideBarChanged = true;
                }
                ++n2;
            }
            controlArray = this.resultTabs.getItems();
            n = controlArray.length;
            n2 = 0;
            while (n2 < n) {
                Control tabItem = controlArray[n2];
                if (tabItem.getData() instanceof SQLEditorPresentationPanel) {
                    tabItem.dispose();
                }
                ++n2;
            }
            this.extraPresentationManager.activePresentationPanel = null;
            if (this.extraPresentationManager.activePresentation != null) {
                List<SQLPresentationPanelDescriptor> panels = this.extraPresentationManager.activePresentationDescriptor.getPanels();
                for (SQLPresentationPanelDescriptor panelDescriptor : panels) {
                    this.removeToggleLayoutButton();
                    sideBarChanged = true;
                    PresentationPanelToggleAction toggleAction = new PresentationPanelToggleAction(panelDescriptor);
                    VerticalButton panelButton = new VerticalButton(this.presentationSwitchFolder, 131072);
                    panelButton.setLayoutData((Object)new GridData(8));
                    panelButton.setAction((IAction)toggleAction, true);
                    panelButton.setData((Object)panelDescriptor);
                    if (panelDescriptor.isAutoActivate()) {
                        toggleAction.run();
                    }
                    this.createToggleLayoutButton();
                }
            }
            this.switchPresentationSQLButton.setChecked(presentation == null);
            controlArray = this.switchPresentationExtraButtons;
            int n3 = this.switchPresentationExtraButtons.length;
            int n4 = 0;
            while (n4 < n3) {
                Control button = controlArray[n4];
                button.setChecked(presentation != null && button.getData() == presentation);
                ++n4;
            }
            this.presentationSwitchFolder.layout(true);
            this.presentationSwitchFolder.redraw();
            if (sideBarChanged) {
                this.topBarMan.update(true);
                this.bottomBarMan.update(true);
                this.topBarMan.getControl().getParent().layout(true);
                this.bottomBarMan.getControl().getParent().layout(true);
            }
            this.presentationStack.layout(true, true);
            UIUtils.asyncExec(() -> {
                if (this.extraPresentationManager.activePresentation == null) {
                    this.setFocusToTextControl();
                } else {
                    this.extraPresentationManager.getActivePresentationControl().setFocus();
                }
            });
        }
        finally {
            this.resultsSash.setRedraw(true);
        }
    }

    private void createToggleLayoutButton() {
        VerticalButton.create((VerticalFolder)this.presentationSwitchFolder, (int)131104, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggleLayout", (boolean)false);
    }

    private void removeToggleLayoutButton() {
        VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
        int n = verticalButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalButton vButton = verticalButtonArray[n2];
            if (vButton.getCommandId() != null && vButton.getCommandId().equals("org.jkiss.dbeaver.ui.editors.sql.toggleLayout")) {
                vButton.dispose();
            }
            ++n2;
        }
    }

    public void toggleResultPanel(boolean switchFocus, boolean createQueryProcessor) {
        if (this.isHideQueryText()) {
            return;
        }
        UIUtils.syncExec(() -> {
            if (this.resultsSash.getMaximizedControl() == null) {
                this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
                this.switchFocus(false);
            } else {
                if (this.resultTabs.getItemCount() == 0 && createQueryProcessor) {
                    this.createQueryProcessor(true, true, true);
                }
                this.resultsSash.setMaximizedControl(null);
                if (switchFocus) {
                    this.switchFocus(true);
                }
            }
        });
    }

    public void toggleEditorMaximize() {
        this.setEditorMaximized(!this.resultsSash.isUpHidden());
    }

    public void setEditorMaximized(boolean maximized) {
        if (this.isHideQueryText()) {
            return;
        }
        if (maximized) {
            this.resultsSash.hideUp();
            this.switchFocus(true);
        } else {
            this.resultsSash.showUp();
            this.switchFocus(false);
        }
    }

    private void switchFocus(boolean results) {
        if (results) {
            ResultSetViewer activeRS = this.getActiveResultSetViewer();
            if (activeRS != null && activeRS.getActivePresentation() != null) {
                activeRS.getActivePresentation().getControl().setFocus();
            } else {
                CTabItem activeTab = this.resultTabs.getSelection();
                if (activeTab != null && activeTab.getControl() != null) {
                    activeTab.getControl().setFocus();
                }
            }
        } else {
            this.getEditorControlWrapper().setFocus();
        }
    }

    public void toggleActivePanel() {
        if (this.resultsSash.getMaximizedControl() == null) {
            this.switchFocus(!UIUtils.hasFocus((Control)this.resultTabs));
        }
    }

    private void updateResultSetOrientation() {
        try {
            this.resultSetOrientation = ResultSetOrientation.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.resultSet.orientation"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resultSetOrientation = ResultSetOrientation.HORIZONTAL;
        }
        if (this.resultsSash != null) {
            this.resultsSash.setOrientation(this.resultSetOrientation.getSashOrientation());
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.updateResultSetOrientation();
        SQLScriptContext parentContext = null;
        DatabaseEditorContext parentEditorContext = EditorUtils.getEditorContext((IEditorInput)editorInput);
        if (parentEditorContext instanceof SQLNavigatorContext) {
            SQLNavigatorContext nc = (SQLNavigatorContext)parentEditorContext;
            parentContext = nc.getScriptContext();
            if (nc.isReuseExecutionContext()) {
                DBCExecutionContext iec = nc.getExecutionContext();
                this.executionContextProvider = () -> iec;
            }
        }
        this.globalScriptContext = new SQLScriptContext(parentContext, this, null, new OutputLogWriter(), new SQLEditorParametersProvider((IWorkbenchPartSite)site)){

            public Path getSourceFile() {
                return EditorUtils.getPathFromInput((Object)SQLEditor.this.getEditorInput());
            }
        };
        DBCExecutionContext inputExecutionContext = this.globalScriptContext.getExecutionContext();
        if (inputExecutionContext != null) {
            this.dataSourceContainer = inputExecutionContext.getDataSource().getContainer();
        }
        this.globalScriptContext.addListener(new DBCScriptContextListener(){

            public void variableChanged(DBCScriptContextListener.ContextAction action, DBCScriptContext.VariableInfo variable) {
                this.saveContextVariables();
            }

            public void parameterChanged(DBCScriptContextListener.ContextAction action, String name, Object value) {
                this.saveContextVariables();
            }

            private void saveContextVariables() {
                new AbstractJob("Save variables"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        DBPDataSourceContainer ds = SQLEditor.this.getDataSourceContainer();
                        if (ds != null) {
                            (this).SQLEditor.this.globalScriptContext.saveVariables(ds.getDriver(), null);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule(200L);
            }
        });
        for (SQLEditorAddInDescriptor addInDesc : SQLEditorAddInsRegistry.getInstance().getAddIns()) {
            try {
                SQLEditorAddIn addIn = addInDesc.createInstance();
                addIn.init(this);
                this.addIns.add(addIn);
            }
            catch (Throwable ex) {
                log.error((Object)"Error during SQL editor add-in initialization", ex);
            }
        }
        this.extraPresentationManager = new ExtraPresentationManager();
    }

    @Nullable
    public <T extends SQLEditorAddIn> T findAddIn(@NotNull Class<T> addInClass) {
        for (SQLEditorAddIn addIn : this.addIns) {
            if (!addInClass.isInstance(addIn)) continue;
            SQLEditorAddIn concreteAddIn = addIn;
            return (T)concreteAddIn;
        }
        return null;
    }

    @Override
    protected void doSetInput(IEditorInput editorInput) throws CoreException {
        this.checkInputFileExistence(editorInput);
        try {
            super.doSetInput(editorInput);
        }
        catch (Throwable e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)out, true));
            editorInput = new StringEditorInput("Error", (CharSequence)CommonUtils.truncateString((String)out.toString(), (int)10000), true, GeneralUtils.UTF8_ENCODING);
            try {
                super.doSetInput(editorInput);
            }
            catch (Throwable throwable) {
                throw e;
            }
            log.error((Object)"Error loading input SQL file", e);
        }
        this.syntaxLoaded = false;
        final IEditorInput finalEditorInput = editorInput;
        Runnable inputinitializer = new Runnable(){

            @Override
            public void run() {
                if (SQLEditor.this.isPartControlInitialized) {
                    SQLEditor.this.accomplishEditorInputInitialization(finalEditorInput);
                } else {
                    UIExecutionQueue.queueExec((Runnable)this);
                }
            }
        };
        UIExecutionQueue.queueExec((Runnable)inputinitializer);
        this.setPartName(this.getEditorName());
        if (this.isNonPersistentEditor() && this.isDetectTitleImageFromInput()) {
            this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_CONSOLE));
        }
        this.baseEditorImage = this.getTitleImage();
        this.editorImage = new Image((Device)Display.getCurrent(), this.baseEditorImage, 0);
    }

    private void accomplishEditorInputInitialization(@NotNull IEditorInput editorInput) {
        DBPDataSourceContainer newDataSource;
        DBPDataSourceContainer oldDataSource = this.getDataSourceContainer();
        if (oldDataSource != (newDataSource = EditorUtils.getInputDataSource((IEditorInput)this.getEditorInput()))) {
            this.dataSourceContainer = null;
            this.updateDataSourceContainer();
        } else {
            this.reloadSyntaxRules();
        }
        DBPDataSourceContainer dataSource = EditorUtils.getInputDataSource((IEditorInput)editorInput);
        SQLEditorFeatures.SQL_EDITOR_OPEN.use(Map.of("driver", dataSource == null ? "" : dataSource.getDriver().getPreconfiguredId()));
        DataSourceToolbarUtils.refreshSelectorToolbar((IWorkbenchWindow)this.getSite().getWorkbenchWindow());
    }

    private void checkInputFileExistence(IEditorInput editorInput) {
        try {
            if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                if (!file.exists()) {
                    file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error checking SQL file", (Throwable)e);
        }
    }

    protected boolean isDetectTitleImageFromInput() {
        return true;
    }

    public String getTitleToolTip() {
        String scriptPath;
        if (!DBWorkbench.getPlatform().getApplication().isStandalone()) {
            return this.getTitle();
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer == null) {
            return super.getTitleToolTip();
        }
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)editorInput;
            scriptPath = fei.getFile().getFullPath().toString();
        } else if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)editorInput;
            scriptPath = pei.getPath().toString();
        } else if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput iei = (IURIEditorInput)editorInput;
            URI uri = iei.getURI();
            scriptPath = "file".equals(uri.getScheme()) ? new File(uri).getAbsolutePath() : uri.toString();
        } else if (editorInput instanceof INonPersistentEditorInput) {
            scriptPath = "SQL Console";
        } else {
            scriptPath = editorInput.getName();
            if (CommonUtils.isEmpty((String)scriptPath)) {
                scriptPath = "<not a file>";
            }
        }
        StringBuilder tip = new StringBuilder();
        tip.append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_path, (Object)scriptPath)).append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_connection, (Object)dataSourceContainer.getName())).append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_type, (Object)dataSourceContainer.getDriver().getFullName())).append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_url, (Object)dataSourceContainer.getConnectionConfiguration().getUrl()));
        SQLEditorVariablesResolver scriptNameResolver = new SQLEditorVariablesResolver(dataSourceContainer, dataSourceContainer.getConnectionConfiguration(), this.getExecutionContext(), scriptPath, null, this.getProject());
        if (scriptNameResolver.get("database") != null) {
            tip.append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_database, (Object)scriptNameResolver.get("database")));
        }
        if (scriptNameResolver.get("schema") != null) {
            tip.append("\n").append(NLS.bind((String)SQLEditorMessages.sql_editor_title_tooltip_schema, (Object)scriptNameResolver.get("schema")));
        }
        EditorUtils.appendProjectToolTip((StringBuilder)tip, (DBPProject)this.getProject());
        if (dataSourceContainer.getConnectionError() != null) {
            tip.append("\n\nConnection error:\n").append(dataSourceContainer.getConnectionError());
        }
        return tip.toString();
    }

    protected String getEditorName() {
        File localFile;
        IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        String scriptName = file != null ? file.getFullPath().removeFileExtension().lastSegment() : ((localFile = EditorUtils.getLocalFileFromInput((Object)this.getEditorInput())) != null ? localFile.getName() : this.getEditorInput().getName());
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        String pattern = preferenceStore.getString("script.title.pattern");
        return GeneralUtils.replaceVariables((String)pattern, (IVariableResolver)new SQLEditorVariablesResolver(this.dataSourceContainer, null, this.getExecutionContext(), scriptName, file, this.getProject()));
    }

    public void setFocus() {
        super.setFocus();
        this.topBarMan.update(true);
    }

    public void loadQueryPlan() {
        DBCQueryPlanner planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)this.getDataSource(), DBCQueryPlanner.class);
        ExplainPlanViewer planView = this.getPlanView(null, planner);
        if (planView != null) {
            this.showResultsPanel(false);
            if (!planView.loadQueryPlan(planner, planView)) {
                this.closeActiveTab();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explainQueryPlan() {
        if (!this.canProcessQueries()) {
            return;
        }
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                listener.beforeQueryPlanExplain();
            }
        }
        SQLScriptElement scriptElement = this.extractActiveQuery();
        if (scriptElement == null) {
            this.setStatus(SQLEditorMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
            return;
        }
        if (!(scriptElement instanceof SQLQuery)) {
            this.setStatus("Can't explain plan for command", DBPMessageType.ERROR);
            return;
        }
        this.explainQueryPlan((SQLQuery)scriptElement);
    }

    private void explainQueryPlan(SQLQuery sqlQuery) {
        this.showResultsPanel(false);
        DBCQueryPlanner planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)this.getDataSource(), DBCQueryPlanner.class);
        DBCPlanStyle planStyle = planner.getPlanStyle();
        if (planStyle == DBCPlanStyle.QUERY) {
            this.explainPlanFromQuery(planner, sqlQuery);
        } else if (planStyle == DBCPlanStyle.OUTPUT) {
            this.explainPlanFromQuery(planner, sqlQuery);
            this.showOutputPanel(true);
        } else {
            ExplainPlanViewer planView = this.getPlanView(sqlQuery, planner);
            if (planView != null) {
                planView.explainQueryPlan(sqlQuery, planner);
            }
        }
    }

    private void showResultsPanel(boolean createQueryProcessor) {
        if (this.resultsSash.getMaximizedControl() != null) {
            this.toggleResultPanel(false, createQueryProcessor);
        }
        UIUtils.syncExec(() -> {
            if (this.resultsSash.isDownHidden()) {
                this.resultsSash.showDown();
            }
        });
    }

    private ExplainPlanViewer getPlanView(SQLQuery sqlQuery, DBCQueryPlanner planner) {
        int n;
        if (planner == null) {
            DBWorkbench.getPlatformUI().showError("Execution plan", "Execution plan explain isn't supported by current datasource");
            return null;
        }
        if (sqlQuery != null && !this.transformQueryWithParameters(sqlQuery)) {
            return null;
        }
        ExplainPlanViewer planView = null;
        if (sqlQuery != null) {
            CTabItem[] cTabItemArray = this.resultTabs.getItems();
            n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExplainPlanViewer pv;
                CTabItem item = cTabItemArray[n2];
                Object object = item.getData();
                if (object instanceof ExplainPlanViewer && (pv = (ExplainPlanViewer)((Object)object)).getQuery() != null && pv.getQuery().equals((Object)sqlQuery)) {
                    this.setResultTabSelection(item);
                    planView = pv;
                    break;
                }
                ++n2;
            }
        }
        if (planView == null) {
            int maxPlanNumber = 0;
            CTabItem[] cTabItemArray = this.resultTabs.getItems();
            int n3 = cTabItemArray.length;
            n = 0;
            while (n < n3) {
                CTabItem item = cTabItemArray[n];
                if (item.getData() instanceof ExplainPlanViewer) {
                    maxPlanNumber = Math.max(maxPlanNumber, ((ExplainPlanViewer)((Object)item.getData())).getPlanNumber());
                }
                ++n;
            }
            planView = new ExplainPlanViewer((IWorkbenchPart)this, this, (Composite)this.resultTabs, ++maxPlanNumber);
            CTabItem item = new CTabItem(this.resultTabs, 64);
            item.setControl(planView.getControl());
            item.setText(SQLEditorMessages.editors_sql_error_execution_plan_title + " - " + maxPlanNumber);
            if (sqlQuery != null) {
                String preparedText = sqlQuery.getText().replaceAll("[\n\r\t]{3,}", "");
                if (preparedText.length() > 300) {
                    item.setToolTipText(preparedText.substring(0, 300) + "...");
                } else {
                    item.setToolTipText(preparedText);
                }
            }
            item.setImage(IMG_EXPLAIN_PLAN);
            item.setData((Object)planView);
            item.addDisposeListener(this.resultTabDisposeListener);
            UIUtils.disposeControlOnItemDispose((CTabItem)item);
            this.setResultTabSelection(item);
        }
        return planView;
    }

    private void explainPlanFromQuery(DBCQueryPlanner planner, SQLQuery sqlQuery) {
        String[] planQueryString = new String[1];
        DBRRunnableWithProgress queryObtainTask = monitor -> {
            DBCQueryPlannerConfiguration configuration = ExplainPlanViewer.makeExplainPlanConfiguration(monitor, planner);
            if (configuration == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, "Prepare plan query");){
                    DBCPlan plan = planner.planQueryExecution(session, sqlQuery.getText(), configuration);
                    stringArray[0] = plan.getPlanQueryString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Explain error", "Failed to explain execution plan", (Throwable)e);
            }
        };
        if (RuntimeUtils.runTask((DBRRunnableWithProgress)queryObtainTask, (String)"Retrieve plan query", (long)5000L) && !CommonUtils.isEmpty((String)planQueryString[0])) {
            SQLQuery planQuery = new SQLQuery(this.getDataSource(), planQueryString[0]);
            this.processQueries(Collections.singletonList(planQuery), false, true, false, true, null, null);
        }
    }

    public void processSQL(boolean newTab, boolean script) {
        this.processSQL(newTab, script, null, null);
    }

    public boolean processSQL(boolean newTab, boolean script, SQLQueryTransformer transformer, @Nullable SQLQueryListener queryListener) {
        return this.processSQL(newTab, script, false, transformer, queryListener);
    }

    public boolean processSQL(boolean newTab, boolean script, boolean executeFromPosition) {
        return this.processSQL(newTab, script, executeFromPosition, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSQL(boolean newTab, boolean script, boolean executeFromPosition, SQLQueryTransformer transformer, @Nullable SQLQueryListener queryListener) {
        List<SQLScriptElement> elements;
        IDocument document = this.getDocument();
        if (document == null) {
            this.setStatus(SQLEditorMessages.editors_sql_status_cant_obtain_document, DBPMessageType.ERROR);
            return false;
        }
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                listener.beforeQueryExecute(script, newTab);
            }
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (script) {
            if (executeFromPosition) {
                elements = this.extractScriptQueries(selection.getOffset(), document.getLength(), true, false, true);
                elements.removeFirst();
                elements.addFirst(this.extractActiveQuery());
            } else {
                elements = selection != null && selection.getLength() > 1 ? this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true) : this.extractScriptQueries(0, document.getLength(), true, false, true);
            }
        } else {
            SQLScriptElement sqlQuery = this.extractActiveQuery();
            if (sqlQuery == null) {
                ResultSetViewer activeViewer = this.getActiveResultSetViewer();
                if (activeViewer != null) {
                    activeViewer.setStatus(SQLEditorMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
                }
                return false;
            }
            elements = Collections.singletonList(sqlQuery);
        }
        try {
            DBPDataSource dataSource;
            if (transformer != null && (dataSource = this.getDataSource()) != null) {
                ArrayList<SQLScriptElement> xQueries = new ArrayList<SQLScriptElement>(elements.size());
                for (SQLScriptElement element : elements) {
                    if (element instanceof SQLQuery) {
                        SQLQuery query = transformer.transformQuery(dataSource, this.getSyntaxManager(), (SQLQuery)element);
                        if (!CommonUtils.isEmpty((Collection)query.getParameters())) {
                            query.setParameters(this.parseQueryParameters(query));
                        }
                        xQueries.add((SQLScriptElement)query);
                        continue;
                    }
                    xQueries.add(element);
                }
                elements = xQueries;
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Bad query", "Can't execute query", (Throwable)e);
            return false;
        }
        if (!CommonUtils.isEmpty(elements)) {
            return this.processQueries(elements, script, newTab, false, true, queryListener, null);
        }
        return false;
    }

    public void exportDataFromQuery(@Nullable SQLScriptContext sqlScriptContext) {
        List<SQLScriptElement> elements = this.getSelectedQueries();
        if (!elements.isEmpty()) {
            this.processQueries(elements, false, false, true, true, null, sqlScriptContext);
        } else {
            DBWorkbench.getPlatformUI().showError("Extract data", "Choose one or more queries to export from");
        }
    }

    @NotNull
    public List<SQLScriptElement> getSelectedQueries() {
        ArrayList<SQLScriptElement> elements = new ArrayList<SQLScriptElement>();
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (selection.getLength() > 1) {
            elements.addAll(this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true));
        } else {
            SQLScriptElement query = this.extractActiveQuery();
            if (query != null) {
                elements.add(query);
            }
        }
        return elements;
    }

    public boolean processQueries(@NotNull List<SQLScriptElement> queries, boolean forceScript, boolean newTab, boolean export, boolean checkSession, @Nullable SQLQueryListener queryListener, @Nullable SQLScriptContext context) {
        SQLScriptElement sQLScriptElement;
        boolean isSingleQuery;
        if (queries.isEmpty()) {
            return false;
        }
        if (!this.canProcessQueries()) {
            return false;
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (checkSession) {
            try {
                boolean finalNewTab = newTab;
                DBRProgressListener connectListener = status -> {
                    if (!status.isOK() || container == null || !container.isConnected()) {
                        DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_obtain_session, null, status);
                        return;
                    }
                    this.updateExecutionContext(() -> UIUtils.syncExec(() -> {
                        boolean bl4 = this.processQueries(queries, forceScript, finalNewTab, export, false, queryListener, context);
                    }));
                };
                if (!this.checkSession(connectListener)) {
                    return false;
                }
            }
            catch (DBException ex) {
                ResultSetViewer viewer = this.getActiveResultSetViewer();
                if (viewer != null) {
                    viewer.setStatus(ex.getMessage(), DBPMessageType.ERROR);
                }
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_obtain_session, ex.getMessage());
                return false;
            }
        }
        if (this.dataSourceContainer == null) {
            return false;
        }
        if (!this.dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EXECUTE_SCRIPTS)) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_permissions_query_message);
            return false;
        }
        if (this.dataSourceContainer.isConnectionReadOnly() && queries.stream().anyMatch(q -> {
            SQLQuery sqlQuery;
            return q instanceof SQLQuery && (sqlQuery = (SQLQuery)q).isMutatingStatement();
        })) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_readonly_query_message);
            return false;
        }
        SQLScriptContext scriptContext = context;
        if (scriptContext == null) {
            scriptContext = this.createScriptContext();
        }
        boolean bl = isSingleQuery = !forceScript && queries.size() == 1;
        if (isSingleQuery && (sQLScriptElement = queries.getFirst()) instanceof SQLQuery) {
            SQLQuery query = (SQLQuery)sQLScriptElement;
            boolean isDropTable = query.isDropTableDangerous();
            if (query.isDeleteUpdateDangerous() || isDropTable) {
                String targetName = "multiple tables";
                if (query.getEntityMetadata(false) != null) {
                    targetName = query.getEntityMetadata(false).getEntityName();
                }
                if (ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)4, (String)(isDropTable ? "drop_sql" : "dangerous_sql"), (int)5, (Object[])new Object[]{query.getType().name(), targetName}) != 0) {
                    return false;
                }
            }
        }
        if (!this.isHideQueryText() && this.resultsSash.getMaximizedControl() != null) {
            this.resultsSash.setMaximizedControl(null);
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnExecute") && this.isDirty()) {
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.clearOutputBeforeExecute")) {
            this.outputViewer.clearOutput();
        }
        boolean replaceCurrentTab = this.getActivePreferenceStore().getBoolean("SQLEditor.resultSet.replaceCurrentTab");
        if (!export && this.curQueryProcessor != null) {
            CTabItem selectedTab;
            CTabItem tabItem;
            boolean needAnotherQueryProcessor;
            boolean noQueryProcessors;
            if (this.isResultSetAutoFocusEnabled && !newTab && (!isSingleQuery || isSingleQuery && !replaceCurrentTab)) {
                int tabsClosed = this.closeExtraResultTabs(null, true, false);
                if (tabsClosed == 1) {
                    return false;
                }
                if (tabsClosed == 3) {
                    newTab = true;
                }
            }
            boolean hasRunningJobs = !(noQueryProcessors = this.queryProcessors.isEmpty()) && this.curQueryProcessor.getRunningJobs() > 0;
            boolean hasPinnedTabs = !noQueryProcessors && this.curQueryProcessor.hasPinnedTabs();
            boolean bl2 = needAnotherQueryProcessor = !noQueryProcessors && this.useTabPerQuery(isSingleQuery) && !(this.curQueryProcessor instanceof MultiTabsQueryProcessor);
            if (newTab || noQueryProcessors || hasRunningJobs || hasPinnedTabs || needAnotherQueryProcessor) {
                boolean foundSuitableTab = false;
                boolean anyNotPinnedTab = false;
                if (!newTab && isSingleQuery) {
                    for (QueryProcessor processor : this.queryProcessors) {
                        if (!processor.hasPinnedTabs() && processor.getRunningJobs() == 0) {
                            foundSuitableTab = true;
                            this.curQueryProcessor = processor;
                            break;
                        }
                        boolean bl3 = anyNotPinnedTab = anyNotPinnedTab || !processor.hasPinnedTabs();
                    }
                }
                if (!(foundSuitableTab || !newTab && anyNotPinnedTab)) {
                    if (needAnotherQueryProcessor && this.curQueryProcessor.getResultContainers().size() == 1 && !this.curQueryProcessor.getFirstResults().viewer.hasData()) {
                        this.curQueryProcessor.getFirstResults().dispose();
                    }
                    this.createQueryProcessor(true, isSingleQuery, false);
                }
            }
            if (!newTab && isSingleQuery && this.curQueryProcessor.getResultContainers().size() > 1) {
                this.closeExtraResultTabs(this.curQueryProcessor, false, true);
            }
            if ((tabItem = this.curQueryProcessor.getFirstResults().getResultsTab()) != null && ((selectedTab = this.resultTabs.getSelection()) == null || selectedTab.getData() != this.outputViewer)) {
                this.setResultTabSelection(tabItem);
            }
        }
        if (this.curQueryProcessor == null || newTab && this.useTabPerQuery(isSingleQuery) == this.curQueryProcessor instanceof SingleTabQueryProcessor) {
            this.createQueryProcessor(true, isSingleQuery, true);
        }
        return this.curQueryProcessor.processQueries(scriptContext, queries, forceScript, false, export, !export && this.getActivePreferenceStore().getBoolean("SQLEditor.resultSet.closeOnError"), queryListener);
    }

    public boolean isActiveQueryRunning() {
        return this.curQueryProcessor != null && this.curQueryProcessor.curJobRunning.get() > 0;
    }

    public void cancelActiveQuery() {
        if (this.curQueryProcessor != null && this.isActiveQueryRunning()) {
            this.curQueryProcessor.cancelJob();
        }
    }

    @NotNull
    private SQLScriptContext createScriptContext() {
        Path localFile = EditorUtils.getPathFromInput((Object)this.getEditorInput());
        return new SQLScriptContext(this.globalScriptContext, (DBPContextProvider)this, localFile, (DBCOutputWriter)new OutputLogWriter(), (SQLParametersProvider)new SQLEditorParametersProvider(this.getSite()));
    }

    private void setStatus(String status, DBPMessageType messageType) {
        ResultSetViewer resultsView = this.getActiveResultSetViewer();
        if (resultsView != null) {
            resultsView.setStatus(status, messageType);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private int closeExtraResultTabs(@Nullable QueryProcessor queryProcessor, boolean confirmClose, boolean keepFirstTab) {
        block14: {
            block15: {
                tabsToClose = new ArrayList<CTabItem>();
                processor = null;
                var9_6 /* !! */  = this.resultTabs.getItems();
                var8_7 = var9_6 /* !! */ .length;
                var7_10 = 0;
                while (var7_10 < var8_7) {
                    item = var9_6 /* !! */ [var7_10];
                    if (item.getData() instanceof QueryResultsContainer) {
                        processor = ((QueryResultsContainer)item.getData()).queryProcessor;
                    } else if (item.getData() instanceof QueryProcessor) {
                        processor = (QueryProcessor)item.getData();
                    }
                    if (item.getData() instanceof QueryProcessingComponent && item.getShowClose() && !this.isPinned(item)) {
                        if (!(queryProcessor != null && queryProcessor != processor || queryProcessor != null && queryProcessor.resultContainers.size() < 2 && keepFirstTab)) {
                            tabsToClose.add(item);
                        }
                    } else if (item.getData() instanceof ExplainPlanViewer) {
                        tabsToClose.add(item);
                    }
                    ++var7_10;
                }
                if (tabsToClose.size() <= 1 && (tabsToClose.size() != 1 || !keepFirstTab)) break block14;
                confirmResult = 2;
                if (confirmClose && ((confirmResult = ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)4, (String)"close_result_tabs", (int)6, (Object[])new Object[]{tabsToClose.size()})) == 1 || confirmResult < 0)) {
                    return 1;
                }
                if (confirmResult != 2) break block15;
                i = 0;
                while (i < tabsToClose.size()) {
                    if (i != 0 || !((var9_6 /* !! */  = ((CTabItem)tabsToClose.getFirst()).getData()) instanceof SingleTabQueryProcessor)) ** GOTO lbl-1000
                    sqp = (SingleTabQueryProcessor)var9_6 /* !! */ ;
                    if (keepFirstTab) {
                        results = new ArrayList<QueryResultsContainer>(sqp.getResultContainers());
                        results.stream().skip(1L).forEach((Consumer<QueryResultsContainer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, dispose(), (Lorg/jkiss/dbeaver/ui/editors/sql/SQLEditor$QueryResultsContainer;)V)());
                    } else if (i != 0 || !keepFirstTab) {
                        ((CTabItem)tabsToClose.get(i)).dispose();
                    }
                    ++i;
                }
            }
            return confirmResult;
        }
        if (tabsToClose.size() == 1 && (var7_11 = ((CTabItem)tabsToClose.getFirst()).getData()) instanceof SingleTabQueryProcessor) {
            sqp = (SingleTabQueryProcessor)var7_11;
            results = new ArrayList<QueryResultsContainer>(sqp.getResultContainers());
            results.forEach((Consumer<QueryResultsContainer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, dispose(), (Lorg/jkiss/dbeaver/ui/editors/sql/SQLEditor$QueryResultsContainer;)V)());
            ((CTabItem)tabsToClose.getFirst()).dispose();
        }
        return 9;
    }

    public boolean transformQueryWithParameters(SQLQuery query) {
        return this.createScriptContext().fillQueryParameters(query, () -> null, false);
    }

    public void checkSessionAndConnect(DBRProgressListener onFinish) throws DBException {
        if (this.getDataSourceContainer() != null && this.getDataSourceContainer().isConnected() && this.getExecutionContext() != null) {
            if (onFinish != null) {
                onFinish.onTaskFinished(Status.OK_STATUS);
            }
        } else {
            this.checkSession(status -> {
                if (status.isOK() && this.getExecutionContext() == null) {
                    status = GeneralUtils.makeErrorStatus((String)"Failed to create execution context after session check");
                }
                if (onFinish != null) {
                    onFinish.onTaskFinished(status);
                }
            });
        }
    }

    private boolean checkSession(DBRProgressListener onFinish) throws DBException {
        DBPDataSourceContainer ds = this.getDataSourceContainer();
        if (ds == null) {
            throw new DBException("No active connection");
        }
        if (!ds.isConnected()) {
            boolean doConnect = ds.getPreferenceStore().getBoolean("database.editor.connect.on.execute");
            if (doConnect) {
                return this.checkConnected(true, onFinish);
            }
            throw new DBException("Disconnected from database");
        }
        DBPDataSource dataSource = ds.getDataSource();
        if (dataSource != null && this.executionContextProvider == null && SQLEditorUtils.isOpenSeparateConnection(ds) && this.isolatedExecutionContext == null) {
            this.initSeparateConnection(dataSource, () -> onFinish.onTaskFinished(Status.OK_STATUS), false);
            return this.isolatedExecutionContext != null;
        }
        return true;
    }

    private void fireDataSourceChange() {
        this.updateExecutionContext(null);
        UIUtils.syncExec(this::onDataSourceChange);
    }

    protected void onDataSourceChange() {
        this.onDataSourceChange(true);
    }

    protected void onDataSourceChange(boolean contextChanged) {
        ResultSetViewer rsv;
        DBCExecutionContext executionContext;
        if (contextChanged) {
            this.reloadSyntaxRules();
        }
        if (this.resultsSash == null || this.resultsSash.isDisposed()) {
            return;
        }
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.resultsSash);
        if (this.sqlEditorPanel != null) {
            DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.sqlEditorPanel);
        }
        if (this.resultTabs != null) {
            DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.resultTabs);
        }
        if ((executionContext = this.getExecutionContext()) != null) {
            EditorUtils.setInputDataSource((IEditorInput)this.getEditorInput(), (DatabaseEditorContext)new SQLNavigatorContext(executionContext));
        }
        this.refreshActions();
        this.refreshEditorIconAndTitle();
        if (this.syntaxLoaded && this.lastExecutionContext == executionContext) {
            return;
        }
        if (this.curResultsContainer != null && (rsv = this.curResultsContainer.getResultSetController()) != null) {
            if (executionContext == null) {
                rsv.setStatus(ModelMessages.error_not_connected_to_database);
            } else {
                rsv.setStatus(SQLEditorMessages.editors_sql_staus_connected_to + executionContext.getDataSource().getContainer().getName() + "'");
            }
        }
        if (this.lastExecutionContext == null || executionContext == null || this.lastExecutionContext.getDataSource() != executionContext.getDataSource()) {
            SQLEditorPropertyTester.firePropertyChange("canExecute");
            SQLEditorPropertyTester.firePropertyChange("canExplain");
        }
        if (!this.isHideQueryText()) {
            if (dsContainer == null) {
                this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
            } else if (this.curQueryProcessor != null && this.curQueryProcessor.getFirstResults().hasData()) {
                this.resultsSash.setMaximizedControl(null);
            }
        }
        this.lastExecutionContext = executionContext;
        this.syntaxLoaded = true;
        this.loadActivePreferenceSettings();
        if (dsContainer != null) {
            this.globalScriptContext.loadVariables(dsContainer.getDriver(), null);
        } else {
            this.globalScriptContext.clearVariables();
        }
        if (this.outputViewer != null && executionContext != null) {
            this.outputViewer.setExecutionContext(executionContext);
        }
    }

    public void refreshEditorIconAndTitle() {
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        this.setPartName(this.getEditorName());
        if (this.editorImage != null) {
            this.editorImage.dispose();
        }
        Object bottomRight = this.getExecutionContext() == null ? (dsContainer instanceof DBPStatefulObject && ((DBPStatefulObject)dsContainer).getObjectState() == DBSObjectState.INVALID ? DBIcon.OVER_ERROR : null) : DBIcon.OVER_SUCCESS;
        DBIcon bottomLeft = SQLEditorUtils.isSQLSyntaxParserApplied(this.getEditorInput()) ? null : DBIcon.OVER_RED_LAMP;
        if (this.baseEditorImage == null) {
            this.baseEditorImage = this.getTitleImage();
        }
        if (bottomLeft != null || bottomRight != null) {
            DBIconComposite image = new DBIconComposite((DBPImage)new DBIconBinary(null, this.baseEditorImage), false, null, null, (DBPImage)bottomLeft, (DBPImage)bottomRight);
            this.editorImage = DBeaverIcons.getImage((DBPImage)image, (boolean)false);
        } else {
            this.editorImage = new Image((Device)Display.getCurrent(), this.baseEditorImage, 0);
        }
        this.setTitleImage(this.editorImage);
    }

    public void beforeConnect() {
    }

    public void beforeDisconnect() {
        this.closeAllJobs();
    }

    @Override
    public void dispose() {
        if (this.extraPresentationManager != null) {
            this.extraPresentationManager.dispose();
        }
        this.releaseContainer();
        this.closeAllJobs();
        IEditorInput editorInput = this.getEditorInput();
        IFile sqlFile = EditorUtils.getFileFromInput((IEditorInput)editorInput);
        this.logViewer = null;
        this.outputViewer = null;
        this.queryProcessors.clear();
        this.curResultsContainer = null;
        this.curQueryProcessor = null;
        ListIterator<SQLEditorAddIn> addInsIterator = this.addIns.listIterator(this.addIns.size());
        while (addInsIterator.hasPrevious()) {
            SQLEditorAddIn addIn = addInsIterator.previous();
            try {
                addIn.cleanup(this);
            }
            catch (Throwable ex) {
                log.error((Object)"Error during SQL editor add-in cleanup", ex);
            }
        }
        super.dispose();
        if (sqlFile != null && !PlatformUI.getWorkbench().isClosing() && !DBWorkbench.isDistributed()) {
            this.deleteFileIfEmpty(sqlFile);
        }
        UIUtils.dispose((Resource)this.editorImage);
        this.baseEditorImage = null;
        this.editorImage = null;
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (!this.extraPresentationManager.presentations.isEmpty()) {
            for (Map.Entry<SQLPresentationDescriptor, SQLEditorPresentation> entry : this.extraPresentationManager.presentations.entrySet()) {
                final SQLPresentationDescriptor pd = entry.getKey();
                if (pd == this.extraPresentationManager.activePresentationDescriptor) continue;
                menu.insertAfter("sql.extras", (IAction)new Action(pd.getDescription(), DBeaverIcons.getImageDescriptor((DBPImage)pd.getIcon())){

                    public void run() {
                        SQLEditor.this.showExtraPresentation(pd);
                    }
                });
            }
            menu.insertAfter("sql.extras", (IContributionItem)new Separator("presentations"));
        }
    }

    private void deleteFileIfEmpty(IFile sqlFile) {
        if (sqlFile == null || !sqlFile.exists()) {
            return;
        }
        SQLPreferenceConstants.EmptyScriptCloseBehavior emptyScriptCloseBehavior = SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(this.getActivePreferenceStore().getString("script.delete.empty"));
        if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.NOTHING) {
            return;
        }
        if (!sqlFile.exists() || ResourceUtils.getFileLength((IResource)sqlFile) != 0L) {
            return;
        }
        try {
            Object[] fileHistory;
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.DELETE_NEW && !ArrayUtils.isEmpty((Object[])(fileHistory = sqlFile.getHistory((IProgressMonitor)monitor)))) {
                Object[] objectArray = fileHistory;
                int n = fileHistory.length;
                int n2 = 0;
                while (n2 < n) {
                    Object historyItem = objectArray[n2];
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (InputStream contents = historyItem.getContents();){
                        int cValue = contents.read();
                        if (cValue != -1) {
                            return;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ++n2;
                }
            }
            if (sqlFile.exists()) {
                log.debug((Object)("Delete empty SQL script '" + sqlFile.getFullPath().toOSString() + "'"));
                sqlFile.delete(true, (IProgressMonitor)monitor);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error deleting empty script file", (Throwable)e);
        }
    }

    private void closeAllJobs() {
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.closeJob();
        }
    }

    private int getTotalQueryRunning() {
        int jobsRunning = 0;
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            jobsRunning += queryProcessor.curJobRunning.get();
        }
        return jobsRunning;
    }

    public void handleDataSourceEvent(@NotNull DBPEvent event) {
        boolean registryEvent;
        boolean dsEvent = event.getObject() == this.getDataSourceContainer();
        boolean objectEvent = event.getObject() != null && event.getObject().getDataSource() == this.getDataSource();
        boolean bl = registryEvent = this.getDataSourceContainer() != null && event.getData() == this.getDataSourceContainer().getRegistry();
        if (dsEvent || objectEvent || registryEvent) {
            UIUtils.asyncExec(() -> {
                switch (event.getAction()) {
                    case OBJECT_REMOVE: {
                        if (!dsEvent) break;
                        this.setDataSourceContainer(null);
                        break;
                    }
                    case OBJECT_UPDATE: 
                    case OBJECT_SELECT: {
                        if (!objectEvent) break;
                        this.setPartName(this.getEditorName());
                        this.firePropertyChange(1);
                        break;
                    }
                    case BEFORE_CONNECT: 
                    case AFTER_CONNECT: {
                        break;
                    }
                }
                this.updateExecutionContext(null);
                boolean contextChanged = this.isContextChanged(event);
                this.onDataSourceChange(contextChanged);
            });
        }
    }

    private boolean isContextChanged(DBPEvent event) {
        DBCExecutionContextDefaults ctxDefault;
        DBCExecutionContext execContext;
        boolean contextChanged;
        DBPEvent.Action eventAction = event.getAction();
        DBSObject eventObject = event.getObject();
        boolean isEditorContext = eventObject == this.getDataSourceContainer() || event.getData() == this.getExecutionContext();
        boolean bl = contextChanged = isEditorContext && eventAction.equals((Object)DBPEvent.Action.OBJECT_UPDATE);
        if (!contextChanged && isEditorContext && eventAction.equals((Object)DBPEvent.Action.OBJECT_SELECT) && event.getEnabled().booleanValue() && (execContext = this.getExecutionContext()) != null && (ctxDefault = execContext.getContextDefaults()) != null && eventObject != null) {
            boolean defaultChanged;
            boolean bl2 = defaultChanged = eventObject == ctxDefault.getDefaultCatalog() || eventObject == ctxDefault.getDefaultSchema();
            if (this.lastExecutionContext != this.isolatedExecutionContext || defaultChanged) {
                contextChanged = true;
            }
        }
        return contextChanged;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this.isNonPersistentEditor()) {
            int decision = ConfirmationDialog.confirmAction((Shell)this.getSite().getShell(), (int)2, (String)"save_sql_console", (int)3, (Object[])new Object[0]);
            if (decision == 2) {
                this.saveAsNewScript();
            }
            return;
        }
        if (!EditorUtils.isInAutoSaveJob()) {
            monitor.beginTask("Save data changes...", 1);
            try {
                monitor.subTask("Save '" + this.getPartName() + "' changes...");
                SaveJob saveJob = new SaveJob();
                saveJob.schedule();
                UIUtils.waitJobCompletion((AbstractJob)saveJob, (IProgressMonitor)monitor);
                if (!saveJob.success.booleanValue()) {
                    monitor.setCanceled(true);
                    return;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (this.extraPresentationManager.activePresentation instanceof ISaveablePart) {
            ((ISaveablePart)this.extraPresentationManager.activePresentation).doSave(monitor);
        }
        super.doSave(monitor);
        this.updateDataSourceContainer();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.saveToExternalFile();
    }

    private synchronized void doScriptAutoSave() {
        if (this.scriptAutoSavejob == null) {
            this.scriptAutoSavejob = new ScriptAutoSaveJob();
        } else {
            this.scriptAutoSavejob.cancel();
        }
        this.scriptAutoSavejob.schedule(1000L);
    }

    public int promptToSaveOnClose() {
        UIServiceConnections serviceConnections;
        int jobsRunning = this.getTotalQueryRunning();
        if (jobsRunning > 0) {
            log.warn((Object)("There are " + jobsRunning + " SQL job(s) still running in the editor"));
            if (ConfirmationDialog.confirmAction(null, (int)4, (String)"close_running_query", (int)3, (Object[])new Object[]{jobsRunning}) != 2) {
                return 2;
            }
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return rsv.promptToSaveOnClose();
            }
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.cancelJob();
            queryProcessor.curJobRunning.updateAndGet(i -> 0);
        }
        if (this.isolatedExecutionContext != null && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null && !serviceConnections.checkAndCloseActiveTransaction(new DBCExecutionContext[]{this.isolatedExecutionContext})) {
            return 2;
        }
        if (this.isNonPersistentEditor()) {
            return 1;
        }
        this.updateDirtyFlag();
        IFile fileFromInput = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnClose") && (fileFromInput == null || fileFromInput.isSynchronized(0))) {
            return 0;
        }
        if (super.isDirty() || this.extraPresentationManager.activePresentation instanceof ISaveablePart && ((ISaveablePart)this.extraPresentationManager.activePresentation).isDirty()) {
            return 3;
        }
        return 0;
    }

    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        IDocumentProviderExtension5 providerExt;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension5 && (providerExt = (IDocumentProviderExtension5)provider).isNotSynchronizedException((Object)this.getEditorInput(), exception)) {
            String[] buttons = new String[]{SQLEditorMessages.update_conflict_message_overwrite, SQLEditorMessages.update_conflict_message_revert, WorkbenchMessages.SaveableHelper_Cancel};
            MessageDialog dialog = new MessageDialog(UIUtils.getActiveShell(), WorkbenchMessages.Save_Resource, null, NLS.bind((String)SQLEditorMessages.update_conflict_message, (Object)this.getEditorInput().getName()), 0, 0, buttons){

                protected int getShellStyle() {
                    return 0x10010860 | 22.getDefaultOrientation();
                }
            };
            int response = dialog.open();
            if (response == 0) {
                this.performSave(true, progressMonitor);
            } else if (response == 1) {
                this.doRevertToSaved();
            } else if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
        } else {
            super.handleExceptionOnSave(exception, progressMonitor);
        }
    }

    protected void afterSaveToFile(File saveFile) {
        try {
            IFileStore fileStore = EFS.getStore((URI)saveFile.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)new SQLNavigatorContext(this.getDataSourceContainer(), this.getExecutionContext()));
            this.setInput((IEditorInput)input);
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError("File save", "Can't open SQL editor from external file", (Throwable)e);
        }
    }

    public boolean supportsRename() {
        return true;
    }

    public void saveToExternalFile() {
        this.saveToExternalFile(this.getScriptDirectory());
    }

    public void saveAsNewScript() {
        SQLNavigatorContext context = new SQLNavigatorContext(this.getDataSourceContainer(), this.getExecutionContext());
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        try {
            IFile script = SQLEditorUtils.createNewScript(this.getProject(), null, context);
            byte[] contents = document.get().getBytes(ResourcesPlugin.getEncoding());
            script.setContents((InputStream)new ByteArrayInputStream(contents), 1, (IProgressMonitor)new NullProgressMonitor());
            FileEditorInput input = new FileEditorInput(script);
            EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)context);
            this.setInput((IEditorInput)input);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("File save", "Can't save as new script file", (Throwable)e);
        }
    }

    @Nullable
    private String getScriptDirectory() {
        URI locationURI;
        IFolder root;
        File inputFile = EditorUtils.getLocalFileFromInput((Object)this.getEditorInput());
        if (inputFile != null) {
            return inputFile.getParent();
        }
        DBPWorkspaceDesktop workspace = DBPPlatformDesktop.getInstance().getWorkspace();
        DBPProject activeProject = workspace.getActiveProject();
        IFolder iFolder = root = activeProject == null ? null : workspace.getResourceDefaultRoot(activeProject, ScriptsHandlerImpl.class, false);
        if (root != null && IOUtils.isLocalURI((URI)(locationURI = root.getLocationURI()))) {
            return new File(locationURI).toString();
        }
        return null;
    }

    @Nullable
    private ResultSetViewer getActiveResultSetViewer() {
        if (this.curResultsContainer != null) {
            return this.curResultsContainer.getResultSetController();
        }
        return null;
    }

    private void showScriptPositionRuler(boolean show) {
        IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
        if (columnSupport != null) {
            RulerColumnDescriptor positionColumn = RulerColumnRegistry.getDefault().getColumnDescriptor("org.jkiss.dbeaver.ui.editors.columns.script.position");
            columnSupport.setColumnVisible(positionColumn, show);
        }
    }

    private void showStatementInEditor(SQLQuery query, boolean select) {
        UIUtils.runUIJob((String)"Select SQL query in editor", monitor -> {
            if (this.isDisposed()) {
                return;
            }
            if (select) {
                this.selectAndReveal(query.getOffset(), query.getLength());
                this.setStatus(query.getText(), DBPMessageType.INFORMATION);
            } else {
                this.getSourceViewer().revealRange(query.getOffset(), query.getLength());
            }
        });
    }

    @Override
    public void reloadSyntaxRules() {
        super.reloadSyntaxRules();
        if (this.outputViewer != null) {
            this.outputViewer.refreshStyles();
        }
    }

    private QueryProcessor createQueryProcessor(boolean setSelection, boolean singleQuery, boolean makeDefault) {
        CTabItem tabItem;
        QueryProcessor queryProcessor;
        this.curQueryProcessor = queryProcessor = this.useTabPerQuery(singleQuery) ? new MultiTabsQueryProcessor(makeDefault) : new SingleTabQueryProcessor(makeDefault);
        this.curResultsContainer = queryProcessor.getFirstResults();
        if (setSelection && (tabItem = this.curResultsContainer.getResultsTab()) != null) {
            this.setResultTabSelection(tabItem);
        }
        return queryProcessor;
    }

    @Override
    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        switch (event.getProperty()) {
            case "sql.parameter.prefix": 
            case "sql.variables.enabled": 
            case "script.sql.ignoreNativeDelimiter": 
            case "sql.command.prefix": 
            case "sql.parameter.anonymous.enabled": 
            case "sql.parameter.enabled": 
            case "script.sql.delimiter.blank": 
            case "script.sql.delimiter": 
            case "sql.parameter.mark": {
                this.reloadSyntaxRules();
                return;
            }
            case "SQLEditor.resultSet.orientation": {
                this.updateResultSetOrientation();
                return;
            }
            case "database.editor.separate.connection": {
                DBPDataSource dataSource = this.curDataSource;
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                if (dataSource != null && SQLEditorUtils.isOpenSeparateConnection(dataSource.getContainer())) {
                    this.initSeparateConnection(dataSource, null, false);
                }
                return;
            }
            case "script.title.pattern": {
                this.setPartName(this.getEditorName());
                return;
            }
            case "SQLEditor.resultSet.multipleResultsPerTab": {
                this.updateMultipleResultsPerTabToolItem();
                return;
            }
        }
        UIUtils.asyncExec(() -> {
            if (this.topBarMan != null) {
                this.topBarMan.update(true);
            }
            this.updateMultipleResultsPerTabToolItem();
        });
        this.setCompletionContext(new SQLEditorCompletionContext(this));
        this.fireDataSourceChanged(event);
        super.preferenceChange(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataSourceChanged(DBPPreferenceListener.PreferenceChangeEvent event) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                try {
                    listener.onDataSourceChanged(event);
                }
                catch (Throwable ex) {
                    log.debug((Object)ex);
                }
            }
        }
    }

    private int obtainDesiredTabIndex(boolean makeDefault) {
        int tabCount = this.resultTabs.getItemCount();
        int tabIndex = 0;
        if (!makeDefault) {
            int i = tabCount;
            while (i > 0) {
                if (this.resultTabs.getItem(i - 1).getData() instanceof QueryProcessingComponent) {
                    tabIndex = i;
                    break;
                }
                --i;
            }
        }
        return tabIndex;
    }

    @NotNull
    protected QueryResultsDecorator createQueryResultsDecorator() {
        return new QueryResultsDecorator(){

            public String getEmptyDataDescription() {
                String execQuery = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.statement", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                String execScript = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.script", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                return NLS.bind((String)ResultSetMessages.sql_editor_resultset_filter_panel_control_execute_to_see_result, (Object)execQuery, (Object)execScript);
            }
        };
    }

    private int getMaxResultsTabIndex() {
        int maxIndex = 0;
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            CTabItem tab = cTabItemArray[n2];
            Object object2 = tab.getData();
            if (object2 instanceof QueryResultsContainer) {
                QueryResultsContainer qrc = (QueryResultsContainer)object2;
                maxIndex = Math.max(maxIndex, qrc.getResultSetIndex());
            }
            if ((object = tab.getData()) instanceof SingleTabQueryProcessor) {
                SingleTabQueryProcessor stqp = (SingleTabQueryProcessor)object;
                List<QueryResultsContainer> results = stqp.getResultContainers();
                maxIndex = Math.max(maxIndex, results.getLast().getResultSetIndex());
            }
            ++n2;
        }
        return maxIndex;
    }

    private String getResultsTabName(int resultSetNumber, int queryIndex, String name) {
        Object tabName = name;
        if (CommonUtils.isEmpty((String)tabName)) {
            tabName = SQLEditorMessages.editors_sql_data_grid;
        }
        tabName = (String)tabName + " " + (queryIndex + 1);
        if (resultSetNumber > 0) {
            tabName = (String)tabName + " (" + (resultSetNumber + 1) + ")";
        }
        return tabName;
    }

    public void updateDirtyFlag() {
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueryServerOutput(@Nullable DBCExecutionResult result) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            DBPDataSource dataSource = executionContext.getDataSource();
            DBCServerOutputReader outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
            if (outputReader == null && result != null) {
                outputReader = new DefaultServerOutputReader();
            }
            if (outputReader != null && outputReader.isServerOutputEnabled()) {
                List<ServerOutputInfo> list = this.serverOutputs;
                synchronized (list) {
                    this.serverOutputs.add(new ServerOutputInfo(outputReader, executionContext, result));
                }
            }
        }
    }

    private void runPostExecuteActions(@Nullable SQLQueryResult result) {
        this.showResultsPanel(true);
    }

    private void updateOutputViewerIcon(boolean alert) {
        Image image = alert ? IMG_OUTPUT_ALERT : IMG_OUTPUT;
        CTabItem outputItem = UIUtils.getTabItem((CTabFolder)this.resultTabs, (Object)((Object)this.outputViewer));
        if (outputItem != null && outputItem != this.resultTabs.getSelection()) {
            outputItem.setImage(image);
        } else {
            ToolItem viewItem = this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.show.output");
            if (viewItem != null) {
                viewItem.setImage(image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnDataListeners(@NotNull QueryResultsContainer container) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            SQLScriptElement query = container.getQuery();
            String queryText = query == null ? "" : query.getOriginalText();
            for (SQLEditorListener listener : this.listeners) {
                try {
                    listener.onDataReceived(this.getContextPrefStore(container), container.getResultSetController().getModel(), queryText);
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnQueryResultListeners(@NotNull QueryResultsContainer container, @NotNull SQLQueryResult result) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                try {
                    listener.onQueryResult(this.getContextPrefStore(container), result);
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        }
    }

    @NotNull
    private DBPPreferenceStore getContextPrefStore(@NotNull QueryResultsContainer container) {
        DBCExecutionContext context = container.getExecutionContext();
        return context != null ? context.getDataSource().getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
    }

    @Nullable
    private String getTransactionStatusText() throws DBCException {
        if (this.dataSourceContainer == null) {
            return null;
        }
        long lastUserActivityTime = DataSourceMonitorJob.getLastUserActivityTime();
        if (lastUserActivityTime < 0L) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedSeconds = (currentTime - lastUserActivityTime) / 1000L;
        if (elapsedSeconds < 60L) {
            return null;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext);
        QMTransactionState txnState = QMUtils.getTransactionState((DBCExecutionContext)executionContext);
        boolean isTransactionInProgress = txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit() && txnState.getUpdateCount() > 0;
        long disconnectTimeoutSeconds = DataSourceMonitorJob.getDisconnectTimeoutSeconds((DBPDataSourceContainer)this.dataSourceContainer);
        long rollbackTimeoutSeconds = DataSourceMonitorJob.getTransactionTimeoutSeconds((DBPDataSourceContainer)this.dataSourceContainer);
        if (isTransactionInProgress && rollbackTimeoutSeconds > 0L && rollbackTimeoutSeconds > elapsedSeconds && (disconnectTimeoutSeconds <= 0L || rollbackTimeoutSeconds < disconnectTimeoutSeconds) && !DBExecUtils.isExecutionInProgress((DBPDataSource)this.dataSourceContainer.getDataSource())) {
            return NLS.bind((String)SQLEditorMessages.sql_editor_status_bar_rollback_label, (Object)RuntimeUtils.formatExecutionTime((Duration)Duration.ofSeconds(rollbackTimeoutSeconds - elapsedSeconds)));
        }
        if (disconnectTimeoutSeconds > 0L && disconnectTimeoutSeconds > elapsedSeconds) {
            return NLS.bind((String)SQLEditorMessages.sql_editor_status_bar_disconnect_label, (Object)RuntimeUtils.formatExecutionTime((Duration)Duration.ofSeconds(disconnectTimeoutSeconds - elapsedSeconds)));
        }
        return null;
    }

    private static class CloseContextJob
    extends AbstractJob {
        private final DBCExecutionContext context;

        CloseContextJob(DBCExecutionContext context) {
            super("Close context " + context.getContextName());
            this.context = context;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Close SQLEditor isolated connection", 1);
            try {
                UIServiceConnections serviceConnections;
                if (QMUtils.isTransactionActive((DBCExecutionContext)this.context) && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null) {
                    serviceConnections.closeActiveTransaction(monitor, this.context, false);
                }
                monitor.subTask("Close context " + this.context.getContextName());
                DBUtils.closeSafely((AutoCloseable)this.context);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class ConnectVisualizer
    extends UIJob {
        private boolean stopped;
        private int tickCount;
        private Cursor oldCursor;

        protected ConnectVisualizer() {
            super("Connect visualizer");
            this.stopped = false;
            this.setSystem(true);
            this.setUser(false);
            StyledText editorControl = SQLEditor.this.getEditorControl();
            if (editorControl != null) {
                this.oldCursor = editorControl.getCursor();
                editorControl.setCursor(editorControl.getDisplay().getSystemCursor(3));
            }
            this.schedule();
        }

        public void stop() {
            this.stopped = true;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ++this.tickCount;
            StyledText editorControl = SQLEditor.this.getEditorControl();
            if (editorControl == null || editorControl.isDisposed()) {
                this.stopped = true;
            }
            if (!this.stopped) {
                SQLEditor.this.setTitleImage(DBeaverIcons.getImage((DBPImage)((DBPImage)UIIcon.LOADING.get(this.tickCount % UIIcon.LOADING.size()))));
                this.schedule(100L);
            } else {
                if (this.oldCursor != null && editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setCursor(this.oldCursor);
                }
                SQLEditor.this.refreshEditorIconAndTitle();
            }
            return Status.OK_STATUS;
        }
    }

    private class DynamicSelectionProvider
    extends CompositeSelectionProvider {
        private boolean lastFocusInEditor = true;

        private DynamicSelectionProvider() {
        }

        public ISelectionProvider getProvider() {
            boolean focusInEditor;
            ISelectionProvider selectionProvider;
            if (SQLEditor.this.extraPresentationManager.activePresentation != null && SQLEditor.this.extraPresentationManager.getActivePresentationControl().isFocusControl() && (selectionProvider = SQLEditor.this.extraPresentationManager.activePresentation.getSelectionProvider()) != null) {
                return selectionProvider;
            }
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor) {
                focusInEditor = rsv != null && rsv.getActivePresentation().getControl() != null && rsv.getActivePresentation().getControl().isFocusControl() ? false : this.lastFocusInEditor;
            }
            this.lastFocusInEditor = focusInEditor;
            if (!focusInEditor && rsv != null) {
                return rsv;
            }
            if (textViewer != null) {
                return textViewer.getSelectionProvider();
            }
            return null;
        }
    }

    private class ExtraPresentationManager {
        private final Map<SQLPresentationDescriptor, SQLEditorPresentation> presentations = new LinkedHashMap<SQLPresentationDescriptor, SQLEditorPresentation>();
        private final Map<SQLPresentationPanelDescriptor, SQLEditorPresentationPanel> panels = new HashMap<SQLPresentationPanelDescriptor, SQLEditorPresentationPanel>();
        private final Map<SQLPresentationDescriptor, Integer> presentationStackIndices = new HashMap<SQLPresentationDescriptor, Integer>();
        private SQLPresentationDescriptor activePresentationDescriptor;
        private SQLEditorPresentation activePresentation;
        private SQLEditorPresentationPanel activePresentationPanel;

        public ExtraPresentationManager() {
            for (SQLPresentationDescriptor presentation : SQLPresentationRegistry.getInstance().getPresentations()) {
                this.presentations.put(presentation, null);
                for (SQLPresentationPanelDescriptor panel : presentation.getPanels()) {
                    this.panels.put(panel, null);
                }
            }
        }

        public boolean setActivePresentation(@Nullable SQLPresentationDescriptor descriptor) throws DBException {
            if (SQLEditor.this.presentationStack == null || this.activePresentationDescriptor == descriptor) {
                return true;
            }
            if (this.activePresentation != null && !this.activePresentation.canHidePresentation(SQLEditor.this)) {
                return false;
            }
            if (descriptor == null) {
                this.activePresentationDescriptor = null;
                this.activePresentation = null;
                this.activePresentationPanel = null;
                SQLEditorPropertyTester.firePropertyChange("canExecute");
                return true;
            }
            SQLEditorPresentation presentation = this.presentations.get((Object)descriptor);
            if (presentation == null) {
                presentation = descriptor.createPresentation();
                if (presentation.canShowPresentation(SQLEditor.this, true)) {
                    this.presentationStackIndices.put(descriptor, SQLEditor.this.presentationStack.getChildren().length);
                    Composite placeholder = new Composite(SQLEditor.this.presentationStack, 0);
                    placeholder.setLayout((Layout)new FillLayout());
                    if (this.activePresentation != null) {
                        this.activePresentation.hidePresentation(SQLEditor.this);
                    }
                    this.activePresentationDescriptor = descriptor;
                    this.activePresentation = presentation;
                    this.activePresentation.createPresentation(placeholder, SQLEditor.this);
                    this.activePresentation.showPresentation(SQLEditor.this, true);
                    this.presentations.put(descriptor, this.activePresentation);
                    SQLEditorPropertyTester.firePropertyChange("canExecute");
                    return true;
                }
            } else if (presentation.canShowPresentation(SQLEditor.this, false)) {
                if (this.activePresentation != null) {
                    this.activePresentation.hidePresentation(SQLEditor.this);
                }
                this.activePresentationDescriptor = descriptor;
                this.activePresentation = presentation;
                this.activePresentation.showPresentation(SQLEditor.this, false);
                SQLEditorPropertyTester.firePropertyChange("canExecute");
                return true;
            }
            return false;
        }

        @Nullable
        private Control getActivePresentationControl() {
            if (SQLEditor.this.presentationStack == null || this.activePresentationDescriptor == null) {
                return null;
            }
            int index = this.presentationStackIndices.get((Object)this.activePresentationDescriptor);
            return SQLEditor.this.presentationStack.getChildren()[index];
        }

        @NotNull
        private VerticalButton createPresentationButton(@NotNull SQLPresentationDescriptor presentation, SQLEditor editor) {
            VerticalButton button = new VerticalButton(editor.presentationSwitchFolder, 131104);
            button.setData((Object)presentation);
            button.setText(presentation.getLabel());
            button.setImage(DBeaverIcons.getImage((DBPImage)presentation.getIcon()));
            String toolTip = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.switch.presentation", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true, (String)"presentationId", (String)presentation.getId());
            if (CommonUtils.isEmpty((String)toolTip)) {
                button.setToolTipText(presentation.getDescription());
            } else {
                button.setToolTipText(presentation.getDescription() + " (" + toolTip + ")");
            }
            IEvaluationService evaluationService = (IEvaluationService)SQLEditor.this.getSite().getService(IEvaluationService.class);
            Expression enabledWhen = presentation.getEnabledWhen();
            if (evaluationService != null && enabledWhen != null) {
                IEvaluationReference reference = evaluationService.addEvaluationListener(enabledWhen, event -> this.handlePresentationEnablement(button, presentation, CommonUtils.toBoolean((Object)event.getNewValue())), "enabled");
                button.addDisposeListener(e -> evaluationService.removeEvaluationListener(reference));
            }
            return button;
        }

        private void handlePresentationEnablement(@NotNull VerticalButton button, @NotNull SQLPresentationDescriptor presentation, boolean enabled) {
            if (SQLEditor.this.isDisposed()) {
                return;
            }
            if (!enabled && this.activePresentationDescriptor == presentation) {
                SQLEditor.this.showExtraPresentation((SQLPresentationDescriptor)null);
            }
            button.setVisible(enabled);
            button.getParent().layout(true, true);
        }

        public void dispose() {
            this.activePresentationDescriptor = null;
            this.activePresentation = null;
            this.activePresentationPanel = null;
            for (SQLEditorPresentation presentation : this.presentations.values()) {
                if (presentation == null) continue;
                presentation.dispose();
            }
            this.presentations.clear();
            this.panels.clear();
        }
    }

    private class FindReplaceTarget
    extends DynamicFindReplaceTarget {
        private IFindReplaceTarget previousTarget = null;

        private FindReplaceTarget() {
        }

        public IFindReplaceTarget getTarget() {
            boolean focusInEditor;
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            SQLEditorOutputConsoleViewer outputViewer = SQLEditor.this.outputViewer.getViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget() != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor && rsv == null && !outputViewer.getText().isFocusControl() && this.previousTarget != null) {
                boolean bl2 = focusInEditor = textViewer != null && this.previousTarget.equals(textViewer.getFindReplaceTarget());
            }
            if (!focusInEditor) {
                if (rsv != null && rsv.getActivePresentation().getControl().isFocusControl()) {
                    this.previousTarget = (IFindReplaceTarget)rsv.getAdapter(IFindReplaceTarget.class);
                } else if (outputViewer.getControl().isFocusControl()) {
                    this.previousTarget = new StyledTextFindReplaceTarget(outputViewer.getText());
                }
            } else {
                this.previousTarget = textViewer.getFindReplaceTarget();
            }
            return this.previousTarget;
        }
    }

    class MultiTabsQueryProcessor
    extends QueryProcessor {
        MultiTabsQueryProcessor(boolean makeDefault) {
            super(makeDefault);
        }

        @Override
        @NotNull
        protected QueryResultsContainer createQueryResultsContainer(int resultSetNumber, int resultSetIndex, boolean makeDefault) {
            return new MultiTabsQueryResultsContainer((QueryProcessor)this, resultSetNumber, resultSetIndex, makeDefault);
        }

        @Override
        @NotNull
        protected QueryResultsContainer createQueryResultsContainer(int resultSetNumber, int resultSetIndex, @NotNull DBSDataContainer dataContainer) {
            return new MultiTabsQueryResultsContainer((QueryProcessor)this, resultSetNumber, resultSetIndex, dataContainer);
        }
    }

    class MultiTabsQueryResultsContainer
    extends QueryResultsContainer {
        private CTabItem resultsTab;

        MultiTabsQueryResultsContainer(QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean makeDefault) {
            super((Composite)SQLEditor.this.resultTabs, queryProcessor, resultSetNumber, resultSetIndex, makeDefault);
            this.resultsTab = this.createResultTab(makeDefault);
        }

        MultiTabsQueryResultsContainer(QueryProcessor queryProcessor, int resultSetNumber, @NotNull int resultSetIndex, DBSDataContainer dataContainer) {
            super((Composite)SQLEditor.this.resultTabs, queryProcessor, resultSetNumber, resultSetIndex, dataContainer);
            this.resultsTab = this.createResultTab(false);
        }

        @NotNull
        private CTabItem createResultTab(boolean makeDefault) {
            int tabIndex = SQLEditor.this.obtainDesiredTabIndex(makeDefault);
            CTabItem resultsTab = new CTabItem(SQLEditor.this.resultTabs, 0, tabIndex);
            resultsTab.setImage(IMG_DATA_GRID);
            resultsTab.setData((Object)this);
            resultsTab.setShowClose(true);
            resultsTab.setText(SQLEditor.this.getResultsTabName(this.resultSetNumber, this.getQueryIndex(), null));
            CSSUtils.markConnectionTypeColor((Widget)resultsTab);
            resultsTab.setControl((Control)this.viewer.getControl());
            resultsTab.addDisposeListener(SQLEditor.this.resultTabDisposeListener);
            UIUtils.disposeControlOnItemDispose((CTabItem)resultsTab);
            return resultsTab;
        }

        @Override
        public void setTabName(@NotNull String tabName) {
            super.setTabName(tabName);
            this.resultsTab.setText(tabName);
        }

        @Override
        public void updateResultsName(@NotNull String resultSetName, @Nullable String toolTip) {
            CTabItem tabItem = this.resultsTab;
            if (tabItem != null && !tabItem.isDisposed()) {
                if (!CommonUtils.isEmpty((String)resultSetName)) {
                    tabItem.setText(resultSetName);
                }
                if (toolTip != null) {
                    tabItem.setToolTipText(toolTip);
                }
            }
        }

        @Override
        @NotNull
        public CTabItem getResultsTab() {
            return this.resultsTab;
        }

        @Override
        public boolean isPinned() {
            return this.isTabPinned(this.resultsTab);
        }

        @Override
        public void setPinned(boolean pinned) {
            this.setTabPinned(this.resultsTab, pinned);
        }

        @Override
        public void detach() {
            super.detach();
            if (this.detached) {
                this.resultsTab.dispose();
                this.resultsTab = null;
            }
        }

        @Override
        protected void dispose() {
            UIUtils.syncExec(() -> ((CTabItem)this.resultsTab).dispose());
        }
    }

    private class OpenContextJob
    extends AbstractJob {
        private final DBSInstance instance;
        private final Runnable onSuccess;
        private Throwable error;
        private final boolean readDefaultsFromInstance;

        OpenContextJob(DBSInstance instance, Runnable onSuccess, boolean readDefaultsFromInstance) {
            super("Open connection to " + instance.getDataSource().getContainer().getName());
            this.instance = instance;
            this.onSuccess = onSuccess;
            this.readDefaultsFromInstance = readDefaultsFromInstance;
            this.setUser(true);
        }

        public boolean belongsTo(Object family) {
            if (family == this || family == SQLEditor.this.dataSourceContainer) {
                return true;
            }
            return super.belongsTo(family);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            block10: {
                monitor.beginTask("Open SQLEditor isolated connection", 1);
                try {
                    try {
                        DBCExecutionContextDefaults contextDefaultsDB;
                        DBCExecutionContext defaultContext;
                        String title = "SQLEditor <" + SQLEditor.this.getEditorInput().getName() + ">";
                        monitor.subTask("Open context " + title);
                        final DBCExecutionContext newContext = this.instance.openIsolatedContext(monitor, title, this.instance.getDefaultContext(monitor, false));
                        String[] contextDefaultNames = null;
                        if (this.readDefaultsFromInstance && SQLEditor.this.datasourceChanged && (defaultContext = DBUtils.getDefaultContext((DBSObject)this.instance, (boolean)false)) != null && (contextDefaultsDB = defaultContext.getContextDefaults()) != null) {
                            contextDefaultNames = new String[2];
                            contextDefaultNames[0] = contextDefaultsDB.getDefaultCatalog() != null ? contextDefaultsDB.getDefaultCatalog().getName() : null;
                            String string = contextDefaultNames[1] = contextDefaultsDB.getDefaultSchema() != null ? contextDefaultsDB.getDefaultSchema().getName() : null;
                        }
                        if (contextDefaultNames == null) {
                            String[] stringArray = contextDefaultNames = SQLEditor.this.isRestoreActiveSchemaFromScript() && this.instance.getDataSource() != null ? EditorUtils.getInputContextDefaults((DBPDataSourceContainer)this.instance.getDataSource().getContainer(), (IEditorInput)SQLEditor.this.getEditorInput()) : null;
                        }
                        if (!(contextDefaultNames == null || contextDefaultNames.length <= 1 || CommonUtils.isEmpty((String)contextDefaultNames[0]) && CommonUtils.isEmpty((String)contextDefaultNames[1]))) {
                            try {
                                DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)monitor, (DBPDataSource)newContext.getDataSource(), (DBCExecutionContext)newContext, (String)contextDefaultNames[0], null, (String)contextDefaultNames[1]);
                            }
                            catch (DBException e) {
                                DBWorkbench.getPlatformUI().showError("New connection default", "Error setting default catalog/schema for new connection", (Throwable)e);
                            }
                        }
                        SQLEditor.this.isolatedExecutionContext = newContext;
                        new AbstractJob("Notify context change"){

                            protected IStatus run(DBRProgressMonitor monitor) {
                                DBUtils.fireObjectSelect((DBSObject)OpenContextJob.this.instance, (boolean)true, (DBCExecutionContext)newContext);
                                return Status.OK_STATUS;
                            }
                        }.schedule(200L);
                    }
                    catch (DBException e) {
                        this.error = e;
                        monitor.done();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            this.updateContext();
            return Status.OK_STATUS;
        }

        private void updateContext() {
            if (this.error != null) {
                SQLEditor.this.releaseExecutionContext();
                DBWorkbench.getPlatformUI().showError("Open context", "Can't open editor connection", this.error);
            } else {
                if (this.onSuccess != null) {
                    this.onSuccess.run();
                }
                SQLEditor.this.fireDataSourceChange();
            }
        }
    }

    private class OutputAutoShowToggleAction
    extends Action {
        OutputAutoShowToggleAction() {
            super(SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view, 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            this.setChecked(SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.outputPanel.autoShow"));
        }

        public void run() {
            SQLEditor.this.getActivePreferenceStore().setValue("SQLEditor.outputPanel.autoShow", this.isChecked());
            try {
                SQLEditor.this.getActivePreferenceStore().save();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private class OutputLogWriter
    implements DBCOutputWriter {
        private OutputLogWriter() {
        }

        public void println(@Nullable DBCOutputSeverity severity, @Nullable String message) {
            UIUtils.syncExec(() -> {
                if (!SQLEditor.this.outputViewer.isDisposed()) {
                    SQLEditor.this.outputViewer.println(severity, message);
                    SQLEditor.this.outputViewer.getViewer().scrollToEnd();
                    if (!SQLEditor.this.outputViewer.isVisible()) {
                        SQLEditor.this.updateOutputViewerIcon(true);
                    }
                }
            });
        }

        public void flush() {
            SQLEditor.this.outputViewer.flush();
        }
    }

    private class PresentationPanelToggleAction
    extends Action {
        private final SQLPresentationPanelDescriptor panel;

        public PresentationPanelToggleAction(SQLPresentationPanelDescriptor panel) {
            super(panel.getLabel(), 2);
            this.setId(SQLEditor.PANEL_ITEM_PREFIX + panel.getId());
            if (panel.getIcon() != null) {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)panel.getIcon()));
            }
            if (panel.getDescription() != null) {
                this.setToolTipText(panel.getDescription());
            }
            this.panel = panel;
        }

        public void run() {
            CTabItem tabItem;
            int n;
            int n2;
            CTabItem[] cTabItemArray;
            this.setChecked(!this.isChecked());
            SQLEditorPresentationPanel panelInstance = SQLEditor.this.extraPresentationManager.panels.get((Object)this.panel);
            if (panelInstance != null && !this.isChecked()) {
                cTabItemArray = SQLEditor.this.resultTabs.getItems();
                n2 = cTabItemArray.length;
                n = 0;
                while (n < n2) {
                    tabItem = cTabItemArray[n];
                    if (tabItem.getData() == panelInstance) {
                        tabItem.dispose();
                        return;
                    }
                    ++n;
                }
            }
            if (panelInstance == null) {
                Control panelControl;
                try {
                    panelInstance = this.panel.createPanel();
                    panelControl = panelInstance.createPanel((Composite)SQLEditor.this.resultTabs, SQLEditor.this, SQLEditor.this.extraPresentationManager.activePresentation);
                }
                catch (DBException e2) {
                    DBWorkbench.getPlatformUI().showError("Panel opening error", "Can't create panel " + this.panel.getLabel(), (Throwable)e2);
                    return;
                }
                SQLEditor.this.extraPresentationManager.panels.put(this.panel, panelInstance);
                CTabItem tabItem2 = new CTabItem(SQLEditor.this.resultTabs, 64);
                tabItem2.setControl(panelControl);
                tabItem2.setText(this.panel.getLabel());
                tabItem2.setToolTipText(this.panel.getDescription());
                tabItem2.setImage(DBeaverIcons.getImage((DBPImage)this.panel.getIcon()));
                tabItem2.setData((Object)panelInstance);
                tabItem2.addDisposeListener(e -> {
                    this.setChecked(false);
                    panelControl.dispose();
                    SQLEditor.this.extraPresentationManager.panels.remove((Object)this.panel);
                    SQLEditor.this.extraPresentationManager.activePresentationPanel = null;
                    SQLEditor.this.resultTabDisposeListener.widgetDisposed(e);
                });
                SQLEditor.this.extraPresentationManager.activePresentationPanel = panelInstance;
                SQLEditor.this.setResultTabSelection(tabItem2);
            } else {
                cTabItemArray = SQLEditor.this.resultTabs.getItems();
                n2 = cTabItemArray.length;
                n = 0;
                while (n < n2) {
                    tabItem = cTabItemArray[n];
                    if (tabItem.getData() == panelInstance) {
                        SQLEditor.this.setResultTabSelection(tabItem);
                        break;
                    }
                    ++n;
                }
            }
            if (!SQLEditor.this.isHideQueryText() && SQLEditor.this.resultsSash.getMaximizedControl() != null) {
                UIUtils.asyncExec(() -> SQLEditor.this.resultsSash.setMaximizedControl(null));
            }
        }
    }

    private static interface QueryProcessingComponent {
    }

    public abstract class QueryProcessor
    implements SQLResultsConsumer,
    ISmartTransactionManager,
    QueryProcessingComponent {
        private volatile SQLQueryJob curJob;
        private final AtomicInteger curJobRunning = new AtomicInteger(0);
        protected final List<QueryResultsContainer> resultContainers = new ArrayList<QueryResultsContainer>();
        private volatile DBDDataReceiver curDataReceiver = null;

        QueryProcessor(boolean makeDefault) {
            if (makeDefault) {
                SQLEditor.this.queryProcessors.addFirst(this);
            } else {
                SQLEditor.this.queryProcessors.add(this);
            }
            this.createResultsProvider(0, makeDefault);
        }

        int getRunningJobs() {
            return this.curJobRunning.get();
        }

        private QueryResultsContainer createResultsProvider(int resultSetNumber, boolean makeDefault) {
            QueryResultsContainer resultsProvider = this.createQueryResultsContainer(resultSetNumber, SQLEditor.this.getMaxResultsTabIndex() + 1, makeDefault);
            this.resultContainers.add(resultsProvider);
            return resultsProvider;
        }

        private QueryResultsContainer createResultsProvider(@NotNull DBSDataContainer dataContainer) {
            QueryResultsContainer resultsProvider = this.createQueryResultsContainer(this.resultContainers.size(), SQLEditor.this.getMaxResultsTabIndex(), dataContainer);
            this.resultContainers.add(resultsProvider);
            return resultsProvider;
        }

        protected abstract QueryResultsContainer createQueryResultsContainer(int var1, int var2, boolean var3);

        protected abstract QueryResultsContainer createQueryResultsContainer(int var1, int var2, DBSDataContainer var3);

        public boolean hasPinnedTabs() {
            for (QueryResultsContainer container : this.resultContainers) {
                if (!container.isPinned()) continue;
                return true;
            }
            return false;
        }

        @NotNull
        QueryResultsContainer getFirstResults() {
            return this.resultContainers.getFirst();
        }

        @NotNull
        List<QueryResultsContainer> getResultContainers() {
            return this.resultContainers;
        }

        private void closeJob() {
            SQLQueryJob job = this.curJob;
            if (job != null) {
                if (job.getState() == 4) {
                    job.cancel();
                }
                this.curJob = null;
                if (job.isJobOpen()) {
                    RuntimeUtils.runTask(monitor -> job.closeJob(), (String)"Close SQL job", (long)2000L, (boolean)true);
                }
            }
        }

        public void cancelJob() {
            for (QueryResultsContainer rc : this.resultContainers) {
                rc.viewer.cancelJobs();
            }
            SQLQueryJob job = this.curJob;
            if (job != null && job.getState() == 4) {
                job.cancel();
            }
        }

        boolean processQueries(SQLScriptContext scriptContext, List<SQLScriptElement> queries, boolean forceScript, boolean fetchResults, boolean export, boolean closeTabOnError, SQLQueryListener queryListener) {
            if (queries.isEmpty()) {
                return false;
            }
            if (this.curJobRunning.get() > 0) {
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_query_message);
                return false;
            }
            DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
            if (executionContext == null) {
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, ModelMessages.error_not_connected_to_database);
                return false;
            }
            boolean isSingleQuery = !forceScript && queries.size() == 1;
            SQLEditor.this.showScriptPositionRuler(SQLEditor.this.isShowScriptRulerOnExecution);
            QueryResultsContainer resultsContainer = this.getFirstResults();
            SQLEditorQueryListener listener = new SQLEditorQueryListener(this, closeTabOnError);
            if (queryListener != null) {
                listener.setExtListener(queryListener);
            }
            if (export) {
                this.processDataExport(scriptContext, queries);
            } else {
                boolean disableFetchCurrentResultSets;
                if (queries.size() > 100) {
                    if (SQLEditor.this.isDisableFetchResultSet == null) {
                        DBPPlatformUI.UserChoiceResponse rs = DBWorkbench.getPlatformUI().showUserChoice(SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_title, SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_question, List.of(SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_yes, SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_no), List.of(SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_remember), Integer.valueOf(0), 0);
                        boolean bl = disableFetchCurrentResultSets = rs.choiceIndex == 0;
                        if (rs.forAllChoiceIndex != null) {
                            SQLEditor.this.isDisableFetchResultSet = disableFetchCurrentResultSets;
                        }
                    } else {
                        disableFetchCurrentResultSets = SQLEditor.this.isDisableFetchResultSet;
                    }
                } else {
                    disableFetchCurrentResultSets = false;
                }
                SQLQueryJob job = new SQLQueryJob(SQLEditor.this.getSite(), isSingleQuery ? SQLEditorMessages.editors_sql_job_execute_query : SQLEditorMessages.editors_sql_job_execute_script, executionContext, resultsContainer, queries, scriptContext, this, listener, disableFetchCurrentResultSets);
                if (isSingleQuery) {
                    resultsContainer.query = queries.getFirst();
                    this.closeJob();
                    this.curJob = job;
                    ResultSetViewer rsv = resultsContainer.getResultSetController();
                    if (rsv != null) {
                        rsv.resetDataFilter(false);
                        rsv.resetHistory();
                        rsv.refresh();
                    }
                } else {
                    if (fetchResults) {
                        job.setFetchResultSets(true);
                    }
                    job.schedule();
                    this.curJob = job;
                }
            }
            return true;
        }

        private void processDataExport(SQLScriptContext scriptContext, List<SQLScriptElement> queries) {
            ArrayList<DatabaseTransferProducer> producers = new ArrayList<DatabaseTransferProducer>();
            for (SQLScriptElement element : queries) {
                if (element instanceof SQLControlCommand) {
                    SQLControlCommand controlCommand = (SQLControlCommand)element;
                    try {
                        SQLControlResult controlResult = scriptContext.executeControlCommand((DBRProgressMonitor)new LoggingProgressMonitor(log), controlCommand);
                        if (controlResult.getTransformed() != null) {
                            element = controlResult.getTransformed();
                        }
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("Command error", "Error processing control command", (Throwable)e);
                        return;
                    }
                }
                if (element instanceof SQLScript) {
                    DBWorkbench.getPlatformUI().showError("Embedded scripts are not allowed", "Query contains script element: " + element.getText());
                    return;
                }
                if (!(element instanceof SQLQuery)) continue;
                SQLQuery query = (SQLQuery)element;
                scriptContext.fillQueryParameters(query, () -> null, false);
                SQLQueryDataContainer dataContainer = new SQLQueryDataContainer((DBPContextProvider)SQLEditor.this, query, scriptContext, log);
                producers.add(new DatabaseTransferProducer((DBSDataContainer)dataContainer, null));
            }
            DataTransferWizard.openWizard((IWorkbenchWindow)SQLEditor.this.getSite().getWorkbenchWindow(), producers, null, (IStructuredSelection)new StructuredSelection((Object)this));
        }

        public boolean isDirty() {
            for (QueryResultsContainer resultsProvider : this.resultContainers) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return true;
            }
            return false;
        }

        void removeResults(QueryResultsContainer resultsContainer) {
            this.resultContainers.remove(resultsContainer);
            if (this.resultContainers.isEmpty()) {
                SQLEditor.this.queryProcessors.remove(this);
                if (SQLEditor.this.curQueryProcessor == this) {
                    if (SQLEditor.this.queryProcessors.isEmpty()) {
                        SQLEditor.this.curQueryProcessor = null;
                        SQLEditor.this.curResultsContainer = null;
                    } else {
                        SQLEditor.this.curQueryProcessor = SQLEditor.this.queryProcessors.getFirst();
                        SQLEditor.this.curResultsContainer = SQLEditor.this.curQueryProcessor.getFirstResults();
                    }
                }
            }
        }

        @Override
        @Nullable
        public DBDDataReceiver getDataReceiver(SQLQuery statement, int resultSetNumber) {
            ResultSetViewer rsv;
            boolean isStatsResult;
            if (this.curDataReceiver != null) {
                return this.curDataReceiver;
            }
            boolean bl = isStatsResult = statement != null && statement.getData() == SQLQueryJob.STATS_RESULTS;
            if (resultSetNumber >= this.resultContainers.size() && !SQLEditor.this.isDisposed()) {
                UIUtils.syncExec(() -> {
                    QueryResultsContainer queryResultsContainer = this.createResultsProvider(resultSetNumber, false);
                });
            }
            if (resultSetNumber >= this.resultContainers.size()) {
                return null;
            }
            QueryResultsContainer resultsProvider = this.resultContainers.get(resultSetNumber);
            if (statement != null && !SQLEditor.this.resultTabs.isDisposed()) {
                resultsProvider.query = statement;
                resultsProvider.lastGoodQuery = statement;
                Object tabName = null;
                String queryText = CommonUtils.truncateString((String)statement.getText(), (int)1000);
                DBPDataSourceContainer dataSourceContainer = SQLEditor.this.getDataSourceContainer();
                String dataSourceContainerName = dataSourceContainer == null ? "N/A" : dataSourceContainer.getName();
                String processedQueryText = CommonUtils.isEmpty((String)queryText) ? "N/A" : queryText;
                String toolTip = NLS.bind((String)SQLEditorMessages.sql_editor_data_receiver_result_name_tooltip_connection, (Object)dataSourceContainerName) + GeneralUtils.getDefaultLineSeparator() + NLS.bind((String)SQLEditorMessages.sql_editor_data_receiver_result_name_tooltip_time, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date())) + GeneralUtils.getDefaultLineSeparator() + NLS.bind((String)SQLEditorMessages.sql_editor_data_receiver_result_name_tooltip_query, (Object)processedQueryText);
                if (isStatsResult) {
                    tabName = SQLEditorMessages.editors_sql_statistics;
                    int queryIndex = SQLEditor.this.queryProcessors.indexOf(this);
                    tabName = (String)tabName + " " + (queryIndex + 1);
                }
                String finalTabName = tabName;
                UIUtils.asyncExec(() -> resultsProvider.updateResultsName(finalTabName, toolTip));
            }
            return (rsv = resultsProvider.getResultSetController()) == null ? null : rsv.getDataReceiver();
        }

        public boolean isSmartAutoCommit() {
            return SQLEditor.this.isSmartAutoCommit();
        }

        public void setSmartAutoCommit(boolean smartAutoCommit) {
            SQLEditor.this.setSmartAutoCommit(smartAutoCommit);
        }
    }

    public abstract class QueryResultsContainer
    implements DBSDataContainer,
    IResultSetContainer,
    IResultSetValueReflector,
    IResultSetListener,
    IResultSetContainerExt,
    SQLQueryContainer,
    ISmartTransactionManager,
    IQueryExecuteController,
    QueryProcessingComponent {
        protected final QueryProcessor queryProcessor;
        protected final ResultSetViewer viewer;
        protected int resultSetNumber;
        protected final int resultSetIndex;
        private SQLScriptElement query = null;
        private SQLScriptElement lastGoodQuery = null;
        private DBSDataContainer dataContainer;
        private String tabName;
        protected boolean detached;

        private QueryResultsContainer(@NotNull Composite resultSetViewerContainer, QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean makeDefault) {
            this.queryProcessor = queryProcessor;
            this.resultSetNumber = resultSetNumber;
            this.resultSetIndex = resultSetIndex;
            this.viewer = new ResultSetViewer(resultSetViewerContainer, SQLEditor.this.getSite(), (IResultSetContainer)this);
            this.viewer.addListener((IResultSetListener)this);
            this.viewer.getControl().addDisposeListener(e -> {
                this.queryProcessor.removeResults(this);
                if (this == SQLEditor.this.curResultsContainer) {
                    SQLEditor.this.curResultsContainer = null;
                }
            });
        }

        protected abstract void dispose();

        QueryResultsContainer(@NotNull Composite resultSetViewerContainer, QueryProcessor queryProcessor, int resultSetNumber, @NotNull int resultSetIndex, DBSDataContainer dataContainer) {
            this(resultSetViewerContainer, queryProcessor, resultSetNumber, resultSetIndex, false);
            this.dataContainer = dataContainer;
            this.updateResultsName(sQLEditor.getResultsTabName(resultSetNumber, 0, dataContainer.getName()), null);
        }

        public void detach() {
            try {
                this.detached = true;
                SQLEditor.this.getSite().getPage().openEditor((IEditorInput)new SQLResultsEditorInput(this), SQLResultsEditor.class.getName(), true, 0);
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError("Detached results", "Can't open results view", e);
                this.detached = false;
            }
        }

        public int getResultSetIndex() {
            return this.resultSetIndex;
        }

        public int getQueryIndex() {
            return SQLEditor.this.queryProcessors.indexOf(this.queryProcessor);
        }

        abstract void updateResultsName(String var1, String var2);

        @Nullable
        public DBPProject getProject() {
            return SQLEditor.this.getProject();
        }

        public DBCExecutionContext getExecutionContext() {
            return SQLEditor.this.getExecutionContext();
        }

        @Nullable
        public ResultSetViewer getResultSetController() {
            return this.viewer;
        }

        boolean hasData() {
            return this.viewer != null && this.viewer.hasData();
        }

        @Nullable
        public DBSDataContainer getDataContainer() {
            return this;
        }

        public boolean isReadyToRun() {
            return this.queryProcessor.curJob == null || this.queryProcessor.curJobRunning.get() <= 0;
        }

        public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
            UIUtils.syncExec(() -> {
                QueryResultsContainer resultsProvider = this.queryProcessor.createResultsProvider(dataContainer);
                CTabItem tabItem = resultsProvider.getResultsTab();
                if (tabItem != null) {
                    tabItem.getParent().setSelection(tabItem);
                }
                SQLEditor.this.setActiveResultsContainer(resultsProvider);
                resultsProvider.viewer.refreshWithFilter(newFilter);
            });
        }

        public IResultSetDecorator createResultSetDecorator() {
            return SQLEditor.this.createQueryResultsDecorator();
        }

        @NotNull
        public String[] getSupportedFeatures() {
            SQLQuery sqlQuery;
            if (this.dataContainer != null) {
                return this.dataContainer.getSupportedFeatures();
            }
            ArrayList<String> features = new ArrayList<String>(3);
            features.add("data.select");
            SQLScriptElement sQLScriptElement = this.query;
            if (sQLScriptElement instanceof SQLQuery && (sqlQuery = (SQLQuery)sQLScriptElement).isModifying()) {
                features.add("data.modifying");
            }
            features.add("data.count");
            if (this.getQueryResultCounts() <= 1 && this.lastGoodQuery instanceof SQLQuery) {
                features.add("data.filter");
            }
            return features.toArray(new String[0]);
        }

        @NotNull
        public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
            SQLQuery sqlQuery;
            if (this.dataContainer != null) {
                return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags, fetchSize);
            }
            SQLQueryJob job = this.queryProcessor.curJob;
            if (job == null) {
                throw new DBCException("No active query - can't read data");
            }
            SQLScriptElement sQLScriptElement = this.query;
            if (sQLScriptElement instanceof SQLQuery && (sqlQuery = (SQLQuery)sQLScriptElement).getResultsMaxRows() >= 0) {
                firstRow = sqlQuery.getResultsOffset();
                maxRows = sqlQuery.getResultsMaxRows();
            }
            try {
                this.queryProcessor.curDataReceiver = dataReceiver != this.viewer.getDataReceiver() ? dataReceiver : null;
                int resultCounts = this.getQueryResultCounts();
                if (resultCounts <= 1 && this.resultSetNumber > 0) {
                    job.setFetchResultSetNumber(this.resultSetNumber);
                } else {
                    job.setFetchResultSetNumber(-1);
                }
                job.setResultSetLimit(firstRow, maxRows);
                job.setDataFilter(dataFilter);
                job.setFetchSize(fetchSize);
                job.setFetchFlags(flags);
                try {
                    job.extractData(session, this.query, resultCounts > 1 ? 0 : this.resultSetNumber, !this.detached, !this.detached);
                }
                finally {
                    this.lastGoodQuery = job.getLastGoodQuery();
                }
                DBCStatistics dBCStatistics = job.getStatistics();
                return dBCStatistics;
            }
            finally {
                this.queryProcessor.curDataReceiver = null;
            }
        }

        private int getQueryResultCounts() {
            int resultCounts = 0;
            for (QueryResultsContainer qrc : this.queryProcessor.resultContainers) {
                if (qrc.query != this.query) continue;
                ++resultCounts;
            }
            return resultCounts;
        }

        /*
         * WARNING - void declaration
         */
        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBException {
            if (this.dataContainer != null) {
                return this.dataContainer.countData(source, session, dataFilter, 0L);
            }
            DBPDataSource dataSource = this.getDataSource();
            if (dataSource == null) {
                throw new DBCException("Query transform is not supported by datasource");
            }
            SQLScriptElement sQLScriptElement = this.query;
            if (!(sQLScriptElement instanceof SQLQuery)) {
                throw new DBCException("Can't count rows for control command");
            }
            SQLQuery sQLQuery = (SQLQuery)sQLScriptElement;
            try {
                void sqlQuery;
                SQLQuery countQuery = new SQLQueryTransformerCount().transformQuery(dataSource, SQLEditor.this.getSyntaxManager(), (SQLQuery)sqlQuery);
                if (!CommonUtils.isEmpty((Collection)countQuery.getParameters())) {
                    countQuery.setParameters(SQLEditor.this.parseQueryParameters(countQuery));
                }
                return DBUtils.countDataFromQuery((DBCExecutionSource)source, (DBCSession)session, (SQLQuery)countQuery);
            }
            catch (DBException e) {
                throw new DBCException("Error executing row count", (Throwable)e);
            }
        }

        @Nullable
        public String getDescription() {
            if (this.dataContainer != null) {
                return this.dataContainer.getDescription();
            }
            return SQLEditorMessages.editors_sql_description;
        }

        @Nullable
        public DBSObject getParentObject() {
            return this.getDataSource();
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return SQLEditor.this.getDataSource();
        }

        public boolean isPersisted() {
            return this.dataContainer == null || this.dataContainer.isPersisted();
        }

        @NotNull
        public String getName() {
            String name;
            if (this.dataContainer != null) {
                return this.dataContainer.getName();
            }
            String string = this.lastGoodQuery != null ? this.lastGoodQuery.getOriginalText() : (name = this.query == null ? null : this.query.getOriginalText());
            if (name == null) {
                name = "SQL";
            }
            return name;
        }

        @Nullable
        public DBPDataSourceContainer getDataSourceContainer() {
            return SQLEditor.this.getDataSourceContainer();
        }

        public String toString() {
            if (this.dataContainer != null) {
                return this.dataContainer.toString();
            }
            return this.query == null ? "SQL Query / " + SQLEditor.this.getEditorInput().getName() : this.query.getOriginalText();
        }

        public void handleResultSetLoad() {
        }

        public void handleResultSetChange() {
            SQLEditor.this.updateDirtyFlag();
        }

        public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        }

        public void onModelPrepared() {
            SQLEditor.this.notifyOnDataListeners(this);
        }

        public SQLScriptContext getScriptContext() {
            return SQLEditor.this.getGlobalScriptContext();
        }

        public SQLScriptElement getQuery() {
            return this.query;
        }

        public Map<String, Object> getQueryParameters() {
            return SQLEditor.this.globalScriptContext.getAllParameters();
        }

        public boolean isSmartAutoCommit() {
            return SQLEditor.this.isSmartAutoCommit();
        }

        public void setSmartAutoCommit(boolean smartAutoCommit) {
            SQLEditor.this.setSmartAutoCommit(smartAutoCommit);
        }

        public void setTabName(String tabName) {
            this.tabName = tabName;
        }

        public void insertCurrentCellValue(DBDAttributeBinding attributeBinding, Object cellValue, String stringValue) {
            StyledText textWidget;
            StyledText styledText = textWidget = SQLEditor.this.getTextViewer() == null ? null : SQLEditor.this.getTextViewer().getTextWidget();
            if (textWidget != null) {
                String sqlValue = this.getDataSource() != null ? SQLUtils.convertValueToSQL((DBPDataSource)this.getDataSource(), (DBSTypedObject)attributeBinding, (Object)cellValue) : stringValue;
                textWidget.insert(sqlValue);
                textWidget.setCaretOffset(textWidget.getCaretOffset() + sqlValue.length());
                textWidget.setFocus();
            }
        }

        public void forceDataReadCancel(Throwable error) {
            for (QueryProcessor processor : SQLEditor.this.queryProcessors) {
                SQLQueryJob job = processor.curJob;
                if (job == null) continue;
                SQLQueryResult currentQueryResult = job.getCurrentQueryResult();
                if (currentQueryResult == null) {
                    currentQueryResult = new SQLQueryResult(new SQLQuery(null, ""));
                }
                currentQueryResult.setError(error);
                job.notifyQueryExecutionEnd(null, currentQueryResult);
            }
        }

        public void handleExecuteResult(DBCExecutionResult result) {
            if (this.resultSetNumber == 0) {
                SQLEditor.this.dumpQueryServerOutput(result);
            }
        }

        public void showCurrentError() {
            if (SQLEditor.this.getLastQueryErrorPosition() > -1) {
                SQLEditor.this.getSelectionProvider().setSelection((ISelection)new TextSelection(SQLEditor.this.getLastQueryErrorPosition(), 0));
                SQLEditor.this.setFocus();
            }
        }

        public abstract CTabItem getResultsTab();

        public abstract boolean isPinned();

        public abstract void setPinned(boolean var1);

        protected boolean isTabPinned(CTabItem tabItem) {
            return tabItem != null && !tabItem.isDisposed() && !tabItem.getShowClose();
        }

        protected void setTabPinned(@NotNull CTabItem tabItem, boolean pinned) {
            if (tabItem != null) {
                tabItem.setShowClose(!pinned);
                tabItem.setImage(pinned ? IMG_DATA_GRID_LOCKED : IMG_DATA_GRID);
            }
        }

        private boolean isStatistics() {
            return this.query != null && this.query.getData() == SQLQueryJob.STATS_RESULTS;
        }
    }

    public static enum ResultSetOrientation {
        HORIZONTAL(512, SQLEditorMessages.sql_editor_result_set_orientation_horizontal, SQLEditorMessages.sql_editor_result_set_orientation_horizontal_tip, true),
        VERTICAL(256, SQLEditorMessages.sql_editor_result_set_orientation_vertical, SQLEditorMessages.sql_editor_result_set_orientation_vertical_tip, true),
        DETACHED(512, SQLEditorMessages.sql_editor_result_set_orientation_detached, SQLEditorMessages.sql_editor_result_set_orientation_detached_tip, false);

        private final int sashOrientation;
        private final String label;
        private final String description;
        private final boolean supported;

        private ResultSetOrientation(int sashOrientation, String label, String description, boolean supported) {
            this.sashOrientation = sashOrientation;
            this.label = label;
            this.description = description;
            this.supported = supported;
        }

        public int getSashOrientation() {
            return this.sashOrientation;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }

    public static class ResultSetOrientationMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (!(activeEditor instanceof SQLEditorBase)) {
                return new IContributionItem[0];
            }
            final DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            String curPresentation = preferenceStore.getString("SQLEditor.resultSet.orientation");
            ResultSetOrientation[] orientations = ResultSetOrientation.values();
            ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>(orientations.length);
            ResultSetOrientation[] resultSetOrientationArray = orientations;
            int n = orientations.length;
            int n2 = 0;
            while (n2 < n) {
                final ResultSetOrientation orientation = resultSetOrientationArray[n2];
                Action action = new Action(orientation.getLabel(), 8){

                    public void run() {
                        preferenceStore.setValue("SQLEditor.resultSet.orientation", orientation.name());
                        PrefUtils.savePreferenceStore((DBPPreferenceStore)preferenceStore);
                    }
                };
                action.setDescription(orientation.getDescription());
                if (!orientation.isSupported()) {
                    action.setEnabled(false);
                }
                if (orientation.name().equals(curPresentation)) {
                    action.setChecked(true);
                }
                items.add(new ActionContributionItem((IAction)action));
                ++n2;
            }
            return items.toArray(new IContributionItem[0]);
        }
    }

    private class SQLEditorQueryListener
    implements SQLQueryListener {
        private final QueryProcessor queryProcessor;
        private boolean scriptMode;
        private long lastUIUpdateTime;
        private final ITextSelection originalSelection;
        private int topOffset;
        private int visibleLength;
        private final boolean closeTabOnError;
        private SQLQueryListener extListener;

        private SQLEditorQueryListener(QueryProcessor queryProcessor, boolean closeTabOnError) {
            this.originalSelection = (ITextSelection)SQLEditor.this.getSelectionProvider().getSelection();
            this.queryProcessor = queryProcessor;
            this.closeTabOnError = closeTabOnError;
        }

        public void setExtListener(SQLQueryListener extListener) {
            this.extListener = extListener;
        }

        public void onStartScript() {
            try {
                this.lastUIUpdateTime = -1L;
                this.scriptMode = true;
                UIUtils.asyncExec(() -> {
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    if (SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.maxEditorOnScriptExecute") && SQLEditor.this.isResultSetAutoFocusEnabled && !SQLEditor.this.isHideQueryText()) {
                        SQLEditor.this.resultsSash.setMaximizedControl((Control)SQLEditor.this.sqlEditorPanel);
                    }
                    SQLEditor.this.clearProblems(null);
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartScript();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStartQuery(DBCSession session, SQLQuery query) {
            try {
                boolean isInExecute;
                boolean bl = isInExecute = SQLEditor.this.getTotalQueryRunning() > 0;
                if (!isInExecute) {
                    UIUtils.asyncExec(() -> {
                        SQLEditor.this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT_EXECUTE));
                        SQLEditor.this.updateDirtyFlag();
                        if (!this.scriptMode) {
                            SQLEditor.this.clearProblems(query);
                        }
                    });
                }
                this.queryProcessor.curJobRunning.incrementAndGet();
                List<SQLQuery> list = SQLEditor.this.runningQueries;
                synchronized (list) {
                    SQLEditor.this.runningQueries.add(query);
                }
                if (this.lastUIUpdateTime < 0L || System.currentTimeMillis() - this.lastUIUpdateTime > 100L) {
                    UIUtils.asyncExec(() -> {
                        TextViewer textViewer = SQLEditor.this.getTextViewer();
                        if (textViewer != null) {
                            this.topOffset = textViewer.getTopIndexStartOffset();
                            this.visibleLength = textViewer.getBottomIndexEndOffset() - this.topOffset;
                        }
                    });
                    if (this.scriptMode) {
                        SQLEditor.this.showStatementInEditor(query, false);
                    }
                    this.lastUIUpdateTime = System.currentTimeMillis();
                }
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartQuery(session, query);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
            try {
                List<SQLQuery> list = SQLEditor.this.runningQueries;
                synchronized (list) {
                    SQLEditor.this.runningQueries.remove(result.getStatement());
                }
                this.queryProcessor.curJobRunning.updateAndGet(i -> i > 0 ? i - 1 : i);
                if (SQLEditor.this.getTotalQueryRunning() <= 0) {
                    UIUtils.asyncExec(() -> {
                        if (SQLEditor.this.isDisposed()) {
                            return;
                        }
                        SQLEditor.this.setTitleImage(SQLEditor.this.editorImage);
                        SQLEditor.this.updateDirtyFlag();
                    });
                }
                if (SQLEditor.this.isDisposed()) {
                    return;
                }
                UIUtils.runUIJob((String)"Process SQL query result", monitor -> {
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    this.processQueryResult(monitor, result, statistics);
                    SQLEditor.this.updateDirtyFlag();
                    SQLEditor.this.refreshActions();
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndQuery(session, result, statistics);
                }
            }
        }

        private void refreshContextDefaults(DBCSession session) {
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
            if (executionContext != null && session != null && SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.refreshDefaultsAfterExecute") && (contextDefaults = executionContext.getContextDefaults()) != null) {
                try {
                    DBUtils.refreshContextDefaultsAndReflect((DBRProgressMonitor)session.getProgressMonitor(), (DBCExecutionContextDefaults)contextDefaults, (DBCExecutionContext)executionContext);
                }
                catch (Exception e) {
                    log.debug((Object)"Error refreshing context defaults", (Throwable)e);
                }
            }
        }

        private void processQueryResult(DBRProgressMonitor monitor, SQLQueryResult result, DBCStatistics statistics) {
            UIServiceSystemAgent serviceSystemAgent;
            CTabItem tabItem;
            if (!this.scriptMode) {
                SQLEditor.this.runPostExecuteActions(result);
            }
            SQLQuery query = result.getStatement();
            Throwable error = result.getError();
            ISelectionProvider selectionProvider = SQLEditor.this.getSelectionProvider();
            if (selectionProvider == null) {
                return;
            }
            if (error != null) {
                SQLQuery sqlQuery;
                SQLQuery originalQuery;
                SQLEditor.this.setStatus(GeneralUtils.getFirstMessage((Throwable)error), DBPMessageType.ERROR);
                SQLScriptElement sQLScriptElement = SQLEditor.this.curResultsContainer.query;
                SQLQuery sQLQuery = originalQuery = sQLScriptElement instanceof SQLQuery ? (sqlQuery = (SQLQuery)sQLScriptElement) : null;
                if (!SQLEditor.this.visualizeQueryErrors(monitor, query, error, originalQuery)) {
                    int errorQueryOffset = query.getOffset();
                    int errorQueryLength = query.getLength();
                    if (errorQueryOffset >= 0 && errorQueryLength > 0) {
                        if (!SQLEditor.this.addProblem(GeneralUtils.getFirstMessage((Throwable)error), new Position(errorQueryOffset, errorQueryLength))) {
                            if (this.scriptMode) {
                                selectionProvider.setSelection((ISelection)new TextSelection(errorQueryOffset, errorQueryLength));
                            } else {
                                selectionProvider.setSelection((ISelection)this.originalSelection);
                            }
                        }
                        SQLEditor.this.setLastQueryErrorPosition(errorQueryOffset);
                    }
                }
            }
            SQLEditor.this.notifyOnQueryResultListeners(SQLEditor.this.curResultsContainer, result);
            for (QueryResultsContainer cr : this.queryProcessor.resultContainers) {
                cr.viewer.updateFiltersText(false);
            }
            if (!result.hasError() && !this.queryProcessor.resultContainers.isEmpty()) {
                if (SQLEditor.this.activeResultsTab != null && !SQLEditor.this.activeResultsTab.isDisposed()) {
                    SQLEditor.this.setResultTabSelection(SQLEditor.this.activeResultsTab);
                } else {
                    SQLEditor.this.setResultTabSelection(this.queryProcessor.resultContainers.getFirst().getResultsTab());
                }
            }
            if (this.scriptMode || !this.queryProcessor.getResultContainers().isEmpty()) {
                int queryIndex = SQLEditor.this.queryProcessors.indexOf(this.queryProcessor);
                int resultsIndex = 0;
                for (QueryResultsContainer results : this.queryProcessor.resultContainers) {
                    if (results.query != query) {
                        results.handleExecuteResult((DBCExecutionResult)result);
                        if (!SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.setSelectionToStatisticsTab") || query.getType() == SQLQueryType.SELECT) continue;
                        SQLEditor.this.setResultTabSelection(results.getResultsTab());
                        continue;
                    }
                    if (resultsIndex < result.getExecuteResults().size()) {
                        ResultSetViewer resultSetViewer;
                        SQLQueryResult.ExecuteResult executeResult = result.getExecuteResults(resultsIndex, true);
                        String resultSetName = results.tabName;
                        if (CommonUtils.isEmpty((String)resultSetName)) {
                            resultSetName = SQLEditor.this.getResultsTabName(results.resultSetNumber, queryIndex, executeResult.getResultSetName());
                            results.updateResultsName(resultSetName, null);
                            SQLEditor.this.setResultTabSelection(results.getResultsTab());
                        }
                        if ((resultSetViewer = results.getResultSetController()) != null) {
                            resultSetViewer.getModel().setStatistics(statistics);
                        }
                        results.handleExecuteResult((DBCExecutionResult)result);
                    }
                    ++resultsIndex;
                }
            } else {
                SQLEditor.this.dumpQueryServerOutput((DBCExecutionResult)result);
            }
            if (this.closeTabOnError && error != null && (tabItem = this.queryProcessor.getFirstResults().getResultsTab()) != null && tabItem.getShowClose()) {
                tabItem.dispose();
            }
            if (SQLEditor.this.dataSourceContainer != null && !this.scriptMode && SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.beepOnQueryEnd")) {
                Display.getCurrent().beep();
            }
            if ((serviceSystemAgent = (UIServiceSystemAgent)DBWorkbench.getService(UIServiceSystemAgent.class)) != null && result.getQueryTime() > serviceSystemAgent.getLongOperationTimeout() * 1000L) {
                serviceSystemAgent.notifyAgent("Query completed [" + SQLEditor.this.getEditorInput().getName() + "]" + GeneralUtils.getDefaultLineSeparator() + CommonUtils.truncateString((String)query.getText(), (int)200), !result.hasError() ? 1 : 4);
            }
        }

        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            try {
                if (SQLEditor.this.isDisposed()) {
                    return;
                }
                SQLEditor.this.runPostExecuteActions(null);
                UIUtils.asyncExec(() -> {
                    QueryResultsContainer results;
                    ResultSetViewer viewer;
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    if (!SQLEditor.this.isHideQueryText()) {
                        SQLEditor.this.resultsSash.setMaximizedControl(null);
                        if (!hasErrors) {
                            SQLEditor.this.getSelectionProvider().setSelection((ISelection)this.originalSelection);
                        }
                    }
                    if ((viewer = (results = this.queryProcessor.getFirstResults()).getResultSetController()) != null) {
                        viewer.getModel().setStatistics(statistics);
                        viewer.updateStatusMessage();
                    }
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndScript(statistics, hasErrors);
                }
            }
        }

        public void onEndSqlJob(DBCSession session, SqlJobResult result) {
            if (result == SqlJobResult.SUCCESS || result == SqlJobResult.PARTIAL_SUCCESS) {
                this.refreshContextDefaults(session);
            }
            if (this.extListener != null) {
                this.extListener.onEndSqlJob(session, result);
            }
        }
    }

    private class SaveJob
    extends AbstractJob {
        private transient Boolean success;

        SaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' data changes...");
            this.success = null;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Save query processors", SQLEditor.this.queryProcessors.size());
            try {
                for (QueryProcessor queryProcessor : SQLEditor.this.queryProcessors) {
                    for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                        ResultSetViewer rsv = resultsProvider.getResultSetController();
                        if (rsv == null || !rsv.isDirty()) continue;
                        rsv.doSave(monitor);
                    }
                    monitor.worked(1);
                }
                this.success = true;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable e) {
                this.success = false;
                log.error((Object)e);
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (this.success == null) {
                    this.success = true;
                }
                monitor.done();
            }
        }
    }

    private class ScriptAutoSaveJob
    extends AbstractJob {
        ScriptAutoSaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' script");
            this.setSystem(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (EditorUtils.isInAutoSaveJob()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Auto-save SQL script", 1);
            try {
                try {
                    UIUtils.asyncExec(() -> SQLEditor.this.doTextEditorSave(monitor));
                }
                catch (Throwable e) {
                    log.debug((Object)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private static class ServerOutputInfo {
        private final DBCServerOutputReader outputReader;
        private final DBCExecutionContext executionContext;
        private final DBCExecutionResult result;

        ServerOutputInfo(DBCServerOutputReader outputReader, DBCExecutionContext executionContext, DBCExecutionResult result) {
            this.outputReader = outputReader;
            this.executionContext = executionContext;
            this.result = result;
        }
    }

    private class ServerOutputReader
    extends AbstractJob {
        ServerOutputReader() {
            super("Dump server output");
            this.setSystem(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (!DBWorkbench.getPlatform().isShuttingDown() && SQLEditor.this.resultsSash != null && !SQLEditor.this.resultsSash.isDisposed()) {
                try {
                    this.dumpOutput(monitor);
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
                this.schedule(200L);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpOutput(DBRProgressMonitor monitor) {
            ArrayList<ServerOutputInfo> outputs;
            final SQLEditorOutputViewer currentOutputViewer = SQLEditor.this.outputViewer;
            if (currentOutputViewer == null || currentOutputViewer.isDisposed()) {
                return;
            }
            List<ServerOutputInfo> list = SQLEditor.this.serverOutputs;
            synchronized (list) {
                outputs = new ArrayList<ServerOutputInfo>(SQLEditor.this.serverOutputs);
                SQLEditor.this.serverOutputs.clear();
            }
            final List<PrintWriter> addInWriters = SQLEditor.this.addIns.stream().map(SQLEditorAddIn::getServerOutputConsumer).filter(Objects::nonNull).toList();
            DBCOutputWriter outputWriter = new DBCOutputWriter(){

                public void println(@Nullable DBCOutputSeverity severity, @Nullable String message) {
                    currentOutputViewer.println(severity, message);
                    if (message != null) {
                        for (PrintWriter writer : addInWriters) {
                            writer.println(message);
                        }
                    }
                }

                public void flush() {
                    currentOutputViewer.flush();
                    for (PrintWriter writer : addInWriters) {
                        writer.flush();
                    }
                }
            };
            if (!outputs.isEmpty()) {
                for (ServerOutputInfo info : outputs) {
                    if (monitor.isCanceled()) break;
                    try {
                        info.outputReader.readServerOutput(monitor, info.executionContext, info.result, null, outputWriter);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
            if (!monitor.isCanceled()) {
                DBCServerOutputReader outputReader = null;
                DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
                if (executionContext != null) {
                    DBPDataSource dataSource = executionContext.getDataSource();
                    outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
                }
                if (outputReader != null && outputReader.isAsyncOutputReadSupported()) {
                    for (QueryProcessor qp : SQLEditor.this.queryProcessors) {
                        SQLQueryJob queryJob = qp.curJob;
                        if (queryJob == null) continue;
                        DBCStatement statement = queryJob.getCurrentStatement();
                        try {
                            if (statement == null || statement.isStatementClosed()) continue;
                            outputReader.readServerOutput(monitor, executionContext, null, statement, outputWriter);
                        }
                        catch (DBCException e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
            outputWriter.flush();
            if (currentOutputViewer == null || currentOutputViewer.isDisposed() || !currentOutputViewer.isHasNewOutput()) {
                return;
            }
            currentOutputViewer.resetNewOutput();
            UIUtils.asyncExec(() -> {
                ToolItem toolItem;
                currentOutputViewer.getViewer().scrollToEnd();
                if (SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.outputPanel.autoShow") && (toolItem = SQLEditor.this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.show.output")) != null && !toolItem.getSelection()) {
                    SQLEditor.this.showOutputPanel(true);
                }
            });
        }
    }

    class SingleTabQueryProcessor
    extends QueryProcessor {
        private static final int SCROLL_SPEED = 10;
        private boolean tabCreated;
        private CTabItem resultsTab;
        private ScrolledComposite tabContentScroller;
        private Composite sectionsContainer;

        SingleTabQueryProcessor(boolean makeDefault) {
            super(makeDefault);
        }

        @Override
        @NotNull
        protected QueryResultsContainer createQueryResultsContainer(int resultSetNumber, int resultSetIndex, boolean makeDefault) {
            return new SingleTabQueryResultsContainer(this.createSection(makeDefault), this, resultSetNumber, resultSetIndex, makeDefault);
        }

        @Override
        protected QueryResultsContainer createQueryResultsContainer(int resultSetNumber, int resultSetIndex, @NotNull DBSDataContainer dataContainer) {
            return new SingleTabQueryResultsContainer(this.createSection(false), this, resultSetNumber, resultSetIndex, dataContainer);
        }

        @NotNull
        private Pair<Section, Composite> createSection(boolean makeDefault) {
            if (!this.tabCreated) {
                this.tabCreated = true;
                this.prepareResultSetContainerHost(makeDefault);
            }
            Section section = new Section(this.sectionsContainer, 66);
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Composite contents = UIUtils.createComposite((Composite)section, (int)1);
            section.setClient((Control)contents);
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    SingleTabQueryProcessor.this.relayoutContents();
                }
            });
            return new Pair((Object)section, (Object)contents);
        }

        public void relayoutContents() {
            this.tabContentScroller.setMinSize(this.sectionsContainer.computeSize(this.tabContentScroller.getBorderWidth(), -1));
            this.sectionsContainer.layout();
        }

        private void prepareResultSetContainerHost(boolean makeDefault) {
            this.tabContentScroller = new ScrolledComposite((Composite)SQLEditor.this.resultTabs, 2560);
            this.tabContentScroller.setExpandHorizontal(true);
            this.tabContentScroller.setExpandVertical(true);
            int tabIndex = SQLEditor.this.obtainDesiredTabIndex(makeDefault);
            this.resultsTab = new CTabItem(SQLEditor.this.resultTabs, 0, tabIndex);
            this.resultsTab.setImage(IMG_DATA_GRID);
            this.resultsTab.setData((Object)this);
            this.resultsTab.setShowClose(true);
            int queryIndex = SQLEditor.this.queryProcessors.indexOf(this);
            this.resultsTab.setText(SQLEditor.this.getResultsTabName(0, queryIndex, null));
            CSSUtils.markConnectionTypeColor((Widget)this.resultsTab);
            this.resultsTab.setControl((Control)this.tabContentScroller);
            this.resultsTab.addDisposeListener(SQLEditor.this.resultTabDisposeListener);
            UIUtils.disposeControlOnItemDispose((CTabItem)this.resultsTab);
            this.sectionsContainer = new Composite((Composite)this.tabContentScroller, 0);
            this.sectionsContainer.setLayout((Layout)new GridLayout(1, false));
            this.sectionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.tabContentScroller.setContent((Control)this.sectionsContainer);
            Listener scrollListener = event -> {
                Control underScroll = (Control)event.widget;
                if (underScroll.getShell() == this.tabContentScroller.getShell() && this.tabContentScroller.isVisible() && (event.stateMask & 0x40000) == 262144) {
                    Point clickedPoint = underScroll.toDisplay(event.x, event.y);
                    if (this.tabContentScroller.getClientArea().contains(this.tabContentScroller.toControl(clickedPoint))) {
                        Control c = underScroll;
                        while (c != null) {
                            if (c == this.tabContentScroller) {
                                Point offset = this.tabContentScroller.getOrigin();
                                offset.y -= event.count * 10;
                                if (offset.y < 0) {
                                    offset.y = 0;
                                }
                                this.tabContentScroller.setOrigin(offset);
                                event.doit = false;
                            }
                            c = c.getParent();
                        }
                    }
                }
            };
            this.tabContentScroller.getDisplay().addFilter(37, scrollListener);
            this.tabContentScroller.addDisposeListener(e -> this.tabContentScroller.getDisplay().removeFilter(37, scrollListener));
        }
    }

    class SingleTabQueryResultsContainer
    extends QueryResultsContainer {
        private static final Integer MIN_VIEWER_HEIGHT = 150;
        private final SingleTabQueryProcessor queryProcessor;
        private final Section section;
        private GridData rsvConstrainedLayout;

        SingleTabQueryResultsContainer(@NotNull Pair<Section, Composite> sectionAndContents, SingleTabQueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean makeDefault) {
            super((Composite)sectionAndContents.getSecond(), (QueryProcessor)queryProcessor, resultSetNumber, resultSetIndex, makeDefault);
            this.queryProcessor = queryProcessor;
            this.section = (Section)sectionAndContents.getFirst();
            this.setupSection((Composite)sectionAndContents.getSecond());
        }

        SingleTabQueryResultsContainer(@NotNull Pair<Section, Composite> sectionAndContents, SingleTabQueryProcessor queryProcessor, int resultSetNumber, @NotNull int resultSetIndex, DBSDataContainer dataContainer) {
            super((Composite)sectionAndContents.getSecond(), (QueryProcessor)queryProcessor, resultSetNumber, resultSetIndex, dataContainer);
            this.queryProcessor = queryProcessor;
            this.section = (Section)sectionAndContents.getFirst();
            this.setupSection((Composite)sectionAndContents.getSecond());
        }

        @Override
        public IResultSetDecorator createResultSetDecorator() {
            if (SQLEditor.this.getActivePreferenceStore().getBoolean("resultset.behavior.showFiltersPanelInSingleTabMode")) {
                return super.createResultSetDecorator();
            }
            return new QueryResultsDecorator(){

                public long getDecoratorFeatures() {
                    return 62L;
                }
            };
        }

        private void setupSection(@NotNull Composite sectionContents) {
            final Composite control = this.viewer.getControl();
            sectionContents.setData(ResultSetViewer.CONTROL_ID, (Object)this.viewer);
            this.rsvConstrainedLayout = GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(10, 300).create();
            control.setLayoutData((Object)this.rsvConstrainedLayout);
            final GridData freeLayout = GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create();
            Label line = new Label(sectionContents, 258);
            line.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(10, 10).create());
            line.setCursor(line.getDisplay().getSystemCursor(7));
            line.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    control.setLayoutData((Object)(control.getLayoutData() == SingleTabQueryResultsContainer.this.rsvConstrainedLayout ? freeLayout : SingleTabQueryResultsContainer.this.rsvConstrainedLayout));
                    SingleTabQueryResultsContainer.this.queryProcessor.relayoutContents();
                }
            });
            line.addMouseMoveListener(e -> {
                if ((e.stateMask & 0x80000) != 0) {
                    Tracker tracker = new Tracker(this.queryProcessor.sectionsContainer, 1040);
                    tracker.setStippled(true);
                    tracker.setCursor(tracker.getDisplay().getSystemCursor(7));
                    Point size = control.getSize();
                    Point origin = this.queryProcessor.sectionsContainer.toControl(control.toDisplay(control.getLocation()));
                    tracker.setRectangles(new Rectangle[]{new Rectangle(origin.x, origin.y, size.x, size.y + label.getSize().y / 2)});
                    if (tracker.open()) {
                        Rectangle after = tracker.getRectangles()[0];
                        int newHeight = after.height - label.getSize().y / 2;
                        if (newHeight != this.rsvConstrainedLayout.heightHint) {
                            this.rsvConstrainedLayout.heightHint = newHeight;
                            control.setLayoutData((Object)this.rsvConstrainedLayout);
                            this.queryProcessor.relayoutContents();
                        }
                    }
                    tracker.dispose();
                }
            });
            Listener displayListener = event -> {
                Control clickedWidget = (Control)event.widget;
                if (clickedWidget instanceof VerticalButton && clickedWidget.getShell() == control.getShell() && control.isVisible()) {
                    Point clickedPoint = clickedWidget.toDisplay(event.x, event.y);
                    if (control.getClientArea().contains(control.toControl(clickedPoint)) && !this.viewer.isPresentationInFocus()) {
                        Composite c = control;
                        while (c != null && !c.isFocusControl()) {
                            if (c == sectionContents) {
                                control.setFocus();
                                break;
                            }
                            c = c.getParent();
                        }
                    }
                }
            };
            control.getDisplay().addFilter(3, displayListener);
            control.addDisposeListener(e -> control.getDisplay().removeFilter(3, displayListener));
            this.queryProcessor.relayoutContents();
        }

        @Override
        public void setTabName(@NotNull String tabName) {
            super.setTabName(tabName);
            this.section.setText(tabName);
        }

        @Override
        public void updateResultsName(@NotNull String resultSetName, @Nullable String toolTip) {
            if (!this.section.isDisposed()) {
                if (!CommonUtils.isEmpty((String)resultSetName)) {
                    this.section.setText(resultSetName);
                }
                if (toolTip != null) {
                    this.section.setToolTipText(toolTip);
                }
            }
        }

        @Override
        @NotNull
        public CTabItem getResultsTab() {
            return this.queryProcessor.resultsTab;
        }

        @Override
        public boolean isPinned() {
            return this.isTabPinned(this.queryProcessor.resultsTab);
        }

        @Override
        public void setPinned(boolean pinned) {
            this.setTabPinned(this.queryProcessor.resultsTab, pinned);
        }

        @Override
        public void handleExecuteResult(DBCExecutionResult result) {
            super.handleExecuteResult(result);
            Control control = this.viewer.getActivePresentation().getControl();
            if (control instanceof Spreadsheet) {
                Spreadsheet s = (Spreadsheet)control;
                UIUtils.syncExec(() -> {
                    Point spreadsheetPreferredSize = s.computeSize(-1, -1, true);
                    Point spreadsheetSize = s.getSize();
                    int desiredViewerHeight = this.rsvConstrainedLayout.heightHint - spreadsheetSize.y + spreadsheetPreferredSize.y;
                    if (desiredViewerHeight < this.rsvConstrainedLayout.heightHint) {
                        if (desiredViewerHeight < MIN_VIEWER_HEIGHT) {
                            desiredViewerHeight = MIN_VIEWER_HEIGHT;
                        }
                        this.rsvConstrainedLayout.heightHint = desiredViewerHeight;
                        this.queryProcessor.relayoutContents();
                    }
                });
            }
        }

        @Override
        protected void dispose() {
            UIUtils.syncExec(() -> ((Section)this.section).dispose());
        }
    }

    private static final class TransactionStatusUpdateJob
    extends AbstractJob {
        private static final int UPDATE_DELAY_MS = 1000;

        public TransactionStatusUpdateJob() {
            super("Update active transaction status");
            this.setUser(false);
            this.setSystem(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            IEditorPart iEditorPart;
            IWorkbenchPage page;
            if (monitor.isCanceled() || DBWorkbench.getPlatform().isShuttingDown()) {
                return Status.CANCEL_STATUS;
            }
            IWorkbenchWindow window = UIUtils.findActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (iEditorPart = page.getActiveEditor()) instanceof SQLEditor) {
                SQLEditor editor = (SQLEditor)iEditorPart;
                UIUtils.syncExec(() -> editor.updateStatusField(SQLEditor.STATS_CATEGORY_TRANSACTION_TIMEOUT));
            }
            this.schedule(1000L);
            return Status.OK_STATUS;
        }
    }
}

