/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "The deal.II Library", "index.html", [
    [ "Tutorial", "Tutorial.html", null ],
    [ "Code gallery", "CodeGallery.html", null ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", "functions_type" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Symbols", "functions_rela.html", "functions_rela" ]
      ] ]
    ] ],
    [ "Coding conventions used throughout deal.II", "CodingConventions.html", null ],
    [ "When to use types::global_dof_index instead of unsigned int", "GlobalDoFIndex.html", null ],
    [ "Glossary", "DEALGlossary.html", null ],
    [ "Template instantiations", "Instantiations.html", [
      [ "Known and fixed number of instantiations", "Instantiations.html#Inst1", [
        [ "Available instances", "Instantiations.html#Inst1a", null ]
      ] ],
      [ "A few instantiations, most of which are known", "Instantiations.html#Inst2", [
        [ "Creating new instances", "Instantiations.html#Inst2c", null ],
        [ "Provided instances", "Instantiations.html#Inst2p", null ]
      ] ],
      [ "Many unknown instantiations", "Instantiations.html#Inst3", null ]
    ] ],
    [ "Changes between Version 1.0 and 2.0", "changes_between_1_0_and_2_0.html", null ],
    [ "Changes between Version 2.0 and 3.0", "changes_between_2_0_and_3_0.html", null ],
    [ "Changes between Version 3.0.0 and 3.0.1", "changes_between_3_0_0_and_3_0_1.html", null ],
    [ "Changes between Version 3.0.0 and 3.1.0", "changes_between_3_0_0_and_3_1_0.html", null ],
    [ "Changes between Version 3.1.0 and 3.1.1", "changes_between_3_1_0_and_3_1_1.html", null ],
    [ "Changes between Version 3.1.0 and 3.2.0", "changes_between_3_1_0_and_3_2_0.html", null ],
    [ "Changes between Version 3.1.1 and 3.1.2", "changes_between_3_1_1_and_3_1_2.html", null ],
    [ "Changes between Version 3.2.0 and 3.2.1", "changes_between_3_2_0_and_3_2_1.html", null ],
    [ "Changes between Version 3.2 and 3.3", "changes_between_3_2_and_3_3.html", null ],
    [ "Changes between Version 3.3.0 and 3.3.1", "changes_between_3_3_0_and_3_3_1.html", null ],
    [ "Changes between Version 3.3 and 3.4", "changes_between_3_3_and_3_4.html", null ],
    [ "Changes between Version 3.4 and 4.0", "changes_between_3_4_and_4_0.html", null ],
    [ "Changes between Version 4.0 and 5.0", "changes_between_4_0_and_5_0.html", null ],
    [ "Changes between Version 5.0 and 5.1", "changes_between_5_0_and_5_1.html", null ],
    [ "Changes between Version 5.1 and 5.2", "changes_between_5_1_and_5_2.html", null ],
    [ "Changes between Version 5.2 and 6.0", "changes_between_5_2_and_6_0.html", null ],
    [ "Changes between Version 6.0 and 6.1", "changes_between_6_0_and_6_1.html", null ],
    [ "Changes between Version 6.1 and 6.2", "changes_between_6_1_and_6_2.html", null ],
    [ "Changes between Version 6.2.0 and 6.2.1", "changes_between_6_2_0_and_6_2_1.html", null ],
    [ "Changes between Version 6.2 and 6.3", "changes_between_6_2_and_6_3.html", null ],
    [ "Changes between Version 6.3.0 and 6.3.1", "changes_between_6_3_0_and_6_3_1.html", null ],
    [ "Changes between Version 6.3 and 7.0", "changes_between_6_3_and_7_0.html", null ],
    [ "Changes between Version 7.0 and 7.1", "changes_between_7_0_and_7_1.html", null ],
    [ "Changes between Version 7.1 and 7.2", "changes_between_7_1_and_7_2.html", null ],
    [ "Changes between Version 7.2 and 7.3", "changes_between_7_2_and_7_3.html", null ],
    [ "Changes between Version 7.3 and 8.0", "changes_between_7_3_and_8_0.html", null ],
    [ "Changes between Version 8.0 and 8.1", "changes_between_8_0_and_8_1.html", null ],
    [ "Changes between Version 8.1 and 8.2", "changes_between_8_1_and_8_2.html", null ],
    [ "Changes between Version 8.2.0 and 8.2.1", "changes_between_8_2_0_and_8_2_1.html", null ],
    [ "Changes between Version 8.2.1 and 8.3", "changes_between_8_2_1_and_8_3.html", null ],
    [ "Changes between Version 8.3.0 and 8.4.0", "changes_between_8_3_and_8_4.html", null ],
    [ "Changes between Version 8.4.0 and 8.4.1", "changes_between_8_4_0_and_8_4_1.html", null ],
    [ "Changes between Version 8.4.1 and 8.4.2", "changes_between_8_4_1_and_8_4_2.html", null ],
    [ "Changes between Version 8.4.2 and 8.5.0", "changes_between_8_4_2_and_8_5_0.html", null ],
    [ "Changes between Version 8.5.0 and 9.0.0", "changes_between_8_5_0_and_9_0_0.html", null ],
    [ "Changes between Version 9.0.0 and 9.0.1", "changes_between_9_0_0_and_9_0_1.html", null ],
    [ "Changes between Version 9.0.1 and 9.1.0", "changes_between_9_0_1_and_9_1_0.html", null ],
    [ "Changes between Version 9.1.0 and 9.1.1", "changes_between_9_1_0_and_9_1_1.html", null ],
    [ "Changes between Version 9.1.1 and 9.2.0", "changes_between_9_1_1_and_9_2_0.html", null ],
    [ "Changes between Version 9.2.0 and 9.3.0", "changes_between_9_2_0_and_9_3_0.html", null ],
    [ "Changes between Version 9.3.0 and 9.3.1", "changes_between_9_3_0_and_9_3_1.html", null ],
    [ "Changes between Version 9.3.1 and 9.3.2", "changes_between_9_3_1_and_9_3_2.html", null ],
    [ "Changes between Version 9.3.2 and 9.3.3", "changes_between_9_3_2_and_9_3_3.html", null ],
    [ "Changes between Version 9.3.3 and 9.4.0", "changes_between_9_3_3_and_9_4_0.html", null ],
    [ "Changes between Version 9.4.0 and 9.5.0", "changes_between_9_4_0_and_9_5_0.html", null ],
    [ "Changes between Version 9.5.0 and 9.5.2", "changes_between_9_5_0_and_9_5_2.html", null ],
    [ "Changes between Version 9.5.2 and 9.6.0", "changes_between_9_5_2_and_9_6_0.html", null ],
    [ "Changes between Version 9.6.0 and 9.7.0", "changes_between_9_6_0_and_9_7_0.html", null ],
    [ "Changes since the last release", "recent_changes.html", null ],
    [ "Tutorial programs", "Tutorial.html", null ],
    [ "The step-1 tutorial program", "step_1.html", null ],
    [ "The step-10 tutorial program", "step_10.html", null ],
    [ "The step-11 tutorial program", "step_11.html", null ],
    [ "The step-12 tutorial program", "step_12.html", null ],
    [ "The step-13 tutorial program", "step_13.html", null ],
    [ "The step-14 tutorial program", "step_14.html", null ],
    [ "The step-15 tutorial program", "step_15.html", null ],
    [ "The step-16 tutorial program", "step_16.html", null ],
    [ "The step-17 tutorial program", "step_17.html", null ],
    [ "The step-18 tutorial program", "step_18.html", null ],
    [ "The step-19 tutorial program", "step_19.html", null ],
    [ "The step-2 tutorial program", "step_2.html", null ],
    [ "The step-20 tutorial program", "step_20.html", null ],
    [ "The step-21 tutorial program", "step_21.html", null ],
    [ "The step-22 tutorial program", "step_22.html", null ],
    [ "The step-23 tutorial program", "step_23.html", null ],
    [ "The step-24 tutorial program", "step_24.html", null ],
    [ "The step-25 tutorial program", "step_25.html", null ],
    [ "The step-26 tutorial program", "step_26.html", null ],
    [ "The step-27 tutorial program", "step_27.html", null ],
    [ "The step-28 tutorial program", "step_28.html", null ],
    [ "The step-29 tutorial program", "step_29.html", null ],
    [ "The step-3 tutorial program", "step_3.html", null ],
    [ "The step-30 tutorial program", "step_30.html", null ],
    [ "The step-31 tutorial program", "step_31.html", null ],
    [ "The step-32 tutorial program", "step_32.html", null ],
    [ "The step-33 tutorial program", "step_33.html", null ],
    [ "The step-34 tutorial program", "step_34.html", null ],
    [ "The step-35 tutorial program", "step_35.html", null ],
    [ "The step-36 tutorial program", "step_36.html", null ],
    [ "The step-37 tutorial program", "step_37.html", null ],
    [ "The step-38 tutorial program", "step_38.html", null ],
    [ "The step-39 tutorial program", "step_39.html", null ],
    [ "The step-4 tutorial program", "step_4.html", null ],
    [ "The step-40 tutorial program", "step_40.html", null ],
    [ "The step-41 tutorial program", "step_41.html", null ],
    [ "The step-42 tutorial program", "step_42.html", null ],
    [ "The step-43 tutorial program", "step_43.html", null ],
    [ "The step-44 tutorial program", "step_44.html", null ],
    [ "The step-45 tutorial program", "step_45.html", null ],
    [ "The step-46 tutorial program", "step_46.html", null ],
    [ "The step-47 tutorial program", "step_47.html", null ],
    [ "The step-48 tutorial program", "step_48.html", null ],
    [ "The step-49 tutorial program", "step_49.html", null ],
    [ "The step-5 tutorial program", "step_5.html", null ],
    [ "The step-50 tutorial program", "step_50.html", null ],
    [ "The step-51 tutorial program", "step_51.html", null ],
    [ "The step-53 tutorial program", "step_53.html", null ],
    [ "The step-54 tutorial program", "step_54.html", null ],
    [ "The step-55 tutorial program", "step_55.html", null ],
    [ "The step-56 tutorial program", "step_56.html", null ],
    [ "The step-57 tutorial program", "step_57.html", null ],
    [ "The step-58 tutorial program", "step_58.html", null ],
    [ "The step-59 tutorial program", "step_59.html", null ],
    [ "The step-6 tutorial program", "step_6.html", null ],
    [ "The step-60 tutorial program", "step_60.html", null ],
    [ "The step-61 tutorial program", "step_61.html", null ],
    [ "The step-62 tutorial program", "step_62.html", null ],
    [ "The step-63 tutorial program", "step_63.html", null ],
    [ "The step-64 tutorial program", "step_64.html", null ],
    [ "The step-65 tutorial program", "step_65.html", null ],
    [ "The step-66 tutorial program", "step_66.html", null ],
    [ "The step-67 tutorial program", "step_67.html", null ],
    [ "The step-68 tutorial program", "step_68.html", null ],
    [ "The step-69 tutorial program", "step_69.html", null ],
    [ "The step-7 tutorial program", "step_7.html", null ],
    [ "The step-70 tutorial program", "step_70.html", null ],
    [ "The step-71 tutorial program", "step_71.html", null ],
    [ "The step-72 tutorial program", "step_72.html", null ],
    [ "The step-74 tutorial program", "step_74.html", null ],
    [ "The step-75 tutorial program", "step_75.html", null ],
    [ "The step-76 tutorial program", "step_76.html", null ],
    [ "The step-77 tutorial program", "step_77.html", null ],
    [ "The step-78 tutorial program", "step_78.html", null ],
    [ "The step-79 tutorial program", "step_79.html", null ],
    [ "The step-8 tutorial program", "step_8.html", null ],
    [ "The step-81 tutorial program", "step_81.html", null ],
    [ "The step-82 tutorial program", "step_82.html", null ],
    [ "The step-83 tutorial program", "step_83.html", null ],
    [ "The step-85 tutorial program", "step_85.html", null ],
    [ "The step-86 tutorial program", "step_86.html", null ],
    [ "The step-87 tutorial program", "step_87.html", null ],
    [ "The step-89 tutorial program", "step_89.html", null ],
    [ "The step-9 tutorial program", "step_9.html", null ],
    [ "The step-90 tutorial program", "step_90.html", null ],
    [ "The step-93 tutorial program", "step_93.html", null ],
    [ "The step-95 tutorial program", "step_95.html", null ],
    [ "The step-97 tutorial program", "step_97.html", null ],
    [ "The 'Viscoelastoplastic topography evolution' code gallery program", "code_gallery_CeresFE.html", [
      [ "Readme file for CeresFE", "code_gallery_CeresFE.html#autotoc_md83", [
        [ "Motivation for project", "code_gallery_CeresFE.html#autotoc_md84", null ],
        [ "Quick facts about the code", "code_gallery_CeresFE.html#autotoc_md85", null ],
        [ "More detailed properties of the code in CeresFE", "code_gallery_CeresFE.html#autotoc_md86", [
          [ "Viscoelastoplasticity", "code_gallery_CeresFE.html#autotoc_md87", null ],
          [ "Domain and boundary conditions", "code_gallery_CeresFE.html#autotoc_md88", null ]
        ] ],
        [ "Description of files in repo", "code_gallery_CeresFE.html#autotoc_md89", null ],
        [ "Other dependencies", "code_gallery_CeresFE.html#autotoc_md90", null ],
        [ "To run the code", "code_gallery_CeresFE.html#autotoc_md91", null ]
      ] ]
    ] ],
    [ "The 'Crystal growth problem using phase field modeling' code gallery program", "code_gallery_Crystal_Growth_Phase_Field_Model.html", null ],
    [ "The 'Distributed LDG Method' code gallery program", "code_gallery_Distributed_LDG_Method.html", [
      [ "Distributed Local Discontinuous Galerkin Methods", "code_gallery_Distributed_LDG_Method.html#autotoc_md46", [
        [ "Introduction", "code_gallery_Distributed_LDG_Method.html#autotoc_md47", null ],
        [ "Compiling and Running", "code_gallery_Distributed_LDG_Method.html#autotoc_md48", null ],
        [ "Local Discontinuous Galerkin Method", "code_gallery_Distributed_LDG_Method.html#autotoc_md49", null ],
        [ "Useful References", "code_gallery_Distributed_LDG_Method.html#autotoc_md50", null ]
      ] ],
      [ "The Commented Code", "code_gallery_Distributed_LDG_Method.html#autotoc_md51", null ]
    ] ],
    [ "The 'Distributed moving laser heating' code gallery program", "code_gallery_Distributed_Moving_Laser_Heating.html", [
      [ "Introduction", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md16", [
        [ "Illustration of the problem", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md17", null ],
        [ "Numerical results", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md18", null ]
      ] ],
      [ "Discretization of the non-uniform isotropic heat equation", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md19", null ],
      [ "Initial temperature", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md20", [
        [ "Mesh", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md21", null ],
        [ "Results", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md22", null ],
        [ "Temperature distribution", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md23", null ],
        [ "8-threads", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md24", null ]
      ] ],
      [ "References", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md25", null ],
      [ "This file defines the boundary and initial conditions", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md26", null ],
      [ "Declaration", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md27", null ],
      [ "Implementation", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md28", null ],
      [ "Declaration and Implementation", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md29", null ],
      [ "mass density and heat capacity", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md30", null ],
      [ "p stores the xyz coordinates at each vertex", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md31", null ],
      [ "for 2D problems in xy, we assume the non-uniform is in y-axis.", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md32", null ],
      [ "Declaration and Implementation", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md33", null ],
      [ "thermal conductivity", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md34", null ],
      [ "p stores the xyz coordinates at each vertex", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md35", null ],
      [ "for 2D problems in xy, we assume the non-uniform is in y-axis.", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md36", null ],
      [ "physics constants", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md37", null ],
      [ "Laser", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md38", null ],
      [ "material", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md39", null ],
      [ "simulation time", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md40", null ],
      [ "about the MESH", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md41", null ],
      [ "This file defines the boundary and initial conditions", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md42", null ],
      [ "Declaration", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md43", null ],
      [ "Implementation", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md44", null ],
      [ "no absorption", "code_gallery_Distributed_Moving_Laser_Heating.html#autotoc_md45", null ]
    ] ],
    [ "The 'Elastoplastic Torsion' code gallery program", "code_gallery_ElastoplasticTorsion.html", null ],
    [ "The 'Linear Elastic Active Skeletal Muscle Model' code gallery program", "code_gallery_Linear_Elastic_Active_Skeletal_Muscle_Model.html", null ],
    [ "The 'MCMC for the Laplace equation' code gallery program", "code_gallery_MCMC_Laplace.html", [
      [ "Bayesian inversion benchmark: Matlab version", "code_gallery_MCMC_Laplace.html#autotoc_md67", null ],
      [ "Readme file for MCMC-Laplace", "code_gallery_MCMC_Laplace.html#autotoc_md69", [
        [ "Motivation for project", "code_gallery_MCMC_Laplace.html#autotoc_md70", null ],
        [ "More detailed properties of the code in MCMC-Laplace", "code_gallery_MCMC_Laplace.html#autotoc_md72", null ],
        [ "To run the code", "code_gallery_MCMC_Laplace.html#autotoc_md73", null ],
        [ "Testing modifications and alternative implementations", "code_gallery_MCMC_Laplace.html#autotoc_md74", null ],
        [ "An alternative implementation in Matlab", "code_gallery_MCMC_Laplace.html#autotoc_md75", null ],
        [ "An alternative implementation in Python", "code_gallery_MCMC_Laplace.html#autotoc_md76", null ]
      ] ]
    ] ],
    [ "The 'Goal-Oriented hp-Adaptivity for the Maxwell Eigenvalue Problem' code gallery program", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html", [
      [ "Readme file for Maxwell-Eigenvallue-hp-Refinement", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md92", [
        [ "Motivation for project", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md93", null ],
        [ "Some comments on the discretization of Maxwell's equations", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md94", null ],
        [ "On the adaptivity", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md95", null ],
        [ "Numerical Results", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md96", null ],
        [ "To run the code", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md97", null ],
        [ "References", "code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md98", null ]
      ] ]
    ] ],
    [ "The 'Higher Order Multipoint Flux Mixed Finite Element (MFMFE) methods' code gallery program", "code_gallery_MultipointFluxMixedFiniteElementMethods.html", [
      [ "Introduction", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md52", null ],
      [ "Higher order Multipoint Flux Mixed Finite Element methods", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md53", null ],
      [ "Formulation of the method", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md54", [
        [ "Reduction to a pressure system and its stencil", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md55", null ],
        [ "Elimination procedure", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md56", null ],
        [ "Convergence properties", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md57", null ]
      ] ],
      [ "Numerical results", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md58", null ],
      [ "References", "code_gallery_MultipointFluxMixedFiniteElementMethods.html#autotoc_md59", null ]
    ] ],
    [ "The 'TRBDF2-DG projection solver for the incompressible Navier-Stokes equations' code gallery program", "code_gallery_NavierStokes_TRBDF2_DG.html", [
      [ "TRBDF2-DG projection solver for the incompressible Navier-Stokes equations", "code_gallery_NavierStokes_TRBDF2_DG.html#autotoc_md190", [
        [ "Compiling and Running", "code_gallery_NavierStokes_TRBDF2_DG.html#autotoc_md191", [
          [ "The Navier-Stokes equations and the time discretization strategy", "code_gallery_NavierStokes_TRBDF2_DG.html#autotoc_md192", null ],
          [ "Some implementation details", "code_gallery_NavierStokes_TRBDF2_DG.html#autotoc_md193", [
            [ "Test case", "code_gallery_NavierStokes_TRBDF2_DG.html#autotoc_md194", null ]
          ] ]
        ] ],
        [ "References", "code_gallery_NavierStokes_TRBDF2_DG.html#autotoc_md195", null ]
      ] ]
    ] ],
    [ "The 'Nonlinear poro-viscoelasticity' code gallery program", "code_gallery_Nonlinear_PoroViscoelasticity.html", [
      [ "Readme file for nonlinear-poro-viscoelasticity", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md196", [
        [ "Overview", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md197", null ],
        [ "Quick facts about the code", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md198", null ],
        [ "Running the code", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md199", [
          [ "Requirements", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md200", null ],
          [ "Compiling and running", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md201", null ]
        ] ],
        [ "Reference for this work", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md202", null ],
        [ "Recommended literature", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md203", null ],
        [ "Results", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md204", [
          [ "Consolidation experiments", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md205", null ],
          [ "Cyclic experiments under multiple loading modes", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md206", null ],
          [ "Our takeaways", "code_gallery_Nonlinear_PoroViscoelasticity.html#autotoc_md207", null ]
        ] ]
      ] ]
    ] ],
    [ "The 'Phase-field fracture model in 3D' code gallery program", "code_gallery_Phase_field_fracture_model_in_3D.html", [
      [ "Phase-field Fracture in 3D", "code_gallery_Phase_field_fracture_model_in_3D.html#autotoc_md77", [
        [ "Motivation", "code_gallery_Phase_field_fracture_model_in_3D.html#autotoc_md78", null ],
        [ "Governing equations", "code_gallery_Phase_field_fracture_model_in_3D.html#autotoc_md79", null ],
        [ "To run the Code", "code_gallery_Phase_field_fracture_model_in_3D.html#autotoc_md80", null ],
        [ "Numerical example", "code_gallery_Phase_field_fracture_model_in_3D.html#autotoc_md81", null ],
        [ "References", "code_gallery_Phase_field_fracture_model_in_3D.html#autotoc_md82", null ]
      ] ]
    ] ],
    [ "The 'Quasi-Static Finite-Strain Compressible Elasticity' code gallery program", "code_gallery_Quasi_static_Finite_strain_Compressible_Elasticity.html", null ],
    [ "The 'Quasi-Static Finite-Strain Quasi-incompressible Visco-elasticity' code gallery program", "code_gallery_Quasi_static_Finite_strain_Quasi_incompressible_ViscoElasticity.html", null ],
    [ "The 'Generalized Swift-Hohenberg Equation Solve' code gallery program", "code_gallery_Swift_Hohenberg_Solver.html", [
      [ "Introduction", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md107", null ],
      [ "Discretization and Solving the Bilaplacian", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md108", null ],
      [ "Boundary Conditions and Choosing a Suitable Domain", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md109", null ],
      [ "Initial Conditions and Parameters", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md110", null ],
      [ "Checking Convergence", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md111", null ],
      [ "Results", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md112", null ],
      [ "References", "code_gallery_Swift_Hohenberg_Solver.html#autotoc_md113", null ]
    ] ],
    [ "The 'Traveling-wave solutions of a qualitative model for combustion waves.' code gallery program", "code_gallery_TravelingWaves.html", [
      [ "Traveling-wave solutions of a qualitative model for combustion waves", "code_gallery_TravelingWaves.html#autotoc_md134", [
        [ "Building, compiling and running", "code_gallery_TravelingWaves.html#autotoc_md135", null ],
        [ "Problem", "code_gallery_TravelingWaves.html#autotoc_md136", null ],
        [ "Numerical algorithm", "code_gallery_TravelingWaves.html#autotoc_md140", [
          [ "Newton–Raphson iteration scheme", "code_gallery_TravelingWaves.html#autotoc_md141", null ],
          [ "Weak formulation", "code_gallery_TravelingWaves.html#autotoc_md144", null ],
          [ "Initial guess", "code_gallery_TravelingWaves.html#autotoc_md145", null ],
          [ "Boundary conditions", "code_gallery_TravelingWaves.html#autotoc_md146", null ]
        ] ],
        [ "Program", "code_gallery_TravelingWaves.html#autotoc_md147", [
          [ "Parameters", "code_gallery_TravelingWaves.html#autotoc_md148", null ],
          [ "Class TravelingWaveSolver", "code_gallery_TravelingWaves.html#autotoc_md149", null ],
          [ "Function calculate_profile()", "code_gallery_TravelingWaves.html#autotoc_md150", null ],
          [ "Error estimation", "code_gallery_TravelingWaves.html#autotoc_md151", null ],
          [ "Initial guess", "code_gallery_TravelingWaves.html#autotoc_md152", null ]
        ] ],
        [ "Results", "code_gallery_TravelingWaves.html#autotoc_md153", [
          [ "Slow deflagration for delta = 0.01", "code_gallery_TravelingWaves.html#autotoc_md154", null ],
          [ "Fast deflagration for delta = 0.01", "code_gallery_TravelingWaves.html#autotoc_md155", null ],
          [ "Detonation for delta = 0.01 and delta = 0.001", "code_gallery_TravelingWaves.html#autotoc_md156", null ]
        ] ],
        [ "Acknowledgments", "code_gallery_TravelingWaves.html#autotoc_md157", null ],
        [ "References", "code_gallery_TravelingWaves.html#autotoc_md158", null ]
      ] ]
    ] ],
    [ "The 'Adaptive advection-reaction' code gallery program", "code_gallery_advection_reaction_estimator.html", [
      [ "A posteriori error estimator for first order hyperbolic problems", "code_gallery_advection_reaction_estimator.html#autotoc_md99", [
        [ "Running the code:", "code_gallery_advection_reaction_estimator.html#autotoc_md100", [
          [ "Parameter file :", "code_gallery_advection_reaction_estimator.html#autotoc_md101", null ]
        ] ],
        [ "The problem:", "code_gallery_advection_reaction_estimator.html#autotoc_md102", null ],
        [ "The weak formulation:", "code_gallery_advection_reaction_estimator.html#autotoc_md103", null ],
        [ "A-posteriori error estimator:", "code_gallery_advection_reaction_estimator.html#autotoc_md104", null ],
        [ "Test case:", "code_gallery_advection_reaction_estimator.html#autotoc_md105", null ],
        [ "References", "code_gallery_advection_reaction_estimator.html#autotoc_md106", null ]
      ] ]
    ] ],
    [ "The 'Convection Diffusion Reaction' code gallery program", "code_gallery_cdr.html", null ],
    [ "The 'Laplace equation coupled to an external simulation program' code gallery program", "code_gallery_coupled_laplace_problem.html", null ],
    [ "The 'Goal-oriented mesh adaptivity in elastoplasticity problems' code gallery program", "code_gallery_goal_oriented_elastoplasticity.html", null ],
    [ "The 'Information density-based mesh refinement' code gallery program", "code_gallery_information_based_mesh_refinement.html", [
      [ "Readme file for \"Information density-based mesh refinement\"", "code_gallery_information_based_mesh_refinement.html#autotoc_md125", [
        [ "Motivation", "code_gallery_information_based_mesh_refinement.html#autotoc_md126", null ],
        [ "To run the code", "code_gallery_information_based_mesh_refinement.html#autotoc_md127", null ]
      ] ]
    ] ],
    [ "The 'Nonlinear heat transfer problem' code gallery program", "code_gallery_nonlinear_heat_transfer_with_AD_NOX.html", null ],
    [ "The 'Parallel in Time Heat Equation' code gallery program", "code_gallery_parallel_in_time.html", [
      [ "Overview", "code_gallery_parallel_in_time.html#autotoc_md176", null ],
      [ "Implementation", "code_gallery_parallel_in_time.html#autotoc_md177", [
        [ "XBraid introduction", "code_gallery_parallel_in_time.html#autotoc_md178", null ],
        [ "deal.II details", "code_gallery_parallel_in_time.html#autotoc_md179", null ],
        [ "Governing Equations", "code_gallery_parallel_in_time.html#math-details", null ],
        [ "Method of Manufactured Solutions", "code_gallery_parallel_in_time.html#autotoc_md180", null ],
        [ "Code Organization", "code_gallery_parallel_in_time.html#autotoc_md181", [
          [ "The src directory", "code_gallery_parallel_in_time.html#autotoc_md182", null ],
          [ "The test directory", "code_gallery_parallel_in_time.html#autotoc_md183", null ],
          [ "The doc directory", "code_gallery_parallel_in_time.html#autotoc_md184", null ]
        ] ]
      ] ],
      [ "Compiling", "code_gallery_parallel_in_time.html#autotoc_md185", null ],
      [ "Running", "code_gallery_parallel_in_time.html#autotoc_md186", null ],
      [ "Results", "code_gallery_parallel_in_time.html#autotoc_md187", null ],
      [ "Conclusions", "code_gallery_parallel_in_time.html#autotoc_md188", null ],
      [ "Future Work", "code_gallery_parallel_in_time.html#autotoc_md189", null ]
    ] ],
    [ "The 'Time-dependent Navier-Stokes' code gallery program", "code_gallery_time_dependent_navier_stokes.html", null ],
    [ "The 'Two phase flow interaction ' code gallery program", "code_gallery_two_phase_flow.html", null ],
    [ "The deal.II code gallery", "CodeGallery.html", null ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Todo List", "todo.html", null ],
    [ "Bibliography", "citelist.html", null ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "dealii.org", "^https://www.dealii.org/", null ]
  ] ]
];

var NAVTREEINDEX =
[
"1_80_80-vs-2_80_80_8h.html",
"array__view_8h_source.html",
"classAffineConstraints.html#a3bc850833411818832f3dbadcdf48878",
"classAlgorithms_1_1Newton.html#a44cfa90e8d8174b0aa69238325c67a77",
"classAlgorithms_1_1TimestepControl.html#a8efad9d4a3ced4f7490718da91ebb1a9",
"classArborXWrappers_1_1PointNearestPredicate.html",
"classBarycentricPolynomials.html#ae58306ce1653d40f9d6f920ac46e0f69",
"classBlockMask.html#ae9840c895d765b30bf81034996eb8cfb",
"classBlockSparseMatrix.html#a935b5e5b6b15af1ed17d77ed3b195506",
"classBlockVector.html#a71b0ab8295e98caf3dfe1ef14ae6b6c1",
"classBoundingBoxDataOut.html#a6a80b0a853e9da4951606bec27a9653c",
"classCellAccessor.html#a99b268c743742c3c9ab159ff916d9236",
"classChartManifold.html#ac06cd32e46c502c6a840d5211efcbd1c",
"classChunkSparsityPattern.html#a2fe7e3303bd59f129cdc53ce6d32c166",
"classComponentSelectFunction.html#ad45788287897bb3434daeedb519c558e",
"classDataOut.html#a062005bfe37e877e1f44e1c3e8e6cb27",
"classDataOutReader.html",
"classDataOutStack.html#a1eff778443cd0431cd807c45b6ae16d9",
"classDataPostprocessors_1_1BoundaryIds.html#acfe41896d49b57a50feee4dc8204a337",
"classDifferentiation_1_1AD_1_1EnergyFunctional.html#a114003cd9c63f8631e6d5089fc108348",
"classDifferentiation_1_1AD_1_1PointLevelFunctionsBase.html#ad08007087f5f221f69dce5db52e789d6",
"classDifferentiation_1_1AD_1_1VectorFunction.html#a1fb77d349347f0fb8c8affad32608d5c",
"classDifferentiation_1_1SD_1_1Expression.html#a4a3db163da2f6f4fdd2035473b932a96",
"classDoFAccessor.html#aa2203fb607f6ae1f79d860a41efdf37c",
"classDoFCellAccessor.html#a9c4f07312b8210527456cff67bc954c6",
"classDoFTools_1_1internal_1_1RigidBodyMotion.html#a45e07b63ee34bd7e7ab2492be5213377",
"classEllipticalManifold.html#a684ad0b97b0f225eb4eb7ee04ab41d7e",
"classFEEvaluation.html#a2a78655d119bd1bde992619c52b2d2f8",
"classFEEvaluationBase.html#adc4401003cd075b72f8b308defb2aa8b",
"classFEFaceEvaluation.html#acdaaf051d3f8f8ada47520efb0811acb",
"classFEFaceValuesBase.html#a0b15e2c3c05ab5dfed99e4befa65859a",
"classFEInterfaceViews_1_1Vector.html#a16d92df1c30f02619e13e399aefdfc98",
"classFERemoteEvaluation.html#a5053b7acfe7fe26c7458c0a96d318120",
"classFESubfaceValues.html#a7bf037ffe1677f98cbd83a0a03492e07",
"classFESystem.html#a16f4fa3651f185f3b4ee5448a8840808",
"classFESystem.html#a593fafcd5692181b79191085c57ae666",
"classFESystem.html#a9af218ae93821b61054de7e88e1734aa",
"classFESystem.html#ad12fbcc708737aa60fa272d4d3e22aea",
"classFESystem_1_1InternalData.html#af4cdec5c6df209839481fb3c9912bac0",
"classFEValuesBase.html#aaf01126d2e3b926fecbaf122357add53",
"classFEValuesViews_1_1Tensor_3_012_00_01dim_00_01spacedim_01_4.html",
"classFE__ABF.html#a1cab5fe59b82da1fc25e1454b12c4fa9",
"classFE__BDM.html#a5592f17f6c16d325de2d30f1cc051eeb",
"classFE__BernardiRaugel.html#a95ac75dfc5b9f4e01c34d5865b4ca5a2",
"classFE__Bernstein.html#adc54301ac234f9844dc6dec9686b360a",
"classFE__DGNedelec.html#a14931dc40fe240f6a263639233bba7c8",
"classFE__DGP.html#a5592f17f6c16d325de2d30f1cc051eeb",
"classFE__DGPMonomial.html#aa009769e662e34081f60ff16327db1b1",
"classFE__DGPNonparametric.html#afbc42f850096c429fd39cfcbde1b6b56",
"classFE__DGQ.html#ab4e6a76c64f925c81561745fd6bc12c3",
"classFE__DGQArbitraryNodes.html#a6dc6a1e69b9c6594f6f08338d11ceb43",
"classFE__DGQHermite.html#a33b522422da89e5c080e7405ad49d7c7",
"classFE__DGQHermite.html#afc49f8114f396b20b9a7fe9a3c058568",
"classFE__DGQLegendre.html#aaf4ea726a5bcbf9cedbf26256f926330",
"classFE__DGRaviartThomas.html#ab9815b8746600bc98e4789d106eb6aac",
"classFE__DGVector.html#ga9003d0156c27b69d5675b3b219cdfa4d",
"classFE__FaceP.html#a2ce95684ce167e59014709678dd36bbd",
"classFE__FaceQ.html#a3950cc32cd2e774dcb76e62839d68466",
"classFE__FaceQ_3_011_00_01spacedim_01_4.html#a443a348f7c568cb05b3ec3f18c788f75",
"classFE__FaceQ_3_011_00_01spacedim_01_4.html#gae0264cf47e72df9f7c9b8c7946c4e09a",
"classFE__Hermite.html#ab4f6e0c83686b918fbb92716ead92313",
"classFE__Nedelec.html#ab0a3126afa2727251eaaddc746b0b066",
"classFE__NedelecSZ.html#ab9815b8746600bc98e4789d106eb6aac",
"classFE__Nothing.html#aa32508c87a3850e94e59193f14c52d6f",
"classFE__P1NC.html#ae2531d00b5c9e77e1e64981864c3b8cc",
"classFE__PolyFace.html#a1ead2dba2770c63493a139bec677ccdb",
"classFE__PolyTensor.html#a4993707a4ec342560ff74e5d22401794",
"classFE__PyramidDGP.html#a443a348f7c568cb05b3ec3f18c788f75",
"classFE__PyramidDGP.html#gabe07a204938fd860848e8f90c76e2df9",
"classFE__PyramidP.html#ab8539eac73f0305ba91e612ad5519250",
"classFE__PyramidPoly.html#a645ff401ff38407d67a0785163939f87",
"classFE__Q.html#a3a0e7be49e27c7e4f8f675c6baaeeb97",
"classFE__Q__Base.html#a4668cb7fdcab160b0b54bdffc274558f",
"classFE__Q__Base.html#gaf85b847eec4f4a6d23d1cc10f4bad51e",
"classFE__Q__Bubbles.html#a741dab9fa897eee29d4372b91604ca2b",
"classFE__Q__Bubbles.html#ga9ece670388503599f2395fbc7d32f5f8",
"classFE__Q__DG0.html#a6dc6a1e69b9c6594f6f08338d11ceb43",
"classFE__Q__DG0.html#affdf36afda77bfd1c6b3c7f1d794f119",
"classFE__Q__iso__Q1.html#a00ab27b2dfa5520f2aa56f9bb8223878",
"classFE__Q__iso__Q1.html#a79050c43c043d560651dab7ddc2e6c5a",
"classFE__Q__iso__Q1.html#gab5e45772e1120c8909f1bca0a33bccf6",
"classFE__RannacherTurek.html#a312513162bd27169ac1b7fc878a45641",
"classFE__RaviartThomas.html#a6f3728ea2a8d8d8744ebe14bdf6cbb31",
"classFE__RaviartThomasNodal.html#aa8f4833a318127b42d2dc806bffe1c2c",
"classFE__SimplexDGP.html#a80dfe820afafe5f01dfcf103a21e63bb",
"classFE__SimplexP.html#a4668cb7fdcab160b0b54bdffc274558f",
"classFE__SimplexP__Bubbles.html",
"classFE__SimplexP__Bubbles.html#abaf754e7d2ce380c65aec08c9a1c2ae2",
"classFE__SimplexPoly.html#a6659bb0dccc62e2d680c964e5035daf6",
"classFE__TraceQ.html#a49f20953f2e9c18182e4aa04e7515b81",
"classFE__WedgeDGP.html#a40e0ebd1082fd37318aac7c5b69c99ba",
"classFE__WedgeDGP.html#ga9003d0156c27b69d5675b3b219cdfa4d",
"classFE__WedgeP.html#ab1d72dc54ae8d760b3c9c4e5ce0f96c4",
"classFE__WedgePoly.html#a62838f7428ee56e34c4081ca6d03bc26",
"classFilteredIterator.html#af4ff0049dfc58d9df66b09dda7b4ebd3",
"classFiniteElement.html#a584a56a1611a86a04c8b9a26d0eb9f27",
"classFiniteElement.html#aaf4ea726a5bcbf9cedbf26256f926330",
"classFiniteElementData.html#a358bffed1fba59ef4df715469473fd36",
"classFullMatrix.html#a76715ebcd64c97475ae26b03ff35f3f4",
"classFunctionManifold.html#affdf36afda77bfd1c6b3c7f1d794f119",
"classFunctions_1_1CoordinateRestriction.html#a45e07b63ee34bd7e7ab2492be5213377",
"classFunctions_1_1CutOffFunctionC1.html#ab0346b65f19cefecaed8290995c7ad1e",
"classFunctions_1_1CutOffFunctionW1.html#af7b872afeee25558ef1f583eb733386f",
"classFunctions_1_1FourierSineFunction.html#a15df10693418b9a80cc1e026465f9806",
"classFunctions_1_1InterpolatedUniformGridData.html#a8d704e48712e2e4ab6fee5113c6efe5a",
"classFunctions_1_1Monomial.html#a4603183dfa66622a4dc428aeb32a4452",
"classFunctions_1_1PoisseuilleFlow.html#a372ec125be7036e20810788e824b97bd",
"classFunctions_1_1SignedDistance_1_1Plane.html#a71f4570a9bacb7f24d8093ef7efd31ba",
"classFunctions_1_1SlitSingularityFunction.html#ae7d37ddb04314b38cf67c6cba22923f6",
"classFunctions_1_1StokesLSingularity.html#ae859fd287b3323bd90940dbf3da51833",
"classGinkgoWrappers_1_1SolverBicgstab.html#a2d3963e27f633eb0e4fca8cace91eccd",
"classGridIn.html#a51f7977b217e305d3538574cbd3d3a01",
"classGridTools_1_1Cache.html#a376c8ecad23b1c000c6c36feae17b386",
"classHDF5_1_1DataSet.html#a9aa6456a1b19508e87f3323f150c680c",
"classIndexSet.html#adce6a2ebf630f44c6204bf4454611acd",
"classIteratorFilters_1_1BoundaryIdEqualTo.html#a2b12293d612c63146a2303e7f055b9d3",
"classLazy.html#af6918cebabc1a357fa75f1f9e35cea5d",
"classLinearAlgebra_1_1ReadWriteVector.html#ae3b59887dd360a84a2f26bb055a23920",
"classLinearAlgebra_1_1TpetraWrappers_1_1BlockVector.html#ae3c7de4e771c97f5525ab54b3b3c25ce",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionBlockSOR.html#a4eff3ec802ac64db575c2f27e8fb21a7",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionChebyshev.html#ga56660602f6f329de37dbc90b6367ddfa",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionILUT.html#a6333956b44196d7bf091cd2e7f53c2fe",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionIfpack.html#a6333956b44196d7bf091cd2e7f53c2fe",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionJacobi.html#acb24b71476007e66626caa7eb0b40f1e",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionL1GaussSeidel.html#gaaec803c7e01359875f9b9a221809258c",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionSOR.html#a4eff3ec802ac64db575c2f27e8fb21a7",
"classLinearAlgebra_1_1TpetraWrappers_1_1PreconditionSSOR.html#ae47f136f3ecaf3c26c19d9ce47c52d60",
"classLinearAlgebra_1_1TpetraWrappers_1_1SparseMatrix.html#ad1becdcb54e80fa3871a9c95293fee1a",
"classLinearAlgebra_1_1TpetraWrappers_1_1SparsityPattern.html#a5fc1fc61827040cef34f1168e9b85654",
"classLinearAlgebra_1_1TpetraWrappers_1_1Vector.html#ab11f1157718dfb7d25208e85dc7769b0",
"classLinearAlgebra_1_1distributed_1_1Vector.html#a77c9aa6f183123d83834aa9164790c76",
"classMGCoarseGridIterativeSolver.html#a6333956b44196d7bf091cd2e7f53c2fe",
"classMGMatrixBlockVector.html#a3f18698f913d36a4d76c3d3b891ed8fd",
"classMGSmootherRelaxation.html#a4eff3ec802ac64db575c2f27e8fb21a7",
"classMGTransferComponentBase.html#acf1c1374f9b80f57becc9309ce1c8621",
"classMGTwoLevelTransfer.html#a6333956b44196d7bf091cd2e7f53c2fe",
"classMappingC1.html#a59cc130f4b0ccdaab206bbe1338f40ac",
"classMappingFE_1_1InternalData.html",
"classMappingQ.html#ac2352688072387c7263f48fd6bc95f84",
"classMappingQCache.html#a929e95edb4dbbd70266a72279667a06f",
"classMatrixBlock.html#a8fbcd53516b1e649014a40622562b635",
"classMatrixFree.html#abdace5a11d605a224e0419d70c0014e9",
"classMatrixFreeOperators_1_1LaplaceOperator.html#acfe41896d49b57a50feee4dc8204a337",
"classMatrixOut.html#a1f2f1d644d9cb1c4d1714d5173d159f2",
"classMeshWorker_1_1Assembler_1_1MGMatrixSimple.html",
"classMeshWorker_1_1LocalResults.html#af070607cff6728efae1bf173363f0d88",
"classMeshWorker_1_1ScratchData.html#aee7a4db478aff6921c6bcb557d353e53",
"classMultipleParameterLoop.html#acf494a63b63e0f0a52ddcd7cd3ba60b9",
"classNonMatching_1_1FEInterfaceValues.html#ae2268e0016219c1bc267a935380d896c",
"classNonMatching_1_1MappingInfo.html#abe146facf2c7b41031f81f52bfea51d6",
"classNonMatching_1_1internal_1_1DiscreteQuadratureGeneratorImplementation_1_1RefSpaceFEFieldFunction.html#a248adab6d82579085953ebcc66f66962",
"classNonMatching_1_1internal_1_1QuadratureGeneratorImplementation_1_1QPartitioning.html#a3c5857acd01be6e87d6aa5ea8da6410d",
"classOpenCASCADE_1_1DirectionalProjectionManifold.html#ae81c1fdfe90512e2069a5e3e22593fa6",
"classOpenCASCADE_1_1NormalToMeshProjectionManifold.html#ac797c1c3a0c757b2ca60818b43c68b78",
"classPETScWrappers_1_1FullMatrix.html#aad4b99bfc37fc183a7d978ec48f83623",
"classPETScWrappers_1_1MPI_1_1BlockSparseMatrix.html#adfd4c9d2a02835be4a0e7fdb9c5fb84b",
"classPETScWrappers_1_1MPI_1_1BlockVector.html#affdf36afda77bfd1c6b3c7f1d794f119",
"classPETScWrappers_1_1MPI_1_1Vector.html#a3ad576803857b394e28549db2cff5128",
"classPETScWrappers_1_1MatrixBase.html#a9350543a29b6e1d39a592c44ca966acb",
"classPETScWrappers_1_1MatrixFree.html#ae6d397cb51074c94824c3db0a21e6210",
"classPETScWrappers_1_1PreconditionBoomerAMG.html#ae47f136f3ecaf3c26c19d9ce47c52d60",
"classPETScWrappers_1_1PreconditionShell.html#a4668cb7fdcab160b0b54bdffc274558f",
"classPETScWrappers_1_1SolverTCQMR.html#a19ac6145f0622bd94d797760cc358dfa",
"classPETScWrappers_1_1SparseMatrix.html#af918fe8858fea210e01de289340c2468",
"classParameterAcceptorProxy.html#aa5bd2385b9c9dea5664813eb63e0b8fe",
"classParticles_1_1Particle.html#a5dba9dac9ff84ef2bbbeb0a179493e8a",
"classParticles_1_1ParticleHandler.html#ac9bdf8f58f2e2bc01fdcbab9dc467040",
"classPatterns_1_1DirectoryName.html#a7f4f2a2146ab0f512e42f29316ceabd4",
"classPatterns_1_1Selection.html#a440e87a581a0aff798c6f8ee6b66c470",
"classPersistentTriangulation.html#aac4d2ddacfa33d03341c12c9417e18bb",
"classPointValueHistory.html#a5215083277dfb44a6446a235e862d53c",
"classPolynomialsP.html#ab010f71808bc0065c03ae6b1816064dc",
"classPolynomials_1_1Hierarchical.html#a47dffef13b36f855ab3d15738acffadd",
"classPolynomials_1_1Lobatto.html#abc5ec5d03b51d1b4f539bec4d11a24c0",
"classPolynomials_1_1PolynomialsHermite.html#a4668cb7fdcab160b0b54bdffc274558f",
"classPortable_1_1MatrixFree.html#aa01ba90365284fd3913e925365476473",
"classPreconditionBlockJacobi.html#a4eff3ec802ac64db575c2f27e8fb21a7",
"classPreconditionBlockSOR.html#a92c61ba3ca1164efcc1d0874ec32111d",
"classPreconditionChebyshev.html#a4d727f1c09586b28655f54080136a49d",
"classPreconditionMG.html#acfe41896d49b57a50feee4dc8204a337",
"classPreconditionSOR.html#a4668cb7fdcab160b0b54bdffc274558f",
"classQGaussChebyshev.html",
"classReductionControl.html#a5daeed267b3e1a14b62f8ede04851db8",
"classReferenceCell.html#ac62ca74012c389ac884b88d074d0edcc",
"classRelaxationBlockJacobi.html#ae47f136f3ecaf3c26c19d9ce47c52d60",
"classRelaxationBlock_1_1AdditionalData.html#a4d727f1c09586b28655f54080136a49d",
"classRol_1_1VectorAdaptor.html#a61fc2569c9aa788cdd7a39070bce07a6",
"classSLEPcWrappers_1_1SolverKrylovSchur.html#ab23353b0d62383f7e5b2a3f98df5af79",
"classSUNDIALS_1_1ARKode.html#a63a3be391429def0384ebf67d4b8e956",
"classSUNDIALS_1_1internal_1_1LinearSolverWrapper.html#a20c5f4f7c3728a09716f43d1486c6748",
"classScalarPolynomialsBase.html#aa12f9f2846545743319be8b6d584250d",
"classSolverFGMRES.html#acb24b71476007e66626caa7eb0b40f1e",
"classSolverRichardson.html#a4eff3ec802ac64db575c2f27e8fb21a7",
"classSparseDirectUMFPACK.html#a44b62341a313440a035bf558c2f3a99a",
"classSparseILU.html#ab7e5b9eb6ad7c45635d346de98b1c1e5",
"classSparseLUDecomposition.html#ae7a9cef75f100f1d1d82f59fd95b0681",
"classSparseMatrix.html#a0b1f22866ffd7e47bfb32f62a1d3e711",
"classSparseMatrixIterators_1_1Accessor_3_01number_00_01false_01_4.html#ad9185b4c659826331a16fafeff343bc7",
"classSparsityPatternBase.html#affdf36afda77bfd1c6b3c7f1d794f119",
"classSymmetricTensor.html#a42632a338dab99a6165188f7d5687dd0",
"classTable_3_012_00_01T_01_4.html#aeb61ee698d27b8f90e6e4db00f261bf0",
"classTensor.html#a71d0baf87e7b3d210ee9c0922a4b7f9f",
"classTensorFunctionParser.html#ab0a3126afa2727251eaaddc746b0b066",
"classThreads_1_1Task.html#a9aed8f99d2b88bd0d6cfff95e38c3ac7",
"classTimeStepping_1_1EmbeddedExplicitRungeKutta.html#a19cc9872a5ae40effe26089403d315de",
"classTorusManifold.html#a600db3bc574626e1c17b64a7cd7650fb",
"classTriaAccessor.html#a8adec5f5b7786cf43e6011d03cc7903a",
"classTriaActiveIterator.html#ab69ab40c71a955ac4723d4114834038c",
"classTriangulation.html#a1dd263157214206ceb637c402552f0eb",
"classTriangulation.html#a8087e84b3b755bcb31767c574342ac0a",
"classTriangulation.html#ae8e877e2e60025d306a75bb58e7ad68e",
"classTrilinosWrappers_1_1BlockSparseMatrix.html#abaf3b791cc3424f4740333bc9ecb23d0",
"classTrilinosWrappers_1_1MPI_1_1BlockVector.html#ab0a3126afa2727251eaaddc746b0b066",
"classTrilinosWrappers_1_1MPI_1_1Vector.html#acb24b71476007e66626caa7eb0b40f1e",
"classTrilinosWrappers_1_1PreconditionAMGMueLu.html#a4eff3ec802ac64db575c2f27e8fb21a7",
"classTrilinosWrappers_1_1PreconditionBlockJacobi.html#ae47f136f3ecaf3c26c19d9ce47c52d60",
"classTrilinosWrappers_1_1PreconditionBlockwiseDirect.html#aac0a8225ad4644c2ad53c062ba4e28e6",
"classTrilinosWrappers_1_1PreconditionILU.html#a4668cb7fdcab160b0b54bdffc274558f",
"classTrilinosWrappers_1_1PreconditionIdentity.html#ae47f136f3ecaf3c26c19d9ce47c52d60",
"classTrilinosWrappers_1_1PreconditionSSOR.html#a864dc8e8aa1215741819c2f1ea7f136c",
"classTrilinosWrappers_1_1SolverGMRES.html#afdefddba07cdfc566bfb749bcb5b0840",
"classTrilinosWrappers_1_1SparseMatrix.html#ae859fd287b3323bd90940dbf3da51833",
"classTrilinosWrappers_1_1SparsityPattern.html#a935abd1908d1ed387625143f305daa2b",
"classUtilities_1_1MPI_1_1ConsensusAlgorithms_1_1PEX.html#a2f5d2d672812f732080ad312e5179930",
"classUtilities_1_1MPI_1_1Partitioner.html#ab3d760ded3110fb5e4d60d1202147bf0",
"classVector.html#a710df6df8902b609158fa277f216d146",
"classVectorizedArray.html#a3676d2de40d79d2ab01808334e9a69b9",
"classhp_1_1CollectionIterator.html#ab04fcc5c4f65046b2cbab62831b608f3",
"classhp_1_1FEValues.html#a5741150ff5397812053b20a77ebf1527",
"classinternal_1_1AlignedVectorDefaultInitialize.html#abe095cac9b7b5cf37867202e54a6b0d0",
"classinternal_1_1DoFHandlerImplementation_1_1DoFFaces_3_013_01_4.html#ab02d610d5bd7741bcad98d970da9ea0c",
"classinternal_1_1Helper_3_01HelperType_1_1dynamic_00_01Number_00_01VectorizationType_00_01fe__degree_00_01transpose_01_4.html#a6f41df2ff3db8dc7b77ee23188b1df75",
"classinternal_1_1MatrixFreeFunctions_1_1MappingDataOnTheFly.html#a989a68bb5fc29cbf17b0d20c87374fb0",
"classinternal_1_1Rescaler.html",
"classinternal_1_1TriangulationImplementation_1_1TriaFaces.html#a142f3e4ba1e3d746f209084eed891288",
"classinternal_1_1TriangulationImplementation_1_1Triangulation.html#a12dc6feb50966969856aa359f6fa316a",
"classinternal_1_1TriangulationImplementation_1_1Triangulation.html#a5cf640d5b174cae0f46e415c3fe39db2",
"classinternal_1_1TriangulationImplementation_1_1Triangulation.html#aa4029122ffe741f843f2f3a7deeceea9",
"classinternal_1_1TriangulationImplementation_1_1Triangulation.html#aeaec203ac31c6102d901e205bd774362",
"classmg_1_1SmootherRelaxation.html#acacd949ce7c4ea6762fed2befea5d98d",
"classparallel_1_1DistributedTriangulationBase.html#a2eb00096abe5ef91413440e1e1b66c00",
"classparallel_1_1DistributedTriangulationBase.html#a76937acd9dfc3ade1fb885c7ab1ae776",
"classparallel_1_1DistributedTriangulationBase.html#ab2cc397e18b3eaf0e8709abea714e17a",
"classparallel_1_1DistributedTriangulationBase.html#afacb21a22bf29351cf42cfb335e82760",
"classparallel_1_1TriangulationBase.html#a3435db0a2019d52212cfc33fdeee4d8b",
"classparallel_1_1TriangulationBase.html#a935cc3b953d71fe4081fa8f88820f034",
"classparallel_1_1TriangulationBase.html#af01ec1d50a410f7cc29c543b212edefc",
"classparallel_1_1distributed_1_1Triangulation.html#a0f5f69b2f422595604c9317ea7f15c13a92fad5ef4e0f7f69d008cb54123b1a9d",
"classparallel_1_1distributed_1_1Triangulation.html#a882c905333d176ffdcb5cd79f2e7a51e",
"classparallel_1_1distributed_1_1Triangulation.html#affce5fca29acccbb2dc1294ebe404a03",
"classparallel_1_1fullydistributed_1_1Triangulation.html#a22320eb97b1adcab2d0fb8482edc580b",
"classparallel_1_1fullydistributed_1_1Triangulation.html#a6ad0b3fb24aae17f4668427a433dea19",
"classparallel_1_1fullydistributed_1_1Triangulation.html#ab0a3126afa2727251eaaddc746b0b066",
"classparallel_1_1fullydistributed_1_1Triangulation.html#af8896f8e838dd34ed5b7c1aa351f76f5",
"classparallel_1_1shared_1_1Triangulation.html#a350ab1255e8f0cd2e5bb8ad9c797d04a",
"classparallel_1_1shared_1_1Triangulation.html#ab7a0837c6dabdda21930bf3d49e9852d",
"code_gallery_Maxwell_Eigenvalue_hp_Refinement.html#autotoc_md94",
"config_8h.html#ade098a84946491ced46fccca5c659443",
"dof__tools__constraints_8cc.html",
"fe__q__base_8cc_source.html",
"functions_rela_s.html",
"group__CPP11.html#ga09c42b09706d9fd8726d9136ab590dbb",
"group__Exceptions.html#ga5ddc378d58c2992cdf17656ac7bb707f",
"group__Exceptions.html#gabfd6302534af0a27aed7256748540889",
"group__LAOperators.html#ga3b78c08372b54dc7bc9a2cf6b497baba",
"group__mapping.html#ggac6eaf900d562c52002dbccc6bdd89275a2c91c679c0e69f01985c12ffa01c7c5c",
"lapack__templates_8h.html#a2d225293186096eee5fa539a00213139",
"mapping__related__data_8cc_source.html",
"namespaceCGALWrappers.html#afd0052dafe4ed27be786aa3a658fae53",
"namespaceDifferentiation_1_1SD.html#aab0b7e232cfce4ec2ce1103c9b2355b6",
"namespaceFEInterfaceViews.html#a04d0a58ef0844a76570401e29f9fc26a",
"namespaceGridTools.html#a995b90803c22dbe67fc6d510494b2e51a0f9bb3e7869273e59af59d0bbba24264",
"namespaceLocalIntegrators_1_1L2.html#a0a7d7409a5f53485a841a33fda68d916",
"namespacePETScWrappers.html",
"namespaceTensorProductMatrixCreator.html#aa2d3de7eafde69e6dbbce59ff62d35bca102747263147bd6e19c3d7ac38293a08",
"namespaceUtilities_1_1MPI_1_1internal_1_1MPIDataTypes.html#aa452acda75bca5731c56d0000eaa337a",
"namespacedeal__II__exceptions_1_1internals.html#af497c2ab12e991e1297f9f31f826ff07",
"namespaceinternal_1_1LinearOperatorImplementation.html#ab93d9044df2cf214963e15067ac1aa00",
"namespacemembers_func_h.html",
"parameter__acceptor_8h_source.html",
"precondition__block__ez_8cc_source.html",
"sparse__matrix__tools_8h.html",
"step_51.html",
"structColorEnriched_1_1Helper.html#ab75585a7268f10cd6c6f3dd40da18e27",
"structDifferentiation_1_1AD_1_1NumberTraits.html",
"structDifferentiation_1_1SD_1_1is__symengine__number.html",
"structFEValuesViews_1_1Scalar_1_1ShapeFunctionData.html#a4f4006a6c68d8cb1aee2ff77c0d4a8e9",
"structGeometryInfo_3_010_01_4.html#a19c7264cf11a7ab37b99edcf74cc80b7",
"structGridOutFlags_1_1XFig.html#ac1a1dc66392f46474f12922a98485bef",
"structLinearAlgebra_1_1TpetraWrappers_1_1PreconditionL1Jacobi_1_1AdditionalData.html",
"structNonMatching_1_1internal_1_1QuadratureGeneratorImplementation_1_1RootFinder_1_1AdditionalData.html#acf977ce6af2e841dc4e4973a3667be62",
"structPatterns_1_1Tools_1_1Convert_3_01std_1_1string_01_4.html#a56aeefa7179405feec6ce66768f3b63c",
"structPortable_1_1internal_1_1EvaluatorTensorProduct_3_01evaluate__general_00_01dim_00_01n__rowsc7f8915b39e935f71b9ff538958eb366.html#a617d511dd049077a5eaae0879d5209ca",
"structSolverQMRS_1_1AdditionalData.html#a0a3c043e715a31019ab069c78d41b580",
"structTimeStepBase__Tria__Flags_1_1RefinementFlags.html#a91ca1c1f1bf8a774eee335e65953fbb3",
"structTrilinosWrappers_1_1PreconditionAMG_1_1AdditionalData.html#acadde5f7bb16d31fb800c405839fcb7f",
"structUtilities_1_1MPI_1_1MinMaxAvg.html#ad61b89ee426dfa08010fafe8eb72edf1",
"structinternal_1_1DataOutImplementation_1_1ParallelData.html#a2bfcaf9f868680e17968b5dfabeb111b",
"structinternal_1_1DoFHandlerImplementation_1_1Iterators_3_011_00_01spacedim_00_01lda_01_4.html#ac23067f7a0cd55ed71a689ecb2e9b604",
"structinternal_1_1EvaluatorSelector_3_01MatrixFreeFunctions_1_1tensor__symmetric__collocation_00_01is__long_01_4.html",
"structinternal_1_1FEFaceEvaluationImplGatherEvaluateSelector_1_1Processor.html",
"structinternal_1_1FEPointEvaluation_1_1EvaluatorTypeTraits_3_01dim_00_01spacedim_00_011_00_01Number_01_4.html#a7fee72419433f8cbf778ac7f2631031e",
"structinternal_1_1MatrixFreeFunctions_1_1FaceIdentifier.html#ad8c104f92b751a96a1281e6db323e617",
"structinternal_1_1MatrixFreeFunctions_1_1TaskInfo.html#adfdb627faba47b3ccbccee4745628e61",
"structinternal_1_1ProductTypeImpl_3_01Sacado_1_1Rad_1_1ADvari_3_01T_01_4_00_01double_01_4.html",
"structinternal_1_1SubfacePossibilities_3_011_01_4.html",
"structinternal_1_1Trait_3_01T1_00_01VectorizationTypes_1_1index_01_4.html#aca52784a5636e29e648e4097871b4945",
"structinternal_1_1TriangulationImplementation_1_1Implementation.html#a8944ee9b254a1ab570ee40ec6c70860c",
"structinternal_1_1TriangulationImplementation_1_1Triangulation_1_1DistortedCellList.html#a8f22073988d2d0e544d735a43cd956fc",
"structinternal_1_1VectorOperations_1_1Vectorization__add__avpbw.html#a5eab145bdb996d0cd76b48f630da5fad",
"structinternal_1_1VectorOperations_1_1functions_3_01Number_00_01Number2_00_01_1_1MemorySpace_1_1Host_01_4.html#af087b4eabac7f78dda5b03d5d8ad9d99",
"structinternal_1_1p4est_1_1functions_3_012_01_4.html#a4b99213180402365d8b242fc450e7886",
"structis__serial__vector_3_01PETScWrappers_1_1MPI_1_1Vector_01_4.html",
"symmetric__tensor_8h.html#a306bfb1d36c717794b7e87fe06135924",
"trilinos__epetra__vector_8h_source.html"
];

var SYNCONMSG = 'click to disable panel synchronization';
var SYNCOFFMSG = 'click to enable panel synchronization';
var LISTOFALLMEMBERS = 'List of all members';