/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ne extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ग्रीनविच मिन समय",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "आपिया मानक समय",
               "",
               "आपिया दिवा समय",
               "",
               "आपिया समय",
               "",
            };
        final String[] Cook = new String[] {
               "कुक टापु मानक समय",
               "",
               "कुक टापु आधा ग्रीष्मकालीन समय",
               "",
               "कुक टापु समय",
               "",
            };
        final String[] Cuba = new String[] {
               "क्यूबाको मानक समय",
               "CST",
               "क्यूबाको दिवा समय",
               "CDT",
               "क्यूबाको समय",
               "CT",
            };
        final String[] Fiji = new String[] {
               "फिजी मानक समय",
               "",
               "फिजी ग्रीष्मकालीन समय",
               "",
               "फिजी समय",
               "",
            };
        final String[] Gulf = new String[] {
               "खाडी मानक समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "होब्ड मानक समय",
               "",
               "होब्ड ग्रीष्मकालीन समय",
               "",
               "होब्ड समय",
               "",
            };
        final String[] Iran = new String[] {
               "इरानी मानक समय",
               "",
               "इरानी दिवा समय",
               "",
               "इरानी समय",
               "",
            };
        final String[] Niue = new String[] {
               "निउए समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ओम्स्क मानक समय",
               "",
               "ओम्स्क ग्रीष्मकालीन समय",
               "",
               "ओम्स्क समय",
               "",
            };
        final String[] Peru = new String[] {
               "पेरू मानक समय",
               "",
               "पेरु ग्रीष्मकालीन समय",
               "",
               "पेरु समय",
               "",
            };
        final String[] Truk = new String[] {
               "चुउक समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "वेक टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "चिली मानक समय",
               "",
               "चिली ग्रीष्मकालीन समय",
               "",
               "चिली समय",
               "",
            };
        final String[] China = new String[] {
               "चीन मानक समय",
               "CST",
               "चीन दिवा समय",
               "CDT",
               "चीन समय",
               "CT",
            };
        final String[] Cocos = new String[] {
               "कोकोस टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "डेभिस समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "भारतीय मानक समय",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "जापान मानक समय",
               "JST",
               "जापान दिवा समय",
               "JDT",
               "जापान समय",
               "JT",
            };
        final String[] Korea = new String[] {
               "कोरियाली मानक समय",
               "KST",
               "कोरियाली दिवा समय",
               "KST",
               "कोरियाली समय",
               "KST",
            };
        final String[] Nauru = new String[] {
               "नाउरु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "नेपाली समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "पालाउ समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "सामोअ मानक समय",
               "SST",
               "सामोअ दिवा समय",
               "SST",
               "सामोअ समय",
               "SST",
            };
        final String[] Syowa = new String[] {
               "स्योवा समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "टोंगा मानक समय",
               "",
               "टोंगा ग्रीष्मकालीन समय",
               "",
               "टोंगा समय",
               "",
            };
        final String[] Yukon = new String[] {
               "युकोनको समय",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "अलस्काको मानक समय",
               "AKST",
               "अलस्काको दिवा समय",
               "AKDT",
               "अलस्काको समय",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "एमाजोन मानक समय",
               "",
               "एमाजोन ग्रीष्मकालीन समय",
               "",
               "एमाजोन समय",
               "",
            };
        final String[] Azores = new String[] {
               "एजोरेस् मानक समय",
               "",
               "एजोरेस् ग्रीष्मकालीन समय",
               "",
               "एजोरेस् समय",
               "",
            };
        final String[] Bhutan = new String[] {
               "भुटानी समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ब्रुनाइ दारूस्सलम समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "इस्टर टापू मानक समय",
               "",
               "इस्टर टापू ग्रीष्म समय",
               "",
               "इस्टर टापू समय",
               "",
            };
        final String[] Guyana = new String[] {
               "गुयाना समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "इजरायल मानक समय",
               "IST",
               "इजरायल दिवा समय",
               "IDT",
               "इजरायल समय",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "कोसराए समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "म्वसन समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "मस्को मानक समय",
               "MSK",
               "मस्को ग्रीष्मकालीन समय",
               "MSK",
               "मस्को समय",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "पोनापे समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ताहिती समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ताइपेइ मानक समय",
               "CST",
               "ताइपेइ दिवा समय",
               "CDT",
               "ताइपेइ समय",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "टुभालु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "भास्टोक समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "वालिस् र फुटुना समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "अरबी मानक समय",
               "",
               "अरबी दिवा समय",
               "",
               "अरबी समय",
               "",
            };
        final String[] Armenia = new String[] {
               "अर्मेनिया मानक समय",
               "",
               "अर्मेनिया ग्रीष्मकालीन समय",
               "",
               "अर्मेनिया समय",
               "",
            };
        final String[] Bolivia = new String[] {
               "बोलिभिया समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "चाथाम मानक समय",
               "",
               "चाथाम दिवा समय",
               "",
               "चाथाम समय",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "समन्वित विश्व समय",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ईक्वोडोर समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ग्याम्बियर समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "जर्जिया मानक समय",
               "",
               "जर्जिया ग्रीष्मकालीन समय",
               "",
               "जर्जिया समय",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ईर्कुट्स्क मानक समय",
               "",
               "ईर्कुट्स्क ग्रीष्मकालीन समय",
               "",
               "ईर्कुट्स्क समय",
               "",
            };
        final String[] Magadan = new String[] {
               "मागादान मानक समय",
               "",
               "मागादान ग्रीष्मकालीन समय",
               "",
               "मागादान समय",
               "",
            };
        final String[] Myanmar = new String[] {
               "म्यानमार समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "नोर्फोक टापूको मानक समय",
               "",
               "नोर्फोक टापूको ग्रीष्मकालीन समय",
               "",
               "नोर्फोक टापूको समय",
               "",
            };
        final String[] Noronha = new String[] {
               "फर्नान्डो डे नोरोन्हा मानक समय",
               "",
               "फर्नान्डो डे नोरोन्हा ग्रीष्मकालीन समय",
               "",
               "फर्नान्डो डे नोरोन्हा समय",
               "",
            };
        final String[] Reunion = new String[] {
               "रियुनियन समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "रोथेरा समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "सोलोमोन टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "तोकेलाउ समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "उरूग्वे मानक समय",
               "",
               "उरुग्वे ग्रीष्मकालीन समय",
               "",
               "उरुग्वे समय",
               "",
            };
        final String[] Vanuatu = new String[] {
               "भानुआतु मानक समय",
               "",
               "भानुआतु ग्रीष्मकालीन समय",
               "",
               "भानुआतु समय",
               "",
            };
        final String[] Yakutsk = new String[] {
               "याकुस्ट मानक समय",
               "",
               "याकुस्ट ग्रीष्मकालीन समय",
               "",
               "याकुस्ट समय",
               "",
            };
        final String[] Atlantic = new String[] {
               "एट्लान्टिक मानक समय",
               "AST",
               "एट्लान्टिक दिवा समय",
               "AST",
               "एट्लान्टिक समय",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ब्राजिलिया मानक समय",
               "",
               "ब्राजिलीया ग्रीष्मकालीन समय",
               "",
               "ब्राजिलीया समय",
               "",
            };
        final String[] Chamorro = new String[] {
               "चामोर्रो मानक समय",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "कोलम्बियाली मानक समय",
               "",
               "कोलम्बियाली ग्रीष्मकालीन समय",
               "",
               "कोलम्बियाली समय",
               "",
            };
        final String[] Falkland = new String[] {
               "फल्कल्यान्ड टापू मानक समय",
               "",
               "फल्कल्यान्ड टापू ग्रीष्मकालीन समय",
               "",
               "फल्कल्यान्ड टापू समय",
               "",
            };
        final String[] Malaysia = new String[] {
               "मलेसिया समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "माल्दिभ्स समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "उलान बाटोर मानक समय",
               "",
               "उलान बाटोर ग्रीष्मकालीन समय",
               "",
               "उलान बाटोर समय",
               "",
            };
        final String[] Pakistan = new String[] {
               "पाकिस्तानी मानक समय",
               "PKT",
               "पाकिस्तानी ग्रीष्मकालीन समय",
               "PKST",
               "पाकिस्तानी समय",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "पाराग्वे मानक समय",
               "",
               "पाराग्वे ग्रीष्मकालीन समय",
               "",
               "पाराग्वे समय",
               "",
            };
        final String[] Pitcairn = new String[] {
               "पिटकैरण समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "साखालिन मानक समय",
               "",
               "साखालिन ग्रीष्मकालीन समय",
               "",
               "साखालिन समय",
               "",
            };
        final String[] Suriname = new String[] {
               "सुरिनामा समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "अर्जेनटिनी मानक समय",
               "",
               "अर्जेनटिनी ग्रीष्मकालीन समय",
               "",
               "अर्जेनटिनी समय",
               "",
            };
        final String[] Christmas = new String[] {
               "क्रिस्मस टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "गालापागोस् समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "हङकङ मानक समय",
               "HKT",
               "हङकङ ग्रीष्मकालीन समय",
               "HKST",
               "हङकङ समय",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "इन्डोचाइना समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "किर्गिस्तान समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "लर्ड हावे मानक समय",
               "",
               "लर्ड हावे दिवा समय",
               "",
               "लर्ड हावे समय",
               "",
            };
        final String[] Marquesas = new String[] {
               "मार्किसस समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "मउरिटस मानक समय",
               "",
               "मउरिटस ग्रीष्मकालीन समय",
               "",
               "मउरिटस समय",
               "",
            };
        final String[] Singapore = new String[] {
               "सिंगापुर मानक समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "भेनेज्युएला समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "भोल्गाग्राद मानक समय",
               "MSK",
               "भोल्गाग्राद ग्रीष्मकालीन समय",
               "MSK",
               "भोल्गाग्राड समय",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "अजरबैजान मानक समय",
               "",
               "अजरबैजान ग्रीष्मकालीन समय",
               "",
               "अजरबैजान समय",
               "",
            };
        final String[] Bangladesh = new String[] {
               "बंगलादेशी मानक समय",
               "",
               "बंगलादेशी ग्रीष्मकालीन समय",
               "",
               "बंगलादेशी समय",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "केप भर्दे मानक समय",
               "",
               "केप भर्दे ग्रीष्मकालीन समय",
               "",
               "केप भर्दे समय",
               "",
            };
        final String[] East_Timor = new String[] {
               "पूर्वी टिमोर समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "काजकस्तानको समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "सेयेचेलास् समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ताजिकस्तान समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "उज्बेकिस्तान मानक समय",
               "",
               "उज्बेकिस्तान ग्रीष्मकालीन समय",
               "",
               "उज्बेकिस्तान समय",
               "",
            };
        final String[] Afghanistan = new String[] {
               "अफगानिस्तान समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "क्रासनोयार्क मानक समय",
               "",
               "क्रासनोयार्क ग्रीष्मकालीन समय",
               "",
               "क्रासनोयार्क समय",
               "",
            };
        final String[] New_Zealand = new String[] {
               "न्यूजिल्यान्ड मानक समय",
               "NZST",
               "न्यूजिल्यान्ड दिवा समय",
               "NZDT",
               "न्यूजिल्यान्ड समय",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "नोभोसिविर्स्क मानक समय",
               "",
               "नोभोसिविर्स्क ग्रीष्मकालीन समय",
               "",
               "नोभोसिविर्स्क समय",
               "",
            };
        final String[] Philippines = new String[] {
               "फिलिपिनी मानक समय",
               "PST",
               "फिलिपिनी ग्रीष्मकालीन समय",
               "PDT",
               "फिलिपिनी समय",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "भ्लादिभास्टोक मानक समय",
               "",
               "भ्लादिभास्टोक ग्रीष्मकालीन समय",
               "",
               "भ्लादिभास्टोक समय",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "हिन्द महासागर समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "लाइन टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "न्यूफाउनडल्यान्डको मानक समय",
               "NST",
               "न्यूफाउनल्यान्डको दिवा समय",
               "NDT",
               "न्यूफाउन्डल्यान्डको समय",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "तुर्कमेनिस्तान मानक समय",
               "",
               "तुर्कमेनिस्तान ग्रीष्मकालीन मानक समय",
               "",
               "तुर्कमेनिस्तान समय",
               "",
            };
        final String[] French_Guiana = new String[] {
               "फ्रेन्च ग्वाना समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "नयाँ कालेदोनिया मानक समय",
               "",
               "नयाँ कालेदोनिया ग्रीष्मकालीन समय",
               "",
               "नयाँ कालेदोनिया समय",
               "",
            };
        final String[] South_Georgia = new String[] {
               "दक्षिण जर्जिया समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "येकाटेरिनबर्ग मानक समय",
               "",
               "येकाटेरिनबर्ग ग्रीष्मकालीन समय",
               "",
               "येकाटेरिनबर्ग समय",
               "",
            };
        final String[] Africa_Central = new String[] {
               "केन्द्रीय अफ्रिकी समय",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "पूर्वी अफ्रिकी समय",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "पश्चिम अफ्रिकी मानक समय",
               "WAT",
               "पश्चिम अफ्रिकी ग्रीष्मकालीन समय",
               "WAT",
               "पश्चिम अफ्रिकी समय",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "डुमोन्ट-डी‘ उर्भिले समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "केन्द्रीय युरोपेली मानक समय",
               "CET",
               "केन्द्रीय युरोपेली ग्रीष्मकालीन समय",
               "CEST",
               "केन्द्रीय युरोपेली समय",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "पूर्वी युरोपेली मानक समय",
               "EET",
               "पूर्वी युरोपेली ग्रीष्मकालीन समय",
               "EEST",
               "पूर्वी युरोपेली समय",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "पश्चिमी युरोपेली मानक समय",
               "WET",
               "युरोपेली ग्रीष्मकालीन समय",
               "WEST",
               "पश्चिमी युरोपेली समय",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "मेक्सिकन प्यासिफिक मानक समय",
               "MST",
               "मेक्सिकन प्यासिफिक दिवा समय",
               "MDT",
               "मेक्सिकन प्यासिफिक समय",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "दक्षिण अफ्रिकी समय",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "केन्द्रीय मानक समय",
               "CST",
               "केन्द्रीय दिवा समय",
               "CDT",
               "केन्द्रीय समय",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "पूर्वी मानक समय",
               "EST",
               "पूर्वी दिवा समय",
               "EST",
               "पूर्वी समय",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "प्यासिफिक मानक समय",
               "PST",
               "प्यासिफिक दिवा समय",
               "PDT",
               "प्यासिफिक समय",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "फ्रेन्च दक्षिणी र अन्टार्टिक समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "गिल्बर्ट टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "हवाई-एलुटियन मानक समय",
               "HST",
               "हवाई-एलुटियन दिवा समय",
               "HST",
               "हवाई-एलुटियन समय",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "फिनिक्स टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "सेन्ट पियर्रे र मिक्युलोनको मानक समय",
               "",
               "सेन्ट पियर्रे र मिक्युलोनको दिवा समय",
               "",
               "सेन्ट पियर्रे र मिक्युलोनको समय",
               "",
            };
        final String[] America_Mountain = new String[] {
               "हिमाली मानक समय",
               "MST",
               "हिमाली दिवा समय",
               "MST",
               "हिमाली समय",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "मार्शल टापु समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "पपूवा न्यू गिनी समय",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "केन्द्रीय अस्ट्रेलिया मानक समय",
               "ACST",
               "केन्द्रीय अस्ट्रेलिया दिवा समय",
               "ACDT",
               "केन्द्रीय अस्ट्रेलिया समय",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "पूर्वी अस्ट्रेलिया मानक समय",
               "AEST",
               "पूर्वी अस्ट्रेलिया दिवा समय",
               "AEDT",
               "पूर्वी अस्ट्रेलिया समय",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "पश्चिमी अस्ट्रेलिया मानक समय",
               "AWST",
               "पश्चिमी अस्ट्रेलिया दिवा समय",
               "AWDT",
               "पश्चिमी अस्ट्रेलिया समय",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "केन्द्रीय इन्डोनेशिया समय",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "पूर्वी इन्डोनेशिया समय",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "पश्चिमी इन्डोनेशिया समय",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "केन्द्रीय पश्चिमी अस्ट्रेलिया मानक समय",
               "",
               "केन्द्रीय पश्चिमी अस्ट्रेलिया दिवा समय",
               "",
               "केन्द्रीय पश्चिमी अस्ट्रेलिया समय",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "समन्वित विश्व समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "आइरिश मानक समय",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "समन्वित विश्व समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "समन्वित विश्व समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "समन्वित विश्व समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "समन्वित विश्व समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "समन्वित विश्व समय",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "आइरिश मानक समय",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ग्रीनविच मिन समय",
                    "GMT",
                    "बेलायती ग्रीष्मकालीन समय",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "एडेन" },
            { "timezone.excity.Asia/Baku", "बाकु" },
            { "timezone.excity.Asia/Dili", "दिल्ली" },
            { "timezone.excity.Asia/Gaza", "गाजा" },
            { "timezone.excity.Asia/Hovd", "होभ्ड" },
            { "timezone.excity.Asia/Omsk", "ओम्स्क" },
            { "timezone.excity.Asia/Oral", "ओरल" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "आम्मान" },
            { "timezone.excity.Asia/Aqtau", "आक्टाउ" },
            { "timezone.excity.Asia/Chita", "चिता" },
            { "timezone.excity.Asia/Dhaka", "ढाका" },
            { "timezone.excity.Asia/Dubai", "दुबही" },
            { "timezone.excity.Asia/Kabul", "काबुल" },
            { "timezone.excity.Asia/Macau", "मकाउ" },
            { "timezone.excity.Asia/Qatar", "कतार" },
            { "timezone.excity.Asia/Seoul", "सिओल" },
            { "timezone.excity.Asia/Tokyo", "टोकियो" },
            { "timezone.excity.Asia/Tomsk", "टोम्स्क" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "जुबा" },
            { "timezone.excity.Africa/Lome", "लोम" },
            { "timezone.excity.Asia/Almaty", "आल्माटी" },
            { "timezone.excity.Asia/Anadyr", "आनाडियर" },
            { "timezone.excity.Asia/Aqtobe", "आक्टोब" },
            { "timezone.excity.Asia/Atyrau", "अटिराउ" },
            { "timezone.excity.Asia/Beirut", "बेईरुट" },
            { "timezone.excity.Asia/Brunei", "ब्रुनाइ" },
            { "timezone.excity.Asia/Hebron", "हिब्रोन" },
            { "timezone.excity.Asia/Kuwait", "कुवेत" },
            { "timezone.excity.Asia/Manila", "मनिला" },
            { "timezone.excity.Asia/Muscat", "मस्क्याट" },
            { "timezone.excity.Asia/Riyadh", "रियाद" },
            { "timezone.excity.Asia/Saigon", "हो ची मिन्ह शहर" },
            { "timezone.excity.Asia/Taipei", "ताईपे" },
            { "timezone.excity.Asia/Tehran", "तेहेरान" },
            { "timezone.excity.Asia/Urumqi", "उरूम्की" },
            { "timezone.excity.Etc/Unknown", "अज्ञात शहर" },
            { "timezone.excity.Europe/Kiev", "किभ" },
            { "timezone.excity.Europe/Oslo", "ओस्लो" },
            { "timezone.excity.Europe/Riga", "रिगा" },
            { "timezone.excity.Europe/Rome", "रोम" },
            { "timezone.excity.Indian/Mahe", "माहे" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "अक्रा" },
            { "timezone.excity.Africa/Cairo", "काइरो" },
            { "timezone.excity.Africa/Ceuta", "सेउटा" },
            { "timezone.excity.Africa/Dakar", "डाकार" },
            { "timezone.excity.Africa/Lagos", "लागोस" },
            { "timezone.excity.Africa/Tunis", "टुनिस" },
            { "timezone.excity.America/Adak", "आडाक" },
            { "timezone.excity.America/Lima", "लिमा" },
            { "timezone.excity.America/Nome", "नोम" },
            { "timezone.excity.Asia/Baghdad", "बगदाद" },
            { "timezone.excity.Asia/Bahrain", "बहराईन" },
            { "timezone.excity.Asia/Bangkok", "बैंकक" },
            { "timezone.excity.Asia/Barnaul", "बरनौल" },
            { "timezone.excity.Asia/Bishkek", "बिसकेक्" },
            { "timezone.excity.Asia/Colombo", "कोलम्बो" },
            { "timezone.excity.Asia/Irkutsk", "इर्कुत्स्क" },
            { "timezone.excity.Asia/Jakarta", "जाकार्ता" },
            { "timezone.excity.Asia/Karachi", "कराची" },
            { "timezone.excity.Asia/Kuching", "कुचिङ" },
            { "timezone.excity.Asia/Magadan", "मागाडान" },
            { "timezone.excity.Asia/Nicosia", "निकोसिया" },
            { "timezone.excity.Asia/Rangoon", "रान्गुन" },
            { "timezone.excity.Asia/Tbilisi", "तिबिलिसी" },
            { "timezone.excity.Asia/Thimphu", "थिम्पु" },
            { "timezone.excity.Asia/Yakutsk", "याकुत्स्क" },
            { "timezone.excity.Asia/Yerevan", "येरेभान" },
            { "timezone.excity.Europe/Kirov", "किरोभ" },
            { "timezone.excity.Europe/Malta", "माल्टा" },
            { "timezone.excity.Europe/Minsk", "मिन्स्क" },
            { "timezone.excity.Europe/Paris", "पेरिस" },
            { "timezone.excity.Europe/Sofia", "सोफिया" },
            { "timezone.excity.Europe/Vaduz", "भाडुज" },
            { "timezone.excity.Indian/Cocos", "कोकोस" },
            { "timezone.excity.Pacific/Apia", "अपिया" },
            { "timezone.excity.Pacific/Fiji", "फिजी" },
            { "timezone.excity.Pacific/Guam", "गुवाम" },
            { "timezone.excity.Pacific/Niue", "निउई" },
            { "timezone.excity.Pacific/Truk", "चूक" },
            { "timezone.excity.Pacific/Wake", "वेक" },
            { "timezone.excity.Africa/Asmera", "आस्मारा" },
            { "timezone.excity.Africa/Bamako", "बोमाको" },
            { "timezone.excity.Africa/Bangui", "बाङ्गुवी" },
            { "timezone.excity.Africa/Banjul", "बन्जुल" },
            { "timezone.excity.Africa/Bissau", "बिसाउ" },
            { "timezone.excity.Africa/Douala", "डोउआला" },
            { "timezone.excity.Africa/Harare", "हरारे" },
            { "timezone.excity.Africa/Kigali", "किगाली" },
            { "timezone.excity.Africa/Luanda", "लुवान्डा" },
            { "timezone.excity.Africa/Lusaka", "लुसाका" },
            { "timezone.excity.Africa/Malabo", "मालाबो" },
            { "timezone.excity.Africa/Maputo", "मापुतो" },
            { "timezone.excity.Africa/Maseru", "मासेरू" },
            { "timezone.excity.Africa/Niamey", "नायमे" },
            { "timezone.excity.America/Aruba", "अरुबा" },
            { "timezone.excity.America/Bahia", "बाहिया" },
            { "timezone.excity.America/Belem", "बेलेम" },
            { "timezone.excity.America/Boise", "बोइज" },
            { "timezone.excity.America/Jujuy", "जुजुई" },
            { "timezone.excity.America/Sitka", "सिट्का" },
            { "timezone.excity.America/Thule", "थुले" },
            { "timezone.excity.Asia/Ashgabat", "अस्काबाट" },
            { "timezone.excity.Asia/Calcutta", "कोलकाता" },
            { "timezone.excity.Asia/Damascus", "दामास्कस्" },
            { "timezone.excity.Asia/Dushanbe", "दस्सान्बे" },
            { "timezone.excity.Asia/Jayapura", "जयापुरा" },
            { "timezone.excity.Asia/Katmandu", "काठमाण्डौं" },
            { "timezone.excity.Asia/Khandyga", "खान्दिगा" },
            { "timezone.excity.Asia/Makassar", "माकास्सार" },
            { "timezone.excity.Asia/Qostanay", "कस्टाने" },
            { "timezone.excity.Asia/Sakhalin", "साखालिन" },
            { "timezone.excity.Asia/Shanghai", "सान्घाई" },
            { "timezone.excity.Asia/Tashkent", "तास्केन्ट" },
            { "timezone.excity.Asia/Ust-Nera", "उस्ट-नेरा" },
            { "timezone.excity.Europe/Athens", "एथेन्स" },
            { "timezone.excity.Europe/Berlin", "बर्लिन" },
            { "timezone.excity.Europe/Dublin", "डब्लिन" },
            { "timezone.excity.Europe/Jersey", "जर्सी" },
            { "timezone.excity.Europe/Lisbon", "लिस्बोन" },
            { "timezone.excity.Europe/London", "लण्डन" },
            { "timezone.excity.Europe/Madrid", "म्याड्रिड" },
            { "timezone.excity.Europe/Monaco", "मोनाको" },
            { "timezone.excity.Europe/Moscow", "मस्को" },
            { "timezone.excity.Europe/Prague", "प्राग" },
            { "timezone.excity.Europe/Samara", "सामारा" },
            { "timezone.excity.Europe/Skopje", "स्कोपजे" },
            { "timezone.excity.Europe/Tirane", "टिराने" },
            { "timezone.excity.Europe/Vienna", "भियना" },
            { "timezone.excity.Europe/Warsaw", "वारसअ" },
            { "timezone.excity.Europe/Zagreb", "जाग्रेब" },
            { "timezone.excity.Europe/Zurich", "जुरिक" },
            { "timezone.excity.Indian/Chagos", "चागोस" },
            { "timezone.excity.Indian/Comoro", "कोमोरो" },
            { "timezone.excity.Pacific/Efate", "ईफाते" },
            { "timezone.excity.Pacific/Nauru", "नाउरु" },
            { "timezone.excity.Pacific/Palau", "पलाउ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "अविड्जान" },
            { "timezone.excity.Africa/Algiers", "अल्जियर्स" },
            { "timezone.excity.Africa/Conakry", "कोनाक्री" },
            { "timezone.excity.Africa/Kampala", "काम्पाला" },
            { "timezone.excity.Africa/Mbabane", "एमबाबेन" },
            { "timezone.excity.Africa/Nairobi", "नाइरोबी" },
            { "timezone.excity.Africa/Tripoli", "त्रिपोली" },
            { "timezone.excity.America/Belize", "बेलिज" },
            { "timezone.excity.America/Bogota", "बोगोटा" },
            { "timezone.excity.America/Cancun", "कानकुन" },
            { "timezone.excity.America/Cayman", "केम्यान" },
            { "timezone.excity.America/Cuiaba", "क्युइआबा" },
            { "timezone.excity.America/Dawson", "डसन" },
            { "timezone.excity.America/Denver", "डेन्भर" },
            { "timezone.excity.America/Guyana", "गुयाना" },
            { "timezone.excity.America/Havana", "हभाना" },
            { "timezone.excity.America/Inuvik", "इनुभिक" },
            { "timezone.excity.America/Juneau", "जुनिउ" },
            { "timezone.excity.America/La_Paz", "ला पाज" },
            { "timezone.excity.America/Maceio", "मासेइओ" },
            { "timezone.excity.America/Manaus", "मानाउस" },
            { "timezone.excity.America/Merida", "मेरिडा" },
            { "timezone.excity.America/Nassau", "नास्साउ" },
            { "timezone.excity.America/Panama", "पानामा" },
            { "timezone.excity.America/Recife", "रिसाइफ" },
            { "timezone.excity.America/Regina", "रेजिना" },
            { "timezone.excity.Asia/Famagusta", "फामागुस्ता" },
            { "timezone.excity.Asia/Hong_Kong", "हङकङ" },
            { "timezone.excity.Asia/Jerusalem", "जेरुसलेम" },
            { "timezone.excity.Asia/Kamchatka", "कामचट्का" },
            { "timezone.excity.Asia/Pontianak", "पोन्टिआनाक" },
            { "timezone.excity.Asia/Pyongyang", "प्योङयाङ" },
            { "timezone.excity.Asia/Qyzylorda", "किजिलोर्डा" },
            { "timezone.excity.Asia/Samarkand", "समारकण्ड" },
            { "timezone.excity.Asia/Singapore", "सिंगापुर" },
            { "timezone.excity.Asia/Vientiane", "भियन्तिन" },
            { "timezone.excity.Europe/Andorra", "आन्डोर्रा" },
            { "timezone.excity.Europe/Saratov", "साराटोभ" },
            { "timezone.excity.Europe/Tallinn", "ताल्लिन" },
            { "timezone.excity.Europe/Vatican", "भ्याटिकन" },
            { "timezone.excity.Europe/Vilnius", "भिल्निअस" },
            { "timezone.excity.Indian/Mayotte", "मायोट्टे" },
            { "timezone.excity.Indian/Reunion", "रियुनियन" },
            { "timezone.excity.Pacific/Easter", "इस्टर" },
            { "timezone.excity.Pacific/Kanton", "कान्टोन" },
            { "timezone.excity.Pacific/Kosrae", "कोस्राए" },
            { "timezone.excity.Pacific/Majuro", "माजुरो" },
            { "timezone.excity.Pacific/Midway", "मिडवे" },
            { "timezone.excity.Pacific/Noumea", "नोउमेअ" },
            { "timezone.excity.Pacific/Ponape", "पोनापे" },
            { "timezone.excity.Pacific/Saipan", "साईपन" },
            { "timezone.excity.Pacific/Tahiti", "ताहिती" },
            { "timezone.excity.Pacific/Tarawa", "तरवा" },
            { "timezone.excity.Pacific/Wallis", "वालिस" },
            { "timezone.excity.Africa/Blantyre", "ब्लान्टायर" },
            { "timezone.excity.Africa/Djibouti", "जिबौंटी" },
            { "timezone.excity.Africa/El_Aaiun", "एल् आइयुन" },
            { "timezone.excity.Africa/Freetown", "फ्रिटाउन" },
            { "timezone.excity.Africa/Gaborone", "गावोरोन" },
            { "timezone.excity.Africa/Khartoum", "खार्टउम" },
            { "timezone.excity.Africa/Kinshasa", "किन्शासा" },
            { "timezone.excity.Africa/Monrovia", "मोन्रोभिया" },
            { "timezone.excity.Africa/Ndjamena", "एन्‌जामेना" },
            { "timezone.excity.Africa/Sao_Tome", "साओ टोमे" },
            { "timezone.excity.Africa/Windhoek", "विन्डहोएक" },
            { "timezone.excity.America/Antigua", "एन्टिगुवा" },
            { "timezone.excity.America/Caracas", "काराकास" },
            { "timezone.excity.America/Cayenne", "कायेन्ने" },
            { "timezone.excity.America/Chicago", "शिकागो" },
            { "timezone.excity.America/Cordoba", "कोरडोवा" },
            { "timezone.excity.America/Creston", "क्रेस्टन" },
            { "timezone.excity.America/Curacao", "कुराकाओ" },
            { "timezone.excity.America/Detroit", "डिट्रोइट" },
            { "timezone.excity.America/Godthab", "नूक" },
            { "timezone.excity.America/Grenada", "ग्रेनाडा" },
            { "timezone.excity.America/Halifax", "ह्यालिफ्याक्स" },
            { "timezone.excity.America/Iqaluit", "इक्वालुइट" },
            { "timezone.excity.America/Jamaica", "जमाइका" },
            { "timezone.excity.America/Managua", "मानागुवा" },
            { "timezone.excity.America/Marigot", "म्यारिगट" },
            { "timezone.excity.America/Mendoza", "मेन्डोजा" },
            { "timezone.excity.America/Moncton", "मोन्कटन" },
            { "timezone.excity.America/Noronha", "नोरोन्हा" },
            { "timezone.excity.America/Ojinaga", "ओजिनागा" },
            { "timezone.excity.America/Phoenix", "फिनिक्स" },
            { "timezone.excity.America/Tijuana", "तिजुआना" },
            { "timezone.excity.America/Toronto", "टोरोन्टो" },
            { "timezone.excity.America/Tortola", "टार्टोला" },
            { "timezone.excity.America/Yakutat", "याकुटाट" },
            { "timezone.excity.Asia/Phnom_Penh", "फेनोम फेन" },
            { "timezone.excity.Atlantic/Azores", "आजोर्स" },
            { "timezone.excity.Atlantic/Canary", "क्यानारी" },
            { "timezone.excity.Atlantic/Faeroe", "फारोइ" },
            { "timezone.excity.Australia/Eucla", "इयुक्ला" },
            { "timezone.excity.Australia/Perth", "पर्थ" },
            { "timezone.excity.Europe/Belgrade", "बेलग्रेड" },
            { "timezone.excity.Europe/Brussels", "ब्रसेल्स" },
            { "timezone.excity.Europe/Budapest", "बुडापेस्ट" },
            { "timezone.excity.Europe/Busingen", "बुसिन्नगन" },
            { "timezone.excity.Europe/Chisinau", "चिसिनाउ" },
            { "timezone.excity.Europe/Guernsey", "गुएर्नसे" },
            { "timezone.excity.Europe/Helsinki", "हेल्सिन्की" },
            { "timezone.excity.Europe/Istanbul", "ईस्टानबुल" },
            { "timezone.excity.Europe/Sarajevo", "साराजेभो" },
            { "timezone.excity.Indian/Maldives", "माल्दिभ्स" },
            { "timezone.excity.Pacific/Chatham", "चाथाम" },
            { "timezone.excity.Pacific/Fakaofo", "फाकाओफो" },
            { "timezone.excity.Pacific/Gambier", "ग्याम्बियर" },
            { "timezone.excity.Pacific/Norfolk", "नरफोल्क" },
            { "timezone.excity.Africa/Bujumbura", "बुजुम्बुरा" },
            { "timezone.excity.Africa/Mogadishu", "मोगाडिशु" },
            { "timezone.excity.America/Anguilla", "एङ्ग्विल्ला" },
            { "timezone.excity.America/Asuncion", "असन्सियन" },
            { "timezone.excity.America/Barbados", "बार्बाडोस" },
            { "timezone.excity.America/Dominica", "डोमिनिका" },
            { "timezone.excity.America/Edmonton", "एड्मोन्टन" },
            { "timezone.excity.America/Eirunepe", "आइरनेपे" },
            { "timezone.excity.America/Mazatlan", "माजाट्लान" },
            { "timezone.excity.America/Miquelon", "मिक्विलन" },
            { "timezone.excity.America/New_York", "न्युयोर्क" },
            { "timezone.excity.America/Resolute", "रिजोलुट" },
            { "timezone.excity.America/Santarem", "सान्टारेम" },
            { "timezone.excity.America/Santiago", "सान्टिआगो" },
            { "timezone.excity.America/St_Johns", "सेन्ट जोन्स" },
            { "timezone.excity.America/St_Kitts", "सेन्ट् किट्स" },
            { "timezone.excity.America/St_Lucia", "सेन्ट लुसिया" },
            { "timezone.excity.America/Winnipeg", "विन्निपेग" },
            { "timezone.excity.Antarctica/Casey", "केजे" },
            { "timezone.excity.Antarctica/Davis", "डेभिस" },
            { "timezone.excity.Antarctica/Syowa", "सिओआ" },
            { "timezone.excity.Antarctica/Troll", "ट्रोल" },
            { "timezone.excity.Asia/Krasnoyarsk", "क्रास्नोयार्स्क" },
            { "timezone.excity.Asia/Novosibirsk", "नोबोसिबिर्स्क" },
            { "timezone.excity.Asia/Ulaanbaatar", "उलानबटार" },
            { "timezone.excity.Asia/Vladivostok", "भ्लाडिभास्टोक" },
            { "timezone.excity.Atlantic/Bermuda", "बर्मुडा" },
            { "timezone.excity.Atlantic/Madeira", "माडेइरा" },
            { "timezone.excity.Atlantic/Stanley", "स्ट्यान्ली" },
            { "timezone.excity.Australia/Darwin", "डार्विन" },
            { "timezone.excity.Australia/Hobart", "होभार्ट" },
            { "timezone.excity.Australia/Sydney", "सिड्नी" },
            { "timezone.excity.Europe/Amsterdam", "एम्स्ट्र्डम" },
            { "timezone.excity.Europe/Astrakhan", "अस्त्रखान" },
            { "timezone.excity.Europe/Bucharest", "वुचारेस्ट" },
            { "timezone.excity.Europe/Gibraltar", "जिब्राल्टार" },
            { "timezone.excity.Europe/Ljubljana", "लजुबिजाना" },
            { "timezone.excity.Europe/Mariehamn", "म्यारिह्याम्न" },
            { "timezone.excity.Europe/Podgorica", "पड्गोरिका" },
            { "timezone.excity.Europe/Stockholm", "स्टकहोल्म" },
            { "timezone.excity.Europe/Ulyanovsk", "उल्यानोभ्स्क" },
            { "timezone.excity.Europe/Volgograd", "भोल्गोग्राद" },
            { "timezone.excity.Indian/Christmas", "ख्रिस्टमस" },
            { "timezone.excity.Indian/Kerguelen", "केर्गुएलेन" },
            { "timezone.excity.Indian/Mauritius", "मउरिटिअस" },
            { "timezone.excity.Pacific/Auckland", "अकल्यान्ड" },
            { "timezone.excity.Pacific/Funafuti", "फुनाफुति" },
            { "timezone.excity.Pacific/Honolulu", "होनोलुलु" },
            { "timezone.excity.Pacific/Pitcairn", "पितकाईरन" },
            { "timezone.excity.Africa/Casablanca", "कासाब्लान्का" },
            { "timezone.excity.Africa/Libreville", "लिब्रेभिल्ले" },
            { "timezone.excity.Africa/Lubumbashi", "लुबुम्बासी" },
            { "timezone.excity.Africa/Nouakchott", "नोउआकचोट" },
            { "timezone.excity.Africa/Porto-Novo", "पोर्टो-नोभो" },
            { "timezone.excity.America/Anchorage", "एङ्कोरेज" },
            { "timezone.excity.America/Araguaina", "आरागुवाना" },
            { "timezone.excity.America/Boa_Vista", "बोआ भिष्टा" },
            { "timezone.excity.America/Catamarca", "कातामार्का" },
            { "timezone.excity.America/Chihuahua", "चिहुवाहुवा" },
            { "timezone.excity.America/Fortaleza", "फोर्टालेजा" },
            { "timezone.excity.America/Glace_Bay", "ग्लेस बे" },
            { "timezone.excity.America/Goose_Bay", "गुज बे" },
            { "timezone.excity.America/Guatemala", "ग्वाटेमाला" },
            { "timezone.excity.America/Guayaquil", "गुयाक्विल" },
            { "timezone.excity.America/Matamoros", "माट्तामोरोस्" },
            { "timezone.excity.America/Menominee", "मेनोमिनी" },
            { "timezone.excity.America/Monterrey", "मोन्टेर्रे" },
            { "timezone.excity.America/Sao_Paulo", "साओ पाउलो" },
            { "timezone.excity.America/St_Thomas", "सेन्ट थोमस" },
            { "timezone.excity.America/Vancouver", "भ्यानकोभर" },
            { "timezone.excity.Antarctica/Mawson", "माउसन" },
            { "timezone.excity.Antarctica/Palmer", "पाल्मेर" },
            { "timezone.excity.Antarctica/Vostok", "भास्टोक" },
            { "timezone.excity.Asia/Kuala_Lumpur", "कुआ लाम्पुर" },
            { "timezone.excity.Asia/Novokuznetsk", "नेभोकुजनेस्क" },
            { "timezone.excity.Europe/Bratislava", "ब्राटिस्लाभा" },
            { "timezone.excity.Europe/Copenhagen", "कोपेनह्यागन" },
            { "timezone.excity.Europe/Luxembourg", "लक्जेम्वर्ग" },
            { "timezone.excity.Europe/San_Marino", "सान मारिनो" },
            { "timezone.excity.Europe/Simferopol", "सिम्फेरोपोल" },
            { "timezone.excity.Pacific/Enderbury", "एन्डरबरी" },
            { "timezone.excity.Pacific/Galapagos", "गलापागोस" },
            { "timezone.excity.Pacific/Kwajalein", "क्वाजालेइन" },
            { "timezone.excity.Pacific/Marquesas", "मार्केसास" },
            { "timezone.excity.Pacific/Pago_Pago", "पागो पागो" },
            { "timezone.excity.Pacific/Rarotonga", "राओतोंगा" },
            { "timezone.excity.Pacific/Tongatapu", "टंगातपु" },
            { "timezone.excity.Africa/Addis_Ababa", "एड्डिस आबाबा" },
            { "timezone.excity.Africa/Brazzaville", "ब्राजाभिल्ले" },
            { "timezone.excity.Africa/Ouagadougou", "औआगाडौगौ" },
            { "timezone.excity.America/Costa_Rica", "कोष्टा रिका" },
            { "timezone.excity.America/Grand_Turk", "ग्रान्ड टर्क" },
            { "timezone.excity.America/Guadeloupe", "ग्वाडेलुप" },
            { "timezone.excity.America/Hermosillo", "हेर्मोसिल्लो" },
            { "timezone.excity.America/Kralendijk", "कालेन्देजिक" },
            { "timezone.excity.America/Louisville", "लुइसभिल्ले" },
            { "timezone.excity.America/Martinique", "मार्टिनिक" },
            { "timezone.excity.America/Metlakatla", "मेट्लाक्टला" },
            { "timezone.excity.America/Montevideo", "मोन्टेभिडियो" },
            { "timezone.excity.America/Montserrat", "मन्टसेर्राट" },
            { "timezone.excity.America/Paramaribo", "पारामारिवो" },
            { "timezone.excity.America/Rio_Branco", "रियो ब्रान्को" },
            { "timezone.excity.America/St_Vincent", "सेन्ट भिन्सेन्ट" },
            { "timezone.excity.America/Whitehorse", "ह्वाइटहर्स" },
            { "timezone.excity.Antarctica/McMurdo", "माकमुर्डो" },
            { "timezone.excity.Antarctica/Rothera", "रोथेरा" },
            { "timezone.excity.Asia/Srednekolymsk", "स्रेद्निकोलिम्स्क" },
            { "timezone.excity.Asia/Yekaterinburg", "एकटरिनबुर्ग" },
            { "timezone.excity.Atlantic/Reykjavik", "रेक्जाभिक" },
            { "timezone.excity.Atlantic/St_Helena", "सेन्ट हेलेना" },
            { "timezone.excity.Australia/Adelaide", "एडेलेड" },
            { "timezone.excity.Australia/Brisbane", "ब्रिस्बेन" },
            { "timezone.excity.Australia/Lindeman", "लिन्डेम्यान" },
            { "timezone.excity.Europe/Isle_of_Man", "इजल अफ् म्यान" },
            { "timezone.excity.Europe/Kaliningrad", "कालिनिनग्राद" },
            { "timezone.excity.Pacific/Kiritimati", "किरितिमाटी" },
            { "timezone.excity.Africa/Johannesburg", "जोहानेसवर्ग" },
            { "timezone.excity.America/El_Salvador", "एल् साल्भाडोर" },
            { "timezone.excity.America/Fort_Nelson", "फोर्ट नेल्सन" },
            { "timezone.excity.America/Los_Angeles", "लस् एन्जेलस" },
            { "timezone.excity.America/Mexico_City", "मेक्सिको सिटी" },
            { "timezone.excity.America/Porto_Velho", "पोर्टो भेल्हो" },
            { "timezone.excity.America/Puerto_Rico", "प्युर्टो रिको" },
            { "timezone.excity.America/Tegucigalpa", "टेगुसिगाल्पा" },
            { "timezone.excity.Arctic/Longyearbyen", "लङयिअरबाइएन" },
            { "timezone.excity.Atlantic/Cape_Verde", "केप भर्डे" },
            { "timezone.excity.Australia/Lord_Howe", "लर्ड होवे" },
            { "timezone.excity.Australia/Melbourne", "मेल्बर्न" },
            { "timezone.excity.Indian/Antananarivo", "अन्टानारिभो" },
            { "timezone.excity.Pacific/Guadalcanal", "गुअडालकनाल" },
            { "timezone.excity.Africa/Dar_es_Salaam", "डार एस् सलाम" },
            { "timezone.excity.America/Blanc-Sablon", "ब्लान्क-साब्लोन" },
            { "timezone.excity.America/Buenos_Aires", "ब्यनेश आयर्स" },
            { "timezone.excity.America/Campo_Grande", "क्याम्पो ग्रान्डे" },
            { "timezone.excity.America/Danmarkshavn", "डान्मार्कशाभन" },
            { "timezone.excity.America/Dawson_Creek", "डसन क्रिक" },
            { "timezone.excity.America/Indiana/Knox", "नोक्स इन्डियाना" },
            { "timezone.excity.America/Indianapolis", "इन्डियानापोलिस" },
            { "timezone.excity.America/Punta_Arenas", "पुन्टा अरिनाज" },
            { "timezone.excity.America/Rankin_Inlet", "रान्किन इन्लेट" },
            { "timezone.excity.America/Scoresbysund", "ईट्टोक्कोरटूर्मिट" },
            { "timezone.excity.Antarctica/Macquarie", "मक्वारिई" },
            { "timezone.excity.Pacific/Bougainville", "बुगेनभिल्ले" },
            { "timezone.excity.Pacific/Port_Moresby", "पोर्ट मोरेस्बी" },
            { "timezone.excity.America/Cambridge_Bay", "क्याम्ब्रिज बे" },
            { "timezone.excity.America/Ciudad_Juarez", "जुआरेज सहर" },
            { "timezone.excity.America/Coral_Harbour", "एटिकोकान" },
            { "timezone.excity.America/Indiana/Vevay", "भेभे, इन्डियाना" },
            { "timezone.excity.America/Lower_Princes", "लोअर प्रिन्स्स क्वार्टर" },
            { "timezone.excity.America/Port_of_Spain", "पोर्ट अफ् स्पेन" },
            { "timezone.excity.America/Santo_Domingo", "सान्टो डोमिङ्गो" },
            { "timezone.excity.America/St_Barthelemy", "सेन्ट बार्थेलेमी" },
            { "timezone.excity.America/Swift_Current", "स्विफ्ट करेन्ट" },
            { "timezone.excity.Australia/Broken_Hill", "ब्रोकन हिल" },
            { "timezone.excity.America/Bahia_Banderas", "बाहिया बान्डेराश" },
            { "timezone.excity.America/Port-au-Prince", "पोर्ट-अउ-प्रिन्स" },
            { "timezone.excity.Atlantic/South_Georgia", "दक्षिण जर्जिया" },
            { "timezone.excity.America/Argentina/Salta", "साल्टा" },
            { "timezone.excity.America/Indiana/Marengo", "मारेन्गो, इन्डियाना" },
            { "timezone.excity.America/Indiana/Winamac", "विनामाक, इन्डियाना" },
            { "timezone.excity.America/Argentina/Tucuman", "टुकुमान" },
            { "timezone.excity.America/Argentina/Ushuaia", "उशुआइआ" },
            { "timezone.excity.America/Indiana/Tell_City", "टेल सिटी, इन्डियाना" },
            { "timezone.excity.America/Indiana/Vincennes", "भिन्सेन्स" },
            { "timezone.excity.Antarctica/DumontDUrville", "दुमोन्ट डि उर्भेल्ले" },
            { "timezone.excity.America/Argentina/La_Rioja", "ला रियोजा" },
            { "timezone.excity.America/Argentina/San_Juan", "सान जुवान" },
            { "timezone.excity.America/Argentina/San_Luis", "सान लुइस" },
            { "timezone.excity.America/Indiana/Petersburg", "पिटर्सबर्ग, इन्डियाना" },
            { "timezone.excity.America/Kentucky/Monticello", "मोन्टिसेल्लो,केन्टकी" },
            { "timezone.excity.America/North_Dakota/Beulah", "बेउला, उत्तर डाकोटा" },
            { "timezone.excity.America/North_Dakota/Center", "उत्तर डाकोटा, केन्द्र" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "रियो ग्यालेगोस" },
            { "timezone.excity.America/North_Dakota/New_Salem", "नयाँ सालेम, उत्तर डाकोटा" },
        };
        return data;
    }
}
