/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ja extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_zbl = "ブリスシンボル";
        final String metaValue_ssy = "サホ語";
        final Object[][] data = new Object[][] {
            { "001", "世界" },
            { "002", "アフリカ" },
            { "003", "北アメリカ大陸" },
            { "005", "南アメリカ" },
            { "009", "オセアニア" },
            { "011", "西アフリカ" },
            { "013", "中央アメリカ" },
            { "014", "東アフリカ" },
            { "015", "北アフリカ" },
            { "017", "中部アフリカ" },
            { "018", "南部アフリカ" },
            { "019", "アメリカ大陸" },
            { "021", "北アメリカ" },
            { "029", "カリブ" },
            { "030", "東アジア" },
            { "034", "南アジア" },
            { "035", "東南アジア" },
            { "039", "南ヨーロッパ" },
            { "053", "オーストララシア" },
            { "054", "メラネシア" },
            { "057", "ミクロネシア" },
            { "061", "ポリネシア" },
            { "142", "アジア" },
            { "143", "中央アジア" },
            { "145", "西アジア" },
            { "150", "ヨーロッパ" },
            { "151", "東ヨーロッパ" },
            { "154", "北ヨーロッパ" },
            { "155", "西ヨーロッパ" },
            { "202", "サブサハラアフリカ" },
            { "419", "ラテンアメリカ" },
            { "AC", "アセンション島" },
            { "AD", "アンドラ" },
            { "AE", "アラブ首長国連邦" },
            { "AF", "アフガニスタン" },
            { "AG", "アンティグア・バーブーダ" },
            { "AI", "アンギラ" },
            { "AL", "アルバニア" },
            { "AM", "アルメニア" },
            { "AO", "アンゴラ" },
            { "AQ", "南極" },
            { "AR", "アルゼンチン" },
            { "AS", "米領サモア" },
            { "AT", "オーストリア" },
            { "AU", "オーストラリア" },
            { "AW", "アルバ" },
            { "AX", "オーランド諸島" },
            { "AZ", "アゼルバイジャン" },
            { "BA", "ボスニア・ヘルツェゴビナ" },
            { "BB", "バルバドス" },
            { "BD", "バングラデシュ" },
            { "BE", "ベルギー" },
            { "BF", "ブルキナファソ" },
            { "BG", "ブルガリア" },
            { "BH", "バーレーン" },
            { "BI", "ブルンジ" },
            { "BJ", "ベナン" },
            { "BL", "サン・バルテルミー" },
            { "BM", "バミューダ" },
            { "BN", "ブルネイ" },
            { "BO", "ボリビア" },
            { "BQ", "オランダ領カリブ" },
            { "BR", "ブラジル" },
            { "BS", "バハマ" },
            { "BT", "ブータン" },
            { "BV", "ブーベ島" },
            { "BW", "ボツワナ" },
            { "BY", "ベラルーシ" },
            { "BZ", "ベリーズ" },
            { "CA", "カナダ" },
            { "CC", "ココス(キーリング)諸島" },
            { "CD", "コンゴ民主共和国(キンシャサ)" },
            { "CF", "中央アフリカ共和国" },
            { "CG", "コンゴ共和国(ブラザビル)" },
            { "CH", "スイス" },
            { "CI", "コートジボワール" },
            { "CK", "クック諸島" },
            { "CL", "チリ" },
            { "CM", "カメルーン" },
            { "CN", "中国" },
            { "CO", "コロンビア" },
            { "CP", "クリッパートン島" },
            { "CR", "コスタリカ" },
            { "CU", "キューバ" },
            { "CV", "カーボベルデ" },
            { "CW", "キュラソー" },
            { "CX", "クリスマス島" },
            { "CY", "キプロス" },
            { "CZ", "チェコ" },
            { "DE", "ドイツ" },
            { "DG", "ディエゴガルシア島" },
            { "DJ", "ジブチ" },
            { "DK", "デンマーク" },
            { "DM", "ドミニカ国" },
            { "DO", "ドミニカ共和国" },
            { "DZ", "アルジェリア" },
            { "EA", "セウタ・メリリャ" },
            { "EC", "エクアドル" },
            { "EE", "エストニア" },
            { "EG", "エジプト" },
            { "EH", "西サハラ" },
            { "ER", "エリトリア" },
            { "ES", "スペイン" },
            { "ET", "エチオピア" },
            { "EU", "欧州連合" },
            { "EZ", "ユーロ圏" },
            { "FI", "フィンランド" },
            { "FJ", "フィジー" },
            { "FK", "フォークランド諸島" },
            { "FM", "ミクロネシア連邦" },
            { "FO", "フェロー諸島" },
            { "FR", "フランス" },
            { "GA", "ガボン" },
            { "GB", "イギリス" },
            { "GD", "グレナダ" },
            { "GE", "ジョージア" },
            { "GF", "仏領ギアナ" },
            { "GG", "ガーンジー" },
            { "GH", "ガーナ" },
            { "GI", "ジブラルタル" },
            { "GL", "グリーンランド" },
            { "GM", "ガンビア" },
            { "GN", "ギニア" },
            { "GP", "グアドループ" },
            { "GQ", "赤道ギニア" },
            { "GR", "ギリシャ" },
            { "GS", "サウスジョージア・サウスサンドウィッチ諸島" },
            { "GT", "グアテマラ" },
            { "GU", "グアム" },
            { "GW", "ギニアビサウ" },
            { "GY", "ガイアナ" },
            { "HK", "中華人民共和国香港特別行政区" },
            { "HM", "ハード島・マクドナルド諸島" },
            { "HN", "ホンジュラス" },
            { "HR", "クロアチア" },
            { "HT", "ハイチ" },
            { "HU", "ハンガリー" },
            { "IC", "カナリア諸島" },
            { "ID", "インドネシア" },
            { "IE", "アイルランド" },
            { "IL", "イスラエル" },
            { "IM", "マン島" },
            { "IN", "インド" },
            { "IO", "英領インド洋地域" },
            { "IQ", "イラク" },
            { "IR", "イラン" },
            { "IS", "アイスランド" },
            { "IT", "イタリア" },
            { "JE", "ジャージー" },
            { "JM", "ジャマイカ" },
            { "JO", "ヨルダン" },
            { "JP", "日本" },
            { "KE", "ケニア" },
            { "KG", "キルギス" },
            { "KH", "カンボジア" },
            { "KI", "キリバス" },
            { "KM", "コモロ" },
            { "KN", "セントクリストファー・ネーヴィス" },
            { "KP", "北朝鮮" },
            { "KR", "韓国" },
            { "KW", "クウェート" },
            { "KY", "ケイマン諸島" },
            { "KZ", "カザフスタン" },
            { "LA", "ラオス" },
            { "LB", "レバノン" },
            { "LC", "セントルシア" },
            { "LI", "リヒテンシュタイン" },
            { "LK", "スリランカ" },
            { "LR", "リベリア" },
            { "LS", "レソト" },
            { "LT", "リトアニア" },
            { "LU", "ルクセンブルク" },
            { "LV", "ラトビア" },
            { "LY", "リビア" },
            { "MA", "モロッコ" },
            { "MC", "モナコ" },
            { "MD", "モルドバ" },
            { "ME", "モンテネグロ" },
            { "MF", "サン・マルタン" },
            { "MG", "マダガスカル" },
            { "MH", "マーシャル諸島" },
            { "MK", "北マケドニア" },
            { "ML", "マリ" },
            { "MM", "ミャンマー (ビルマ)" },
            { "MN", "モンゴル" },
            { "MO", "中華人民共和国マカオ特別行政区" },
            { "MP", "北マリアナ諸島" },
            { "MQ", "マルティニーク" },
            { "MR", "モーリタニア" },
            { "MS", "モントセラト" },
            { "MT", "マルタ" },
            { "MU", "モーリシャス" },
            { "MV", "モルディブ" },
            { "MW", "マラウイ" },
            { "MX", "メキシコ" },
            { "MY", "マレーシア" },
            { "MZ", "モザンビーク" },
            { "NA", "ナミビア" },
            { "NC", "ニューカレドニア" },
            { "NE", "ニジェール" },
            { "NF", "ノーフォーク島" },
            { "NG", "ナイジェリア" },
            { "NI", "ニカラグア" },
            { "NL", "オランダ" },
            { "NO", "ノルウェー" },
            { "NP", "ネパール" },
            { "NR", "ナウル" },
            { "NU", "ニウエ" },
            { "NZ", "ニュージーランド" },
            { "OM", "オマーン" },
            { "PA", "パナマ" },
            { "PE", "ペルー" },
            { "PF", "仏領ポリネシア" },
            { "PG", "パプアニューギニア" },
            { "PH", "フィリピン" },
            { "PK", "パキスタン" },
            { "PL", "ポーランド" },
            { "PM", "サンピエール島・ミクロン島" },
            { "PN", "ピトケアン諸島" },
            { "PR", "プエルトリコ" },
            { "PS", "パレスチナ自治区" },
            { "PT", "ポルトガル" },
            { "PW", "パラオ" },
            { "PY", "パラグアイ" },
            { "QA", "カタール" },
            { "QO", "オセアニア周辺地域" },
            { "RE", "レユニオン" },
            { "RO", "ルーマニア" },
            { "RS", "セルビア" },
            { "RU", "ロシア" },
            { "RW", "ルワンダ" },
            { "SA", "サウジアラビア" },
            { "SB", "ソロモン諸島" },
            { "SC", "セーシェル" },
            { "SD", "スーダン" },
            { "SE", "スウェーデン" },
            { "SG", "シンガポール" },
            { "SH", "セントヘレナ" },
            { "SI", "スロベニア" },
            { "SJ", "スバールバル諸島・ヤンマイエン島" },
            { "SK", "スロバキア" },
            { "SL", "シエラレオネ" },
            { "SM", "サンマリノ" },
            { "SN", "セネガル" },
            { "SO", "ソマリア" },
            { "SR", "スリナム" },
            { "SS", "南スーダン" },
            { "ST", "サントメ・プリンシペ" },
            { "SV", "エルサルバドル" },
            { "SX", "シント・マールテン" },
            { "SY", "シリア" },
            { "SZ", "エスワティニ" },
            { "TA", "トリスタン・ダ・クーニャ" },
            { "TC", "タークス・カイコス諸島" },
            { "TD", "チャド" },
            { "TF", "仏領極南諸島" },
            { "TG", "トーゴ" },
            { "TH", "タイ" },
            { "TJ", "タジキスタン" },
            { "TK", "トケラウ" },
            { "TL", "東ティモール" },
            { "TM", "トルクメニスタン" },
            { "TN", "チュニジア" },
            { "TO", "トンガ" },
            { "TR", "トルコ" },
            { "TT", "トリニダード・トバゴ" },
            { "TV", "ツバル" },
            { "TW", "台湾" },
            { "TZ", "タンザニア" },
            { "UA", "ウクライナ" },
            { "UG", "ウガンダ" },
            { "UM", "合衆国領有小離島" },
            { "UN", "国際連合" },
            { "US", "アメリカ合衆国" },
            { "UY", "ウルグアイ" },
            { "UZ", "ウズベキスタン" },
            { "VA", "バチカン市国" },
            { "VC", "セントビンセント及びグレナディーン諸島" },
            { "VE", "ベネズエラ" },
            { "VG", "英領ヴァージン諸島" },
            { "VI", "米領ヴァージン諸島" },
            { "VN", "ベトナム" },
            { "VU", "バヌアツ" },
            { "WF", "ウォリス・フツナ" },
            { "WS", "サモア" },
            { "XA", "疑似アクセント" },
            { "XB", "疑似 BIDI" },
            { "XK", "コソボ" },
            { "YE", "イエメン" },
            { "YT", "マヨット" },
            { "ZA", "南アフリカ" },
            { "ZM", "ザンビア" },
            { "ZW", "ジンバブエ" },
            { "ZZ", "不明な地域" },
            { "aa", "アファル語" },
            { "ab", "アブハズ語" },
            { "ae", "アヴェスタ語" },
            { "af", "アフリカーンス語" },
            { "ak", "アカン語" },
            { "am", "アムハラ語" },
            { "an", "アラゴン語" },
            { "ar", "アラビア語" },
            { "as", "アッサム語" },
            { "av", "アヴァル語" },
            { "ay", "アイマラ語" },
            { "az", "アゼルバイジャン語" },
            { "ba", "バシキール語" },
            { "be", "ベラルーシ語" },
            { "bg", "ブルガリア語" },
            { "bi", "ビスラマ語" },
            { "bm", "バンバラ語" },
            { "bn", "ベンガル語" },
            { "bo", "チベット語" },
            { "br", "ブルトン語" },
            { "bs", "ボスニア語" },
            { "ca", "カタロニア語" },
            { "ce", "チェチェン語" },
            { "ch", "チャモロ語" },
            { "co", "コルシカ語" },
            { "cr", "クリー語" },
            { "cs", "チェコ語" },
            { "cu", "教会スラブ語" },
            { "cv", "チュヴァシ語" },
            { "cy", "ウェールズ語" },
            { "da", "デンマーク語" },
            { "de", "ドイツ語" },
            { "dv", "ディベヒ語" },
            { "dz", "ゾンカ語" },
            { "ee", "エウェ語" },
            { "el", "ギリシャ語" },
            { "en", "英語" },
            { "eo", "エスペラント語" },
            { "es", "スペイン語" },
            { "et", "エストニア語" },
            { "eu", "バスク語" },
            { "fa", "ペルシア語" },
            { "ff", "フラ語" },
            { "fi", "フィンランド語" },
            { "fj", "フィジー語" },
            { "fo", "フェロー語" },
            { "fr", "フランス語" },
            { "fy", "西フリジア語" },
            { "ga", "アイルランド語" },
            { "gd", "スコットランド・ゲール語" },
            { "gl", "ガリシア語" },
            { "gn", "グアラニー語" },
            { "gu", "グジャラート語" },
            { "gv", "マン島語" },
            { "ha", "ハウサ語" },
            { "he", "ヘブライ語" },
            { "hi", "ヒンディー語" },
            { "ho", "ヒリモツ語" },
            { "hr", "クロアチア語" },
            { "ht", "ハイチ・クレオール語" },
            { "hu", "ハンガリー語" },
            { "hy", "アルメニア語" },
            { "hz", "ヘレロ語" },
            { "ia", "インターリングア" },
            { "id", "インドネシア語" },
            { "ie", "インターリング" },
            { "ig", "イボ語" },
            { "ii", "四川イ語" },
            { "ik", "イヌピアック語" },
            { "io", "イド語" },
            { "is", "アイスランド語" },
            { "it", "イタリア語" },
            { "iu", "イヌクティトット語" },
            { "ja", "日本語" },
            { "jv", "ジャワ語" },
            { "ka", "ジョージア語" },
            { "kg", "コンゴ語" },
            { "ki", "キクユ語" },
            { "kj", "クワニャマ語" },
            { "kk", "カザフ語" },
            { "kl", "グリーンランド語" },
            { "km", "クメール語" },
            { "kn", "カンナダ語" },
            { "ko", "韓国語" },
            { "kr", "カヌリ語" },
            { "ks", "カシミール語" },
            { "ku", "クルド語" },
            { "kv", "コミ語" },
            { "kw", "コーンウォール語" },
            { "ky", "キルギス語" },
            { "la", "ラテン語" },
            { "lb", "ルクセンブルク語" },
            { "lg", "ガンダ語" },
            { "li", "リンブルフ語" },
            { "ln", "リンガラ語" },
            { "lo", "ラオ語" },
            { "lt", "リトアニア語" },
            { "lu", "ルバ・カタンガ語" },
            { "lv", "ラトビア語" },
            { "mg", "マダガスカル語" },
            { "mh", "マーシャル語" },
            { "mi", "マオリ語" },
            { "mk", "マケドニア語" },
            { "ml", "マラヤーラム語" },
            { "mn", "モンゴル語" },
            { "mr", "マラーティー語" },
            { "ms", "マレー語" },
            { "mt", "マルタ語" },
            { "my", "ミャンマー語" },
            { "na", "ナウル語" },
            { "nb", "ノルウェー語(ブークモール)" },
            { "nd", "北ンデベレ語" },
            { "ne", "ネパール語" },
            { "ng", "ンドンガ語" },
            { "nl", "オランダ語" },
            { "nn", "ノルウェー語(ニーノシュク)" },
            { "no", "ノルウェー語" },
            { "nr", "南ンデベレ語" },
            { "nv", "ナバホ語" },
            { "ny", "ニャンジャ語" },
            { "oc", "オック語" },
            { "oj", "オジブウェー語" },
            { "om", "オロモ語" },
            { "or", "オディア語" },
            { "os", "オセット語" },
            { "pa", "パンジャブ語" },
            { "pi", "パーリ語" },
            { "pl", "ポーランド語" },
            { "ps", "パシュトゥー語" },
            { "pt", "ポルトガル語" },
            { "qu", "ケチュア語" },
            { "rm", "ロマンシュ語" },
            { "rn", "ルンディ語" },
            { "ro", "ルーマニア語" },
            { "ru", "ロシア語" },
            { "rw", "キニアルワンダ語" },
            { "sa", "サンスクリット語" },
            { "sc", "サルデーニャ語" },
            { "sd", "シンド語" },
            { "se", "北サーミ語" },
            { "sg", "サンゴ語" },
            { "sh", "セルボ・クロアチア語" },
            { "si", "シンハラ語" },
            { "sk", "スロバキア語" },
            { "sl", "スロベニア語" },
            { "sm", "サモア語" },
            { "sn", "ショナ語" },
            { "so", "ソマリ語" },
            { "sq", "アルバニア語" },
            { "sr", "セルビア語" },
            { "ss", "スワジ語" },
            { "st", "南部ソト語" },
            { "su", "スンダ語" },
            { "sv", "スウェーデン語" },
            { "sw", "スワヒリ語" },
            { "ta", "タミル語" },
            { "te", "テルグ語" },
            { "tg", "タジク語" },
            { "th", "タイ語" },
            { "ti", "ティグリニア語" },
            { "tk", "トルクメン語" },
            { "tl", "タガログ語" },
            { "tn", "ツワナ語" },
            { "to", "トンガ語" },
            { "tr", "トルコ語" },
            { "ts", "ツォンガ語" },
            { "tt", "タタール語" },
            { "tw", "トウィ語" },
            { "ty", "タヒチ語" },
            { "ug", "ウイグル語" },
            { "uk", "ウクライナ語" },
            { "ur", "ウルドゥー語" },
            { "uz", "ウズベク語" },
            { "ve", "ベンダ語" },
            { "vi", "ベトナム語" },
            { "vo", "ヴォラピュク語" },
            { "wa", "ワロン語" },
            { "wo", "ウォロフ語" },
            { "xh", "コサ語" },
            { "yi", "イディッシュ語" },
            { "yo", "ヨルバ語" },
            { "za", "チワン語" },
            { "zh", "中国語" },
            { "zu", "ズールー語" },
            { "ace", "アチェ語" },
            { "ach", "アチョリ語" },
            { "ada", "アダングメ語" },
            { "ady", "アディゲ語" },
            { "aeb", "チュニジア・アラビア語" },
            { "afh", "アフリヒリ語" },
            { "agq", "アゲム語" },
            { "ain", "アイヌ語" },
            { "akk", "アッカド語" },
            { "akz", "アラバマ語" },
            { "ale", "アレウト語" },
            { "aln", "ゲグ・アルバニア語" },
            { "alt", "南アルタイ語" },
            { "ang", "古英語" },
            { "ann", "オボロ語" },
            { "anp", "アンギカ語" },
            { "arc", "アラム語" },
            { "arn", "マプチェ語" },
            { "aro", "アラオナ語" },
            { "arp", "アラパホー語" },
            { "arq", "アルジェリア・アラビア語" },
            { "ars", "ナジュド地方・アラビア語" },
            { "arw", "アラワク語" },
            { "ary", "モロッコ・アラビア語" },
            { "arz", "エジプト・アラビア語" },
            { "asa", "アス語" },
            { "ase", "アメリカ手話" },
            { "ast", "アストゥリアス語" },
            { "atj", "アティカメク語" },
            { "avk", "コタヴァ" },
            { "awa", "アワディー語" },
            { "bal", "バルーチー語" },
            { "ban", "バリ語" },
            { "bar", "バイエルン・オーストリア語" },
            { "bas", "バサ語" },
            { "bax", "バムン語" },
            { "bbc", "トバ・バタク語" },
            { "bbj", "ゴーマラ語" },
            { "bej", "ベジャ語" },
            { "bem", "ベンバ語" },
            { "bew", "ベタウィ語" },
            { "bez", "ベナ語" },
            { "bfd", "バフット語" },
            { "bfq", "バダガ語" },
            { "bgc", "ハリヤーンウィー語" },
            { "bgn", "西バローチー語" },
            { "bho", "ボージュプリー語" },
            { "bik", "ビコル語" },
            { "bin", "ビニ語" },
            { "bjn", "バンジャル語" },
            { "bkm", "コム語" },
            { "bla", "シクシカ語" },
            { "blo", "アニ語 (blo)" },
            { "bpy", "ビシュヌプリヤ・マニプリ語" },
            { "bqi", "バフティヤーリー語" },
            { "bra", "ブラジ語" },
            { "brh", "ブラフイ語" },
            { "brx", "ボド語" },
            { "bss", "アコース語" },
            { "bua", "ブリヤート語" },
            { "bug", "ブギ語" },
            { "bum", "ブル語" },
            { "byn", "ビリン語" },
            { "byv", "メドゥンバ語" },
            { "cad", "カドー語" },
            { "car", "カリブ語" },
            { "cay", "カユーガ語" },
            { "cch", "チャワイ語" },
            { "ccp", "チャクマ語" },
            { "ceb", "セブアノ語" },
            { "cgg", "チガ語" },
            { "chb", "チブチャ語" },
            { "chg", "チャガタイ語" },
            { "chk", "チューク語" },
            { "chm", "マリ語" },
            { "chn", "チヌーク混成語" },
            { "cho", "チョクトー語" },
            { "chp", "チペワイアン語" },
            { "chr", "チェロキー語" },
            { "chy", "シャイアン語" },
            { "ckb", "中央クルド語" },
            { "clc", "チルコーティン語" },
            { "cop", "コプト語" },
            { "cps", "カピス語" },
            { "crg", "ミチフ語" },
            { "crh", "クリミア・タタール語" },
            { "crj", "東部クリー語(南部)" },
            { "crk", "平原クリー語" },
            { "crl", "東部クリー語(北部)" },
            { "crm", "ムースクリー語" },
            { "crr", "カロライナ・アルゴンキン語" },
            { "crs", "セーシェル・クレオール語" },
            { "csb", "カシューブ語" },
            { "csw", "湿原クリー語" },
            { "dak", "ダコタ語" },
            { "dar", "ダルグワ語" },
            { "dav", "タイタ語" },
            { "del", "デラウェア語" },
            { "den", "スレイビー語" },
            { "dgr", "ドグリブ語" },
            { "din", "ディンカ語" },
            { "dje", "ザルマ語" },
            { "doi", "ドーグリー語" },
            { "dsb", "低地ソルブ語" },
            { "dtp", "中央ドゥスン語" },
            { "dua", "ドゥアラ語" },
            { "dum", "中世オランダ語" },
            { "dyo", "ジョラ＝フォニィ語" },
            { "dyu", "ジュラ語" },
            { "dzg", "ダザガ語" },
            { "ebu", "エンブ語" },
            { "efi", "エフィク語" },
            { "egl", "エミリア語" },
            { "egy", "古代エジプト語" },
            { "eka", "エカジュク語" },
            { "elx", "エラム語" },
            { "enm", "中英語" },
            { "esu", "中央アラスカ・ユピック語" },
            { "ewo", "エウォンド語" },
            { "ext", "エストレマドゥーラ語" },
            { "fan", "ファング語" },
            { "fat", "ファンティー語" },
            { "fil", "フィリピノ語" },
            { "fit", "トルネダール・フィンランド語" },
            { "fon", "フォン語" },
            { "frc", "ケイジャン・フランス語" },
            { "frm", "中期フランス語" },
            { "fro", "古フランス語" },
            { "frp", "アルピタン語" },
            { "frr", "北フリジア語" },
            { "frs", "東フリジア語" },
            { "fur", "フリウリ語" },
            { "gaa", "ガ語" },
            { "gag", "ガガウズ語" },
            { "gan", "贛語" },
            { "gay", "ガヨ語" },
            { "gba", "バヤ語" },
            { "gbz", "ダリー語(ゾロアスター教)" },
            { "gez", "ゲエズ語" },
            { "gil", "キリバス語" },
            { "glk", "ギラキ語" },
            { "gmh", "中高ドイツ語" },
            { "goh", "古高ドイツ語" },
            { "gon", "ゴーンディー語" },
            { "gor", "ゴロンタロ語" },
            { "got", "ゴート語" },
            { "grb", "グレボ語" },
            { "grc", "古代ギリシャ語" },
            { "gsw", "スイスドイツ語" },
            { "guc", "ワユ語" },
            { "gur", "フラフラ語" },
            { "guz", "グシイ語" },
            { "gwi", "グウィッチン語" },
            { "hai", "ハイダ語" },
            { "hak", "客家語" },
            { "haw", "ハワイ語" },
            { "hax", "南部ハイダ語" },
            { "hif", "フィジー・ヒンディー語" },
            { "hil", "ヒリガイノン語" },
            { "hit", "ヒッタイト語" },
            { "hmn", "フモン語" },
            { "hsb", "高地ソルブ語" },
            { "hsn", "湘語" },
            { "hup", "フパ語" },
            { "hur", "ハルコメレム語" },
            { "iba", "イバン語" },
            { "ibb", "イビビオ語" },
            { "ikt", "イヌイナクトゥン語" },
            { "ilo", "イロカノ語" },
            { "inh", "イングーシ語" },
            { "izh", "イングリア語" },
            { "jam", "ジャマイカ・クレオール語" },
            { "jbo", "ロジバン語" },
            { "jgo", "ンゴンバ語" },
            { "jmc", "マチャメ語" },
            { "jpr", "ユダヤ・ペルシア語" },
            { "jrb", "ユダヤ・アラビア語" },
            { "jut", "ユトランド語" },
            { "kaa", "カラカルパク語" },
            { "kab", "カビル語" },
            { "kac", "カチン語" },
            { "kaj", "カジェ語" },
            { "kam", "カンバ語" },
            { "kaw", "カウィ語" },
            { "kbd", "カバルド語" },
            { "kbl", "カネンブ語" },
            { "kcg", "カタブ語" },
            { "kde", "マコンデ語" },
            { "kea", "カーボベルデ・クレオール語" },
            { "ken", "ニャン語" },
            { "kfo", "コロ語" },
            { "kgp", "カインガング語" },
            { "kha", "カシ語" },
            { "kho", "コータン語" },
            { "khq", "コイラ・チーニ語" },
            { "khw", "コワール語" },
            { "kiu", "キルマンジュキ語" },
            { "kkj", "カコ語" },
            { "kln", "カレンジン語" },
            { "kmb", "キンブンド語" },
            { "koi", "コミ・ペルミャク語" },
            { "kok", "コンカニ語" },
            { "kos", "コスラエ語" },
            { "kpe", "クペレ語" },
            { "krc", "カラチャイ・バルカル語" },
            { "kri", "クリオ語" },
            { "krj", "キナライア語" },
            { "krl", "カレリア語" },
            { "kru", "クルク語" },
            { "ksb", "サンバー語" },
            { "ksf", "バフィア語" },
            { "ksh", "ケルン語" },
            { "kum", "クムク語" },
            { "kut", "クテナイ語" },
            { "kwk", "クヮキゥワラ語" },
            { "kxv", "クーヴィンガ語" },
            { "lad", "ラディノ語" },
            { "lag", "ランギ語" },
            { "lah", "ラフンダー語" },
            { "lam", "ランバ語" },
            { "lez", "レズギ語" },
            { "lfn", "リングア・フランカ・ノバ" },
            { "lij", "リグリア語" },
            { "lil", "リルエット語" },
            { "liv", "リヴォニア語" },
            { "lkt", "ラコタ語" },
            { "lmo", "ロンバルド語" },
            { "lol", "モンゴ語" },
            { "lou", "ルイジアナ・クレオール語" },
            { "loz", "ロジ語" },
            { "lrc", "北ロル語" },
            { "lsm", "サーミア語" },
            { "ltg", "ラトガリア語" },
            { "lua", "ルバ・ルルア語" },
            { "lui", "ルイセーニョ語" },
            { "lun", "ルンダ語" },
            { "luo", "ルオ語" },
            { "lus", "ミゾ語" },
            { "luy", "ルヒヤ語" },
            { "lzh", "漢文" },
            { "lzz", "ラズ語" },
            { "mad", "マドゥラ語" },
            { "maf", "マファ語" },
            { "mag", "マガヒー語" },
            { "mai", "マイティリー語" },
            { "mak", "マカッサル語" },
            { "man", "マンディンゴ語" },
            { "mas", "マサイ語" },
            { "mde", "マバ語" },
            { "mdf", "モクシャ語" },
            { "mdr", "マンダル語" },
            { "men", "メンデ語" },
            { "mer", "メル語" },
            { "mfe", "モーリシャス・クレオール語" },
            { "mga", "中期アイルランド語" },
            { "mgh", "マクア・ミート語" },
            { "mgo", "メタ語" },
            { "mic", "ミクマク語" },
            { "min", "ミナンカバウ語" },
            { "mnc", "満州語" },
            { "mni", "マニプリ語" },
            { "moe", "イヌー＝アイムン語" },
            { "moh", "モーホーク語" },
            { "mos", "モシ語" },
            { "mrj", "山地マリ語" },
            { "mua", "ムンダン語" },
            { "mul", "複数言語" },
            { "mus", "クリーク語" },
            { "mwl", "ミランダ語" },
            { "mwr", "マールワーリー語" },
            { "mwv", "メンタワイ語" },
            { "mye", "ミエネ語" },
            { "myv", "エルジャ語" },
            { "mzn", "マーザンダラーン語" },
            { "nan", "閩南語" },
            { "nap", "ナポリ語" },
            { "naq", "ナマ語" },
            { "nds", "低地ドイツ語" },
            { "new", "ネワール語" },
            { "nia", "ニアス語" },
            { "niu", "ニウーエイ語" },
            { "njo", "アオ・ナガ語" },
            { "nmg", "クワシオ語" },
            { "nnh", "ンジエムブーン語" },
            { "nog", "ノガイ語" },
            { "non", "古ノルド語" },
            { "nov", "ノヴィアル" },
            { "nqo", "ンコ語" },
            { "nso", "北部ソト語" },
            { "nus", "ヌエル語" },
            { "nwc", "古典ネワール語" },
            { "nym", "ニャムウェジ語" },
            { "nyn", "ニャンコレ語" },
            { "nyo", "ニョロ語" },
            { "nzi", "ンゼマ語" },
            { "ojb", "北西部オジブワ語" },
            { "ojc", "中部オジブワ語" },
            { "ojs", "セヴァーン・オジブワ語" },
            { "ojw", "西部オジブワ語" },
            { "oka", "オカナガン語" },
            { "osa", "オセージ語" },
            { "ota", "オスマントルコ語" },
            { "pag", "パンガシナン語" },
            { "pal", "パフラヴィー語" },
            { "pam", "パンパンガ語" },
            { "pap", "パピアメント語" },
            { "pau", "パラオ語" },
            { "pcd", "ピカルディ語" },
            { "pcm", "ナイジェリア・ピジン語" },
            { "pdc", "ペンシルベニア・ドイツ語" },
            { "pdt", "メノナイト低地ドイツ語" },
            { "peo", "古代ペルシア語" },
            { "pfl", "プファルツ語" },
            { "phn", "フェニキア語" },
            { "pis", "ピジン語" },
            { "pms", "ピエモンテ語" },
            { "pnt", "ポントス・ギリシャ語" },
            { "pon", "ポンペイ語" },
            { "pqm", "マリシート＝パサマコディ語" },
            { "prg", "プロシア語" },
            { "pro", "古期プロバンス語" },
            { "quc", "キチェ語" },
            { "qug", "チンボラソ高地ケチュア語" },
            { "raj", "ラージャスターン語" },
            { "rap", "ラパヌイ語" },
            { "rar", "ラロトンガ語" },
            { "rgn", "ロマーニャ語" },
            { "rhg", "ロヒンギャ語" },
            { "rif", "リーフ語" },
            { "rof", "ロンボ語" },
            { "rom", "ロマーニー語" },
            { "rtm", "ロツマ語" },
            { "rue", "ルシン語" },
            { "rug", "ロヴィアナ語" },
            { "rup", "アルーマニア語" },
            { "rwk", "ルワ語" },
            { "sad", "サンダウェ語" },
            { "sah", "サハ語" },
            { "sam", "サマリア・アラム語" },
            { "saq", "サンブル語" },
            { "sas", "ササク語" },
            { "sat", "サンターリー語" },
            { "saz", "サウラーシュトラ語" },
            { "sba", "ンガムバイ語" },
            { "sbp", "サング語" },
            { "scn", "シチリア語" },
            { "sco", "スコットランド語" },
            { "sdc", "サッサリ・サルデーニャ語" },
            { "sdh", "南部クルド語" },
            { "see", "セネカ語" },
            { "seh", "セナ語" },
            { "sei", "セリ語" },
            { "sel", "セリクプ語" },
            { "ses", "コイラボロ・センニ語" },
            { "sga", "古アイルランド語" },
            { "sgs", "サモギティア語" },
            { "shi", "タシルハイト語" },
            { "shn", "シャン語" },
            { "shu", "チャド・アラビア語" },
            { "sid", "シダモ語" },
            { "slh", "南部ルシュツィード語" },
            { "sli", "低シレジア語" },
            { "sly", "スラヤール語" },
            { "sma", "南サーミ語" },
            { "smj", "ルレ・サーミ語" },
            { "smn", "イナリ・サーミ語" },
            { "sms", "スコルト・サーミ語" },
            { "snk", "ソニンケ語" },
            { "sog", "ソグド語" },
            { "srn", "スリナム語" },
            { "srr", "セレル語" },
            { "ssy", metaValue_ssy },
            { "stq", "ザーターフリジア語" },
            { "str", "ストレイツセイリッシュ語" },
            { "suk", "スクマ語" },
            { "sus", "スス語" },
            { "sux", "シュメール語" },
            { "swb", "コモロ語" },
            { "syc", "古典シリア語" },
            { "syr", "シリア語" },
            { "szl", "シレジア語" },
            { "tce", "南部トゥショーニ語" },
            { "tcy", "トゥル語" },
            { "tem", "テムネ語" },
            { "teo", "テソ語" },
            { "ter", "テレーノ語" },
            { "tet", "テトゥン語" },
            { "tgx", "タギシュ語" },
            { "tht", "タールタン語" },
            { "tig", "ティグレ語" },
            { "tiv", "ティブ語" },
            { "tkl", "トケラウ語" },
            { "tkr", "ツァフル語" },
            { "tlh", "クリンゴン語" },
            { "tli", "トリンギット語" },
            { "tly", "タリシュ語" },
            { "tmh", "タマシェク語" },
            { "tog", "トンガ語(ニアサ)" },
            { "tok", "トキポナ語" },
            { "tpi", "トク・ピシン語" },
            { "tru", "トゥロヨ語" },
            { "trv", "タロコ語" },
            { "tsd", "ツァコン語" },
            { "tsi", "チムシュ語" },
            { "ttm", "北部トゥショーニ語" },
            { "ttt", "ムスリム・タタール語" },
            { "tum", "トゥンブカ語" },
            { "tvl", "ツバル語" },
            { "twq", "タサワク語" },
            { "tyv", "トゥヴァ語" },
            { "tzm", "中央アトラス・タマジクト語" },
            { "udm", "ウドムルト語" },
            { "uga", "ウガリト語" },
            { "umb", "ムブンドゥ語" },
            { "und", "言語不明" },
            { "vai", "ヴァイ語" },
            { "vec", "ヴェネト語" },
            { "vep", "ヴェプス語" },
            { "vls", "西フラマン語" },
            { "vmf", "マインフランク語" },
            { "vmw", "マクア語" },
            { "vot", "ヴォート語" },
            { "vro", "ヴォロ語" },
            { "vun", "ヴンジョ語" },
            { "wae", "ヴァリス語" },
            { "wal", "ウォライタ語" },
            { "war", "ワライ語" },
            { "was", "ワショ語" },
            { "wbp", "ワルピリ語" },
            { "wuu", "呉語" },
            { "xal", "カルムイク語" },
            { "xmf", "メグレル語" },
            { "xnr", "カーングリー語" },
            { "xog", "ソガ語" },
            { "yao", "ヤオ語" },
            { "yap", "ヤップ語" },
            { "yav", "ヤンベン語" },
            { "ybb", "イエンバ語" },
            { "yrl", "ニェエンガトゥ語" },
            { "yue", "広東語" },
            { "zap", "サポテカ語" },
            { "zbl", metaValue_zbl },
            { "zea", "ゼーラント語" },
            { "zen", "ゼナガ語" },
            { "zgh", "標準モロッコ タマジクト語" },
            { "zun", "ズニ語" },
            { "zxx", "言語的内容なし" },
            { "zza", "ザザ語" },
            { "Adlm", "アドラム文字" },
            { "Afak", "アファカ文字" },
            { "Aghb", "カフカス・アルバニア文字" },
            { "Arab", "アラビア文字" },
            { "Aran", "ナスタアリーク体" },
            { "Armi", "帝国アラム文字" },
            { "Armn", "アルメニア文字" },
            { "Avst", "アヴェスター文字" },
            { "Bali", "バリ文字" },
            { "Bamu", "バムン文字" },
            { "Bass", "バサ文字" },
            { "Batk", "バタク文字" },
            { "Beng", "ベンガル文字" },
            { "Blis", metaValue_zbl },
            { "Bopo", "注音字母" },
            { "Brah", "ブラーフミー文字" },
            { "Brai", "ブライユ点字" },
            { "Bugi", "ブギス文字" },
            { "Buhd", "ブヒッド文字" },
            { "Cakm", "チャクマ文字" },
            { "Cans", "統合カナダ先住民音節文字" },
            { "Cari", "カリア文字" },
            { "Cham", "チャム文字" },
            { "Cher", "チェロキー文字" },
            { "Cirt", "キアス文字" },
            { "Copt", "コプト文字" },
            { "Cprt", "キプロス文字" },
            { "Cyrl", "キリル文字" },
            { "Cyrs", "古代教会スラブ語キリル文字" },
            { "Deva", "デーバナーガリー文字" },
            { "Dsrt", "デセレット文字" },
            { "Dupl", "デュプロワエ式速記" },
            { "Egyd", "エジプト民衆文字" },
            { "Egyh", "エジプト神官文字" },
            { "Egyp", "エジプト聖刻文字" },
            { "Elba", "エルバサン文字" },
            { "Ethi", "エチオピア文字" },
            { "Geok", "ジョージア文字(フツリ)" },
            { "Geor", "ジョージア文字" },
            { "Glag", "グラゴル文字" },
            { "Goth", "ゴート文字" },
            { "Gran", "グランタ文字" },
            { "Grek", "ギリシャ文字" },
            { "Gujr", "グジャラート文字" },
            { "Guru", "グルムキー文字" },
            { "Hanb", "漢語注音字母" },
            { "Hang", "ハングル" },
            { "Hani", "漢字" },
            { "Hano", "ハヌノオ文字" },
            { "Hans", "簡体字" },
            { "Hant", "繁体字" },
            { "Hebr", "ヘブライ文字" },
            { "Hira", "ひらがな" },
            { "Hluw", "アナトリア象形文字" },
            { "Hmng", "パハウ・フモン文字" },
            { "Hrkt", "仮名" },
            { "Hung", "古代ハンガリー文字" },
            { "Inds", "インダス文字" },
            { "Ital", "古イタリア文字" },
            { "Jamo", "字母" },
            { "Java", "ジャワ文字" },
            { "Jpan", "日本語の文字" },
            { "Jurc", "女真文字" },
            { "Kali", "カヤー文字" },
            { "Kana", "カタカナ" },
            { "Khar", "カローシュティー文字" },
            { "Khmr", "クメール文字" },
            { "Khoj", "ホジャ文字" },
            { "Knda", "カンナダ文字" },
            { "Kore", "韓国語の文字" },
            { "Kpel", "クペレ文字" },
            { "Kthi", "カイティ文字" },
            { "Lana", "ラーンナー文字" },
            { "Laoo", "ラオ文字" },
            { "Latf", "ラテン文字(ドイツ文字)" },
            { "Latg", "ラテン文字 (ゲール文字)" },
            { "Latn", "ラテン文字" },
            { "Lepc", "レプチャ文字" },
            { "Limb", "リンブ文字" },
            { "Lina", "線文字A" },
            { "Linb", "線文字B" },
            { "Lisu", "フレイザー文字" },
            { "Loma", "ロマ文字" },
            { "Lyci", "リキア文字" },
            { "Lydi", "リディア文字" },
            { "Mahj", "マハージャニー文字" },
            { "Mand", "マンダ文字" },
            { "Mani", "マニ文字" },
            { "Maya", "マヤ象形文字" },
            { "Mend", "メンデ文字" },
            { "Merc", "メロエ文字草書体" },
            { "Mero", "メロエ文字" },
            { "Mlym", "マラヤーラム文字" },
            { "Modi", "モーディー文字" },
            { "Mong", "モンゴル文字" },
            { "Moon", "ムーン文字" },
            { "Mroo", "ムロ文字" },
            { "Mtei", "メイテイ文字" },
            { "Mymr", "ミャンマー文字" },
            { "Narb", "古代北アラビア文字" },
            { "Nbat", "ナバテア文字" },
            { "Nkgb", "ナシ族ゲバ文字" },
            { "Nkoo", "ンコ文字" },
            { "Nshu", "女書" },
            { "Ogam", "オガム文字" },
            { "Olck", "オルチキ文字" },
            { "Orkh", "オルホン文字" },
            { "Orya", "オディア文字" },
            { "Osma", "オスマニア文字" },
            { "Palm", "パルミラ文字" },
            { "Pauc", "パウ・チン・ハウ文字" },
            { "Perm", "古ぺルム文字" },
            { "Phag", "パスパ文字" },
            { "Phli", "碑文パフラヴィー文字" },
            { "Phlp", "詩編用パフラヴィー文字" },
            { "Phlv", "書物用パフラヴィー文字" },
            { "Phnx", "フェニキア文字" },
            { "Plrd", "ポラード音声記号" },
            { "Prti", "碑文パルティア文字" },
            { "Rjng", "ルジャン文字" },
            { "Rohg", "ロヒンギャ文字" },
            { "Roro", "ロンゴロンゴ文字" },
            { "Runr", "ルーン文字" },
            { "Samr", "サマリア文字" },
            { "Sara", "サラティ文字" },
            { "Sarb", "古代南アラビア文字" },
            { "Saur", "サウラーシュトラ文字" },
            { "Sgnw", "手話文字" },
            { "Shaw", "ショー文字" },
            { "Shrd", "シャーラダー文字" },
            { "Sidd", "梵字" },
            { "Sind", "クダワディ文字" },
            { "Sinh", "シンハラ文字" },
            { "Sora", "ソラング・ソンペング文字" },
            { "Sund", "スンダ文字" },
            { "Sylo", "シロティ・ナグリ文字" },
            { "Syrc", "シリア文字" },
            { "Syre", "シリア文字(エストランゲロ文字)" },
            { "Syrj", "シリア文字(西方シリア文字)" },
            { "Syrn", "シリア文字(東方シリア文字)" },
            { "Tagb", "タグバンワ文字" },
            { "Takr", "タークリー文字" },
            { "Tale", "タイ・レ文字" },
            { "Talu", "新タイ・ルー文字" },
            { "Taml", "タミル文字" },
            { "Tang", "西夏文字" },
            { "Tavt", "タイ・ヴェト文字" },
            { "Telu", "テルグ文字" },
            { "Teng", "テングワール文字" },
            { "Tfng", "ティフナグ文字" },
            { "Tglg", "タガログ文字" },
            { "Thaa", "ターナ文字" },
            { "Thai", "タイ文字" },
            { "Tibt", "チベット文字" },
            { "Tirh", "ティルフータ文字" },
            { "Ugar", "ウガリット文字" },
            { "Vaii", "ヴァイ文字" },
            { "Visp", "視話法" },
            { "Wara", "バラン・クシティ文字" },
            { "Wole", "ウォレアイ文字" },
            { "Xpeo", "古代ペルシア文字" },
            { "Xsux", "シュメール＝アッカド語楔形文字" },
            { "Yiii", "イ文字" },
            { "Zinh", "基底文字の種別を継承する結合文字" },
            { "Zmth", "数学記号" },
            { "Zsye", "絵文字" },
            { "Zsym", "記号文字" },
            { "Zxxx", "非表記" },
            { "Zyyy", "共通文字" },
            { "Zzzz", "不明な文字" },
            { "de_CH", "標準ドイツ語 (スイス)" },
            { "en_AU", "オーストラリア英語" },
            { "en_CA", "カナダ英語" },
            { "en_GB", "イギリス英語" },
            { "en_US", "アメリカ英語" },
            { "es_ES", "スペイン語 (イベリア半島)" },
            { "fa_AF", "ダリー語" },
            { "nl_BE", "フラマン語" },
            { "pt_PT", "ポルトガル語 (イベリア半島)" },
            { "ro_MD", "モルダビア語" },
            { "sw_CD", "コンゴ・スワヒリ語" },
            { "%%1901", "ドイツ語旧正書法" },
            { "%%1994", "標準レージア方言正書法" },
            { "%%1996", "ドイツ語正書法(1996)" },
            { "ar_001", "現代標準アラビア語" },
            { "key.ca", "暦法" },
            { "key.cf", "通貨フォーマット" },
            { "key.co", "並べ替え順序" },
            { "key.cu", "通貨" },
            { "key.hc", "時間制(12 / 24)" },
            { "key.lb", "禁則処理" },
            { "key.ms", "単位系" },
            { "key.nu", "数値書式" },
            { "key.tz", "タイムゾーン" },
            { "key.va", "ロケールのバリアント" },
            { "%%ALUKU", "アロコ方言" },
            { "%%BISKE", "サン・ジョルジョ/ビーラ方言" },
            { "%%BOONT", "ブーントリング" },
            { "%%JAUER", "ヤウエル" },
            { "%%KKCOR", "共通コーンウォール語正書法" },
            { "%%KSCOR", "標準コーンウォール語正書法" },
            { "%%LIPAW", "レージア方言 リポヴァツ方言" },
            { "%%NEDIS", "ナティゾーネ方言" },
            { "%%NJIVA", "ニヴァ方言" },
            { "%%NULIK", "現代ヴォラピュク語" },
            { "%%OSOJS", "オゼアッコ/オソヤネ方言" },
            { "%%POSIX", "コンピュータ" },
            { "%%PUTER", "プーター" },
            { "%%RIGIK", "古典ヴォラピュク語" },
            { "%%ROZAJ", "レシア方言" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "ストルヴィッツァ/ソルビツァ方言" },
            { "%%UCCOR", "統一コーンウォール語正書法" },
            { "zh_Hans", "簡体中国語" },
            { "zh_Hant", "繁体中国語" },
            { "%%DAJNKO", "ダインチッツァ" },
            { "%%FONIPA", "国際音声記号" },
            { "%%FONUPA", "ウラル音声記号" },
            { "%%NDYUKA", "ンジュカ方言" },
            { "%%PAMAKA", "パマカ方言" },
            { "%%PINYIN", "ピン音(ローマ字表記法)" },
            { "%%SCOUSE", "リバプール方言" },
            { "%%TARASK", "タラシケヴィツァ正書法" },
            { "%%UCRCOR", "改訂統一コーンウォール語正書法" },
            { "%%ULSTER", "アルスター" },
            { "%%ALALC97", "ALA-LCラテン文字化(1997)" },
            { "%%AREVELA", "東アルメニア文語" },
            { "%%AREVMDA", "西アルメニア文語" },
            { "%%BAUDDHA", "バウッダ" },
            { "%%BOHORIC", "ボホリッツ・アルファベット" },
            { "%%EMODENG", "初期近代英語" },
            { "%%HEPBURN", "ヘボン式ローマ字" },
            { "%%ITIHASA", "イティハーサ" },
            { "%%LAUKIKA", "ラウキカ" },
            { "%%METELKO", "メテルチッツァ" },
            { "%%MONOTON", "モノトニック" },
            { "%%POLYTON", "ポリトニック" },
            { "%%REVISED", "改訂版" },
            { "%%SURSILV", "スルシルヴァン" },
            { "%%SUTSILV", "ストシルヴァン" },
            { "%%VAIDIKA", "ヴァイディカ" },
            { "%%1606NICT", "後期中世フランス語(〜1606)" },
            { "%%1694ACAD", "初期現代フランス語" },
            { "%%1959ACAD", "標準ベラルーシ語 (1959)" },
            { "%%BAKU1926", "統一トルコラテン文字" },
            { "%%BISCAYAN", "ビスカヤ語" },
            { "%%FONXSAMP", "フォンクサンプ" },
            { "%%HOGNORSK", "ヘグノシュク" },
            { "%%JYUTPING", "略称粤拼" },
            { "%%SCOTLAND", "スコットランド標準英語" },
            { "%%SURMIRAN", "スルミラン" },
            { "%%VALENCIA", "バレンシア方言" },
            { "%%VALLADER", "ヴァラダー" },
            { "%%WADEGILE", "ウェード式ローマ字表記法" },
            { "type.ca.roc", "中華民国暦" },
            { "type.co.eor", "ヨーロッパ言語文字の並べ替え規則" },
            { "type.hc.h11", "12時間制(0〜11)" },
            { "type.hc.h12", "12時間制(1〜12)" },
            { "type.hc.h23", "24時間制(0〜23)" },
            { "type.hc.h24", "24時間制(1〜24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "アラビア・インド数字" },
            { "type.nu.armn", "アルメニア数字" },
            { "type.nu.bali", "バリ数字" },
            { "type.nu.beng", "ベンガル数字" },
            { "type.nu.brah", "ブラーフミー数字" },
            { "type.nu.cakm", "チャクマ数字" },
            { "type.nu.cham", "チャム数字" },
            { "type.nu.deva", "デーバナーガリー数字" },
            { "type.nu.ethi", "エチオピア数字" },
            { "type.nu.geor", "ジョージア数字" },
            { "type.nu.grek", "ギリシャ数字" },
            { "type.nu.gujr", "グジャラート数字" },
            { "type.nu.guru", "グルムキー数字" },
            { "type.nu.hans", "簡体漢数字" },
            { "type.nu.hant", "繁体漢数字" },
            { "type.nu.hebr", "ヘブライ数字" },
            { "type.nu.java", "ジャワ数字" },
            { "type.nu.jpan", "漢数字" },
            { "type.nu.kali", "カヤー数字" },
            { "type.nu.khmr", "クメール数字" },
            { "type.nu.knda", "カンナダ数字" },
            { "type.nu.lana", "ラーンナー数字" },
            { "type.nu.laoo", "ラオ数字" },
            { "type.nu.latn", "算用数字" },
            { "type.nu.lepc", "レプチャ数字" },
            { "type.nu.limb", "リンブ数字" },
            { "type.nu.mlym", "マラヤーラム数字" },
            { "type.nu.mong", "モンゴル数字" },
            { "type.nu.mtei", "マニプリ数字" },
            { "type.nu.mymr", "ミャンマー数字" },
            { "type.nu.nkoo", "ンコ数字" },
            { "type.nu.olck", "オルチキ数字" },
            { "type.nu.orya", "オディア数字" },
            { "type.nu.osma", "オスマニア数字" },
            { "type.nu.saur", "サウラーシュトラ数字" },
            { "type.nu.shrd", "シャーラダー数字" },
            { "type.nu.sora", "ソラ・ソンペン数字" },
            { "type.nu.sund", "スンダ数字" },
            { "type.nu.takr", "タークリー数字" },
            { "type.nu.talu", "新タイ・ルー数字" },
            { "type.nu.taml", "伝統的タミル数字" },
            { "type.nu.telu", "テルグ数字" },
            { "type.nu.thai", "タイ数字" },
            { "type.nu.tibt", "チベット数字" },
            { "type.nu.vaii", "ヴァイ文字の記数法" },
            { "type.ca.dangi", "ダンギ暦" },
            { "type.co.ducet", "ユニコード照合順" },
            { "type.lb.loose", "禁則処理(弱)" },
            { "type.nu.roman", "ローマ数字" },
            { "type.ca.coptic", "コプト暦" },
            { "type.ca.hebrew", "ユダヤ暦" },
            { "type.ca.indian", "インド国定暦" },
            { "type.co.compat", "以前の順序（互換性）" },
            { "type.co.pinyin", "ピンイン順" },
            { "type.co.search", "汎用検索" },
            { "type.co.stroke", "画数順" },
            { "type.co.unihan", "部首順" },
            { "type.co.zhuyin", "注音順" },
            { "type.d0.fwidth", "全角" },
            { "type.d0.hwidth", "半角" },
            { "type.lb.normal", "禁則処理(標準)" },
            { "type.lb.strict", "禁則処理(強)" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "メートル法" },
            { "type.nu.native", "独自の記数法" },
            { "type.ca.chinese", "中国暦" },
            { "type.ca.islamic", "イスラム暦" },
            { "type.ca.iso8601", "ISO-8601" },
            { "type.ca.persian", "ペルシア暦" },
            { "type.cf.account", "会計通貨フォーマット" },
            { "type.co.big5han", "繁体字中国語順(Big5)" },
            { "type.d0.npinyin", "数字" },
            { "type.nu.arabext", "ペルシア数字" },
            { "type.nu.armnlow", "アルメニア数字(小文字)" },
            { "type.nu.finance", "財務用漢数字" },
            { "type.nu.greklow", "ギリシャ数字(小文字)" },
            { "type.nu.hanidec", "漢数字(位取り記数法)" },
            { "type.nu.hansfin", "簡体大字" },
            { "type.nu.hantfin", "繁体大字" },
            { "type.nu.jpanfin", "大字" },
            { "type.nu.tamldec", "タミル数字" },
            { "type.ca.buddhist", "仏暦" },
            { "type.ca.ethiopic", "エチオピア暦" },
            { "type.ca.japanese", "和暦" },
            { "type.cf.standard", "標準通貨フォーマット" },
            { "type.co.phonetic", "音声順による並べ替え" },
            { "type.co.searchjl", "ハングル語頭子音による並べ替え" },
            { "type.co.standard", "標準並べ替え順序" },
            { "type.ms.uksystem", "ヤード・ポンド法" },
            { "type.ms.ussystem", "米慣習単位" },
            { "type.nu.fullwide", "全角数字" },
            { "type.nu.lanatham", "ラーンナー・タム数字" },
            { "type.nu.mymrshan", "ミャンマー・シャン数字" },
            { "type.nu.romanlow", "ローマ数字(小文字)" },
            { "type.ca.gregorian", "西暦(グレゴリオ暦)" },
            { "type.co.gb2312han", "簡体字中国語順(GB2312)" },
            { "type.co.phonebook", "電話帳順" },
            { "type.co.dictionary", "辞書順" },
            { "type.co.traditional", "トラディッショナル" },
            { "type.nu.traditional", "従来の記数法" },
            { "type.ca.islamic-civil", "イスラム暦(定周期、公民紀元)" },
            { "ListCompositionPattern", "{0}、{1}" },
            { "type.ca.islamic-umalqura", "イスラム暦(ウンム・アルクラー)" },
            { "type.ca.ethiopic-amete-alem", "エチオピア創世紀元暦" },
        };
        return data;
    }
}
